/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/spu"}, name="\u5546\u54c1SPU")
public class RsSpuCon
extends SpringmvcController {
    @Autowired
    private RsSpuServiceRepository rsSpuServiceRepository;
    private static String CODE = "rs.spu.con";

    protected String getContext() {
        return "spu";
    }

    @RequestMapping(value={"saveSpu.json"}, name="\u589e\u52a0\u5546\u54c1SPU")
    @ResponseBody
    public HtmlJsonReBean saveSpu(RsSpuReDomain rsSpuReDomain) {
        if (null == rsSpuReDomain) {
            this.logger.error(CODE + ".saveSpu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSpuServiceRepository.saveSpu((RsSpuDomain)rsSpuReDomain);
    }

    @RequestMapping(value={"getSpu.json"}, name="\u83b7\u53d6\u5546\u54c1SPU\u4fe1\u606f")
    @ResponseBody
    public RsSpuReDomain getSpu(String spuId) {
        if (StringUtils.isBlank((String)spuId)) {
            this.logger.error(CODE + ".getSpu", (Object)"param is null");
            return null;
        }
        return this.rsSpuServiceRepository.getSpu(Integer.valueOf(spuId));
    }

    @RequestMapping(value={"updateSpu.json"}, name="\u7f16\u8f91\u5546\u54c1SPU")
    @ResponseBody
    public HtmlJsonReBean updateSpu(RsSpuReDomain rsSpuReDomain) {
        if (null == rsSpuReDomain) {
            this.logger.error(CODE + ".updateSpu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSpuServiceRepository.updateSpu((RsSpuDomain)rsSpuReDomain);
    }

    @RequestMapping(value={"deleteSpu.json"}, name="\u5220\u9664\u5546\u54c1SPU")
    @ResponseBody
    public HtmlJsonReBean deleteSpu(String spuId) {
        if (StringUtils.isBlank((String)spuId)) {
            this.logger.error(CODE + ".deleteSpu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSpuServiceRepository.deleteSpu(Integer.valueOf(spuId));
    }

    @RequestMapping(value={"querySpuPage.json"}, name="\u5546\u54c1SPU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSpuReDomain> querySpuPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSpuServiceRepository.querySpuPage(param);
    }

    @RequestMapping(value={"updateSpuState.json"}, name="\u7f16\u8f91\u5546\u54c1SPU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSpuState(String spuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)spuId)) {
            this.logger.error(CODE + ".updateSpuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSpuServiceRepository.updateSpuState(Integer.valueOf(spuId), dataState, oldDataState);
    }
}

