/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/resourceGoods"}, name="\u5546\u54c1")
public class ResourceGoodsCon
extends SpringmvcController {
    private static String CODE = "rs.resourceGoods.con";
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "resourceGoods";
    }

    @RequestMapping(value={"saveResourceGoods.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".saveResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList() || ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4e0b\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsServiceRepository.saveResourceGoods(rsResourceGoodsDomain);
        if (rsResourceGoodsDomain.getDataOpbillstate() == 1 && null != htmlJsonReBean.getDataObj()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", htmlJsonReBean.getDataObj());
            map.put("tenantCode", this.getTenantCode(request));
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            if (null != rsResourceGoodsReDomain) {
                this.updateAhAndAuditResourcePass(rsResourceGoodsReDomain.getGoodsId() + "");
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getResourceGoods.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsResourceGoodsReDomain getResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResourceGoods", (Object)"param is null");
            return null;
        }
        return this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
    }

    @RequestMapping(value={"updateResourceGoods.json"}, name="\u66f4\u65b0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".updateResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        return this.rsResourceGoodsServiceRepository.updateResourceGoods(rsResourceGoodsDomain);
    }

    @RequestMapping(value={"deleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".deleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.deleteResourceGoods(Integer.valueOf(goodsId));
    }

    @RequestMapping(value={"queryResourceGoodsPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPageByPlant.json"}, name="\u5e73\u53f0\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageByPlant(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"updateResourceGoodsState.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsState(String goodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".updateResourceGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u5ba1\u6838\u540e)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateCannelResourceList.json"}, name="\u5546\u54c1\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateCannelResourceList(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResourceList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateAhAndAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"batchDeleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResourceGoods(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode,memberCode", new Object[]{goodsNo, this.getTenantCode(request), this.getMerchantCode(request)});
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsList.getRows()) {
                if (goodsCode.equals(rsResourceGoodsReDomain.getGoodsCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsList && null != rsList.getList() && rsList.getList().size() > 0) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)" exist goodsNo");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    private List<Integer> getGoodsIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            goodsIdList.add(Integer.parseInt(id));
        }
        return goodsIdList;
    }
}

