/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpecServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/specOption"}, name="\u5546\u54c1\u89c4\u683c\u9009\u9879")
public class RsSpecOptionCon
extends SpringmvcController {
    private static String CODE = "rs.specOption.con";
    @Autowired
    private RsSpecServiceRepository rsSpecServiceRepository;

    protected String getContext() {
        return "specOption";
    }

    @RequestMapping(value={"saveSpecOption.json"}, name="\u589e\u52a0\u5546\u54c1\u89c4\u683c\u9009\u9879")
    @ResponseBody
    public HtmlJsonReBean saveSpecOption(HttpServletRequest request, RsSpecOptionDomain specOptionDomain) {
        if (null == specOptionDomain) {
            this.logger.error(CODE + ".saveSpecOption", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        specOptionDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.saveSpecOption(specOptionDomain);
    }

    @RequestMapping(value={"getSpecOption.json"}, name="\u83b7\u53d6\u5546\u54c1\u89c4\u683c\u9009\u9879\u4fe1\u606f")
    @ResponseBody
    public RsSpecOptionReDomain getSpecOption(String specOptionId) {
        if (StringUtils.isBlank((String)specOptionId)) {
            this.logger.error(CODE + ".getSpecOption", (Object)"param is null");
            return null;
        }
        return this.rsSpecServiceRepository.getSpecOption(Integer.valueOf(specOptionId));
    }

    @RequestMapping(value={"updateSpecOption.json"}, name="\u66f4\u65b0\u5546\u54c1\u89c4\u683c\u9009\u9879")
    @ResponseBody
    public HtmlJsonReBean updateSpecOption(HttpServletRequest request, RsSpecOptionDomain specOptionDomain) {
        if (null == specOptionDomain) {
            this.logger.error(CODE + ".updateSpecOption", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        specOptionDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.updateSpecOption(specOptionDomain);
    }

    @RequestMapping(value={"deleteSpecOption.json"}, name="\u5220\u9664\u5546\u54c1\u89c4\u683c\u9009\u9879")
    @ResponseBody
    public HtmlJsonReBean deleteSpecOption(HttpServletRequest request, String specOptionId) {
        if (StringUtils.isBlank((String)specOptionId)) {
            this.logger.error(CODE + ".deleteSpecOption", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSpecOptionReDomain specOptionReDomain = this.rsSpecServiceRepository.getSpecOption(Integer.valueOf(specOptionId));
        String specGroupCode = specOptionReDomain.getSpecGroupCode();
        if (StringUtils.isBlank((String)specGroupCode)) {
            this.logger.error(CODE + ".deleteSpecOption", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("specGroupCode", specGroupCode);
        param.put("tenantCode", this.getTenantCode(request));
        RsSpecGroupReDomain specGroupReDomain = this.rsSpecServiceRepository.getSpecGroupByCode(param);
        if (StringUtils.isNotBlank((String)specGroupReDomain.getPntreeCode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4f7f\u7528\u4e2d");
        }
        return this.rsSpecServiceRepository.deleteSpecOption(Integer.valueOf(specOptionId));
    }

    @RequestMapping(value={"querySpecOptionPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u89c4\u683c\u9009\u9879\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSpecOptionReDomain> querySpecOptionPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSpecServiceRepository.querySpecOptionPage(param);
    }

    @RequestMapping(value={"updateSpecOptionState.json"}, name="\u66f4\u65b0\u5546\u54c1\u89c4\u683c\u9009\u9879\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSpecOptionState(String specOptionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)specOptionId)) {
            this.logger.error(CODE + ".updateSpecOptionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSpecServiceRepository.updateSpecOptionState(Integer.valueOf(specOptionId), dataState, oldDataState);
    }
}

