/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFilesortReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsFilesortServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.sc.domain.ScShopdeReDomain;
import com.qjsoft.laser.controller.facade.sc.repository.ScShopdeServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/resourceGoods"}, name="\u5546\u54c1")
public class ResourceGoodsCon
extends SpringmvcController {
    private static String CODE = "rs.resourceGoods.con";
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository goodsOtherServiceRepository;
    @Autowired
    private ScShopdeServiceRepository scShopdeServiceRepository;
    @Autowired
    private RsGoodsFilesortServiceRepository rsGoodsFilesortServiceRepository;

    protected String getContext() {
        return "resourceGoods";
    }

    @RequestMapping(value={"saveResourceGoods.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, null);
    }

    public HtmlJsonReBean saveResourceGoodsMain(HttpServletRequest request, String paramStr, String goodsRemark, String flag) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".saveResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList() || ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4e0b\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        switch (flag) {
            case "gys": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("6");
                break;
            }
            case "tc": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("8");
                break;
            }
            default: {
                if (null != rsResourceGoodsDomain.getGoodsOrigin() && !StringUtils.isEmpty((String)rsResourceGoodsDomain.getGoodsOrigin())) break;
                rsResourceGoodsDomain.setGoodsOrigin("0");
            }
        }
        this.makeChannel(rsResourceGoodsDomain, request);
        HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsServiceRepository.saveResourceGoods(rsResourceGoodsDomain);
        if (rsResourceGoodsDomain.getDataOpbillstate() == 1 && null != htmlJsonReBean.getDataObj()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", htmlJsonReBean.getDataObj());
            map.put("tenantCode", this.getTenantCode(request));
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            if (null != rsResourceGoodsReDomain) {
                this.updateAhAndAuditResourcePass(rsResourceGoodsReDomain.getGoodsId() + "");
            }
        }
        return htmlJsonReBean;
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    private String getShopdeName(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult qlist = this.scShopdeServiceRepository.queryShopdePage(map);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return userSession.getMerberCompname();
        }
        return ((ScShopdeReDomain)qlist.getRows().get(0)).getShopdeName();
    }

    @RequestMapping(value={"getResourceGoods.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsResourceGoodsReDomain getResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResourceGoods", (Object)"param is null");
            return null;
        }
        return this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
    }

    @RequestMapping(value={"updateResourceGoods.json"}, name="\u66f4\u65b0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".updateResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        return this.rsResourceGoodsServiceRepository.updateResourceGoods(rsResourceGoodsDomain);
    }

    @RequestMapping(value={"deleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".deleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.deleteResourceGoods(Integer.valueOf(goodsId));
    }

    @RequestMapping(value={"queryResourceGoodsPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPageByPlant.json"}, name="\u5e73\u53f0\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageByPlant(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"updateResourceGoodsState.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsState(String goodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".updateResourceGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u5ba1\u6838\u540e)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"checkGoodsRel.json"}, name="\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5173\u8054\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean checkGoodsRel(HttpServletRequest request, String goodsCodeStr) {
        if (StringUtils.isBlank((String)goodsCodeStr)) {
            this.logger.error(CODE + ".checkGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<String> goodsCodeList = this.getGoodsCodeList(goodsCodeStr);
        for (String goodsCode : goodsCodeList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsRelGcode", goodsCode);
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult goodsRelReDomainSupQueryResult = this.goodsOtherServiceRepository.queryGoodsRelPage(map);
            if (null == goodsRelReDomainSupQueryResult || goodsRelReDomainSupQueryResult.getList().size() <= 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u88ab\u5173\u8054\uff0c \u786e\u8ba4\u5220\u9664\uff1f");
        }
        return new HtmlJsonReBean();
    }

    private List<String> getGoodsCodeList(String goodsCodeStr) {
        String[] codeStr = goodsCodeStr.split(",");
        ArrayList<String> goodsCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            goodsCodeList.add(code);
        }
        return goodsCodeList;
    }

    @RequestMapping(value={"updateCannelResourceList.json"}, name="\u5546\u54c1\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateCannelResourceList(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResourceList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updatePlatformResourceList.json"}, name="\u5e73\u53f0\u5546\u54c1\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updatePlatformResourceList(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResourceList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateAhAndAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"batchDeleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResourceGoods(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode,memberCode", new Object[]{goodsNo, this.getTenantCode(request), this.getMerchantCode(request)});
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsList.getRows()) {
                if (goodsCode.equals(rsResourceGoodsReDomain.getGoodsCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsList && null != rsList.getList() && rsList.getList().size() > 0) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)" exist goodsNo");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    private List<Integer> getGoodsIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            goodsIdList.add(Integer.parseInt(id));
        }
        return goodsIdList;
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"queryResourceGoodsByClassTreeCode.json"}, name="\u6839\u636e\u5206\u7c7b\u67e5\u8be2\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryResourceGoodsByClassTreeCode(HttpServletRequest request, String classtreeCode) {
        if (StringUtils.isBlank((String)classtreeCode)) {
            this.logger.error(CODE + ".queryResourceGoodsByClassTreeCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == supQueryResult || null == supQueryResult.getRows() || supQueryResult.getRows().isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        ArrayList<RsResourceGoodsReDomain> resourceGoodsReDomainList = new ArrayList<RsResourceGoodsReDomain>();
        for (RsResourceGoodsReDomain resourceGoodsReDomain : supQueryResult.getList()) {
            ArrayList rsGoodsFileDomainList = new ArrayList();
            HashMap<String, Object> filesortPama = new HashMap<String, Object>();
            filesortPama.put("order", true);
            filesortPama.put("orderStr", "GOODS_FILE_NO ASC");
            filesortPama.put("pntreeCode", resourceGoodsReDomain.getPntreeCode());
            filesortPama.put("tenantCode", this.getTenantCode(request));
            SupQueryResult reDomainSupQueryResult = this.rsGoodsFilesortServiceRepository.queryGoodsFilesortPage(filesortPama);
            if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getRows() || reDomainSupQueryResult.getRows().isEmpty()) continue;
            block1: for (RsGoodsFilesortReDomain goodsFilesortReDomain : reDomainSupQueryResult.getList()) {
                if (rsGoodsFileDomainList.size() > 2) break;
                if (goodsFilesortReDomain.getGoodsFileMinnum() <= 0) continue;
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("goodsCode", resourceGoodsReDomain.getGoodsCode());
                fileMap.put("goodsFileSort", goodsFilesortReDomain.getGoodsFileSort());
                fileMap.put("goodsFilesortName", goodsFilesortReDomain.getGoodsFilesortName());
                fileMap.put("tenantCode", this.getTenantCode(request));
                SupQueryResult goodsFileReDomainSupQueryResult = this.goodsOtherServiceRepository.queryGoodsFilePage(fileMap);
                if (null == goodsFileReDomainSupQueryResult || null == goodsFileReDomainSupQueryResult.getRows() || goodsFileReDomainSupQueryResult.getRows().isEmpty()) continue;
                if (rsGoodsFileDomainList.size() <= 0) {
                    rsGoodsFileDomainList.add(goodsFileReDomainSupQueryResult.getList().get(0));
                    continue;
                }
                for (RsGoodsFileReDomain rsGoodsFileReDomain : goodsFileReDomainSupQueryResult.getList()) {
                    if (rsGoodsFileDomainList.size() >= 3) continue block1;
                    rsGoodsFileDomainList.add(rsGoodsFileReDomain);
                }
            }
            resourceGoodsReDomain.setRsGoodsFileDomainList(rsGoodsFileDomainList);
            resourceGoodsReDomainList.add(resourceGoodsReDomain);
        }
        return new HtmlJsonReBean(resourceGoodsReDomainList);
    }

    @RequestMapping(value={"saveResourceGoodsGys.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsGys(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsGys", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsGys", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "gys");
    }

    @RequestMapping(value={"queryResourceGoodsGys.json"}, name="\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGys(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsGysDtj.json"}, name="\u4f9b\u5e94\u5546\u5f85\u63d0\u4ea4\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysDtj(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsGysDsh.json"}, name="\u4f9b\u5e94\u5546\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysDsh(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsGysYsh.json"}, name="\u4f9b\u5e94\u5546\u5df2\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysYsh(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsPt.json"}, name="\u5e73\u53f0\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPt(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtPageDsh.json"}, name="\u5e73\u53f0\u5217\u8868\u4e2d\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtPageDsh(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtDsh.json"}, name="\u5e73\u53f0\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtDsh(HttpServletRequest request) {
        return this.fetchQueryGys(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtDsj.json"}, name="\u5e73\u53f0\u5f85\u4e0a\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtDsj(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtYsj.json"}, name="\u5e73\u53f0\u5df2\u4e0a\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtYsj(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtTy.json"}, name="\u5e73\u53f0\u505c\u7528\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtTy(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryResourceGoodsPtGysXj.json"}, name="\u5e73\u53f0\u4f9b\u5e94\u5546\u4e0b\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtGysXj(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"updateResourceGoodsStateGys.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGys(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStateGysDtj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546-\u5f85\u63d0\u4ea4")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGysDtj(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStateGysYsh.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546-\u5df2\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGysYsh(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePt.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePt(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtDsh.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5f85\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtDsh(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtDsj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5f85\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtDsj(String goodsIdStr, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateResourceGoodsStatePtDsj", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (goodsIdStr.contains(",")) {
            List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
            HtmlJsonReBean htmlJsonReBean = null;
            for (Integer goodsId : goodsIdList) {
                htmlJsonReBean = this.fetchUpdate(String.valueOf(goodsId), dataState, oldDataState);
                if (null != htmlJsonReBean && !htmlJsonReBean.getSysRecode().equals("error")) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            return htmlJsonReBean;
        }
        return this.fetchUpdate(goodsIdStr, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtYsj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5df2\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtYsj(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtTy.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtTy(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    public SupQueryResult<RsResourceGoodsReDomain> fetchQueryGys(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCode", this.getMerchantCode(request));
        param.put("goodsOrigin", "6");
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    public SupQueryResult<RsResourceGoodsReDomain> fetchQuery(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCode", this.getMerchantCode(request));
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    public HtmlJsonReBean fetchUpdate(String goodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".updateResourceGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), dataState, oldDataState);
    }

    public HtmlJsonReBean fetchUpdateSave(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        if (dataState.equals(2)) {
            UserSession userSession = this.getUserSession(request);
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(Integer.parseInt(goodsId)));
            rsResourceGoodsReDomain.setGoodsId(null);
            rsResourceGoodsReDomain.setGoodsCode(null);
            rsResourceGoodsReDomain.setDataState(Integer.valueOf(0));
            rsResourceGoodsReDomain.setMemberCode(userSession.getUserPcode());
            rsResourceGoodsReDomain.setMemberName(userSession.getUserName());
            rsResourceGoodsReDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            rsResourceGoodsReDomain.setGoodsOrigin("7");
            HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsServiceRepository.saveResourceGoods((RsResourceGoodsDomain)rsResourceGoodsReDomain);
            if (null != htmlJsonReBean.getDataObj() && rsResourceGoodsReDomain.getDataOpbillstate() == 1) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("goodsCode", htmlJsonReBean.getDataObj());
                map.put("tenantCode", this.getTenantCode(request));
                RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null != rsResourceGoodsReDomain1) {
                    this.updateAhAndAuditResourcePass(rsResourceGoodsReDomain.getGoodsId() + "");
                    return this.fetchUpdate(goodsId, dataState, oldDataState);
                }
            }
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    public HtmlJsonReBean updateDouble(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        boolean flag = false;
        HtmlJsonReBean htmlJsonReBean = this.fetchUpdate(goodsId, dataState, oldDataState);
        if (null != htmlJsonReBean.getDataObj()) {
            Integer dataStatePt = 3;
            RsResourceGoodsReDomain resourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(Integer.parseInt(goodsId)));
            if (null != resourceGoodsReDomain) {
                RsResourceGoodsReDomain resourceGoodsReDomain1;
                HtmlJsonReBean hjrb;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantCode", this.getTenantCode(request));
                map.put("goodsCodeOld", resourceGoodsReDomain.getGoodsCode());
                SupQueryResult supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
                if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0 && null != (hjrb = this.fetchUpdate(String.valueOf((resourceGoodsReDomain1 = (RsResourceGoodsReDomain)supQueryResult.getList().get(0)).getGoodsId()), dataStatePt, resourceGoodsReDomain1.getDataState()))) {
                    flag = true;
                }
            }
        }
        if (flag) {
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
    }

    @RequestMapping(value={"saveResourceGoodsTc.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsTc(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsTc", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "gys");
    }
}

