/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/rsGoodsClass"}, name="\u5546\u54c1\u865a\u62df\u5206\u7c7b")
public class RsGoodsClassCon
extends SpringmvcController {
    private static String CODE = "rs.rsGoodsClass.con";
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;

    protected String getContext() {
        return "rsGoodsClass";
    }

    @RequestMapping(value={"saveRsGoodsClass.json"}, name="\u589e\u52a0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean saveRsGoodsClass(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".saveRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveRsGoodsClass", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String goodsClassName = goodsClassDomain.getGoodsClassName();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassName", goodsClassName);
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult SupQueryResultDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null != SupQueryResultDomainSupQueryResult.getRows() && SupQueryResultDomainSupQueryResult.getRows().size() > 0) {
            this.logger.error(CODE + ".saveRsGoodsClass", (Object)"\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        goodsClassDomain.setMemberName(userSession.getUserName());
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsClassServiceRepository.saveGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"getRsGoodsClass.json"}, name="\u83b7\u53d6\u5546\u54c1\u865a\u62df\u5206\u7c7b\u4fe1\u606f")
    @ResponseBody
    public RsGoodsClassDomain getRsGoodsClass(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".getRsGoodsClass", (Object)"param is null");
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassDomain = this.rsGoodsClassServiceRepository.getGoodsClass(Integer.valueOf(goodsClassId));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassParentcode", rsGoodsClassDomain.getGoodsClassCode());
        param.put("tenantCode", rsGoodsClassDomain.getTenantCode());
        SupQueryResult result = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        List list = result.getList();
        if (null == list || list.isEmpty()) {
            rsGoodsClassDomain.setHasChild(false);
        } else {
            rsGoodsClassDomain.setHasChild(true);
        }
        return rsGoodsClassDomain;
    }

    @RequestMapping(value={"updateRsGoodsClass.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClass(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".updateRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassName", goodsClassDomain.getGoodsClassName());
        param.put("memberCode", goodsClassDomain.getMemberCode());
        SupQueryResult SupQueryResultDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null != SupQueryResultDomainSupQueryResult.getRows() && SupQueryResultDomainSupQueryResult.getRows().size() > 0) {
            for (RsGoodsClassReDomain goodsClassReDomain : SupQueryResultDomainSupQueryResult.getList()) {
                if (goodsClassDomain.getGoodsClassId().equals(goodsClassReDomain.getGoodsClassId())) continue;
                this.logger.error(CODE + ".updateRsGoodsClass", (Object)"\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        }
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsClassServiceRepository.updateGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"deleteRsGoodsClass.json"}, name="\u5220\u9664\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean deleteRsGoodsClass(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".deleteRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.deleteGoodsClass(Integer.valueOf(goodsClassId));
    }

    @RequestMapping(value={"queryRsGoodsClassPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsGoodsClassReDomain> queryRsGoodsClassPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GOODS_CLASS_ORDER ASC");
        }
        return this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
    }

    @RequestMapping(value={"updateRsGoodsClassState.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClassState(String goodsClassId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".updateRsGoodsClassState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.updateGoodsClassState(Integer.valueOf(goodsClassId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryGoodsClassTree.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u8fc7\u6ee4\u65e0\u5b9e\u4f53\u5206\u7c7b\u7684")
    @ResponseBody
    public SupQueryResult<RsGoodsClassReDomain> queryGoodsClassTree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsClassParentcode", "-1");
        param.put("tenantcode", this.getTenantCode(request));
        ArrayList<RsGoodsClassReDomain> resultList = new ArrayList<RsGoodsClassReDomain>();
        SupQueryResult supQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : supQueryResult.getList()) {
            param.put("goodsClassParentcode", rsGoodsClassReDomain.getGoodsClassCode());
            SupQueryResult supQueryResult1 = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
            if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) continue;
            for (RsGoodsClassReDomain rsGoodsClassReDomain1 : supQueryResult1.getList()) {
                param.put("goodsClassParentcode", rsGoodsClassReDomain1.getGoodsClassCode());
                SupQueryResult supQueryResult2 = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
                if (null == supQueryResult2 || null == supQueryResult2.getList() || supQueryResult2.getList().size() <= 0) continue;
                ArrayList<RsGoodsClassReDomain> rsGoodsClassReDomains = new ArrayList<RsGoodsClassReDomain>();
                for (RsGoodsClassReDomain rsGoodsClassReDomain2 : supQueryResult2.getList()) {
                    if (!StringUtils.isNotBlank((String)rsGoodsClassReDomain2.getClasstreeCode())) continue;
                    rsGoodsClassReDomains.add(rsGoodsClassReDomain2);
                }
                if (rsGoodsClassReDomains.size() <= 0) continue;
                rsGoodsClassReDomain.setChildList(supQueryResult1.getList());
                rsGoodsClassReDomain1.setChildList(supQueryResult2.getList());
                resultList.add(rsGoodsClassReDomain);
            }
        }
        supQueryResult.setRows(resultList);
        supQueryResult.setList(resultList);
        return supQueryResult;
    }
}

