/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRtagDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsRtagDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsRtagReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsRtagServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsRtagServiceRepository;
import com.qjsoft.laser.controller.facade.sc.domain.ScShopdeReDomain;
import com.qjsoft.laser.controller.facade.sc.repository.ScShopdeServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/rtag"}, name="\u5546\u54c1\u6807\u7b7e")
public class RtagCon
extends SpringmvcController {
    private static String CODE = "rs.rtag.con";
    @Autowired
    private RsRtagServiceRepository rsRtagServiceRepository;
    @Autowired
    private RsGoodsRtagServiceRepository rsGoodsRtagServiceRepository;
    @Autowired
    private ScShopdeServiceRepository scShopdeServiceRepository;

    protected String getContext() {
        return "rtag";
    }

    @RequestMapping(value={"saveRtag.json"}, name="\u589e\u52a0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean saveRtag(HttpServletRequest request, RsRtagDomain rsRtagDomain) {
        if (null == rsRtagDomain) {
            this.logger.error(CODE + ".saveRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String rtagName = rsRtagDomain.getRtagName();
        if (StringUtils.isBlank((String)rtagName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.checkRtagName(request, rtagName, rsRtagDomain.getRtagCode());
        if (null != htmlJsonReBean && htmlJsonReBean.getSysRecode().equals("error")) {
            return htmlJsonReBean;
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(this.getShopdeName(userSession));
        return this.rsRtagServiceRepository.saveRtag(rsRtagDomain);
    }

    @RequestMapping(value={"getRtag.json"}, name="\u83b7\u53d6\u5546\u54c1\u6807\u7b7e\u4fe1\u606f")
    @ResponseBody
    public RsRtagReDomain getRtag(Integer rtagId) {
        if (StringUtils.isBlank((Integer)rtagId)) {
            this.logger.error(CODE + ".getRtag", (Object)"param is null");
            return null;
        }
        return this.rsRtagServiceRepository.getRtag(rtagId);
    }

    @RequestMapping(value={"updateRtag.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean updateRtag(HttpServletRequest request, RsRtagDomain rsRtagDomain) {
        if (null == rsRtagDomain || null == rsRtagDomain.getRtagCode()) {
            this.logger.error(CODE + ".updateRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String rtagName = rsRtagDomain.getRtagName();
        if (StringUtils.isBlank((String)rtagName)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.checkRtagName(request, rtagName, rsRtagDomain.getRtagCode());
        if (null != htmlJsonReBean && htmlJsonReBean.getSysRecode().equals("error")) {
            return htmlJsonReBean;
        }
        UserSession userSession = this.getUserSession(request);
        rsRtagDomain.setTenantCode(this.getTenantCode(request));
        rsRtagDomain.setRtagType("0");
        rsRtagDomain.setUserCode(userSession.getUserCode());
        rsRtagDomain.setMemberCode(userSession.getUserPcode());
        rsRtagDomain.setMemberName(this.getShopdeName(userSession));
        HtmlJsonReBean htmlJsonReBean1 = this.rsRtagServiceRepository.updateRtag(rsRtagDomain);
        RsGoodsRtagDomain rsGoodsRtagDomain = new RsGoodsRtagDomain();
        rsGoodsRtagDomain.setRtagCode(rsRtagDomain.getRtagCode());
        rsGoodsRtagDomain.setRtagName(rsRtagDomain.getRtagName());
        rsGoodsRtagDomain.setRtagFont(rsRtagDomain.getRtagFont());
        rsGoodsRtagDomain.setRtagBack(rsRtagDomain.getRtagBack());
        this.rsGoodsRtagServiceRepository.updateByRtagCode(rsGoodsRtagDomain);
        return htmlJsonReBean1;
    }

    @RequestMapping(value={"deleteRtag.json"}, name="\u5220\u9664\u5546\u54c1\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean deleteRtag(Integer rtagId) {
        if (StringUtils.isBlank((Integer)rtagId)) {
            this.logger.error(CODE + ".deleteRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsRtagReDomain rsRtagReDomain = this.rsRtagServiceRepository.getRtag(rtagId);
        SupQueryResult supQueryResult = this.rsGoodsRtagServiceRepository.queryGoodsRtagPage(this.getQueryMapParam("rtagCode,tenantCode", new Object[]{rsRtagReDomain.getRtagCode(), rsRtagReDomain.getTenantCode()}));
        if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".deleteRtag", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u6709\u5173\u8054\u5546\u54c1\uff0c\u8bf7\u5148\u53d6\u6d88\u5546\u54c1\u6807\u7b7e\uff01");
        }
        return this.rsRtagServiceRepository.deleteRtag(rtagId);
    }

    @RequestMapping(value={"queryRtagPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u6807\u7b7e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsRtagReDomain> queryRtagPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsRtagServiceRepository.queryRtagPage(param);
    }

    @RequestMapping(value={"updateRtagState.json"}, name="\u66f4\u65b0\u5546\u54c1\u6807\u7b7e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRtagState(String rtagId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)rtagId)) {
            this.logger.error(CODE + ".updateRtagState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsRtagServiceRepository.updateRtagState(Integer.valueOf(rtagId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"checkRtagName.json"}, name="\u6807\u7b7e\u540d\u68c0\u67e5")
    @ResponseBody
    public HtmlJsonReBean checkRtagName(HttpServletRequest request, String rtagName, String rtagCode) {
        if (StringUtils.isBlank((String)rtagName)) {
            this.logger.error(CODE + ".checkRtagName", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult supQueryResult = this.rsRtagServiceRepository.queryRtagPage(this.getQueryMapParam("rtagName,tenantCode", new Object[]{rtagName, this.getTenantCode(request)}));
        if (null == supQueryResult || null == supQueryResult.getRows() || supQueryResult.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)rtagCode)) {
            for (RsRtagReDomain rsRtagReDomain : supQueryResult.getRows()) {
                if (rtagCode.equals(rsRtagReDomain.getRtagCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            flag = true;
        }
        if (!flag && null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
            this.logger.error(CODE + ".checkRtagName", (Object)" exist rtagName");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return new HtmlJsonReBean();
    }

    private String getShopdeName(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult qlist = this.scShopdeServiceRepository.queryShopdePage(map);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return userSession.getMerberCompname();
        }
        return ((ScShopdeReDomain)qlist.getRows().get(0)).getShopdeName();
    }
}

