/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistDomain;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.EditSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandRelationReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFilesortReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandRelationServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsFilesortServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPropertiesServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpecServiceRepository;
import com.qjsoft.laser.controller.facade.sc.domain.ScShopdeReDomain;
import com.qjsoft.laser.controller.facade.sc.repository.ScShopdeServiceRepository;
import com.qjsoft.laser.controller.facade.wl.domain.WlFreightExpReDomain;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.CmsTginfo;
import com.qjsoft.laser.controller.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public abstract class ResourceComCon
extends SpringmvcController {
    private static String CODE = "rs.resourcecom.con";
    @Autowired
    RsGoodsFilesortServiceRepository rsGoodsFilesortServiceRepository;
    @Autowired
    protected RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    protected ScShopdeServiceRepository scShopdeServiceRepository;
    @Autowired
    protected RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    protected RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    protected RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    protected RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    protected RsPropertiesServiceRepository rsPropertiesServiceRepository;
    @Autowired
    protected RsSpecServiceRepository rsSpecServiceRepository;
    @Autowired
    protected RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    protected RsBrandRelationServiceRepository rsBrandRelationServiceRepository;
    @Autowired
    protected FileServiceRepository fileServiceRepository;
    @Autowired
    protected WlFreightTemServiceRepository wlFreightTemServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";

    protected String getContext() {
        return "resourcecom";
    }

    protected SupQueryResult<WlFreightExpReDomain> queryFreightExpMain(HttpServletRequest request, String type, String memberCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".WlFreightExpReDomain.userSession", (Object)"userSession is null");
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            if (StringUtils.isBlank((String)type)) {
                memberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
            } else if (TYPE_PLAT.equals(type)) {
                memberCode = this.getTeananMemberCode(request);
            } else if (TYPE_BUS.equals(type)) {
                memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
            } else if (TYPE_USER.equals(type)) {
                memberCode = userSession.getUserPcode();
            }
        }
        String tenantCode = this.getTenantCode(request);
        Map param = this.getQueryMapParam("memberCode,tenantCode", new Object[]{memberCode, tenantCode});
        if (null != param) {
            param.put("orderStr", "FREIGHT_EXP_DEFAULT desc");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlFreightTemServiceRepository.queryFreightExpPage(param);
    }

    protected HtmlJsonReBean saveResourceGoodsMain(HttpServletRequest request, String paramStr, String goodsRemark, String flag, String type) {
        HtmlJsonReBean htmlJsonReBean;
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".saveResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList() || ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4e0b\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsType("00");
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        mapP.put("tenantCode", this.getTenantCode(request));
        RsPntreeReDomain rsPntreeReDomain = this.rsPntreeServiceRepository.getPntreeByCode(mapP);
        if (null == rsPntreeReDomain) {
            this.logger.error(CODE + ".saveResourceGoods.rsPntreeReDomain", (Object)((Object)mapP).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5206\u7c7b\u4fe1\u606f\u5f02\u5e38");
        }
        rsResourceGoodsDomain.setPntreeName(rsPntreeReDomain.getPntreeName());
        if (StringUtils.isNotBlank((String)rsPntreeReDomain.getPntreeType())) {
            rsResourceGoodsDomain.setGoodsType(rsPntreeReDomain.getPntreeType());
        }
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                rsResourceGoodsDomain.setMemberCode(this.getTeananMemberCode(request));
                rsResourceGoodsDomain.setMemberName("\u5e73\u53f0");
            } else {
                rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberName(userSession.getMerberCompname());
            }
        } else if (TYPE_PLAT.equals(type)) {
            rsResourceGoodsDomain.setMemberCode(this.getTeananMemberCode(request));
            rsResourceGoodsDomain.setMemberName("\u5e73\u53f0");
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                rsResourceGoodsDomain.setMemberCode(userSession.getUserinfoParentCode());
                rsResourceGoodsDomain.setMemberName(userSession.getUserinfoParentName());
            } else {
                rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberName(userSession.getMerberCompname());
            }
        } else if (TYPE_USER.equals(type)) {
            rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
            rsResourceGoodsDomain.setMemberName(userSession.getMerberCompname());
        }
        switch (flag) {
            case "sup": {
                rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberName(userSession.getMerberCompname());
                DisChannel disChannelReDomain = this.getChannelSup(rsResourceGoodsDomain.getMemberCcode(), this.getTenantCode(request));
                if (null == disChannelReDomain) {
                    this.logger.error(CODE + ".saveResourceGoodsMain.channel", (Object)"skuList is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f9b\u5e94\u5546\u672a\u8bbe\u7f6e\u6e20\u9053");
                }
                if (!this.getDgoodsScopeList(disChannelReDomain.getChannelCode(), this.getTenantCode(request), rsResourceGoodsDomain)) {
                    this.logger.error(CODE + ".saveResourceGoodsMain.channel", (Object)"skuList is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u4e0d\u7b26\u5408\u6e20\u9053\u89c4\u5219\u8bbe\u7f6e");
                }
                rsResourceGoodsDomain.setGoodsOrigin("6");
                break;
            }
            case "sm": {
                rsResourceGoodsDomain.setGoodsOrigin("8");
                break;
            }
            case "int": {
                rsResourceGoodsDomain.setGoodsOrigin("0");
                rsResourceGoodsDomain.setGoodsType("06");
                break;
            }
            case "fic": {
                rsResourceGoodsDomain.setGoodsOrigin("0");
                rsResourceGoodsDomain.setGoodsType("07");
                break;
            }
            case "mcc": {
                rsResourceGoodsDomain.setGoodsPro("3");
                rsResourceGoodsDomain.setGoodsOrigin("20");
                break;
            }
            case "replace": {
                rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberName(userSession.getMerberCompname());
                if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCcode()) || StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCname())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f9b\u5e94\u5546\u4ee3\u7801\u6216\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\u7a7a");
                }
                DisChannel disCha = this.getChannelSup(rsResourceGoodsDomain.getMemberCcode(), this.getTenantCode(request));
                if (null == disCha) {
                    this.logger.error(CODE + ".saveResourceGoodsMain.channel", (Object)"skuList is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f9b\u5e94\u5546\u672a\u8bbe\u7f6e\u6e20\u9053");
                }
                if (!this.getDgoodsScopeList(disCha.getChannelCode(), this.getTenantCode(request), rsResourceGoodsDomain)) {
                    this.logger.error(CODE + ".saveResourceGoodsMain.channel", (Object)"skuList is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u4e0d\u7b26\u5408\u6e20\u9053\u89c4\u5219\u8bbe\u7f6e");
                }
                rsResourceGoodsDomain.setGoodsOrigin("6");
                break;
            }
            case "default": {
                if (null != rsResourceGoodsDomain.getGoodsOrigin() && !StringUtils.isEmpty((String)rsResourceGoodsDomain.getGoodsOrigin())) break;
                rsResourceGoodsDomain.setGoodsOrigin("0");
                break;
            }
        }
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCcode())) {
            rsResourceGoodsDomain.setMemberCcode(rsResourceGoodsDomain.getMemberCode());
            rsResourceGoodsDomain.setMemberCname(rsResourceGoodsDomain.getMemberName());
        }
        this.makeChannel(rsResourceGoodsDomain, request);
        if (null != rsResourceGoodsDomain.getDataOpbillstate() && rsResourceGoodsDomain.getDataOpbillstate() == 1) {
            ArrayList<RsResourceGoodsDomain> rsResourceGoodsDomainList = new ArrayList<RsResourceGoodsDomain>();
            rsResourceGoodsDomainList.add(rsResourceGoodsDomain);
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendSavePassResourceGoodsBatch(rsResourceGoodsDomainList);
        } else {
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendSaveResourceGoods(rsResourceGoodsDomain);
        }
        return htmlJsonReBean;
    }

    private DisChannel getChannelSup(String memberCode, String tenantCode) {
        return (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class);
    }

    private boolean getDgoodsScopeList(String channelCode, String tenantCode, RsResourceGoodsDomain rsResourceGoodsDomain) {
        return this.checkDisGoodsChannel(rsResourceGoodsDomain, channelCode, tenantCode);
    }

    private DisDgoodsDomain checkDgoods(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisDgoodsDomain disDgoods = (DisDgoodsDomain)SupDisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoodsDomain.class);
        if (null == disDgoods) {
            this.logger.error(CODE + ".checkDisGoods.disDgoods", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        if (!"1".equals(disDgoods.getDgoodsSync())) {
            this.logger.error(CODE + ".checkDisGoods.dgoodsSync", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disDgoods;
    }

    private boolean checkDisGoodsChannel(RsResourceGoodsDomain rsResourceGoodsReDomain, String channelCode, String tenantCode) {
        if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return true;
        }
        DisDgoodsDomain disDgoods = this.checkDgoods(channelCode, tenantCode);
        if (null == disDgoods) {
            return true;
        }
        List disDgoodsScopelistList = DisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + tenantCode), DisDgoodsScopelistDomain.class);
        boolean flag = true;
        if (!ListUtil.isEmpty((Collection)disDgoodsScopelistList)) {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return true;
            }
            String term = "";
            String key = "";
            for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs;
                    for (String o : otrs = objValue.toString().split("\\,")) {
                        if (this.cond(valueList, term, o)) break;
                    }
                    continue;
                }
                if (this.cond(valueList, term, objValue)) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelistDomain> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelistDomain disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDgoodsScopelist.getDgoodsScopelistTerm())) {
                disDgoodsScopelist.setDgoodsScopelistTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm()))) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType() + "|" + disDgoodsScopelist.getDgoodsScopelistTerm(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    protected void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    protected String getShopdeName(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult qlist = this.scShopdeServiceRepository.queryShopdePage(map);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return userSession.getMerberCompname();
        }
        return ((ScShopdeReDomain)qlist.getRows().get(0)).getShopdeName();
    }

    protected RsResourceGoodsReDomain fetchResGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResGoodsFromGysEdit", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        if (null != rsResourceGoodsReDomain && ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
            ArrayList<RsGoodsRelDomain> relDomainList = new ArrayList<RsGoodsRelDomain>();
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                map.put("goodsCode", rsGoodsRelDomain.getGoodsRelGcode());
                RsResourceGoodsReDomain relGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                rsGoodsRelDomain.setRsResourceGoods((RsResourceGoodsDomain)relGoods);
                relDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsReDomain.setRsGoodsRelDomainList(relDomainList);
        }
        return rsResourceGoodsReDomain;
    }

    protected HtmlJsonReBean updateResGooMain(HttpServletRequest request, String paramStr, String goodsRemark, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        if (null == rsResourceGoodsDomain || ListUtil.isEmpty((Collection)rsResourceGoodsDomain.getRsSkuDomainList())) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"rsResourceGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
            rsSkuDomain.setGoodsSupplynum(rsSkuDomain.getGoodsNum());
            rsSkuDomain.setGoodsSupplyweight(rsSkuDomain.getGoodsWeight());
        }
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".updateResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        return this.rsResourceGoodsServiceRepository.sendUpdateResourceGoods(rsResourceGoodsDomain);
    }

    protected List<Integer> getGoodsIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            goodsIdList.add(Integer.parseInt(id));
        }
        return goodsIdList;
    }

    protected HtmlJsonReBean checkGoodsNoMain(HttpServletRequest request, String type, String goodsNo, String memberCode, String goodsCode, String channelCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNoMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".checkGoodsNoMain.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)memberCode)) {
            if (StringUtils.isBlank((String)type)) {
                memberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
            } else if (TYPE_PLAT.equals(type)) {
                memberCode = this.getTeananMemberCode(request);
            } else if (TYPE_BUS.equals(type)) {
                memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
            } else if (TYPE_USER.equals(type)) {
                memberCode = userSession.getUserPcode();
            }
        }
        String tenantCode = this.getTenantCode(request);
        Map param = this.getQueryMapParam("goodsNo,memberCode,validFlag,tenantCode", new Object[]{goodsNo, memberCode, true, tenantCode});
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            if (null == channelCode) {
                channelCode = "";
            }
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsList.getRows()) {
                if (!(StringUtils.isNotBlank((String)channelCode) ? !goodsCode.equals(rsResourceGoodsReDomain.getGoodsCode()) && channelCode.equals(rsResourceGoodsReDomain.getChannelCode()) : !goodsCode.equals(rsResourceGoodsReDomain.getGoodsCode()))) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsList && null != rsList.getList() && rsList.getList().size() > 0) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)" exist goodsNo");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean checkSkuNoMain(HttpServletRequest request, String type, String skuNo, String memberCode, String skuCode, String channelCode) {
        Map param;
        SupQueryResult rsList;
        if (StringUtils.isBlank((String)skuNo)) {
            this.logger.error(CODE + ".checkSkuNoMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".checkSkuNoMain.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)memberCode)) {
            if (StringUtils.isBlank((String)type)) {
                memberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
            } else if (TYPE_PLAT.equals(type)) {
                memberCode = this.getTeananMemberCode(request);
            } else if (TYPE_BUS.equals(type)) {
                memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
            } else if (TYPE_USER.equals(type)) {
                memberCode = userSession.getUserPcode();
            }
        }
        if (null == (rsList = this.rsSkuServiceRepository.querySkuOnePage(param = this.getQueryMapParam("skuNo,memberCode,validFlag,tenantCode", new Object[]{skuNo, memberCode, true, tenantCode}))) || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)skuCode)) {
            if (null == channelCode) {
                channelCode = "";
            }
            for (RsSkuReDomain rsSkuReDomain : rsList.getRows()) {
                if (!(StringUtils.isNotBlank((String)channelCode) ? !skuCode.equals(rsSkuReDomain.getSkuCode()) && channelCode.equals(rsSkuReDomain.getChannelCode()) : !skuCode.equals(rsSkuReDomain.getSkuCode()))) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsList && null != rsList.getList() && rsList.getList().size() > 0) {
            this.logger.error(CODE + ".checkSkuNoMain", (Object)(skuNo + "=" + memberCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean updateAuditResourcePassMain(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourcePassMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateAuditResourcePass(this.getGoodsIdList(goodsIdStr));
    }

    protected HtmlJsonReBean updateAuditResourceNoPassMain(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourceNoPassMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateAuditResourceNoPass(this.getGoodsIdList(goodsIdStr));
    }

    protected HtmlJsonReBean cannelGoodsDown(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".cannelGoodsDown", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateSoldOutGoods(this.getGoodsIdList(goodsIdStr));
    }

    protected HtmlJsonReBean cannelGoodsUp(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".cannelGoodsUp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateShelveGoods(this.getGoodsIdList(goodsIdStr));
    }

    protected HtmlJsonReBean batchDeleteResourceUnified(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResourceUnified", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.sendUpdateGoodsStateById(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    protected HtmlJsonReBean updateSkuEdits(HttpServletRequest request, EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            this.logger.error(CODE + ".updateSkuEdit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        editSkuDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.sendUpdateSkuEdit(editSkuDomain);
    }

    protected HtmlJsonReBean updateSkuUp(String skuId) {
        if (null == skuId) {
            this.logger.error(CODE + ".updateSkuUp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateShelveSku(Integer.valueOf(skuId));
    }

    protected HtmlJsonReBean updateSkuDown(String skuId) {
        if (null == skuId) {
            this.logger.error(CODE + ".updateSkuDown", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateSoldOutSku(Integer.valueOf(skuId));
    }

    protected HtmlJsonReBean updateGoodsStateByIdMain(Integer goodsId, Integer dataState, Integer oldDataState) {
        if (null == goodsId || null == dataState) {
            this.logger.error(CODE + ".updateGoodsStateByIdMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateGoodsStateById(goodsId, dataState, oldDataState);
    }

    protected HtmlJsonReBean updateSkuStateByIdMain(Integer skuId, Integer dataState, Integer oldDataState) {
        if (null == skuId || null == dataState) {
            this.logger.error(CODE + ".updateSkuStateByIdMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendUpdateSkuStateById(skuId, dataState, oldDataState);
    }

    protected HtmlJsonReBean deleteGoodsById(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".deleteGoodsById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendDeleteGoodsById(Integer.valueOf(goodsId));
    }

    protected HtmlJsonReBean deleteSkuBySkuId(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSkuBySkuId", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendDeleteSkuBySkuId(Integer.valueOf(skuId));
    }

    protected HtmlJsonReBean virtualorentity(HttpServletRequest request, String path) {
        if (StringUtils.isBlank((String)path)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8def\u7531\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        String map = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-virtualorentity-" + path));
        if (StringUtils.isBlank((String)map)) {
            map = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-virtualorentity-" + path));
        }
        if (StringUtils.isBlank((String)map)) {
            return new HtmlJsonReBean((Object)0);
        }
        return new HtmlJsonReBean((Object)map);
    }

    protected List<RsClasstreeReDomain> getClasstreeLastMain(HttpServletRequest request, String classtreeType, boolean flag, String type, String userMemberCode) {
        SupQueryResult reDomainSupQueryResult;
        if (null == request || StringUtils.isBlank((String)classtreeType)) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getClasstreeLastMain", (Object)"userSession is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String memberCode = "";
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode)) {
            memberCode = userMemberCode;
        } else if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            memberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        } else if (TYPE_PLAT.equals(type)) {
            memberCode = this.getTeananMemberCode(request);
        } else if (TYPE_BUS.equals(type)) {
            memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
        } else if (TYPE_USER.equals(type)) {
            memberCode = userSession.getUserPcode();
        }
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        if (StringUtils.isNotBlank((String)memberCode)) {
            param.put("memberCode", memberCode);
        }
        if (StringUtils.isNotBlank((String)classtreeType)) {
            param.put("classtreeType", classtreeType);
        }
        if (null == (reDomainSupQueryResult = this.rsClasstreeServiceRepository.queryClasstreePage(param)) || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return null;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals("-1")) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            List<RsClasstreeReDomain> childList = this.getChild(rsClasstreeReDomain.getClasstreeCode(), all);
            if (flag) {
                rsClasstreeReDomain.setChildList(childList);
                continue;
            }
            if (null == childList) continue;
            ArrayList<RsClasstreeReDomain> childList1 = new ArrayList<RsClasstreeReDomain>();
            for (RsClasstreeReDomain rsClasstreeReDomain1 : childList) {
                if (!ListUtil.isNotEmpty((Collection)rsClasstreeReDomain1.getChildList())) continue;
                childList1.add(rsClasstreeReDomain1);
                rsClasstreeReDomain.setChildList(childList1);
            }
            if (!ListUtil.isNotEmpty((Collection)rsClasstreeReDomain.getChildList())) continue;
            reDomainList.add(rsClasstreeReDomain);
        }
        if (flag) {
            return rootClass;
        }
        return reDomainList;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public List<RsGoodsClassReDomain> getChildGoodsClass(String id, List<RsGoodsClassReDomain> all) {
        ArrayList<RsGoodsClassReDomain> childList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getGoodsClassParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChildGoodsClass(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    protected List<RsGoodsClassReDomain> getGoodsClassMain(HttpServletRequest request, String goodsClassType, boolean flag, String type, String channelCode, String memberCode) {
        SupQueryResult reDomainSupQueryResult;
        if (null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getClasstreeLastMain", (Object)"userSession is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)memberCode)) {
            if (StringUtils.isBlank((String)type)) {
                memberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
            } else if (TYPE_PLAT.equals(type)) {
                memberCode = this.getTeananMemberCode(request);
            } else if (TYPE_BUS.equals(type)) {
                memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
            } else if (TYPE_USER.equals(type)) {
                memberCode = userSession.getUserPcode();
            }
        }
        ArrayList<RsGoodsClassReDomain> reDomainList = new ArrayList<RsGoodsClassReDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("orderStr", "GOODS_CLASS_ORDER ASC");
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("channelCode", channelCode);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            param.put("memberCode", memberCode);
        }
        if (StringUtils.isNotBlank((String)goodsClassType)) {
            param.put("goodsClassType", goodsClassType);
        }
        if (null == (reDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param)) || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return null;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsGoodsClassReDomain> rootClass = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getGoodsClassParentcode().equals("-1")) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : rootClass) {
            List<RsGoodsClassReDomain> childList = this.getChildGoodsClass(rsGoodsClassReDomain.getGoodsClassCode(), all);
            if (flag) {
                rsGoodsClassReDomain.setChildList(childList);
                continue;
            }
            if (ListUtil.isNotEmpty(childList)) {
                ArrayList<RsGoodsClassReDomain> childList1 = new ArrayList<RsGoodsClassReDomain>();
                for (RsGoodsClassReDomain rsClasstreeReDomain1 : childList) {
                    if (!ListUtil.isNotEmpty((Collection)rsClasstreeReDomain1.getChildList()) && !rsClasstreeReDomain1.getGoodsClassLast().equals("0")) continue;
                    childList1.add(rsClasstreeReDomain1);
                    rsGoodsClassReDomain.setChildList(childList1);
                }
            }
            if (!ListUtil.isNotEmpty((Collection)rsGoodsClassReDomain.getChildList()) && !rsGoodsClassReDomain.getGoodsClassLast().equals("0")) continue;
            reDomainList.add(rsGoodsClassReDomain);
        }
        if (flag) {
            return rootClass;
        }
        return reDomainList;
    }

    protected List<RsBrandReDomain> queryBrandMain(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("order", true);
        SupQueryResult supQueryResult = this.rsBrandServiceRepository.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            return null;
        }
        return supQueryResult.getList();
    }

    protected RsClasstreeReDomain getpntreeCode(HttpServletRequest request, String classTreeCode) {
        if (StringUtils.isBlank((String)classTreeCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("classtreeCode", classTreeCode);
        return this.rsClasstreeServiceRepository.getClasstreeByCode(param);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request, String type, String userMemberCode) {
        Map param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.getBusMemberCodeQueryMapParams(request);
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        return this.querySkuMain(param);
    }

    private SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    protected SupQueryResult<RsPropertiesReDomain> queryProMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPropertiesServiceRepository.queryPropertiesPage(param);
    }

    protected List<RsSpecReDomain> getInfo(String tenantCode, String pntreeCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("pntreeCode", pntreeCode);
        SupQueryResult supQueryResult = this.rsSpecServiceRepository.querySpecGroupPage(map);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return null;
        }
        RsSpecGroupReDomain specGroupReDomain = (RsSpecGroupReDomain)supQueryResult.getList().get(0);
        map.remove("pntreeCode");
        map.put("specGroupCode", specGroupReDomain.getSpecGroupCode());
        SupQueryResult supQueryResult1 = this.rsSpecServiceRepository.querySpecPage(map);
        if (null == supQueryResult1 || ListUtil.isEmpty((Collection)supQueryResult1.getList())) {
            return null;
        }
        SupQueryResult supQueryResult2 = this.rsSpecServiceRepository.querySpecOptionPage(map);
        if (null == supQueryResult2 || ListUtil.isEmpty((Collection)supQueryResult2.getList())) {
            return null;
        }
        Map<String, Object> specMap = this.makeMap(supQueryResult2.getList());
        if (null == specMap) {
            this.logger.error(CODE + ".fetchSpeOptByPntCodeNomRel.specMap", (Object)"list\u6570\u636e\u8f6cmap\u51fa\u9519");
            return null;
        }
        for (RsSpecReDomain rsSpecReDomain : supQueryResult1.getList()) {
            if (!specMap.containsKey(rsSpecReDomain.getSpecCode())) continue;
            rsSpecReDomain.setSpecOptionList((List)specMap.get(rsSpecReDomain.getSpecCode()));
        }
        return supQueryResult1.getList();
    }

    private Map<String, Object> makeMap(List<RsSpecOptionReDomain> list) {
        HashMap<String, Object> specMap = new HashMap<String, Object>();
        ArrayList<RsSpecOptionReDomain> rsSpecOptionReDomains = null;
        for (RsSpecOptionReDomain rsSpecOptionReDomain : list) {
            if (!specMap.containsKey(rsSpecOptionReDomain.getSpecCode())) {
                rsSpecOptionReDomains = new ArrayList<RsSpecOptionReDomain>();
                rsSpecOptionReDomains.add(rsSpecOptionReDomain);
                specMap.put(rsSpecOptionReDomain.getSpecCode(), rsSpecOptionReDomains);
                continue;
            }
            List specList = (List)specMap.get(rsSpecOptionReDomain.getSpecCode());
            specList.add(rsSpecOptionReDomain);
        }
        return specMap;
    }

    protected SupQueryResult<RsBrandRelationReDomain> queryBrandRelMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsBrandRelationServiceRepository.queryBrandRelationPage(param);
    }

    protected SupQueryResult<RsGoodsFilesortReDomain> queryGoodsFilesortByPnTreeCodeMain(HttpServletRequest request, String pntreeCode) {
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".queryGoodsFilesortByPnTreeCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pntreeCode", pntreeCode);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsGoodsFilesortServiceRepository.queryGoodsFilesortPage(param);
    }

    protected FmFileReDomainBean uploadGoodsFilesMain(HttpServletRequest request, MultipartFile file) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFiles", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileServiceRepository.saveFile(file, tenantCode, "FILE_GD");
    }

    protected SupQueryResult<RsSkuReDomain> querySKu(HttpServletRequest request, String tginfoCode) {
        String channelCode;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (StringUtils.isNotBlank((String)(channelCode = this.getChannelCode(tginfoCode, this.getTenantCode(request))))) {
            param.put("channelCode", channelCode);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    private String getChannelCode(String tginfoCode, String tenantCode) {
        TmProappEnv tmProappEnv;
        CmsTginfo tginfo;
        String channelCode = "";
        String proappCode = "";
        if (StringUtils.isNotBlank((String)tginfoCode) && null != (tginfo = (CmsTginfo)SupDisUtil.getMapJson((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode), CmsTginfo.class))) {
            channelCode = tginfo.getChannelCode();
            proappCode = tginfo.getProappCode();
        }
        if (StringUtils.isBlank((String)channelCode) && StringUtils.isNotBlank((String)proappCode) && null != (tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(tenantCode + "-" + proappCode), TmProappEnv.class))) {
            channelCode = tmProappEnv.getChannelCode();
        }
        return channelCode;
    }

    protected List<String> getGoodsCodeList(String goodsCodeStr) {
        String[] idStr = goodsCodeStr.split(",");
        ArrayList<String> goodsIdList = new ArrayList<String>();
        for (String id : idStr) {
            goodsIdList.add(id);
        }
        return goodsIdList;
    }
}

