/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.rs.domain.EditSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandRelationReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFilesortReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.wl.domain.WlFreightExpReDomain;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.qjsoft.laser.controller.resources.controller.ResourceComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/rs/resourceBase"}, name="\u5546\u54c1\u57fa\u7840\u670d\u52a1")
public class ResourceBaseCon
extends ResourceComCon {
    private static String CODE = "rs.resourceBase.con";
    @Autowired
    private RsGoodsOtherServiceRepository goodsOtherServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    @Override
    protected String getContext() {
        return "resourceBase";
    }

    @RequestMapping(value={"checkGoodsRel.json"}, name="\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5173\u8054\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean checkGoodsRel(HttpServletRequest request, String goodsCodeStr) {
        if (StringUtils.isBlank((String)goodsCodeStr)) {
            this.logger.error(CODE + ".checkGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<String> goodsCodeList = this.getGoodsCodeList(goodsCodeStr);
        for (String goodsCode : goodsCodeList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsRelGcode", goodsCode);
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult goodsRelReDomainSupQueryResult = this.goodsOtherServiceRepository.queryGoodsRelPage(map);
            if (null == goodsRelReDomainSupQueryResult || goodsRelReDomainSupQueryResult.getList().size() <= 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u88ab\u5173\u8054\uff0c \u786e\u8ba4\u5220\u9664\uff1f");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateSkuFile.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean updateSkuFile(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"queryGoodsByDis.json"}, name="\u6839\u636e\u7ad9\u70b9\u548c\u79df\u6237code\u67e5\u8be2\u8fc7\u6ee4\u6e20\u9053\u5546\u54c1sku(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResGoodsForBusByDis(HttpServletRequest request, String tginfoCode) {
        return this.querySKu(request, tginfoCode);
    }

    @RequestMapping(value={"getResourceGoods.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f(\u516c\u7528)")
    @ResponseBody
    public RsResourceGoodsReDomain getResourceGoods(String goodsId) {
        return this.fetchResGoods(goodsId);
    }

    @RequestMapping(value={"getResourceGoodsByCode.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f(\u516c\u7528)")
    @ResponseBody
    public RsResourceGoodsReDomain getResourceGoodsByCode(HttpServletRequest request, String goodsCode) {
        return this.fetchResGoodsByCode(goodsCode, request);
    }

    @RequestMapping(value={"getSku.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f(\u516c\u7528)")
    @ResponseBody
    public RsSkuReDomain getSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSkuFromFd", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"queryPropertiesPage.json"}, name="\u5546\u54c1\u5c5e\u6027\u5217\u8868(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsPropertiesReDomain> queryPropertiesPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryProMain(param);
    }

    @RequestMapping(value={"fetchSpeOptByPntCodeNomRel.json"}, name="\u6839\u636e\u7c7b\u578bcode\u67e5\u8be2\u89c4\u683c\u4fe1\u606f-\u53d1\u5e03\u5546\u54c1(\u516c\u7528)")
    @ResponseBody
    public List<RsSpecReDomain> fetchSpeOptByPntCodeNomRel(HttpServletRequest request, String pntreeCode) {
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".fetchSpeOptByPntCodeNomRel", (Object)"param is null");
            return null;
        }
        return this.getInfo(this.getTenantCode(request), pntreeCode);
    }

    @RequestMapping(value={"queryGoodsFilesortByPnTreeCode.json"}, name="\u6839\u636e\u5546\u54c1\u7c7b\u578b\u83b7\u53d6\u5546\u54c1\u56fe\u7247\u5206\u7c7b\u8bbe\u7f6e\u6d41\u6c34\u670d\u52a1\u4fe1\u606f(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsGoodsFilesortReDomain> queryGoodsFilesortByPnTreeCode(HttpServletRequest request, String pntreeCode) {
        return this.queryGoodsFilesortByPnTreeCodeMain(request, pntreeCode);
    }

    @RequestMapping(value={"queryBrandRelationPage.json"}, name="\u5546\u54c1\u54c1\u724c\u5173\u8054\u5217\u8868(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsBrandRelationReDomain> queryBrandRelationPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandRelMain(param);
    }

    @RequestMapping(value={"uploadGoodsFiles.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6(\u6539\u7248)(\u516c\u7528)")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFiles(HttpServletRequest request, MultipartFile file) {
        return this.uploadGoodsFilesMain(request, file);
    }

    @Override
    @RequestMapping(value={"deleteSkuBySkuId.json"}, name="\u6839\u636eID\u5220\u9664sku(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean deleteSkuBySkuId(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSkuBySkuId", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendDeleteSkuBySkuId(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"deleteBatchSkuBySkuId.json"}, name="\u6279\u91cf\u5220\u9664sku(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean deleteBatchSkuBySkuId(String skuIdStr) {
        if (StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".deleteBatchSkuBySkuId", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendDeleteBatchSkuBySkuId(this.getGoodsIdList(skuIdStr));
    }

    @RequestMapping(value={"deleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean deleteResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".deleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.sendDeleteGoodsById(Integer.valueOf(goodsId));
    }

    @Override
    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuMcc.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u6bcd\u5b50")
    @ResponseBody
    public HtmlJsonReBean updateSkuMcc(String goodsCode, String skuCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, RsSkuDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsCode", goodsCode);
        map.put("goodsRelType", "4");
        SupQueryResult supQueryResult = this.goodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u65e0\u5bf9\u5e94\u4fe1\u606f");
            return null;
        }
        HtmlJsonReBean deleteRes = null;
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            deleteRes = this.goodsOtherServiceRepository.deleteGoodsRel(rsGoodsRelReDomain.getGoodsRelId());
        }
        if (null == deleteRes) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u5173\u8054\u5173\u7cfb\u5220\u9664\u5931\u8d25");
            return null;
        }
        HtmlJsonReBean htmlJsonReBean = null;
        RsGoodsRelDomain rsGoodsRelDomain = null;
        for (RsSkuDomain rsSkuReDomain : list) {
            rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsCode(goodsCode);
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuReDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("4");
            rsGoodsRelDomain.setMemberCode(rsSkuReDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuReDomain.getMemberName());
            rsGoodsRelDomain.setSkuCode(rsSkuReDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuReDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
            rsGoodsRelDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
            rsGoodsRelDomain.setDataPic(rsSkuReDomain.getDataPic());
            rsGoodsRelDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            htmlJsonReBean = this.goodsOtherServiceRepository.saveGoodsRel(rsGoodsRelDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateSkuSm.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromTc(String goodsCode, String skuCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, RsSkuDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsSkuCode", skuCode);
        map.put("goodsRelType", "3");
        SupQueryResult supQueryResult = this.goodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u65e0\u5bf9\u5e94\u4fe1\u606f");
            return null;
        }
        HtmlJsonReBean deleteRes = null;
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            deleteRes = this.goodsOtherServiceRepository.deleteGoodsRel(rsGoodsRelReDomain.getGoodsRelId());
        }
        if (null == deleteRes) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u5173\u8054\u5173\u7cfb\u5220\u9664\u5931\u8d25");
            return null;
        }
        HtmlJsonReBean htmlJsonReBean = null;
        RsGoodsRelDomain rsGoodsRelDomain = null;
        for (RsSkuDomain rsSkuReDomain : list) {
            rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsSkuCode(skuCode);
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuReDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("3");
            rsGoodsRelDomain.setMemberCode(rsSkuReDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuReDomain.getMemberName());
            rsGoodsRelDomain.setSkuCode(rsSkuReDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuReDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
            rsGoodsRelDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
            rsGoodsRelDomain.setDataPic(rsSkuReDomain.getDataPic());
            rsGoodsRelDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            htmlJsonReBean = this.goodsOtherServiceRepository.saveGoodsRel(rsGoodsRelDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateBatchDelGoodsById.json"}, name="\u6839\u636eID\u903b\u8f91\u5220\u9664\u5546\u54c1(\u505c\u7528)(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateBatchDelGoodsById(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateBatchDelGoodsById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.updateGoodsStateByIdMain(goodsId, -1, 0);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateBatchReGoodsById.json"}, name="\u6839\u636eID\u903b\u8f91\u5220\u9664\u5546\u54c1(\u505c\u7528)(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateBatchReGoodsById(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateBatchReGoodsById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.updateGoodsStateByIdMain(goodsId, 0, -1);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateBatchDelSkuById.json"}, name="\u6839\u636eID\u903b\u8f91\u5220\u9664SKU(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateBatchDelSkuById(String skuIdStr) {
        if (StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".updateBatchDelSkuById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(skuIdStr);
        for (Integer skuId : goodsIdList) {
            this.updateSkuStateByIdMain(skuId, -1, 0);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateBatchReSkuById.json"}, name="\u6839\u636eID\u903b\u8f91\u6062\u590dSKU(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateBatchReSkuById(String skuIdStr) {
        if (StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".updateBatchReSkuById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(skuIdStr);
        for (Integer skuId : goodsIdList) {
            this.updateSkuStateByIdMain(skuId, 0, -1);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request, String goodsCode) {
        if (StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".querySkuPage", (Object)"param is null");
            return null;
        }
        return this.querySkuMain(this.assemMapParam(request));
    }

    @RequestMapping(value={"updatBatchSkuUp.json"}, name="\u6279\u91cfSKU\u4e0a\u67b6(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updatBatchSkuUp(String skuIdStr) {
        if (StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".updatBatchSkuUp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> skuIdList = this.getGoodsIdList(skuIdStr);
        return this.rsResourceGoodsServiceRepository.sendUpdateShelveBatchSku(skuIdList);
    }

    @RequestMapping(value={"updateBatchSkuDown.json"}, name="\u6279\u91cfSKU\u4e0b\u67b6(\u516c\u7528)")
    @ResponseBody
    public HtmlJsonReBean updateBatchSkuDown(String skuIdStr) {
        if (StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".updateBatchSkuDown", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> skuIdList = this.getGoodsIdList(skuIdStr);
        return this.rsResourceGoodsServiceRepository.sendUpdateSoldOutBatchSku(skuIdList);
    }

    @RequestMapping(value={"queryFreightExpPageForPlat.json"}, name="\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u6a21\u677f\u670d\u52a1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<WlFreightExpReDomain> queryFreightExpPageForPlat(HttpServletRequest request, String memberCode) {
        return this.queryFreightExpMain(request, TYPE_PLAT, memberCode);
    }

    @RequestMapping(value={"checkGoodsNoForPlat.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoForPlat(HttpServletRequest request, String goodsNo, String memberCode, String goodsCode, String channelCode) {
        return this.checkGoodsNoMain(request, TYPE_PLAT, goodsNo, memberCode, goodsCode, channelCode);
    }

    @RequestMapping(value={"checkSkuNoForPlat.json"}, name="\u6821\u9a8c\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean checkSkuNoForPlat(HttpServletRequest request, String skuNo, String memberCode, String skuCode, String channelCode) {
        return this.checkSkuNoMain(request, TYPE_PLAT, skuNo, memberCode, skuCode, channelCode);
    }

    @RequestMapping(value={"updateAuditResourcePassForPlat.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u901a\u8fc7(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePassForPlat(String goodsIdStr) {
        return this.updateAuditResourcePassMain(goodsIdStr);
    }

    @RequestMapping(value={"updateAuditResourceNoPassForPlat.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u4e0d\u901a\u8fc7(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourceNoPassForPlat(String goodsIdStr) {
        return this.updateAuditResourceNoPassMain(goodsIdStr);
    }

    @RequestMapping(value={"queryClasstreeForPlat.json"}, name="\u5546\u54c1\u5206\u7c7b\u6811(\u5e73\u53f0)")
    @ResponseBody
    public List<RsClasstreeReDomain> queryClasstreeForPlat(HttpServletRequest request, String memberCode) {
        return this.getClasstreeLastMain(request, "0", false, TYPE_PLAT, memberCode);
    }

    @RequestMapping(value={"queryGoodsClassTreeForPlat.json"}, name="\u524d\u53f0\u5206\u7c7b\u6811(\u5e73\u53f0)")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForPlat(HttpServletRequest request, String memberCode) {
        return this.getGoodsClassMain(request, null, false, TYPE_PLAT, null, memberCode);
    }

    @RequestMapping(value={"querySkuPageeForPlat.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)(\u5e73\u53f0)(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageForPlat(HttpServletRequest request) {
        return this.querySkuMotherPage(request, TYPE_PLAT, null);
    }

    @RequestMapping(value={"updateGoodsUpForPlat.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsUpForPlat(String goodsIdStr) {
        return this.cannelGoodsUp(goodsIdStr);
    }

    @RequestMapping(value={"updateGoodsDownForPlat.json"}, name="\u5546\u54c1\u4e0b\u67b6(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsDownForPlat(String goodsIdStr) {
        return this.cannelGoodsDown(goodsIdStr);
    }

    @RequestMapping(value={"updatSkuUpForPlat.json"}, name="SKU\u4e0a\u67b6(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updatSkuUpForPlat(String skuId) {
        return this.updateSkuUp(skuId);
    }

    @RequestMapping(value={"updateSkuDownForPlat.json"}, name="SKU\u4e0b\u67b6(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateSkuDownForPlat(String skuId) {
        return this.updateSkuDown(skuId);
    }

    @RequestMapping(value={"updateSkuEditForPlat.json"}, name="\u4fee\u6539\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateSkuEditForPlat(HttpServletRequest request, EditSkuDomain editSkuDomain) {
        return this.updateSkuEdits(request, editSkuDomain);
    }

    @RequestMapping(value={"updateBatchSkuEditForPlat.json"}, name="\u4e2d\u53f0\u4fee\u6539\u4e2d\u53f0\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateBatchSkuEditForPlat(HttpServletRequest request, String editSkuDomainStr, String channelCode) {
        if (StringUtils.isBlank((String)editSkuDomainStr)) {
            this.logger.error(CODE + ".updateBatchSkuEditForPlat.editSkuDomainStr", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        List editSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(editSkuDomainStr, EditSkuDomain.class);
        if (ListUtil.isEmpty((Collection)editSkuDomainList)) {
            this.logger.error(CODE + ".updateBatchSkuEditForPlat.editSkuDomainList", (Object)editSkuDomainStr);
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        for (EditSkuDomain editSkuDomain : editSkuDomainList) {
            editSkuDomain.setChannelCode(channelCode);
            editSkuDomain.setMemberCode(this.getTeananMemberCode(request));
            editSkuDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.updateBatchSkuEdits(request, editSkuDomainList);
    }

    @RequestMapping(value={"updateBatchSkuEditUserForPlat.json"}, name="\u4e2d\u53f0\u4fee\u6539\u7528\u6237\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateBatchSkuEditUserForPlat(HttpServletRequest request, String editSkuDomainStr, String channelCode) {
        if (StringUtils.isBlank((String)editSkuDomainStr)) {
            this.logger.error(CODE + ".updateBatchSkuEditUserForPlat.editSkuDomainStr", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        List editSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(editSkuDomainStr, EditSkuDomain.class);
        if (ListUtil.isEmpty((Collection)editSkuDomainList)) {
            this.logger.error(CODE + ".updateBatchSkuEditUserForPlat.editSkuDomainList", (Object)editSkuDomainStr);
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        for (EditSkuDomain editSkuDomain : editSkuDomainList) {
            if (StringUtils.isBlank((String)editSkuDomain.getMemberCode())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            editSkuDomain.setChannelCode(channelCode);
            editSkuDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.updateBatchSkuEdits(request, editSkuDomainList);
    }

    @RequestMapping(value={"updateBatchSkuEditForBus.json"}, name="\u8fd0\u8425\u4fee\u6539\u8fd0\u8425\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateBatchSkuEditForBus(HttpServletRequest request, String editSkuDomainStr, String channelCode) {
        if (StringUtils.isBlank((String)editSkuDomainStr)) {
            this.logger.error(CODE + ".updateBatchSkuEditForBus.editSkuDomainStr", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        List editSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(editSkuDomainStr, EditSkuDomain.class);
        if (ListUtil.isEmpty((Collection)editSkuDomainList)) {
            this.logger.error(CODE + ".updateBatchSkuEditForBus.editSkuDomainList", (Object)editSkuDomainStr);
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateBatchSkuEditForBus.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        String memberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
        for (EditSkuDomain editSkuDomain : editSkuDomainList) {
            editSkuDomain.setChannelCode(channelCode);
            editSkuDomain.setMemberCode(memberCode);
            editSkuDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.updateBatchSkuEdits(request, editSkuDomainList);
    }

    @RequestMapping(value={"updateBatchSkuEditForUser.json"}, name="\u7528\u6237\u4fee\u6539\u7528\u6237\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateBatchSkuEditForUser(HttpServletRequest request, String editSkuDomainStr, String channelCode) {
        if (StringUtils.isBlank((String)editSkuDomainStr)) {
            this.logger.error(CODE + ".updateBatchSkuEditForUser.editSkuDomainStr", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        List editSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(editSkuDomainStr, EditSkuDomain.class);
        if (ListUtil.isEmpty((Collection)editSkuDomainList)) {
            this.logger.error(CODE + ".updateBatchSkuEditForUser.editSkuDomainList", (Object)editSkuDomainStr);
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateBatchSkuEditForPlat.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        for (EditSkuDomain editSkuDomain : editSkuDomainList) {
            editSkuDomain.setChannelCode(channelCode);
            editSkuDomain.setMemberCode(userSession.getUserPcode());
            editSkuDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.updateBatchSkuEdits(request, editSkuDomainList);
    }

    @RequestMapping(value={"queryAuditGoodsForPlat.json"}, name="\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryAuditGoodsForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPageComForPlat.json"}, name="\u67e5\u8be2\u5e73\u53f0\u5546\u54c1\u5206\u9875\u5217\u8868(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageComForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageComForPlat.json"}, name="\u67e5\u8be2\u5e73\u53f0\u8d27\u54c1\u5206\u9875\u5217\u8868(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageComForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsForPlat.json"}, name="\u589e\u52a0\u6807\u51c6\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForPlat", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "default", TYPE_PLAT);
    }

    @RequestMapping(value={"updateResourceGoodsForPlat.json"}, name="\u66f4\u65b0\u6807\u51c6\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_PLAT);
    }

    @RequestMapping(value={"queryResourceGoodsPageForPlat.json"}, name="\u67e5\u8be2\u6807\u51c6\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageForPlat.json"}, name="\u67e5\u8be2\u6807\u51c6\u8d27\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsMccForPlat.json"}, name="\u589e\u52a0\u6bcd\u5b50\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsMccForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMccForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMccForPlat", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "mcc", TYPE_PLAT);
    }

    @RequestMapping(value={"updateResourceGoodsMccForPlat.json"}, name="\u66f4\u65b0\u6bcd\u5b50\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsMccForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_PLAT);
    }

    @RequestMapping(value={"queryResourceGoodsMccPageForPlat.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsMccPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuMccPageForPlat.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u8d27\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuMccPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsSmForPlat.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsSmForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsSmForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsSmForPlat", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "sm", TYPE_PLAT);
    }

    @RequestMapping(value={"updateResourceGoodsSmForPlat.json"}, name="\u66f4\u65b0\u5957\u9910\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsSmForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_PLAT);
    }

    @RequestMapping(value={"queryResourceGoodsSmPageForPlat.json"}, name="\u67e5\u8be2\u5957\u9910\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsSmPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuSmPageForPlat.json"}, name="\u67e5\u8be2\u5957\u9910\u8d27\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuSmPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsIntForPlat.json"}, name="\u589e\u52a0\u79ef\u5206\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsIntForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsIntForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsIntForPlat", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "int", TYPE_PLAT);
    }

    @RequestMapping(value={"updateResourceGoodsIntForPlat.json"}, name="\u66f4\u65b0\u79ef\u5206\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsIntForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_PLAT);
    }

    @RequestMapping(value={"queryResourceGoodsIntPageForPlat.json"}, name="\u67e5\u8be2\u79ef\u5206\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsIntPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuIntPageForPlat.json"}, name="\u67e5\u8be2\u79ef\u5206\u8d27\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuIntPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsFicForPlat.json"}, name="\u589e\u52a0\u865a\u62df\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsFicForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsFicForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsFicForPlat", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "fic", TYPE_PLAT);
    }

    @RequestMapping(value={"updateResourceGoodsFicForPlat.json"}, name="\u66f4\u65b0\u865a\u62df\u5546\u54c1(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsFicForPlat(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_PLAT);
    }

    @RequestMapping(value={"queryResourceGoodsFicPageForPlat.json"}, name="\u67e5\u8be2\u865a\u62df\u5546\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFicPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuFicPageForPlat.json"}, name="\u67e5\u8be2\u865a\u62df\u8d27\u54c1\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuFicPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryFreightExpPageForBus.json"}, name="\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u6a21\u677f\u670d\u52a1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<WlFreightExpReDomain> queryFreightExpPageForBus(HttpServletRequest request, String memberCode) {
        return this.queryFreightExpMain(request, TYPE_BUS, memberCode);
    }

    @RequestMapping(value={"checkGoodsNoForBus.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoForBus(HttpServletRequest request, String goodsNo, String memberCode, String goodsCode, String channelCode) {
        return this.checkGoodsNoMain(request, TYPE_BUS, goodsNo, memberCode, goodsCode, channelCode);
    }

    @RequestMapping(value={"checkSkuNoForBus.json"}, name="\u6821\u9a8c\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean checkSkuNoForBus(HttpServletRequest request, String skuNo, String memberCode, String skuCode, String channelCode) {
        return this.checkSkuNoMain(request, TYPE_BUS, skuNo, memberCode, skuCode, channelCode);
    }

    @RequestMapping(value={"updateAuditResourcePassForBus.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u901a\u8fc7(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePassForBus(String goodsIdStr) {
        return this.updateAuditResourcePassMain(goodsIdStr);
    }

    @RequestMapping(value={"updateAuditResourceNoPassForBus.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u4e0d\u901a\u8fc7(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourceNoPassForBus(String goodsIdStr) {
        return this.updateAuditResourceNoPassMain(goodsIdStr);
    }

    @RequestMapping(value={"queryClasstreeForBus.json"}, name="\u5546\u54c1\u5206\u7c7b\u6811(\u8fd0\u8425)")
    @ResponseBody
    public List<RsClasstreeReDomain> queryClasstreeForBus(HttpServletRequest request, String memberCode) {
        return this.getClasstreeLastMain(request, "0", false, TYPE_BUS, memberCode);
    }

    @RequestMapping(value={"queryGoodsClassTreeForBus.json"}, name="\u524d\u53f0\u5206\u7c7b\u6811(\u8fd0\u8425)")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForBus(HttpServletRequest request, String memberCode) {
        return this.getGoodsClassMain(request, null, false, TYPE_BUS, null, memberCode);
    }

    @RequestMapping(value={"querySkuPageeForBus.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)(\u8fd0\u8425)(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageeForBus(HttpServletRequest request) {
        return this.querySkuMotherPage(request, TYPE_BUS, null);
    }

    @RequestMapping(value={"updateGoodsUpForBus.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsUpForBus(String goodsIdStr) {
        return this.cannelGoodsUp(goodsIdStr);
    }

    @RequestMapping(value={"updateGoodsDownForBus.json"}, name="\u5546\u54c1\u4e0b\u67b6(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsDownForBus(String goodsIdStr) {
        return this.cannelGoodsDown(goodsIdStr);
    }

    @RequestMapping(value={"updatSkuUpForBus.json"}, name="SKU\u4e0a\u67b6(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updatSkuUpForBus(String skuId) {
        return this.updateSkuUp(skuId);
    }

    @RequestMapping(value={"updateSkuDownForBus.json"}, name="SKU\u4e0b\u67b6(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateSkuDownForBus(String skuId) {
        return this.updateSkuDown(skuId);
    }

    @RequestMapping(value={"updateSkuEditForBus.json"}, name="\u4fee\u6539\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateSkuEditForBus(HttpServletRequest request, EditSkuDomain editSkuDomain) {
        return this.updateSkuEdits(request, editSkuDomain);
    }

    @RequestMapping(value={"updateSkuEditForBusBatch.json"}, name="\u4fee\u6539\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateSkuEditForBusBatch(HttpServletRequest request, String editSkuDomainJson) {
        List editSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(editSkuDomainJson, EditSkuDomain.class);
        for (EditSkuDomain editSkuDomain : editSkuDomainList) {
            this.updateSkuEdits(request, editSkuDomain);
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"queryAuditGoodsForBus.json"}, name="\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryAuditGoodsForBus(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"saveResourceGoodsForBus.json"}, name="\u589e\u52a0\u6807\u51c6\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "default", TYPE_BUS);
    }

    @RequestMapping(value={"updateResourceGoodsForBus.json"}, name="\u66f4\u65b0\u6807\u51c6\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsPageForBus.json"}, name="\u67e5\u8be2\u6807\u51c6\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageForBus.json"}, name="\u67e5\u8be2\u6807\u51c6\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsMccForBus.json"}, name="\u589e\u52a0\u6bcd\u5b50\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsMccForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMccForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMccForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "mcc", TYPE_BUS);
    }

    @RequestMapping(value={"updateResourceGoodsMccForBus.json"}, name="\u66f4\u65b0\u6bcd\u5b50\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsMccForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsMccPageForBus.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsMccPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuMccPageForBus.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuMccPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsSmForBus.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsSmForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsSmForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsSmForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "sm", TYPE_BUS);
    }

    @RequestMapping(value={"updateResourceGoodsSmForBus.json"}, name="\u66f4\u65b0\u5957\u9910\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsSmForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsSmPageForBus.json"}, name="\u67e5\u8be2\u5957\u9910\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsSmPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuSmPageForBus.json"}, name="\u67e5\u8be2\u5957\u9910\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuSmPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsIntForBus.json"}, name="\u589e\u52a0\u79ef\u5206\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsIntForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsIntForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsIntForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "int", TYPE_BUS);
    }

    @RequestMapping(value={"updateResourceGoodsIntForBus.json"}, name="\u66f4\u65b0\u79ef\u5206\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsIntForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsIntPageForBus.json"}, name="\u67e5\u8be2\u79ef\u5206\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsIntPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuIntPageForBus.json"}, name="\u67e5\u8be2\u79ef\u5206\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuIntPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsFicForBus.json"}, name="\u589e\u52a0\u865a\u62df\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsFicForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsFicForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsFicForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "fic", TYPE_BUS);
    }

    @RequestMapping(value={"updateResourceGoodsFicForBus.json"}, name="\u66f4\u65b0\u865a\u62df\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsFicForBus(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsFicPageForBus.json"}, name="\u67e5\u8be2\u865a\u62df\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFicPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuFicPageForBus.json"}, name="\u67e5\u8be2\u865a\u62df\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuFicPageForBus(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsForAt.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsForAt(HttpServletRequest request, String paramStr, String goodsRemark, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForBus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForBus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "at", type);
    }

    @RequestMapping(value={"updateResourceGoodsForAt.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5546\u54c1(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsForAt(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_BUS);
    }

    @RequestMapping(value={"queryResourceGoodsPageForAt.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageForAt(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "19");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageForAt.json"}, name="\u67e5\u8be2\u8ba2\u5355\u8d27\u54c1\u5206\u9875\u5217\u8868(\u8fd0\u8425)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageForAt(HttpServletRequest request) {
        Map param = this.getBusMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "19");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryFreightExpPageForUser.json"}, name="\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u6a21\u677f\u670d\u52a1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<WlFreightExpReDomain> queryFreightExpPageForUser(HttpServletRequest request, String memberCode) {
        return this.queryFreightExpMain(request, TYPE_USER, memberCode);
    }

    @RequestMapping(value={"checkGoodsNoForUser.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoForUser(HttpServletRequest request, String goodsNo, String memberCode, String goodsCode, String channelCode) {
        return this.checkGoodsNoMain(request, TYPE_USER, goodsNo, memberCode, goodsCode, channelCode);
    }

    @RequestMapping(value={"checkSkuNoForUser.json"}, name="\u6821\u9a8c\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean checkSkuNoForUser(HttpServletRequest request, String skuNo, String memberCode, String skuCode, String channelCode) {
        return this.checkSkuNoMain(request, TYPE_USER, skuNo, memberCode, skuCode, channelCode);
    }

    @RequestMapping(value={"updateAuditResourcePassForUser.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u901a\u8fc7(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePassForUser(String goodsIdStr) {
        return this.updateAuditResourcePassMain(goodsIdStr);
    }

    @RequestMapping(value={"updateAuditResourceNoPassForUser.json"}, name="\u5546\u54c1\u4e0a\u67b6\u5ba1\u6838\u4e0d\u901a\u8fc7(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourceNoPassForUser(String goodsIdStr) {
        return this.updateAuditResourceNoPassMain(goodsIdStr);
    }

    @RequestMapping(value={"queryClasstreeForUser.json"}, name="\u5546\u54c1\u5206\u7c7b\u6811(\u7528\u6237)")
    @ResponseBody
    public List<RsClasstreeReDomain> queryClasstreeForUser(HttpServletRequest request) {
        return this.getClasstreeLastMain(request, "0", false, TYPE_USER, null);
    }

    @RequestMapping(value={"queryGoodsClassTreeForUser.json"}, name="\u524d\u53f0\u5206\u7c7b\u6811(\u7528\u6237)")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForUser(HttpServletRequest request) {
        return this.getGoodsClassMain(request, null, false, TYPE_USER, null, null);
    }

    @RequestMapping(value={"querySkuPageeForUser.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)(\u7528\u6237)(\u516c\u7528)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageeForUser(HttpServletRequest request) {
        return this.querySkuMotherPage(request, TYPE_USER, null);
    }

    @RequestMapping(value={"updateGoodsUpForUser.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsUpForUser(String goodsIdStr) {
        return this.cannelGoodsUp(goodsIdStr);
    }

    @RequestMapping(value={"updateGoodsDownForUser.json"}, name="\u5546\u54c1\u4e0b\u67b6(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateGoodsDownForUser(String goodsIdStr) {
        return this.cannelGoodsDown(goodsIdStr);
    }

    @RequestMapping(value={"updatSkuUpForUser.json"}, name="SKU\u4e0a\u67b6(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updatSkuUpForUser(String skuId) {
        return this.updateSkuUp(skuId);
    }

    @RequestMapping(value={"updateSkuDownForUser.json"}, name="SKU\u4e0b\u67b6(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateSkuDownForUser(String skuId) {
        return this.updateSkuDown(skuId);
    }

    @RequestMapping(value={"updateSkuEditForUser.json"}, name="\u4fee\u6539\u5e93\u5b58\u8ddf\u4ef7\u683c\uff08\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateSkuEditForUser(HttpServletRequest request, EditSkuDomain editSkuDomain) {
        return this.updateSkuEdits(request, editSkuDomain);
    }

    @RequestMapping(value={"queryAuditGoodsForUser.json"}, name="\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryAuditGoodsForUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"saveResourceGoodsForUser.json"}, name="\u589e\u52a0\u6807\u51c6\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "default", TYPE_USER);
    }

    @RequestMapping(value={"updateResourceGoodsForUser.json"}, name="\u66f4\u65b0\u6807\u51c6\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_USER);
    }

    @RequestMapping(value={"queryResourceGoodsPageForUser.json"}, name="\u67e5\u8be2\u6807\u51c6\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageForUser.json"}, name="\u67e5\u8be2\u6807\u51c6\u8d27\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPageForSup.json"}, name="\u67e5\u770b\u6807\u51c6\u5546\u54c1(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuPageForSup.json"}, name="\u67e5\u8be2\u6807\u51c6\u8d27\u54c1\u5206\u9875\u5217\u8868(\u4f9b\u5e94)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsMccForUser.json"}, name="\u589e\u52a0\u6bcd\u5b50\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsMccForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMccForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMccForUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "mcc", TYPE_USER);
    }

    @RequestMapping(value={"updateResourceGoodsMccForUser.json"}, name="\u66f4\u65b0\u6bcd\u5b50\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsMccForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_USER);
    }

    @RequestMapping(value={"queryResourceGoodsMccPageForUser.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsMccPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuMccPageForUser.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u8d27\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuMccPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryResourceGoodsMccPageForSup.json"}, name="\u67e5\u770b\u6bcd\u5b50\u5546\u54c1(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsMccPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuMccPageForSup.json"}, name="\u67e5\u8be2\u6bcd\u5b50\u8d27\u54c1\u5206\u9875\u5217\u8868(\u4f9b\u5e94)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuMccPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsPro", "3");
        param.put("goodsOrigin", "20");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsSmForUser.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsSmForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsSmForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsSmForUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "sm", TYPE_USER);
    }

    @RequestMapping(value={"updateResourceGoodsSmForUser.json"}, name="\u66f4\u65b0\u5957\u9910\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsSmForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_USER);
    }

    @RequestMapping(value={"queryResourceGoodsSmPageForUser.json"}, name="\u67e5\u8be2\u5957\u9910\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsSmPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuSmPageForUser.json"}, name="\u67e5\u8be2\u5957\u9910\u8d27\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuSmPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryResourceGoodsSmPageForSup.json"}, name="\u67e5\u770b\u5957\u9910\u5546\u54c1(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsSmPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuSmPageForSup.json"}, name="\u67e5\u8be2\u5957\u9910\u8d27\u54c1\u5206\u9875\u5217\u8868(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuSmPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsIntForUser.json"}, name="\u589e\u52a0\u79ef\u5206\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsIntForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsIntForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsIntForUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "int", TYPE_USER);
    }

    @RequestMapping(value={"updateResourceGoodsIntForUser.json"}, name="\u66f4\u65b0\u79ef\u5206\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsIntForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_USER);
    }

    @RequestMapping(value={"queryResourceGoodsIntPageForUser.json"}, name="\u67e5\u8be2\u79ef\u5206\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsIntPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuIntPageForUser.json"}, name="\u67e5\u8be2\u79ef\u5206\u8d27\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuIntPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryResourceGoodsIntPageForSup.json"}, name="\u67e5\u770b\u79ef\u5206\u5546\u54c1(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsIntPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuIntPageForSup.json"}, name="\u67e5\u8be2\u79ef\u5206\u8d27\u54c1\u5206\u9875\u5217\u8868(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuIntPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsType", "06");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveResourceGoodsFicForUser.json"}, name="\u589e\u52a0\u865a\u62df\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsFicForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsFicForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsFicForUser", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "fic", TYPE_USER);
    }

    @RequestMapping(value={"updateResourceGoodsFicForUser.json"}, name="\u66f4\u65b0\u865a\u62df\u5546\u54c1(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsFicForUser(HttpServletRequest request, String paramStr, String goodsRemark) {
        return this.updateResGooMain(request, paramStr, goodsRemark, TYPE_USER);
    }

    @RequestMapping(value={"queryResourceGoodsFicPageForUser.json"}, name="\u67e5\u8be2\u865a\u62df\u5546\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFicPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuFicPageForUser.json"}, name="\u67e5\u8be2\u865a\u62df\u8d27\u54c1\u5206\u9875\u5217\u8868(\u7528\u6237)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuFicPageForUser(HttpServletRequest request) {
        Map param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryResourceGoodsFicPageForSup.json"}, name="\u67e5\u770b\u865a\u62df\u5546\u54c1(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFicPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryRsSkuFicPageForSup.json"}, name="\u67e5\u8be2\u865a\u62df\u8d27\u54c1\u5206\u9875\u5217\u8868(\u4f9b\u5e94\u5546)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryRsSkuFicPageForSup(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"importResourceGoodsBatch.json"}, name="\u6279\u91cf\u5bfc\u5165\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean importResourceGoodsBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".importResourceGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".importResourceGoodsBatch", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List rsResourceGoodsDomains = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsResourceGoodsDomain.class);
        StringBuilder error = new StringBuilder();
        ArrayList<String> errorClasstreeName = new ArrayList<String>();
        ArrayList<String> errorBrandName = new ArrayList<String>();
        ArrayList<String> errorFgreightName = new ArrayList<String>();
        ArrayList<String> errorSkuNo = new ArrayList<String>();
        ArrayList<String> errorSpec = new ArrayList<String>();
        ArrayList<String> errorMember = new ArrayList<String>();
        HashMap<String, String> memberCname = new HashMap<String, String>();
        HashMap<String, String> goodsAndSkuNo = new HashMap<String, String>();
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        ArrayList<RsResourceGoodsDomain> inserResourceGoodsList = new ArrayList<RsResourceGoodsDomain>();
        for (RsResourceGoodsDomain rsResourceGoodsDomain : rsResourceGoodsDomains) {
            String goodsCode;
            SupQueryResult rsSkuList;
            SupQueryResult supQueryResult;
            boolean flag = true;
            String goodsNo = rsResourceGoodsDomain.getGoodsNo();
            String classtreeName = rsResourceGoodsDomain.getClasstreeName();
            String brandName = rsResourceGoodsDomain.getBrandName();
            String freightTemName = rsResourceGoodsDomain.getFreightTemName();
            String spec = rsResourceGoodsDomain.getGoodsSpec();
            BigDecimal nPrice = rsResourceGoodsDomain.getPricesetNprice() == null ? BigDecimal.ZERO : rsResourceGoodsDomain.getPricesetNprice();
            BigDecimal basePrice = rsResourceGoodsDomain.getPricesetBaseprice() == null ? BigDecimal.ZERO : rsResourceGoodsDomain.getPricesetBaseprice();
            BigDecimal makePrice = rsResourceGoodsDomain.getPricesetMakeprice() == null ? BigDecimal.ZERO : rsResourceGoodsDomain.getPricesetMakeprice();
            String skuNo = rsResourceGoodsDomain.getSkuNo();
            String memeberCname = rsResourceGoodsDomain.getMemberCname();
            rsResourceGoodsDomain.setPricesetNprice(nPrice);
            rsResourceGoodsDomain.setPricesetBaseprice(basePrice);
            rsResourceGoodsDomain.setPricesetMakeprice(makePrice);
            if (StringUtils.isBlank((String)goodsNo) || StringUtils.isBlank((String)classtreeName) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)brandName) || StringUtils.isBlank((String)freightTemName) || StringUtils.isBlank((String)memeberCname) || StringUtils.isBlank((String)spec) || null == rsResourceGoodsDomain.getPricesetNprice() || null == rsResourceGoodsDomain.getPricesetBaseprice() || null == rsResourceGoodsDomain.getPricesetMakeprice()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b58\u5728\u7a7a\u503c\uff01 \u8bf7\u4ed4\u7ec6\u68c0\u67e5");
            }
            rsResourceGoodsDomain.setTenantCode(tenantCode);
            rsResourceGoodsDomain.setDataOpbillstate(Integer.valueOf(0));
            rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
            rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
            rsResourceGoodsDomain.setGoodsOrigin("0");
            rsResourceGoodsDomain.setGoodsType("00");
            if (!goodsMap.containsKey(rsResourceGoodsDomain.getPntreeCode())) {
                HashMap<String, String> mapP = new HashMap<String, String>();
                mapP.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
                mapP.put("tenantCode", this.getTenantCode(request));
                RsPntreeReDomain rsPntreeReDomain = this.rsPntreeServiceRepository.getPntreeByCode(mapP);
                if (null != rsPntreeReDomain && StringUtils.isNotBlank((String)rsPntreeReDomain.getPntreeType())) {
                    rsResourceGoodsDomain.setGoodsType(rsPntreeReDomain.getPntreeType());
                    goodsMap.put(rsResourceGoodsDomain.getPntreeCode(), rsPntreeReDomain.getPntreeType());
                }
            } else {
                rsResourceGoodsDomain.setGoodsType((String)goodsMap.get(rsResourceGoodsDomain.getPntreeCode()));
            }
            if (memberCname.containsKey(memeberCname)) {
                rsResourceGoodsDomain.setMemberCcode((String)memberCname.get(memeberCname));
            } else {
                List umUserinfoReDomainBeans = this.userServiceRepository.queryUserinfoList(this.getQueryMapParam("userinfoCompname,tenantCode", new Object[]{memeberCname, tenantCode}));
                if (null == umUserinfoReDomainBeans || ListUtil.isEmpty((Collection)umUserinfoReDomainBeans)) {
                    if (!errorMember.contains(memeberCname)) {
                        error.append("\u4f9b\u5e94\u5546\uff1a \u3010" + memeberCname + "\u3011 \u4e0d\u5b58\u5728\uff1b\n");
                        errorMember.add(memeberCname);
                        flag = false;
                    }
                } else {
                    String memberCcode = ((UmUserinfoReDomainBean)umUserinfoReDomainBeans.get(0)).getUserinfoCode();
                    rsResourceGoodsDomain.setMemberCcode(memberCcode);
                    memberCname.put(memeberCname, memberCcode);
                }
            }
            String pntreeCode = null;
            if (StringUtils.isNotBlank((String)classtreeName)) {
                String lastName = classtreeName.substring(classtreeName.lastIndexOf("/") + 1);
                RsClasstreeReDomain rsClasstreeReDomain = this.rsClasstreeServiceRepository.checkClasstreeName(lastName, tenantCode);
                if (null == rsClasstreeReDomain) {
                    if (!errorClasstreeName.contains(classtreeName)) {
                        error.append("\u5206\u7c7b\uff1a \u3010" + classtreeName + "\u3011 \u672a\u7ef4\u62a4\uff1b\n");
                        errorClasstreeName.add(classtreeName);
                        flag = false;
                    }
                } else {
                    rsResourceGoodsDomain.setClasstreeName(lastName);
                    if (StringUtils.isNotBlank((String)rsClasstreeReDomain.getPntreeCode())) {
                        RsPntreeReDomain rsPntreeReDomain = this.rsPntreeServiceRepository.getPntreeByCode(this.getQueryMapParam("pntreeCode,tenantCode", new Object[]{rsClasstreeReDomain.getPntreeCode(), tenantCode}));
                        if (null != rsPntreeReDomain) {
                            pntreeCode = rsPntreeReDomain.getPntreeCode();
                            rsResourceGoodsDomain.setPntreeCode(rsPntreeReDomain.getPntreeCode());
                            rsResourceGoodsDomain.setPntreeName(rsPntreeReDomain.getPntreeName());
                            rsResourceGoodsDomain.setClasstreeCode(rsClasstreeReDomain.getClasstreeCode());
                        } else {
                            this.logger.error(CODE + ".importResourceGoodsBatch", (Object)"pntreeCode \u672a\u5728\u8868\u4e2d\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01\uff01\uff01\uff01");
                            error.append(" \u5206\u7c7b\uff1a \u3010" + classtreeName + "\u3011 \u4e2d\uff0c\u672b\u7ea7\u5206\u7c7b\u7c7b\u578b\u5173\u8054\u5f02\u5e38\uff01\uff1b\n");
                            flag = false;
                        }
                    } else {
                        error.append(" \u5206\u7c7b\uff1a \u3010" + classtreeName + "\u3011 \u4e2d\uff0c\u672b\u7ea7\u5206\u7c7b\u672a\u5173\u8054\u7c7b\u578b\uff1b\n");
                        flag = false;
                    }
                }
            }
            if (StringUtils.isNotBlank((String)brandName)) {
                RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByName(brandName, tenantCode);
                if (null == rsBrandReDomain) {
                    if (!errorBrandName.contains(brandName)) {
                        error.append(" \u54c1\u724c\uff1a \u3010" + brandName + "\u3011 \u4e0d\u5b58\u5728\uff1b\n");
                        errorBrandName.add(brandName);
                        flag = false;
                    }
                } else {
                    rsResourceGoodsDomain.setBrandCode(rsBrandReDomain.getBrandCode());
                }
            }
            if (StringUtils.isNotBlank((String)freightTemName)) {
                SupQueryResult wlFreightExpReDomainSupQueryResult = this.wlFreightTemServiceRepository.queryFreightExpPage(this.getQueryMapParam("freightExpName,tenantCode", new Object[]{freightTemName, tenantCode}));
                if (null == wlFreightExpReDomainSupQueryResult || ListUtil.isEmpty((Collection)wlFreightExpReDomainSupQueryResult.getList())) {
                    if (!errorFgreightName.contains(freightTemName)) {
                        error.append(" \u7269\u6d41\u6a21\u677f\uff1a \u3010" + freightTemName + "\u3011 \u4e0d\u5b58\u5728\uff1b\n");
                        errorFgreightName.add(freightTemName);
                        flag = false;
                    }
                } else {
                    rsResourceGoodsDomain.setFreightTemCode(((WlFreightExpReDomain)wlFreightExpReDomainSupQueryResult.getList().get(0)).getFreightExpCode());
                }
            }
            if (StringUtils.isNotBlank((String)goodsNo)) {
                if (goodsAndSkuNo.containsKey(goodsNo)) {
                    String value = (String)goodsAndSkuNo.get(goodsNo);
                    if (value.contains(skuNo)) {
                        error.append(" \u8d27\u54c1\u7f16\u53f7\uff1a \u3010" + skuNo + "\u3011 \u91cd\u590d\uff1b\n");
                        errorSkuNo.add(skuNo);
                        flag = false;
                    } else {
                        goodsAndSkuNo.put(goodsNo, value + "," + skuNo);
                    }
                } else {
                    goodsAndSkuNo.put(goodsNo, skuNo);
                }
            }
            if (StringUtils.isNotBlank((String)skuNo) && null != (supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(this.getQueryMapParam("goodsNo,tenantCode", new Object[]{goodsNo, tenantCode}))) && ListUtil.isNotEmpty((Collection)supQueryResult.getList()) && null != (rsSkuList = this.rsSkuServiceRepository.querySkuPage(this.getQueryMapParam("goodsCode,skuNo,tenantCode", new Object[]{goodsCode = ((RsResourceGoodsReDomain)supQueryResult.getList().get(0)).getGoodsCode(), skuNo, tenantCode}))) && ListUtil.isNotEmpty((Collection)rsSkuList.getList()) && !errorSkuNo.contains(skuNo)) {
                error.append(" \u8d27\u54c1\u7f16\u53f7\uff1a \u3010" + skuNo + "\u3011 \u5df2\u5b58\u5728\uff1b\n");
                errorSkuNo.add(skuNo);
                flag = false;
            }
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            if (StringUtils.isNotBlank((String)spec) && StringUtils.isNotBlank(pntreeCode)) {
                String[] str = spec.split("/");
                for (int i = 0; i < str.length; ++i) {
                    RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                    RsSpecOptionReDomain rsSpecOptionReDomain = this.rsSpecServiceRepository.checkSpecName(pntreeCode, str[i], tenantCode);
                    if (null != rsSpecOptionReDomain) {
                        rsSpecValueDomain.setSpecGroupCode(rsSpecOptionReDomain.getSpecGroupCode());
                        rsSpecValueDomain.setSpecCode(rsSpecOptionReDomain.getSpecCode());
                        rsSpecValueDomain.setTenantCode(tenantCode);
                        rsSpecValueDomain.setSpecValueValue(rsSpecOptionReDomain.getSpecOptionName());
                        rsSpecValueDomainList.add(rsSpecValueDomain);
                        continue;
                    }
                    if (errorSpec.contains(str[i])) continue;
                    error.append(" \u89c4\u683c\uff1a \u3010" + str[i] + "\u3011 \u4e0d\u5b58\u5728\uff1b\n");
                    errorSpec.add(str[i]);
                    flag = false;
                }
            }
            rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            if (!flag) continue;
            inserResourceGoodsList.add(rsResourceGoodsDomain);
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (rsResourceGoodsDomains.size() == inserResourceGoodsList.size()) {
            for (RsResourceGoodsDomain rsResourceGoodsDomain : inserResourceGoodsList) {
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuName(rsResourceGoodsDomain.getGoodsSpec());
                rsSkuDomain.setSkuNo(rsResourceGoodsDomain.getSkuNo());
                rsSkuDomain.setPricesetNprice(rsResourceGoodsDomain.getPricesetNprice());
                rsSkuDomain.setPricesetBaseprice(rsResourceGoodsDomain.getPricesetBaseprice());
                rsSkuDomain.setPricesetMakeprice(rsResourceGoodsDomain.getPricesetMakeprice());
                rsSkuDomain.setGoodsNum(rsResourceGoodsDomain.getGoodsNum());
                rsSkuDomain.setGoodsWeight(rsResourceGoodsDomain.getGoodsWeight());
                rsSkuDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsSkuDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsSkuDomain.setMemberCcode(rsResourceGoodsDomain.getMemberCcode());
                rsSkuDomain.setMemberCname(rsResourceGoodsDomain.getMemberCname());
                rsSkuDomain.setTenantCode(tenantCode);
                ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                rsSkuDomainList.add(rsSkuDomain);
                rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
                SupQueryResult supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(this.getQueryMapParam("goodsNo,tenantCode", new Object[]{rsResourceGoodsDomain.getGoodsNo(), tenantCode}));
                if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    rsSkuDomain.setSpuCode(((RsResourceGoodsReDomain)supQueryResult.getList().get(0)).getSpuCode());
                    rsSkuDomain.setGoodsCode(((RsResourceGoodsReDomain)supQueryResult.getList().get(0)).getGoodsCode());
                    htmlJsonReBean = this.rsSkuServiceRepository.saveSku(rsSkuDomain);
                    continue;
                }
                htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendSaveResourceGoods(rsResourceGoodsDomain);
            }
        } else {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, error.toString());
        }
        return htmlJsonReBean;
    }
}

