/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassconfDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRtagReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsRtagReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassconfServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/rsGoodsClass"}, name="\u5546\u54c1\u865a\u62df\u5206\u7c7b")
public class RsGoodsClassCon
extends SpringmvcController {
    private static String CODE = "rs.rsGoodsClass.con";
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RsGoodsClassconfServiceRepository rsGoodsClassconfServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;

    protected String getContext() {
        return "rsGoodsClass";
    }

    @RequestMapping(value={"saveRsGoodsClass.json"}, name="\u589e\u52a0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean saveRsGoodsClass(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".saveRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveRsGoodsClass", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        goodsClassDomain.setMemberName(userSession.getUserName());
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        this.makeChannel(goodsClassDomain, request);
        return this.rsGoodsClassServiceRepository.saveGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"saveRsGoodsClassIntegral.json"}, name="\u589e\u52a0\u5546\u54c1\u865a\u62df\u5206\u7c7b\u79ef\u5206")
    @ResponseBody
    public HtmlJsonReBean saveRsGoodsClassIntegral(HttpServletRequest request, String goodsClassDomainStr) {
        if (StringUtils.isEmpty((String)goodsClassDomainStr)) {
            this.logger.error(CODE + ".saveRsGoodsClassIntegral", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        RsGoodsClassDomain goodsClassDomain = (RsGoodsClassDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(goodsClassDomainStr, RsGoodsClassDomain.class);
        goodsClassDomain.setTenantCode(tenantCode);
        goodsClassDomain.setGoodsClassType("1");
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        return this.rsGoodsClassServiceRepository.saveGoodsClass(goodsClassDomain);
    }

    private void makeChannel(RsGoodsClassDomain goodsClassDomain, HttpServletRequest request) {
        if (null == goodsClassDomain || null == request) {
            return;
        }
        String memberCode = goodsClassDomain.getMemberCode();
        if (StringUtils.isBlank((String)memberCode)) {
            return;
        }
        String tenantCode = this.getTenantCode(request);
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode), DisChannel.class);
        if (null == disChannel && null == (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class))) {
            return;
        }
        goodsClassDomain.setChannelCode(disChannel.getChannelCode());
        goodsClassDomain.setChannelName(disChannel.getChannelName());
    }

    @RequestMapping(value={"getRsGoodsClass.json"}, name="\u83b7\u53d6\u5546\u54c1\u865a\u62df\u5206\u7c7b\u4fe1\u606f")
    @ResponseBody
    public RsGoodsClassDomain getRsGoodsClass(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".getRsGoodsClass", (Object)"param is null");
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassDomain = this.rsGoodsClassServiceRepository.getGoodsClass(Integer.valueOf(goodsClassId));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassParentcode", rsGoodsClassDomain.getGoodsClassCode());
        param.put("tenantCode", rsGoodsClassDomain.getTenantCode());
        SupQueryResult result = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        List list = result.getList();
        if (null == list || list.isEmpty()) {
            rsGoodsClassDomain.setHasChild(false);
        } else {
            rsGoodsClassDomain.setHasChild(true);
        }
        return rsGoodsClassDomain;
    }

    @RequestMapping(value={"getRsGoodsClassIntegral.json"}, name="\u83b7\u53d6\u5546\u54c1\u865a\u62df\u5206\u7c7b\u4fe1\u606f")
    @ResponseBody
    public RsGoodsClassDomain getRsGoodsClassIntegral(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".getRsGoodsClass", (Object)"param is null");
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassDomain = this.rsGoodsClassServiceRepository.getGoodsClass(Integer.valueOf(goodsClassId));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassParentcode", rsGoodsClassDomain.getGoodsClassCode());
        param.put("tenantCode", rsGoodsClassDomain.getTenantCode());
        SupQueryResult result = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        List list = result.getList();
        if (null == list || list.isEmpty()) {
            rsGoodsClassDomain.setHasChild(false);
        } else {
            rsGoodsClassDomain.setHasChild(true);
        }
        return rsGoodsClassDomain;
    }

    @RequestMapping(value={"updateRsGoodsClass.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClass(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".updateRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateRsGoodsClass", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsClassName", goodsClassDomain.getGoodsClassName());
        param.put("memberCode", this.getMerchantCode(request));
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult SupQueryResultDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null != SupQueryResultDomainSupQueryResult.getRows() && SupQueryResultDomainSupQueryResult.getRows().size() > 0) {
            for (RsGoodsClassReDomain goodsClassReDomain : SupQueryResultDomainSupQueryResult.getList()) {
                if (goodsClassDomain.getGoodsClassId().equals(goodsClassReDomain.getGoodsClassId())) continue;
                this.logger.error(CODE + ".updateRsGoodsClass", (Object)"\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        }
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        goodsClassDomain.setMemberName(userSession.getUserName());
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        this.makeChannel(goodsClassDomain, request);
        return this.rsGoodsClassServiceRepository.updateGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"updateRsGoodsClassByP.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClassByP(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".updateRsGoodsClassByP", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.updateGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"updateRsGoodsClassByPIntegral.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClassByPIntegral(HttpServletRequest request, RsGoodsClassDomain goodsClassDomain) {
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".updateRsGoodsClassByP", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.updateGoodsClass(goodsClassDomain);
    }

    @RequestMapping(value={"deleteRsGoodsClass.json"}, name="\u5220\u9664\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean deleteRsGoodsClass(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".deleteRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.deleteGoodsClass(Integer.valueOf(goodsClassId));
    }

    @RequestMapping(value={"deleteRsGoodsClassIntegral.json"}, name="\u5220\u9664\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean deleteRsGoodsClassIntegral(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".deleteRsGoodsClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.deleteGoodsClass(Integer.valueOf(goodsClassId));
    }

    @RequestMapping(value={"queryRsGoodsClassPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsGoodsClassReDomain> queryRsGoodsClassPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GOODS_CLASS_ORDER ASC");
        }
        return this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
    }

    @RequestMapping(value={"queryRsGoodsClassPageList.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u6811\u5f62")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryRsGoodsClassPageList(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), null, true, null, request);
    }

    @RequestMapping(value={"queryRsGoodsClassForRetList.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u6811\u5f62-\u5206\u9500\u5546")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryRsGoodsClassForRetList(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        String code = this.disChannelServiceRepository.queryChannelCode(param);
        String channelCode = null == code ? this.getNowChannel(request) : code;
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), "0", true, channelCode, request);
    }

    @RequestMapping(value={"queryRsGoodsClassPageListForGoods.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u4e2d\u53f0\u5546\u54c1")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryRsGoodsClassPageListForGoods(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), null, true, null, request);
    }

    @RequestMapping(value={"updateRsGoodsClassState.json"}, name="\u66f4\u65b0\u5546\u54c1\u865a\u62df\u5206\u7c7b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRsGoodsClassState(String goodsClassId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".updateRsGoodsClassState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.updateGoodsClassState(Integer.valueOf(goodsClassId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryTreeByPointsForPlat.json"}, name="\u67e5\u8be2\u79ef\u5206\u865a\u62df\u5206\u7c7b-\u8fc7\u6ee4\u65e0\u5b9e\u4f53\u5206\u7c7b")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryTreeByPointsForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String channelCode = this.disChannelServiceRepository.queryChannelCode(param);
        this.logger.error(CODE, (Object)("--------------------param---------" + param.toString()));
        return this.getClasstreeLastMain(this.getTenantCode(request), null, "1", false, channelCode, request);
    }

    @RequestMapping(value={"queryTreeByPointsForBus.json"}, name="\u67e5\u8be2\u79ef\u5206\u865a\u62df\u5206\u7c7b-\u8fc7\u6ee4\u65e0\u5b9e\u4f53\u5206\u7c7b")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryTreeByPointsForBus(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String channelCode = this.disChannelServiceRepository.queryChannelCode(param);
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), "1", false, channelCode, request);
    }

    @RequestMapping(value={"queryTreeByPointsForBusStr.json"}, name="\u67e5\u8be2\u79ef\u5206\u865a\u62df\u5206\u7c7b-\u8fc7\u6ee4\u65e0\u5b9e\u4f53\u5206\u7c7b")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryTreeByPointsForBusStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String channelCode = this.disChannelServiceRepository.queryChannelCode(param);
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), "1", false, channelCode, request);
    }

    @RequestMapping(value={"queryGoodsClassTree.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u8fc7\u6ee4\u65e0\u5b9e\u4f53\u5206\u7c7b\u7684")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTree(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), null, null, false, this.getNowChannel(request), request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForegoods.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u53d1\u5e03\u5546\u54c1\u9875\u9762")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForegoods(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), null, null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForerelease.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-release")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForerelease(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getTeananMemberCode(request), null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForBus.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForBus(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        String channelCode = null == map.get("channelCode") ? null : (String)map.get("channelCode");
        this.logger.info(CODE + ".queryGoodsClassTreeForBus.request .", (Object)(channelCode + "=:=" + map));
        return this.getClasstreeLastMain(this.getTenantCode(request), null, null, false, channelCode, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForBusStr.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForBusStr(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        String channelCode = null == map.get("channelCode") ? null : (String)map.get("channelCode");
        this.logger.info(CODE + ".queryGoodsClassTreeForBus.request .", (Object)(channelCode + "=:=" + map));
        return this.getClasstreeLastMain(this.getTenantCode(request), null, "0", false, channelCode, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForeMem.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u5546\u5bb6")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForeMem(HttpServletRequest request) {
        String memberCode = "";
        UserSession userSession = this.getUserSession(request);
        if (null != userSession && StringUtils.isBlank((String)(memberCode = userSession.getUserinfoParentCode()))) {
            this.logger.error(CODE + ".queryClasstreeFormMem", (Object)"menberCode\u4e3a\u7a7a\uff01");
            return null;
        }
        return this.getClasstreeLastMain(this.getTenantCode(request), memberCode, null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForeUser.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u81ea\u8425/\u7528\u6237")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForeUser(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryClasstreeFormMem", (Object)"menberCode\u4e3a\u7a7a\uff01");
            return null;
        }
        return this.getClasstreeLastMain(this.getTenantCode(request), memberCode, null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForMz.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u5546\u54c1\u5206\u7c7b/\u5e73\u53f0")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForMz(HttpServletRequest request) {
        String memberCode = this.getTeananMemberCode(request);
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryClasstreeFormMem", (Object)"menberCode\u4e3a\u7a7a\uff01");
            return null;
        }
        return this.getClasstreeLastMain(this.getTenantCode(request), memberCode, null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassTreeForeBusiness.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u5546\u5bb6\u5546\u54c1")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassTreeForeBusiness(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryClasstreeFormMem", (Object)"menberCode\u4e3a\u7a7a\uff01");
            return null;
        }
        return this.getClasstreeLastMain(this.getTenantCode(request), memberCode, null, false, null, request);
    }

    @RequestMapping(value={"queryGoodsClassListNew.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassListNew(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), null, null, true, null, request);
    }

    @RequestMapping(value={"queryGoodsClassListNewNoLogin.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryGoodsClassListNewNoLogin(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), null, null, true, null, request);
    }

    @RequestMapping(value={"checkGoodsClassName.json"}, name="\u865a\u62df\u5206\u7c7b\u540d\u68c0\u67e5-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public HtmlJsonReBean checkGoodsClassName(HttpServletRequest request, String goodsClassName, String goodsClassCode) {
        if (StringUtils.isBlank((String)goodsClassName)) {
            this.logger.error(CODE + ".checkGoodsClassName", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult supQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(this.getQueryMapParam("goodsClassName,tenantCode", new Object[]{goodsClassName, this.getTenantCode(request)}));
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsClassCode)) {
            for (RsGoodsClassReDomain rsGoodsClassReDomain : supQueryResult.getList()) {
                if (goodsClassCode.equals(rsGoodsClassReDomain.getGoodsClassCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            flag = true;
        }
        if (!flag && null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".checkGoodsClassName", (Object)" exist rtagName");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u865a\u62df\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveGoodsClassNew.json"}, name="\u589e\u52a0\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public HtmlJsonReBean saveGoodsClassNew(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveGoodsClassNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsGoodsClassDomain goodsClassDomain = (RsGoodsClassDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsGoodsClassDomain.class);
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".saveGoodsClassNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u8f6c\u6362\u5f02\u5e38");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGoodsClassNew", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        goodsClassDomain.setMemberName(userSession.getUserName());
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        goodsClassDomain.setRsGoodsClassconfDomainList(goodsClassDomain.getRsGoodsClassconfDomains());
        this.makeChannel(goodsClassDomain, request);
        HtmlJsonReBean htmlJsonReBean = this.rsGoodsClassServiceRepository.saveGoodsClass(goodsClassDomain);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGoodsClassNew.json"}, name="\u4fee\u6539\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public HtmlJsonReBean updateGoodsClassNew(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateGoodsClassNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsGoodsClassDomain goodsClassDomain = (RsGoodsClassDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsGoodsClassDomain.class);
        if (null == goodsClassDomain) {
            this.logger.error(CODE + ".updateGoodsClassNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u8f6c\u6362\u5f02\u5e38");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateGoodsClassNew", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsClassDomain.setMemberCode(userSession.getUserPcode());
        goodsClassDomain.setMemberName(userSession.getUserName());
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        this.makeChannel(goodsClassDomain, request);
        HtmlJsonReBean htmlJsonReBean = this.rsGoodsClassServiceRepository.updateGoodsClass(goodsClassDomain);
        if (htmlJsonReBean.getSysRecode().equals("success") && ListUtil.isNotEmpty((Collection)goodsClassDomain.getRsGoodsClassconfDomains())) {
            this.rsGoodsClassconfServiceRepository.deleteByGoodsClassCode(this.getTenantCode(request), goodsClassDomain.getGoodsClassCode());
            List rsGoodsClassconfDomainList = goodsClassDomain.getRsGoodsClassconfDomains();
            for (RsGoodsClassconfDomain rsGoodsClassconfDomain : rsGoodsClassconfDomainList) {
                rsGoodsClassconfDomain.setTenantCode(this.getTenantCode(request));
                rsGoodsClassconfDomain.setGoodsClassCode(goodsClassDomain.getGoodsClassCode());
                rsGoodsClassconfDomain.setMemberCode(userSession.getUserPcode());
                rsGoodsClassconfDomain.setMemberName(userSession.getMerberCompname());
            }
            this.rsGoodsClassconfServiceRepository.saveGoodsClassconfBatch(rsGoodsClassconfDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryResourceGoods.json"}, name="\u67e5\u770b\u5546\u54c1-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsRtagReDomain> queryResourceGoods(HttpServletRequest request, String goodsClassCode) {
        if (StringUtils.isBlank((String)goodsClassCode)) {
            this.logger.error(CODE + ".queryResourceGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        SupQueryResult rsGoodsClassconfQueryResult = this.rsGoodsClassconfServiceRepository.queryGoodsClassconfPage(this.getQueryMapParam("goodsClassCode,tenantCode", new Object[]{goodsClassCode, tenantCode}));
        if (null == rsGoodsClassconfQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassconfQueryResult.getList())) {
            this.logger.error(CODE + ".queryResourceGoods", (Object)"\u65e0\u6570\u636e");
            return null;
        }
        SupQueryResult resGoodsRtagSup = this.rsResourceGoodsServiceRepository.queryResourcesGoodsRtagByGoodsClass(goodsClassCode, tenantCode);
        if (null != resGoodsRtagSup && ListUtil.isNotEmpty((Collection)resGoodsRtagSup.getList())) {
            for (RsResourceGoodsRtagReDomain rsResourceGoodsRtagReDomain : resGoodsRtagSup.getList()) {
                String str = rsResourceGoodsRtagReDomain.getRtag();
                if (StringUtils.isBlank((String)str)) continue;
                str = "[" + str + "]";
                List rsGoodsRtagReDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(str, RsGoodsRtagReDomain.class);
                if (ListUtil.isEmpty((Collection)rsGoodsRtagReDomainList)) {
                    this.logger.error(CODE + ".queryResourceGoods", (Object)"\u6807\u7b7e\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25\uff01");
                    continue;
                }
                rsResourceGoodsRtagReDomain.setRsGoodsRtagReDomains(rsGoodsRtagReDomainList);
            }
        }
        return resGoodsRtagSup;
    }

    @RequestMapping(value={"goodsClassRel.json"}, name="\u865a\u62df\u5206\u7c7b\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean goodsClassRel(HttpServletRequest request) {
        return this.rsGoodsClassServiceRepository.updateStateList(this.getTenantCode(request), Integer.valueOf(1), Integer.valueOf(0), "0");
    }

    @RequestMapping(value={"deleteGoodsClassNew.json"}, name="\u5220\u9664\u5546\u54c1\u865a\u62df\u5206\u7c7b-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsClassNew(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".deleteGoodsClassNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsClassServiceRepository.deleteGoodsClass(Integer.valueOf(goodsClassId));
    }

    @RequestMapping(value={"getRsGoodsClassNew.json"}, name="\u83b7\u53d6\u5546\u54c1\u865a\u62df\u5206\u7c7b\u4fe1\u606f-\u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public RsGoodsClassReDomain getRsGoodsClassNew(String goodsClassId) {
        if (StringUtils.isBlank((String)goodsClassId)) {
            this.logger.error(CODE + ".getRsGoodsClassNew", (Object)"param is null");
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassReDomain = this.rsGoodsClassServiceRepository.getGoodsClass(Integer.valueOf(goodsClassId));
        if (null == rsGoodsClassReDomain) {
            this.logger.error(CODE + ".getRsGoodsClassNew", (Object)"\u53c2\u6570ID\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u8bb0\u5f55\uff01");
            return null;
        }
        SupQueryResult resultGoodsClassconf = this.rsGoodsClassconfServiceRepository.queryGoodsClassconfPage(this.getQueryMapParam("goodsClassCode,tenantCode", new Object[]{rsGoodsClassReDomain.getGoodsClassCode(), rsGoodsClassReDomain.getTenantCode()}));
        if (null != resultGoodsClassconf && ListUtil.isNotEmpty((Collection)resultGoodsClassconf.getList())) {
            ArrayList<RsGoodsClassconfDomain> rsGoodsClassconfDomains = new ArrayList<RsGoodsClassconfDomain>();
            for (RsGoodsClassconfDomain rsGoodsClassconfDomain : resultGoodsClassconf.getList()) {
                rsGoodsClassconfDomains.add(rsGoodsClassconfDomain);
            }
            rsGoodsClassReDomain.setRsGoodsClassconfDomains(rsGoodsClassconfDomains);
        }
        return rsGoodsClassReDomain;
    }

    public List<RsGoodsClassReDomain> getChild(String id, List<RsGoodsClassReDomain> all) {
        ArrayList<RsGoodsClassReDomain> childList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getGoodsClassParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private List<RsGoodsClassReDomain> getClasstreeLastMain(String tenantCode, String memberCode, String goodsClassType, boolean flag, String channelCode, HttpServletRequest request) {
        if (StringUtils.isBlank((String)channelCode) && StringUtils.isBlank((String)memberCode)) {
            memberCode = this.getTeananMemberCode(request);
        }
        ArrayList<RsGoodsClassReDomain> reDomainList = new ArrayList<RsGoodsClassReDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("orderStr", "GOODS_CLASS_ORDER ASC,GMT_MODIFIED DESC");
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("channelCode", channelCode);
        } else {
            channelCode = "";
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            param.put("memberCode", memberCode);
        } else {
            memberCode = "";
        }
        if (StringUtils.isNotBlank((String)goodsClassType)) {
            param.put("goodsClassType", goodsClassType);
        }
        this.logger.error(CODE + ".getClasstreeLastMain.reDomainSupQueryResult1", (Object)((Object)param).toString());
        SupQueryResult reDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param);
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".getClasstreeLastMain.reDomainSupQueryResult", (Object)((Object)param).toString());
            return null;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsGoodsClassReDomain> rootClass = new ArrayList<RsGoodsClassReDomain>();
        ArrayList<RsGoodsClassReDomain> chirdlist = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (StringUtils.isBlank((String)rsClasstreeReDomain.getMemberCode())) {
                rsClasstreeReDomain.setMemberCode("");
            }
            if (StringUtils.isBlank((String)rsClasstreeReDomain.getChannelCode())) {
                rsClasstreeReDomain.setChannelCode("");
            }
            if (rsClasstreeReDomain.getGoodsClassParentcode().equals("-1") && (channelCode.equals(rsClasstreeReDomain.getChannelCode()) || memberCode.equals(rsClasstreeReDomain.getMemberCode()))) {
                rootClass.add(rsClasstreeReDomain);
                continue;
            }
            if (!channelCode.equals(rsClasstreeReDomain.getChannelCode()) && !memberCode.equals(rsClasstreeReDomain.getMemberCode())) continue;
            chirdlist.add(rsClasstreeReDomain);
        }
        all = null;
        this.logger.error("====", (Object)JsonUtil.buildNormalBinder().toJson(rootClass));
        this.logger.error("====", (Object)JsonUtil.buildNormalBinder().toJson(chirdlist));
        for (RsGoodsClassReDomain rsGoodsClassReDomain : rootClass) {
            List<RsGoodsClassReDomain> childList = this.getChild(rsGoodsClassReDomain.getGoodsClassCode(), chirdlist);
            if (flag) {
                rsGoodsClassReDomain.setChildList(childList);
                continue;
            }
            if (ListUtil.isNotEmpty(childList)) {
                ArrayList<RsGoodsClassReDomain> childList1 = new ArrayList<RsGoodsClassReDomain>();
                for (RsGoodsClassReDomain rsClasstreeReDomain1 : childList) {
                    if (!ListUtil.isNotEmpty((Collection)rsClasstreeReDomain1.getChildList()) && !rsClasstreeReDomain1.getGoodsClassLast().equals("0")) continue;
                    childList1.add(rsClasstreeReDomain1);
                    rsGoodsClassReDomain.setChildList(childList1);
                }
            }
            if (!ListUtil.isNotEmpty((Collection)rsGoodsClassReDomain.getChildList()) && !rsGoodsClassReDomain.getGoodsClassLast().equals("0")) continue;
            reDomainList.add(rsGoodsClassReDomain);
        }
        if (flag) {
            return rootClass;
        }
        return reDomainList;
    }

    @RequestMapping(value={"excelImportRsGoodsClassBatch.json"}, name="excel\u6279\u91cf\u5bfc\u5165\u524d\u540e\u53f0\u5206\u7c7b\u5173\u8054")
    @ResponseBody
    public HtmlJsonReBean excelImportRsGoodsClassBatch(HttpServletRequest request, String paramJsonList) {
        if (StringUtils.isEmpty((String)paramJsonList)) {
            this.logger.error(CODE + ".excelImportRsGoodsClassBatch", (Object)"paramJsonList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".excelImportRsGoodsClassBatch", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String userPcode = userSession.getUserPcode();
        List paramMaps = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramJsonList, Map.class);
        ArrayList<Map> errorList = new ArrayList<Map>();
        for (int i = 0; i < paramMaps.size(); ++i) {
            Map map = (Map)paramMaps.get(i);
            map.put("tenantCode", tenantCode);
            map.put("userinfoCode", userPcode);
            this.logger.error(CODE + ".excelImportRsGoodsClassBatch.param", (Object)map);
            String result = this.rsResourceGoodsServiceRepository.insertEntityAndVirtualClasstree(map);
            if (!StringUtils.isBlank((String)result)) continue;
            this.logger.error(CODE + ".excelImportRsGoodsClassBatch.insertEntityAndVirtualClasstree.result", (Object)"");
            errorList.add(map);
        }
        this.logger.error(CODE + ".excelImportRsGoodsClassBatch.end", (Object)("=========\u540c\u6b65\u7ed3\u675f\uff01\u5931\u8d25\u7684\u6709:" + errorList));
        return new HtmlJsonReBean(errorList);
    }

    public Map<String, Object> errorExcelGoods(String goodsCode, String barCode, String goodsName, String errorMsg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("barCode", barCode);
        map.put("goodsName", goodsName);
        map.put("errorMsg", errorMsg);
        return map;
    }
}

