/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsOrdskuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsOrdskuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsOrdskuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/Ordsku"}, name="\u5230\u8d27\u901a\u77e5")
public class OrdskuCon
extends SpringmvcController {
    private static String CODE = "rs.Ordsku.con";
    @Autowired
    private RsOrdskuServiceRepository rsOrdskuServiceRepository;

    protected String getContext() {
        return "Ordsku";
    }

    @RequestMapping(value={"saveOrdsku.json"}, name="\u589e\u52a0\u5230\u8d27\u901a\u77e5")
    @ResponseBody
    public HtmlJsonReBean saveOrdsku(HttpServletRequest request, RsOrdskuDomain rsOrdskuDomain) {
        if (null == rsOrdskuDomain) {
            this.logger.error(CODE + ".saveOrdsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)rsOrdskuDomain.getSpuCode()) || StringUtils.isBlank((String)rsOrdskuDomain.getGoodsCode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5931");
        }
        UserSession userSession = this.getUserSession(request);
        rsOrdskuDomain.setMemberBcode(userSession.getUserPcode());
        rsOrdskuDomain.setMemberBname(userSession.getUserName());
        rsOrdskuDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> sendParamMap = new HashMap<String, String>();
        sendParamMap.put("memberBcode", userSession.getUserPcode());
        sendParamMap.put("skuNo", rsOrdskuDomain.getSkuNo());
        sendParamMap.put("tenantCode", this.getTenantCode(request));
        List list = this.rsOrdskuServiceRepository.queryOrdskuPage(sendParamMap).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("list is null");
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsOrdskuServiceRepository.saveOrdsku(rsOrdskuDomain);
    }

    @RequestMapping(value={"deleteOrdskuByNo.json"}, name="\u6839\u636e\u8d27\u53f7\u5220\u9664\u5230\u8d27\u901a\u77e5")
    @ResponseBody
    public HtmlJsonReBean deleteOrdskuByNo(HttpServletRequest request, String skuNo) {
        if (StringUtils.isBlank((String)skuNo)) {
            this.logger.error(CODE + ".deleteOrdskuByNo", (Object)"skuNo is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u503c\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuNo", skuNo);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("tenantCode", this.getTenantCode(request));
        return this.rsOrdskuServiceRepository.deleteOrdskuByNo(map);
    }

    @RequestMapping(value={"getOrdsku.json"}, name="\u83b7\u53d6\u5230\u8d27\u901a\u77e5\u4fe1\u606f")
    @ResponseBody
    public RsOrdskuReDomain getOrdsku(Integer ordskuId) {
        if (StringUtils.isBlank((Integer)ordskuId)) {
            this.logger.error(CODE + ".getOrdsku", (Object)"param is null");
            return null;
        }
        return this.rsOrdskuServiceRepository.getOrdsku(ordskuId);
    }

    @RequestMapping(value={"updateOrdsku.json"}, name="\u66f4\u65b0\u5230\u8d27\u901a\u77e5")
    @ResponseBody
    public HtmlJsonReBean updateOrdsku(HttpServletRequest request, RsOrdskuDomain rsOrdskuDomain) {
        if (null == rsOrdskuDomain) {
            this.logger.error(CODE + ".updateOrdsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsOrdskuDomain.setTenantCode(this.getTenantCode(request));
        return this.rsOrdskuServiceRepository.updateOrdsku(rsOrdskuDomain);
    }

    @RequestMapping(value={"deleteOrdsku.json"}, name="\u5220\u9664\u5230\u8d27\u901a\u77e5")
    @ResponseBody
    public HtmlJsonReBean deleteOrdsku(Integer ordskuId) {
        if (StringUtils.isBlank((Integer)ordskuId)) {
            this.logger.error(CODE + ".deleteOrdsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsOrdskuServiceRepository.deleteOrdsku(ordskuId);
    }

    @RequestMapping(value={"queryOrdskuPage.json"}, name="\u67e5\u8be2\u5230\u8d27\u901a\u77e5\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsOrdskuReDomain> queryOrdskuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsOrdskuServiceRepository.queryOrdskuPage(param);
    }

    @RequestMapping(value={"updateOrdskuState.json"}, name="\u66f4\u65b0\u5230\u8d27\u901a\u77e5\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOrdskuState(String ordskuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)ordskuId)) {
            this.logger.error(CODE + ".updateOrdskuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsOrdskuServiceRepository.updateOrdskuState(Integer.valueOf(ordskuId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getOrdskuBySkuNoAndMemCode.json"}, name="\u66f4\u65b0\u5230\u8d27\u901a\u77e5\u72b6\u6001")
    @ResponseBody
    public RsOrdskuReDomain getOrdskuBySkuNoAndMemCode(HttpServletRequest request, String skuNo) {
        String memberBcode = this.getUserSession(request).getUserPcode();
        if (StringUtils.isBlank((String)skuNo)) {
            this.logger.error(CODE + ".getOrdsku", (Object)"skuNo param is null");
            return null;
        }
        return this.rsOrdskuServiceRepository.getOrdskuBySkuNoAndMemCode(skuNo, memberBcode);
    }

    @RequestMapping(value={"queryOrdskuPageForSkuNo.json"}, name="\u67e5\u8be2\u5230\u8d27\u901a\u77e5\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsOrdskuReDomain> queryOrdskuPageForSkuNo(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", this.getMerchantCode(request));
        return this.rsOrdskuServiceRepository.queryOrdskuPage(param);
    }
}

