/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsStoreRuleDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsStoreRuleReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsLaundryGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsStoreRuleServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/storeRule"}, name="\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e")
public class StoreRuleCon
extends SpringmvcController {
    private static String CODE = "rs.storeRule.con";
    @Autowired
    private RsStoreRuleServiceRepository rsStoreRuleServiceRepository;
    @Autowired
    private RsLaundryGoodsServiceRepository rsLaundryGoodsServiceRepository;

    protected String getContext() {
        return "storeRule";
    }

    @RequestMapping(value={"saveStoreRule.json"}, name="\u589e\u52a0\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveStoreRule(HttpServletRequest request, String rsStoreRuleStr) {
        if (StringUtils.isBlank((String)rsStoreRuleStr)) {
            this.logger.error(CODE + ".saveStoreRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsStoreRuleDomainlist = (List)JsonUtil.buildNormalBinder().getJsonToList(rsStoreRuleStr, RsStoreRuleDomain.class);
        if (ListUtil.isEmpty((Collection)rsStoreRuleDomainlist)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "is null" + rsStoreRuleStr);
        }
        for (RsStoreRuleDomain rsStoreRuleDomain : rsStoreRuleDomainlist) {
            SupQueryResult rsStoreRuleReDomainSupQueryResult;
            UserSession userSession = this.getUserSession(request);
            if (null == userSession) {
                this.logger.error(CODE + ".saveStoreRule", (Object)"userSession is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", rsStoreRuleDomain.getTenantCode());
            map.put("skuCode", rsStoreRuleDomain.getSkuCode());
            map.put("provinceCode", rsStoreRuleDomain.getProvinceCode());
            if (StringUtils.isNotBlank((String)rsStoreRuleDomain.getCityCode())) {
                map.put("cityCode", rsStoreRuleDomain.getCityCode());
            }
            if (ListUtil.isNotEmpty((Collection)(rsStoreRuleReDomainSupQueryResult = this.rsStoreRuleServiceRepository.queryStoreRulePage(map)).getList())) {
                this.logger.error(CODE + ".saveStoreRuleStr", (Object)(" is null" + map));
                continue;
            }
            rsStoreRuleDomain.setUserCode(userSession.getUserCode());
            rsStoreRuleDomain.setUserName(userSession.getUserName());
            rsStoreRuleDomain.setTenantCode(this.getTenantCode(request));
            this.rsStoreRuleServiceRepository.saveStoreRule(rsStoreRuleDomain);
        }
        HtmlJsonReBean htmljsonRebean = new HtmlJsonReBean((Object)"success");
        htmljsonRebean.setErrorCode("success");
        return htmljsonRebean;
    }

    @RequestMapping(value={"getStoreRule.json"}, name="\u83b7\u53d6\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public RsStoreRuleReDomain getStoreRule(Integer ruleId) {
        if (StringUtils.isBlank((Integer)ruleId)) {
            this.logger.error(CODE + ".getStoreRule", (Object)"param is null");
            return null;
        }
        return this.rsStoreRuleServiceRepository.getStoreRule(ruleId);
    }

    @RequestMapping(value={"updateStoreRule.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateStoreRule(HttpServletRequest request, RsStoreRuleDomain rsStoreRuleDomain) {
        if (null == rsStoreRuleDomain) {
            this.logger.error(CODE + ".updateStoreRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsStoreRuleDomain.setTenantCode(this.getTenantCode(request));
        return this.rsStoreRuleServiceRepository.updateStoreRule(rsStoreRuleDomain);
    }

    @RequestMapping(value={"deleteStoreRule.json"}, name="\u5220\u9664\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteStoreRule(Integer ruleId) {
        if (StringUtils.isBlank((Integer)ruleId)) {
            this.logger.error(CODE + ".deleteStoreRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsStoreRuleServiceRepository.deleteStoreRule(ruleId);
    }

    @RequestMapping(value={"queryStoreRulePage.json"}, name="\u67e5\u8be2\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsStoreRuleReDomain> queryStoreRulePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsStoreRuleServiceRepository.queryStoreRulePage(param);
    }

    @RequestMapping(value={"updateStoreRuleState.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStoreRuleState(String ruleId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)ruleId)) {
            this.logger.error(CODE + ".updateStoreRuleState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsStoreRuleServiceRepository.updateStoreRuleState(Integer.valueOf(ruleId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateStoreRulePrice.json"}, name="\u66f4\u65b0\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateStoreRulePrice(String ruleId, String subMoney) {
        if (StringUtils.isBlank((String)ruleId) || StringUtils.isBlank((String)subMoney)) {
            this.logger.error(CODE + ".updateStoreRulePrice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsStoreRuleReDomain storeRule = this.rsStoreRuleServiceRepository.getStoreRule(Integer.valueOf(Integer.parseInt(ruleId)));
        if (null == storeRule) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u627e\u5230\u533a\u57df\u5546\u54c1");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", storeRule.getTenantCode());
        map.put("cityCode", storeRule.getCityCode());
        map.put("areaCode", storeRule.getAreaCode());
        map.put("skuCode", storeRule.getSkuCode());
        SupQueryResult rsLaundryGoodsReDomainSupQueryResult = this.rsLaundryGoodsServiceRepository.queryLaundryGoodsPage(map);
        if (ListUtil.isEmpty((Collection)rsLaundryGoodsReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ed9\u5730\u533a\u6ca1\u6709\u76f8\u5e94\u95e8\u5e97\u5546\u54c1");
        }
        return this.rsStoreRuleServiceRepository.updateStoreRulePrice(Integer.valueOf(ruleId), subMoney, null);
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

