/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsContractMtDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsContractMtReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsContractMtServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/contractMt"}, name="\u5408\u540c\u7ef4\u4fdd")
public class ContractMtCon
extends SpringmvcController {
    private static String CODE = "rs.contractMt.con";
    @Autowired
    private RsContractMtServiceRepository rsContractMtServiceRepository;

    protected String getContext() {
        return "contractMt";
    }

    @RequestMapping(value={"saveContractMt.json"}, name="\u589e\u52a0\u5408\u540c\u7ef4\u4fdd")
    @ResponseBody
    public HtmlJsonReBean saveContractMt(HttpServletRequest request, RsContractMtDomain contractMtDomain) {
        if (null == contractMtDomain) {
            this.logger.error(CODE + ".saveContractMt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        contractMtDomain.setTenantCode(this.getTenantCode(request));
        return this.rsContractMtServiceRepository.saveContractMt(contractMtDomain);
    }

    @RequestMapping(value={"saveContractMtBatch.json"}, name="\u589e\u52a0\u5408\u540c\u7ef4\u4fdd\u6279\u91cf")
    @ResponseBody
    public HtmlJsonReBean saveContractMtBatch(HttpServletRequest request, String contractMtDomainStr) {
        if (null == contractMtDomainStr) {
            this.logger.error(CODE + ".contractMtDomainStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List contractMtDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(contractMtDomainStr, RsContractMtDomain.class);
        String tenantCode = this.getTenantCode(request);
        for (RsContractMtDomain rsContractMtDomain : contractMtDomainList) {
            rsContractMtDomain.setTenantCode(tenantCode);
        }
        return this.rsContractMtServiceRepository.saveContractMtBatch(contractMtDomainList);
    }

    @RequestMapping(value={"getContractMt.json"}, name="\u83b7\u53d6\u5408\u540c\u7ef4\u4fdd\u4fe1\u606f")
    @ResponseBody
    public RsContractMtReDomain getContractMt(Integer contractMtId) {
        if (StringUtils.isBlank((Integer)contractMtId)) {
            this.logger.error(CODE + ".getContractMt", (Object)"param is null");
            return null;
        }
        return this.rsContractMtServiceRepository.getContractMt(contractMtId);
    }

    @RequestMapping(value={"updateContractMt.json"}, name="\u66f4\u65b0\u5408\u540c\u7ef4\u4fdd")
    @ResponseBody
    public HtmlJsonReBean updateContractMt(HttpServletRequest request, RsContractMtDomain contractMtDomain) {
        if (null == contractMtDomain) {
            this.logger.error(CODE + ".updateContractMt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        contractMtDomain.setTenantCode(this.getTenantCode(request));
        return this.rsContractMtServiceRepository.updateContractMt(contractMtDomain);
    }

    @RequestMapping(value={"deleteContractMt.json"}, name="\u5220\u9664\u5408\u540c\u7ef4\u4fdd")
    @ResponseBody
    public HtmlJsonReBean deleteContractMt(Integer contractMtId) {
        if (StringUtils.isBlank((Integer)contractMtId)) {
            this.logger.error(CODE + ".deleteContractMt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsContractMtServiceRepository.deleteContractMt(contractMtId);
    }

    @RequestMapping(value={"queryContractMtPage.json"}, name="\u67e5\u8be2\u5408\u540c\u7ef4\u4fdd\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsContractMtReDomain> queryContractMtPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsContractMtServiceRepository.queryContractMtPage(param);
    }

    @RequestMapping(value={"updateContractMtState.json"}, name="\u66f4\u65b0\u5408\u540c\u7ef4\u4fdd\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractMtState(String contractMtId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractMtId)) {
            this.logger.error(CODE + ".updateContractMtState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsContractMtServiceRepository.updateContractMtState(Integer.valueOf(contractMtId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"actSubmitMt.json"}, name="\u63d0\u4ea4\u5408\u540c\u7ef4\u4fdd\u5ba1\u6279\u6d41")
    @ResponseBody
    public HtmlJsonReBean actSubmitMt(HttpServletRequest request, String contractMtDomainStr) {
        if (StringUtils.isBlank((String)contractMtDomainStr)) {
            this.logger.error(CODE + ".actSubmitMt", (Object)"contractMtDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsContractMtDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(contractMtDomainStr, RsContractMtDomain.class);
        if (ListUtil.isEmpty((Collection)rsContractMtDomainList)) {
            this.logger.error(CODE + ".actSubmitMt", (Object)"contractMtDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        for (RsContractMtDomain rsContractMtDomain : rsContractMtDomainList) {
            rsContractMtDomain.setExtend(userSession.getUserCode());
            rsContractMtDomain.setExtend1(userSession.getUserRelname());
        }
        return this.rsContractMtServiceRepository.actSubmitMt(rsContractMtDomainList);
    }
}

