/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuStoreDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuStoreReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuStoreServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/skuStore"}, name="\u5546\u54c1\u660e\u7ec6\u6d41\u6c34")
public class SkuStoreCon
extends SpringmvcController {
    private static String CODE = "rs.skuStore.con";
    @Autowired
    private RsSkuStoreServiceRepository rsSkuStoreServiceRepository;

    protected String getContext() {
        return "skuStore";
    }

    @RequestMapping(value={"saveSkuStore.json"}, name="\u589e\u52a0\u5546\u54c1\u660e\u7ec6\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveSkuStore(HttpServletRequest request, RsSkuStoreDomain rsSkuStoreDomain) {
        if (null == rsSkuStoreDomain) {
            this.logger.error(CODE + ".saveSkuStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuStoreDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuStoreServiceRepository.saveSkuStore(rsSkuStoreDomain);
    }

    @RequestMapping(value={"getSkuStore.json"}, name="\u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public RsSkuStoreReDomain getSkuStore(Integer skuStoreId) {
        if (StringUtils.isBlank((Integer)skuStoreId)) {
            this.logger.error(CODE + ".getSkuStore", (Object)"param is null");
            return null;
        }
        return this.rsSkuStoreServiceRepository.getSkuStore(skuStoreId);
    }

    @RequestMapping(value={"updateSkuStore.json"}, name="\u66f4\u65b0\u5546\u54c1\u660e\u7ec6\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateSkuStore(HttpServletRequest request, RsSkuStoreDomain rsSkuStoreDomain) {
        if (null == rsSkuStoreDomain) {
            this.logger.error(CODE + ".updateSkuStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuStoreDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuStoreServiceRepository.updateSkuStore(rsSkuStoreDomain);
    }

    @RequestMapping(value={"deleteSkuStore.json"}, name="\u5220\u9664\u5546\u54c1\u660e\u7ec6\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteSkuStore(Integer skuStoreId) {
        if (StringUtils.isBlank((Integer)skuStoreId)) {
            this.logger.error(CODE + ".deleteSkuStore", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuStoreServiceRepository.deleteSkuStore(skuStoreId);
    }

    @RequestMapping(value={"querySkuStorePage.json"}, name="\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuStoreReDomain> querySkuStorePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuStoreServiceRepository.querySkuStorePage(param);
    }

    @RequestMapping(value={"updateSkuStoreState.json"}, name="\u66f4\u65b0\u5546\u54c1\u660e\u7ec6\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuStoreState(String skuStoreId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuStoreId)) {
            this.logger.error(CODE + ".updateSkuStoreState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuStoreServiceRepository.updateSkuStoreState(Integer.valueOf(skuStoreId), dataState, oldDataState, null);
    }
}

