/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.interceptor;

import com.qjsoft.laser.controller.interceptor.service.BaseIntercepter;
import com.qjsoft.laser.controller.springmvc.local.GlobalHandlerMethodLocal;
import com.qjsoft.laser.controller.springmvc.local.HandlerMethodLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SpringMVCInterceptor
extends BaseIntercepter
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.logger.info("==url==", (Object)(request.getServletPath() + ":" + request.getMethod()));
        this.setGlobalHandlerThreadLocal(request, handler);
        boolean flag = this.filterPer(request, response);
        String requestservice = this.getRequestservice(request, this.getTenantCode(request));
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        request.setAttribute("path_servername", (Object)requestservice);
        request.setAttribute("sysAppContextPath", (Object)contextPath);
        request.setAttribute("requestUrl", (Object)servletPath);
        return flag;
    }

    private void setHandlerThreadLocal(Object handler) {
        if (handler != null && handler instanceof HandlerMethod) {
            HandlerMethodLocal.set((HandlerMethod)handler);
        }
    }

    private void setGlobalHandlerThreadLocal(HttpServletRequest request, Object handler) {
        if (handler != null) {
            if (handler instanceof HandlerMethod) {
                GlobalHandlerMethodLocal.set((HandlerMethod)handler);
            }
            if (!this.isJsonRequest(request).booleanValue()) {
                this.setHandlerThreadLocal(handler);
            }
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.filterEnd(request, response);
        GlobalHandlerMethodLocal.remove();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (null != ex) {
            this.logger.error((Throwable)ex);
        }
    }
}

