/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.xss;

import com.qjsoft.laser.controller.springmvc.xss.HtmlFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest;
    private static final HtmlFilter htmlFilter = new HtmlFilter();

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest request) {
        if (request instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)request).getOrgRequest();
        }
        return request;
    }

    public String getParameter(String name) {
        String value = super.getParameter(htmlFilter.filter(name));
        String newValues = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            newValues = htmlFilter.filter(value);
        }
        return StringEscapeUtils.unescapeHtml4((String)newValues);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        String[] newValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = htmlFilter.filter(values[i]);
            newValues[i] = StringEscapeUtils.unescapeHtml4((String)newValues[i]);
        }
        return newValues;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        Map parameters = super.getParameterMap();
        for (String key : parameters.keySet()) {
            String[] values = (String[])parameters.get(key);
            String[] newValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = htmlFilter.filter(values[i]);
                newValues[i] = StringEscapeUtils.unescapeHtml4((String)newValues[i]);
            }
            map.put(key, newValues);
        }
        return map;
    }

    public String getHeader(String name) {
        String value = super.getHeader(htmlFilter.filter(name));
        String newValues = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            newValues = htmlFilter.filter(value);
        }
        return StringEscapeUtils.unescapeHtml4((String)newValues);
    }
}

