/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.tk.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.tk.domain.TkTasklistDomain;
import com.qjsoft.laser.controller.facade.tk.domain.TkTasklistReDomain;
import com.qjsoft.laser.controller.facade.tk.repository.TkTasklistServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tk/tasklist"}, name="\u4efb\u52a1\u9879\u76ee\u670d\u52a1")
public class TasklistCon
extends SpringmvcController {
    private static String CODE = "tk.tasklist.con";
    @Autowired
    private TkTasklistServiceRepository tkTasklistServiceRepository;

    protected String getContext() {
        return "tasklist";
    }

    @RequestMapping(value={"saveTasklist.json"}, name="\u589e\u52a0\u4efb\u52a1\u9879\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTasklist(HttpServletRequest request, TkTasklistDomain tkTasklistDomain) {
        if (null == tkTasklistDomain) {
            this.logger.error(CODE + ".saveTasklist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTasklistDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTasklistServiceRepository.saveTasklist(tkTasklistDomain);
    }

    @RequestMapping(value={"getTasklist.json"}, name="\u83b7\u53d6\u4efb\u52a1\u9879\u76ee\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public TkTasklistReDomain getTasklist(Integer tasklistId) {
        if (StringUtils.isBlank((Integer)tasklistId)) {
            this.logger.error(CODE + ".getTasklist", (Object)"param is null");
            return null;
        }
        return this.tkTasklistServiceRepository.getTasklist(tasklistId);
    }

    @RequestMapping(value={"updateTasklist.json"}, name="\u66f4\u65b0\u4efb\u52a1\u9879\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTasklist(HttpServletRequest request, TkTasklistDomain tkTasklistDomain) {
        if (null == tkTasklistDomain) {
            this.logger.error(CODE + ".updateTasklist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTasklistDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTasklistServiceRepository.updateTasklist(tkTasklistDomain);
    }

    @RequestMapping(value={"deleteTasklist.json"}, name="\u5220\u9664\u4efb\u52a1\u9879\u76ee\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTasklist(Integer tasklistId) {
        if (StringUtils.isBlank((Integer)tasklistId)) {
            this.logger.error(CODE + ".deleteTasklist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTasklistServiceRepository.deleteTasklist(tasklistId);
    }

    @RequestMapping(value={"queryTasklistPage.json"}, name="\u67e5\u8be2\u4efb\u52a1\u9879\u76ee\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TkTasklistReDomain> queryTasklistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tkTasklistServiceRepository.queryTasklistPage(param);
    }

    @RequestMapping(value={"updateTasklistState.json"}, name="\u66f4\u65b0\u4efb\u52a1\u9879\u76ee\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTasklistState(String tasklistId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tasklistId)) {
            this.logger.error(CODE + ".updateTasklistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTasklistServiceRepository.updateTasklistState(Integer.valueOf(tasklistId), dataState, oldDataState, map);
    }
}

