/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.upm.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.upm.domain.UpmUpointsDomain;
import com.qjsoft.laser.controller.facade.upm.domain.UpmUpointsListReDomain;
import com.qjsoft.laser.controller.facade.upm.domain.UpmUpointsReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/upm/upmupoints"}, name="\u7528\u6237\u79ef\u5206\u670d\u52a1")
public class UpmupointsCon
extends SpringmvcController {
    private static String CODE = "upm.upmupoints.con";
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;

    protected String getContext() {
        return "upmupoints";
    }

    @RequestMapping(value={"saveUpmupoints.json"}, name="\u589e\u52a0\u7528\u6237\u79ef\u5206\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmupoints(HttpServletRequest request, UpmUpointsDomain upmUpointsDomain) {
        if (null == upmUpointsDomain) {
            this.logger.error(CODE + ".saveUpmupoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmUpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmUpointsServiceRepository.saveUpoints(upmUpointsDomain);
    }

    @RequestMapping(value={"getUpmupoints.json"}, name="\u83b7\u53d6\u7528\u6237\u79ef\u5206\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmUpointsReDomain getUpmupoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".getUpmupoints", (Object)"param is null");
            return null;
        }
        return this.upmUpointsServiceRepository.getUpoints(upointsId);
    }

    @RequestMapping(value={"getMemberIntegralInfo.json"}, name="\u83b7\u53d6\u4f1a\u5458\u79ef\u5206\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<UpmUpointsListReDomain> getMemberIntegralInfo(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getMemberIntegralInfo", (Object)"param is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        Date dNow = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dNow);
        calendar.add(2, -3);
        Date dBefore = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String defaultStartDate = sdf.format(dBefore);
        String defaultEndDate = sdf.format(dNow);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", userSession.getUserPcode());
        param.put("startDate", defaultStartDate);
        param.put("endDate", defaultEndDate);
        SupQueryResult upointsList = this.upmUpointsServiceRepository.queryUpointsListPage(param);
        if (null == upointsList || upointsList.getList().size() <= 0) {
            return null;
        }
        return upointsList;
    }

    @RequestMapping(value={"queryUpmupointsList.json"}, name="\u6839\u636eCODE\u67e5\u8be2\u7528\u6237\u79ef\u5206\u6d41\u6c34")
    @ResponseBody
    public SupQueryResult<UpmUpointsListReDomain> queryUpointsListPage(HttpServletRequest request, String memberCode) {
        Map param = this.assemMapParam(request);
        param.put("memberCode", memberCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.upmUpointsServiceRepository.queryUpointsListPage(param);
    }

    @RequestMapping(value={"updateUpmupoints.json"}, name="\u66f4\u65b0\u7528\u6237\u79ef\u5206\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateUpmupoints(HttpServletRequest request, UpmUpointsDomain upmupointsDomain) {
        if (null == upmupointsDomain) {
            this.logger.error(CODE + ".updateUpmupoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmupointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmUpointsServiceRepository.updateUpoints(upmupointsDomain);
    }

    @RequestMapping(value={"deleteUpmupoints.json"}, name="\u5220\u9664\u7528\u6237\u79ef\u5206\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteUpmupoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".deleteUpmupoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmUpointsServiceRepository.deleteUpoints(upointsId);
    }

    @RequestMapping(value={"queryUpmupointsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u79ef\u5206\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmUpointsReDomain> queryUpmupointsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.upmUpointsServiceRepository.queryUpointsPage(param);
    }

    @RequestMapping(value={"updateUpmupointsState.json"}, name="\u66f4\u65b0\u7528\u6237\u79ef\u5206\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpmupointsState(String upointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)upointsId)) {
            this.logger.error(CODE + ".updateUpmupointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmUpointsServiceRepository.updateUpointsState(Integer.valueOf(upointsId), dataState, oldDataState);
    }

    @RequestMapping(value={"getUpmupointsPageByPC.json"}, name="\u67e5\u8be2\u7528\u6237\u79ef\u5206\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public UpmUpointsReDomain getUpmupointsPageByPC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult upointsList = this.upmUpointsServiceRepository.queryUpointsPage(param);
        if (null == upointsList || upointsList.getList().size() <= 0) {
            this.logger.error(CODE + ".getUpmupointsPageByPC", (Object)"upointsList is null");
            return null;
        }
        return (UpmUpointsReDomain)upointsList.getList().get(0);
    }

    @RequestMapping(value={"queryUpmupointsPageByPC.json"}, name="\u67e5\u8be2\u7528\u6237\u79ef\u5206\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmUpointsReDomain> queryUpmupointsPageByPC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult upointsList = this.upmUpointsServiceRepository.queryUpointsPage(param);
        if (null == upointsList || upointsList.getList().size() <= 0) {
            this.logger.error(CODE + ".getUpmupointsPageByPC", (Object)"upointsList is null");
            return null;
        }
        return upointsList;
    }
}

