/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wo.domain.WoWorkOrderDomain;
import com.qjsoft.laser.controller.facade.wo.domain.WoWorkOrderReDomain;
import com.qjsoft.laser.controller.facade.wo.repository.WoWorkOrderServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wo/woWorkOrder"}, name="\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1")
public class WoWorkOrderCon
extends SpringmvcController {
    private static String CODE = "wo.woWorkOrder.con";
    @Autowired
    private WoWorkOrderServiceRepository woWorkOrderServiceRepository;

    protected String getContext() {
        return "woWorkOrder";
    }

    @RequestMapping(value={"saveWoWorkOrder.json"}, name="\u589e\u52a0\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveWoWorkOrder(HttpServletRequest request, WoWorkOrderDomain workOrderDomain) {
        if (null == workOrderDomain) {
            this.logger.error(CODE + ".saveWoWorkOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        workOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.woWorkOrderServiceRepository.saveWorkOrder(workOrderDomain);
    }

    @RequestMapping(value={"getWoWorkOrder.json"}, name="\u83b7\u53d6\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WoWorkOrderReDomain getWoWorkOrder(Integer workOrderId) {
        if (StringUtils.isBlank((Integer)workOrderId)) {
            this.logger.error(CODE + ".getWoWorkOrder", (Object)"param is null");
            return null;
        }
        return this.woWorkOrderServiceRepository.getWorkOrder(workOrderId);
    }

    @RequestMapping(value={"updateWoWorkOrder.json"}, name="\u66f4\u65b0\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateWoWorkOrder(HttpServletRequest request, WoWorkOrderDomain workOrderDomain) {
        if (null == workOrderDomain) {
            this.logger.error(CODE + ".updateWoWorkOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        workOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.woWorkOrderServiceRepository.updateWorkOrder(workOrderDomain);
    }

    @RequestMapping(value={"deleteWoWorkOrder.json"}, name="\u5220\u9664\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteWoWorkOrder(Integer workOrderId) {
        if (StringUtils.isBlank((Integer)workOrderId)) {
            this.logger.error(CODE + ".deleteWoWorkOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.woWorkOrderServiceRepository.deleteWorkOrder(workOrderId);
    }

    @RequestMapping(value={"queryWoWorkOrderPage.json"}, name="\u67e5\u8be2\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WoWorkOrderReDomain> queryWoWorkOrderPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.woWorkOrderServiceRepository.queryWorkOrderPage(param);
    }

    @RequestMapping(value={"updateWoWorkOrderState.json"}, name="\u66f4\u65b0\u5de5\u5355\u4fe1\u606f\u8868\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWoWorkOrderState(String workOrderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)workOrderId)) {
            this.logger.error(CODE + ".updateWoWorkOrderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.woWorkOrderServiceRepository.updateWorkOrderState(Integer.valueOf(workOrderId), dataState, oldDataState);
    }
}

