/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.reb.RebPointsDomain;
import cn.com.qj.bff.domain.reb.RebPointsReDomain;
import cn.com.qj.bff.service.reb.RebPointsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/points"}, name="\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
public class RebPointsCon
extends SpringmvcController {
    private static String CODE = "reb.points.con";
    @Autowired
    private RebPointsService rebPointsService;

    @Override
    protected String getContext() {
        return "points";
    }

    @RequestMapping(value={"savePoints.json"}, name="\u589e\u52a0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean savePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".savePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.savePoints(rebPointsDomain);
    }

    @RequestMapping(value={"getPoints.json"}, name="\u83b7\u53d6\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u4fe1\u606f")
    @ResponseBody
    public RebPointsReDomain getPoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getPoints", (Object)"param is null");
            return null;
        }
        return this.rebPointsService.getPoints(pointsId);
    }

    @RequestMapping(value={"updatePoints.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePoints(rebPointsDomain);
    }

    @RequestMapping(value={"deletePoints.json"}, name="\u5220\u9664\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean deletePoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deletePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryPointsPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsState.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryPointsPageStr.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPageStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsStr.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePointsStr(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePoints(rebPointsDomain);
    }
}

