/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.org;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.org.OrgPositionDomain;
import cn.com.qj.bff.domain.org.OrgPositionReDomain;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.org.OrgPositionService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/position"}, name="\u804c\u4f4d\u670d\u52a1")
public class orgPositionCon
extends SpringmvcController {
    private static String CODE = "org.position.con";
    @Autowired
    private OrgPositionService orgPositionService;
    @Autowired
    private OrgEmployeeService orgEmployeeService;

    @Override
    protected String getContext() {
        return "position";
    }

    @RequestMapping(value={"queryPositionPage.json"}, name="\u67e5\u8be2\u804c\u4f4d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    @RequestMapping(value={"queryPositionPageCurrency.json"}, name="\u67e5\u8be2\u804c\u4f4d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionPageCurrency(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    @RequestMapping(value={"queryCompanyPositionPage.json"}, name="\u67e5\u8be2\u516c\u53f8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryCompanyPositionPage(HttpServletRequest request, String companyCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "0");
            param.put("companyCode", companyCode);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    @RequestMapping(value={"queryCompanyPositionPageForB.json"}, name="B\u7aef\u67e5\u8be2\u516c\u53f8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryCompanyPositionPageForB(HttpServletRequest request, String companyCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "0");
            param.put("companyCode", companyCode);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    @RequestMapping(value={"queryDepartPositionPage.json"}, name="\u67e5\u8be2\u90e8\u95e8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryDepartPositionPage(HttpServletRequest request, String companyCode) {
        return this.queryDepartPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"queryGroupPositionPage.json"}, name="\u67e5\u8be2\u7fa4\u7ec4\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryGroupPositionPage(HttpServletRequest request, String companyCode) {
        return this.queryGroupPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"updatePosition.json"}, name="\u66f4\u65b0\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePosition(HttpServletRequest request, OrgPositionDomain orgPositionDomain) {
        if (null == orgPositionDomain) {
            this.logger.error(CODE + ".updatePosition", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgPositionDomain.setTenantCode(this.getTenantCode(request));
        orgPositionDomain.setChannelCode(this.getChannelCode(request));
        orgPositionDomain.setChannelName(this.getChannelName(this.getChannelCode(request), request));
        return this.orgPositionService.updatePosition(orgPositionDomain);
    }

    @RequestMapping(value={"updatePositionState.json"}, name="\u66f4\u65b0\u804c\u4f4d\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePositionState(String positionId) {
        if (StringUtils.isBlank((String)positionId)) {
            this.logger.error(CODE + ".updatePositionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgPositionService.updatePositionState(Integer.valueOf(positionId), 0, -1);
    }

    @RequestMapping(value={"stoppedPositionState.json"}, name="\u505c\u7528\u804c\u4f4d")
    @ResponseBody
    public HtmlJsonReBean stoppedPositionState(String positionId) {
        if (StringUtils.isBlank((String)positionId)) {
            this.logger.error(CODE + ".stoppedPositionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgPositionService.updatePositionState(Integer.valueOf(positionId), -1, 0);
    }

    @RequestMapping(value={"savePosition.json"}, name="\u589e\u52a0\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePosition(HttpServletRequest request, OrgPositionDomain orgPositionDomain) {
        if (null == orgPositionDomain) {
            this.logger.error(CODE + ".savePosition", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgPositionDomain.setTenantCode(this.getTenantCode(request));
        orgPositionDomain.setChannelCode(this.getChannelCode(request));
        orgPositionDomain.setChannelName(this.getChannelName(this.getChannelCode(request), request));
        return this.orgPositionService.savePosition(orgPositionDomain);
    }

    @RequestMapping(value={"getPosition.json"}, name="\u83b7\u53d6\u804c\u4f4d\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgPositionReDomain getPosition(Integer positionId) {
        if (StringUtils.isBlank((Integer)positionId)) {
            this.logger.error(CODE + ".getPosition", (Object)"param is null");
            return null;
        }
        return this.orgPositionService.getPosition(positionId);
    }

    @RequestMapping(value={"deletePosition.json"}, name="\u5220\u9664\u804c\u4f4d\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePosition(Integer positionId) {
        if (StringUtils.isBlank((Integer)positionId)) {
            this.logger.error(CODE + ".deletePosition", (Object)"positionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgPositionReDomain orgPositionReDomain = this.orgPositionService.getPosition(positionId);
        if (null == orgPositionReDomain) {
            this.logger.error(CODE + ".savePosition", (Object)"orgPositionReDomain is null");
            return null;
        }
        HashMap<String, Object> positionmap = new HashMap<String, Object>();
        positionmap.put("positionCode", orgPositionReDomain.getPositionCode());
        positionmap.put("tenantCode", orgPositionReDomain.getTenantCode());
        List employeeList = this.orgEmployeeService.queryEmployeePage(positionmap).getList();
        this.logger.error(CODE + ".deletePosition.employeeList:" + JsonUtil.buildNormalBinder().toJson((Object)employeeList));
        if (null != employeeList && !employeeList.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u804c\u4f4d\u8fd8\u6709\u5458\u5de5");
        }
        return this.orgPositionService.deletePosition(positionId);
    }

    @RequestMapping(value={"queryPositionByUserCode.json"}, name="\u6839\u636eUserCode\u67e5\u627e\u6240\u5c5e\u516c\u53f8\u804c\u4f4d")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryPositionByUserCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserCode())) {
            this.logger.error(CODE + ".queryPositionByUserCode", (Object)"userSession is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> usermap = new HashMap<String, Object>();
        usermap.put("userCode", userSession.getUserCode());
        usermap.put("tenantCode", tenantCode);
        List employeebyuser = this.orgEmployeeService.queryEmployeePage(usermap).getList();
        if (null == employeebyuser || employeebyuser.size() <= 0) {
            this.logger.error(CODE + ".queryPositionByUserCode", (Object)"employeebyuser is null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)employeebyuser.get(0);
        HashMap<String, Object> companyMap = new HashMap<String, Object>();
        HashMap<String, Object> companyCodemap = new HashMap<String, Object>();
        companyMap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        companyMap.put("tenantCode", tenantCode);
        ArrayList<String> pList = new ArrayList<String>();
        SupQueryResult<OrgEmployeeReDomain> employeeList = this.orgEmployeeService.queryEmployeePage(companyMap);
        if (null != employeeList && employeeList.getList().size() > 0) {
            for (OrgEmployeeReDomain orgEmployee : employeeList.getList()) {
                pList.add(orgEmployee.getPositionName());
            }
            if (pList.contains("\u603b\u7ecf\u7406")) {
                companyCodemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
                companyCodemap.put("positionName", "\u9500\u552e\u5458");
                companyCodemap.put("positionType", "0");
                companyCodemap.put("tenantCode", tenantCode);
                return this.orgPositionService.queryPositionPage(companyCodemap);
            }
        }
        companyCodemap.put("companyCode", orgEmployeeReDomain.getCompanyCode());
        companyCodemap.put("positionType", "0");
        companyCodemap.put("tenantCode", tenantCode);
        return this.orgPositionService.queryPositionPage(companyCodemap);
    }

    @RequestMapping(value={"queryDepartPositionPageByPC.json"}, name="PC\u67e5\u8be2\u516c\u53f8\u90e8\u95e8\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryDepartPositionPageByPC(HttpServletRequest request, String companyCode) {
        return this.queryDepartPositionPageByCommon(request, companyCode);
    }

    @RequestMapping(value={"queryGroupPositionPageByPC.json"}, name="PC\u67e5\u8be2\u516c\u53f8\u7fa4\u7ec4\u804c\u4f4d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgPositionReDomain> queryGroupPositionPageByPC(HttpServletRequest request, String companyCode) {
        return this.queryGroupPositionPageByCommon(request, companyCode);
    }

    private SupQueryResult<OrgPositionReDomain> queryDepartPositionPageByCommon(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".queryDepartPositionPage", (Object)"companyCode is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "1");
            param.put("companyCode", companyCode);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    private SupQueryResult<OrgPositionReDomain> queryGroupPositionPageByCommon(HttpServletRequest request, String companyCode) {
        if (StringUtils.isBlank((String)companyCode)) {
            this.logger.error(CODE + ".queryGroupPositionPage", (Object)"companyCode is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("positionType", "2");
            param.put("companyCode", companyCode);
        }
        return this.orgPositionService.queryPositionPage(param);
    }

    @RequestMapping(value={"updatePositions.json"}, name="\u804c\u4f4d\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updatePositions(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgPositionDomain.class);
        if (goodsList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (OrgPositionDomain orgPositionDomain : goodsList) {
            orgPositionDomain.setTenantCode(tenantCode);
            orgPositionDomain.setChannelCode(this.getChannelCode(request));
            orgPositionDomain.setChannelName(this.getChannelName(this.getChannelCode(request), request));
        }
        this.orgPositionService.updatePositions(goodsList);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"savePositions.json"}, name="\u804c\u4f4d\u6279\u91cf\u6dfb\u52a0")
    @ResponseBody
    public HtmlJsonReBean savePositions(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, OrgPositionDomain.class);
        if (goodsList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (OrgPositionDomain orgPositionDomain : goodsList) {
            orgPositionDomain.setTenantCode(tenantCode);
            orgPositionDomain.setChannelCode(this.getChannelCode(request));
            orgPositionDomain.setChannelName(this.getChannelName(this.getChannelCode(request), request));
        }
        this.orgPositionService.savePositions(goodsList);
        return new HtmlJsonReBean();
    }
}

