/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pte;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OrderDomain;
import cn.com.qj.bff.domain.oc.PackageDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.pte.PteBalancelistDomain;
import cn.com.qj.bff.domain.pte.PteBalancelistReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.oc.OcService;
import cn.com.qj.bff.service.pte.PteBalancelistService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/balancelist"}, name="\u7ed3\u7b97\u6d41\u6c34")
public class PteBalancelistCon
extends SpringmvcController {
    private static String CODE = "pte.balancelist.con";
    @Autowired
    private PteBalancelistService pteBalancelistService;
    @Autowired
    private UserService userService;
    @Autowired
    private OcService ocService;

    @Override
    protected String getContext() {
        return "balancelist";
    }

    @RequestMapping(value={"saveBalancelist.json"}, name="\u589e\u52a0\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveBalancelist(HttpServletRequest request, PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            this.logger.error(CODE + ".saveBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pteBalancelistDomain.setTenantCode(this.getTenantCode(request));
        return this.pteBalancelistService.saveBalancelist(pteBalancelistDomain);
    }

    @RequestMapping(value={"getBalancelist.json"}, name="\u83b7\u53d6\u7ed3\u7b97\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public PteBalancelistReDomain getBalancelist(Integer pteBalancelistId) {
        if (StringUtils.isBlank((Integer)pteBalancelistId)) {
            this.logger.error(CODE + ".getBalancelist", (Object)"param is null");
            return null;
        }
        return this.pteBalancelistService.getBalancelist(pteBalancelistId);
    }

    @RequestMapping(value={"updateBalancelist.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateBalancelist(HttpServletRequest request, PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            this.logger.error(CODE + ".updateBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pteBalancelistDomain.setTenantCode(this.getTenantCode(request));
        return this.pteBalancelistService.updateBalancelist(pteBalancelistDomain);
    }

    @RequestMapping(value={"deleteBalancelist.json"}, name="\u5220\u9664\u7ed3\u7b97\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteBalancelist(Integer pteBalancelistId) {
        if (StringUtils.isBlank((Integer)pteBalancelistId)) {
            this.logger.error(CODE + ".deleteBalancelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteBalancelistService.deleteBalancelist(pteBalancelistId);
    }

    @RequestMapping(value={"queryBalancelistPage.json"}, name="\u67e5\u8be2\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pteBalancelistService.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByUser.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.pteBalancelistService.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByPlat.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        Object memberCode = param.get("memberCode");
        String reStr = "";
        if (null != memberCode) {
            List<String> result = Arrays.asList(memberCode.toString().split(","));
            for (String code : result) {
                HashMap<String, Object> uMap = new HashMap<String, Object>();
                uMap.put("userinfoParentCode", code);
                uMap.put("tenantCode", this.getTenantCode(request));
                uMap.put("fuzzy", true);
                List<UmUserinfoReDomainBean> umUserinfoReDomainBeans = this.userService.queryUserinfoList(uMap);
                if (ListUtil.isEmpty(umUserinfoReDomainBeans)) continue;
                for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeans) {
                    reStr = reStr + umUserinfoReDomainBean.getUserinfoCode() + ",";
                }
            }
        }
        if (StringUtils.isNotBlank((String)reStr)) {
            reStr = reStr.substring(0, reStr.length() - 1);
            param.put("memberCode", memberCode.toString() + "," + reStr);
        }
        return this.pteBalancelistService.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByMemberCcode.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByMemberCcode(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberBcode", userSession.getUserPcode());
        }
        return this.pteBalancelistService.queryBalancelistPage(param);
    }

    @RequestMapping(value={"queryBalancelistPageByMemberCcodeOnlyMy.json"}, name="\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)")
    @ResponseBody
    public SupQueryResult<PteBalancelistReDomain> queryBalancelistPageByMemberCcodeOnlyMy(HttpServletRequest request) {
        this.logger.debug(CODE + ".queryBalancelistPageByMemberCcodeOnlyMy", (Object)"================================\u67e5\u8be2\u5206\u9500\u7ed3\u7b97\u6d41\u6c34\u5206\u9875\u5217\u8868(\u5206\u9500\u5546)================================");
        Map<String, Object> param = this.assemMapParam(request);
        this.logger.debug(CODE + ".queryBalancelistPageByMemberCcodeOnlyMy", (Object)("================================param" + JsonUtil.buildNonEmptyBinder().toJson(param) + "================================"));
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        HashMap<String, Object> userinfoMap = new HashMap<String, Object>();
        userinfoMap.put("userinfoParentCode", this.getUserSession(request).getUserPcode());
        SupQueryResult<UmUserinfoReDomainBean> userinfoSupQueryResult = this.userService.queryUserinfoPage(userinfoMap);
        List uiList = new ArrayList();
        if (userinfoSupQueryResult != null && userinfoSupQueryResult.getList() != null) {
            uiList = userinfoSupQueryResult.getList();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoParentCode", param.get("userinfoParentCode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(map);
        ArrayList AllList = new ArrayList();
        List userinfoList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            userinfoList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        userinfoList.addAll(uiList);
        for (int i = 0; i < userinfoList.size(); ++i) {
            param.put("memberCode", ((UmUserinfoReDomainBean)userinfoList.get(i)).getUserinfoCode());
            param.put("balanceType", "shsettl");
            param.put("memberBcode", userSession.getUserPcode());
            SupQueryResult<PteBalancelistReDomain> pteBalancelistReDomainSupQueryResult = this.pteBalancelistService.queryBalancelistPage(param);
            if (pteBalancelistReDomainSupQueryResult == null) continue;
            List list = pteBalancelistReDomainSupQueryResult.getList();
            AllList.addAll(list);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(AllList);
        supQueryResult.setRows(AllList);
        return supQueryResult;
    }

    @RequestMapping(value={"updateBalancelistState.json"}, name="\u66f4\u65b0\u7ed3\u7b97\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBalancelistState(String pteBalancelistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pteBalancelistId)) {
            this.logger.error(CODE + ".updateBalancelistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteBalancelistService.updateBalancelistState(Integer.valueOf(pteBalancelistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveBalancelistToPay.json"}, name="\u652f\u4ed8\u7ed3\u7b97")
    @ResponseBody
    public HtmlJsonReBean saveBalancelistToPay(HttpServletRequest request, String ocContractSettlDomainStr, String JsonMap) {
        if (StringUtils.isBlank((String)JsonMap) || StringUtils.isBlank((String)ocContractSettlDomainStr)) {
            this.logger.error(CODE + ".saveBalancelistToPay.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map jsonToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonMap, String.class, Object.class);
        String remark = String.valueOf(jsonToMap.get("remark"));
        String pteBalancelistCode = String.valueOf(jsonToMap.get("pteBalancelistCode"));
        String contractPaydate = String.valueOf(jsonToMap.get("contractPaydate"));
        String grossAmount = String.valueOf(jsonToMap.get("grossAmount"));
        if (StringUtils.isBlank((String)pteBalancelistCode)) {
            this.logger.error(CODE + ".saveBalancelistToPay.param", (Object)"pteBalancelistCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PteBalancelistReDomain pteBalancelistReDomain = this.pteBalancelistService.getBalancelistByCode(this.getTenantCode(request), pteBalancelistCode);
        if (null == pteBalancelistReDomain) {
            this.logger.error(CODE + ".saveBalancelistToPay.pteBalancelistReDomain", (Object)(pteBalancelistCode + "=pteBalancelistReDomain is null"));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u5f02\u5e38");
        }
        List ocContractSettlDomainStrList = JsonUtil.buildNormalBinder().getJsonToList(ocContractSettlDomainStr, OcContractSettlDomain.class);
        if (ListUtil.isEmpty((Collection)ocContractSettlDomainStrList)) {
            this.logger.error(CODE + ".saveBalancelistToPay.list", (Object)(ocContractSettlDomainStr + "=list is null"));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u5f02\u5e381");
        }
        BigDecimal grossAmountNew = BigDecimal.valueOf(Double.parseDouble(grossAmount));
        Date contractPaydateNew = DateUtil.getDateToString((String)contractPaydate, (String)"yyyy-MM-dd HH:mm:ss");
        return this.saveOrder(request, remark, pteBalancelistReDomain, ocContractSettlDomainStrList, contractPaydateNew, grossAmountNew);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, String remark, PteBalancelistReDomain pteBalancelistReDomain, List<OcContractSettlDomain> ocContractSettlDomainStrList, Date contractPaydate, BigDecimal grossAmount) {
        if (null == pteBalancelistReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (ListUtil.isEmpty(ocContractSettlDomainStrList)) {
            this.logger.error(CODE + ".saveOrder.list");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u5f02\u5e381");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "49";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocService.getOcSetting(shoppingType, pteBalancelistReDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(remark);
        orderDomain.setContractType(shoppingType);
        orderDomain.setContractTypepro("01");
        orderDomain.setGoodsReceiptPhone("");
        orderDomain.setContractNbillcode(pteBalancelistReDomain.getBalancelistCode());
        orderDomain.setContractPaydate(contractPaydate);
        orderDomain.setOcContractSettlList(ocContractSettlDomainStrList);
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(pteBalancelistReDomain.getOrderOamount());
        ocContractGoodsDomain.setContractGoodsMoney(grossAmount);
        ocContractGoodsDomain.setContractGoodsPrice(pteBalancelistReDomain.getOrderOamount());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(pteBalancelistReDomain.getBusinessDes());
        ocContractGoodsDomain.setGoodsNo(pteBalancelistReDomain.getBalancelistCode());
        ocContractGoodsDomain.setGoodsCode(pteBalancelistReDomain.getBalancelistCode());
        ocContractGoodsDomain.setSkuCode(pteBalancelistReDomain.getBalancelistCode());
        ocContractGoodsDomain.setSkuNo(pteBalancelistReDomain.getBalancelistCode());
        ocContractGoodsDomain.setSkuName(pteBalancelistReDomain.getBusinessDes());
        ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ocContractGoodsDomain.setMemberCode(pteBalancelistReDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(pteBalancelistReDomain.getMemberName());
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        HtmlJsonReBean htmlJsonReBean = this.ocService.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", pteBalancelistReDomain.getOrderOamount());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }
}

