/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.mh.ActiveDomain;
import cn.com.qj.bff.domain.mh.ActiveRebateDomain;
import cn.com.qj.bff.domain.reb.RebPointsConfDomain;
import cn.com.qj.bff.domain.reb.RebPointsConfReDomain;
import cn.com.qj.bff.domain.reb.RebPointsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleReDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersReDomain;
import cn.com.qj.bff.service.mh.ExService;
import cn.com.qj.bff.service.nm.NmNoService;
import cn.com.qj.bff.service.reb.RebPointsGoodsService;
import cn.com.qj.bff.service.reb.RebPointsService;
import cn.com.qj.bff.service.reb.RebPointsUsersService;
import cn.com.qj.bff.service.reb.RebPointsuserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/points"}, name="\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
public class RebPointsCon
extends SpringmvcController {
    private static String CODE = "reb.points.con";
    @Autowired
    private RebPointsuserService rebPointsuserService;
    @Autowired
    private RebPointsService rebPointsService;
    @Autowired
    RebPointsGoodsService rebPointsGoodsService;
    @Autowired
    RebPointsUsersService rebPointsUsersService;
    @Autowired
    NmNoService nmNoService;
    @Autowired
    ExService exService;

    @Override
    protected String getContext() {
        return "points";
    }

    @RequestMapping(value={"savePoints.json"}, name="\u589e\u52a0\u8fd4\u5229\u5f00\u542f")
    @ResponseBody
    public HtmlJsonReBean savePoints(HttpServletRequest request, String rebPointsDomainStr) {
        HtmlJsonReBean htmlJsonReBean;
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".savePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        HashMap<String, Object> pointsParam = new HashMap<String, Object>();
        pointsParam.put("tenantCode", this.getTenantCode(request));
        pointsParam.put("channelCode", rebPointsDomain.getChannelCode());
        SupQueryResult<RebPointsReDomain> supQueryResult = this.rebPointsService.queryPointsPage(pointsParam);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".savePoints", (Object)"\u6e20\u9053\u89c4\u5219\u5df2\u5b58\u5728");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u89c4\u5219\u5df2\u5b58\u5728");
        }
        String rebPointsCode = this.nmNoService.createMaxBillNumber(null, "RebPoints", "rebPoints", this.getTenantCode(request));
        if ("1".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FL" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        } else if ("2".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FYSQ" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        } else if ("3".equals(rebPointsDomain.getFundType())) {
            rebPointsCode = "FYHX" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + rebPointsCode.substring(rebPointsCode.length() - 4);
        }
        rebPointsDomain.setUpointsType("2");
        rebPointsDomain.setPointsUstart("1");
        rebPointsDomain.setPointsStart("0");
        rebPointsDomain.setPointsCode(rebPointsCode);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        DisChannel disChannel = this.getChannelModel(rebPointsDomain.getChannelCode(), request);
        if (null != disChannel) {
            rebPointsDomain.setGoodsClass(disChannel.getGoodsClass());
            rebPointsDomain.setMemberMcode(disChannel.getMemberMcode());
            rebPointsDomain.setMemberMname(disChannel.getMemberMname());
        }
        if (!(htmlJsonReBean = this.rebPointsService.savePoints(rebPointsDomain)).isSuccess()) {
            return htmlJsonReBean;
        }
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(rebPointsCode);
                rebPointsGoodsDomain.setTenantCode(rebPointsDomain.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        return htmlJsonReBean;
    }

    private ActiveDomain createActive(RebPointsDomain rebPointsDomain) {
        ActiveDomain activeDomain = new ActiveDomain();
        Date date = new Date();
        activeDomain.setGrantNo(rebPointsDomain.getPointsCode());
        activeDomain.setApplyDate(date);
        activeDomain.setApplyDepart(rebPointsDomain.getPointsUserqua());
        activeDomain.setApplyPerson(rebPointsDomain.getMemberName());
        activeDomain.setBrandName(rebPointsDomain.getFchannelClassifyName());
        activeDomain.setStartTime(rebPointsDomain.getPointsStartdate());
        activeDomain.setEndTime(rebPointsDomain.getPointsEstartdate());
        activeDomain.setTenantCode(rebPointsDomain.getTenantCode());
        activeDomain.setGrantType(rebPointsDomain.getFundType());
        activeDomain.setAttachUrl(rebPointsDomain.getFchannelName());
        activeDomain.setApplayNo(rebPointsDomain.getPointsPcvalue());
        ActiveRebateDomain activeRebate = new ActiveRebateDomain();
        activeRebate.setRebPointsGoodsDomainList(rebPointsDomain.getRebPointsGoodsDomainList());
        activeRebate.setRebType(rebPointsDomain.getPointsDatetype());
        activeRebate.setComplianceRebType(rebPointsDomain.getPointsDatatype());
        activeRebate.setUpointsName(rebPointsDomain.getUpointsName());
        activeRebate.setActiveFeeRemark(rebPointsDomain.getPointsRemark());
        activeDomain.setActiveRebate(activeRebate);
        return activeDomain;
    }

    @RequestMapping(value={"getPoints.json"}, name="\u83b7\u53d6\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u4fe1\u606f")
    @ResponseBody
    public RebPointsReDomain getPoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getPoints", (Object)"param is null");
            return null;
        }
        RebPointsReDomain points = this.rebPointsService.getPoints(pointsId);
        if (points == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", points.getTenantCode());
        map.put("pointsCode", points.getPointsCode());
        ArrayList<RebPointsGoodsDomain> rebPointsGoodsDomainList = new ArrayList<RebPointsGoodsDomain>();
        SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(map);
        if (rebPointsGoodsReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsGoodsReDomainSupQueryResult.getList())) {
            rebPointsGoodsDomainList.addAll(rebPointsGoodsReDomainSupQueryResult.getList());
            rebPointsGoodsReDomainSupQueryResult.getList().forEach(goods -> {
                goods.setChannelCode(points.getChannelCode());
                goods.setChannelName(points.getChannelName());
            });
        }
        points.setRebPointsGoodsDomainList(rebPointsGoodsDomainList);
        return points;
    }

    @RequestMapping(value={"updatePoints.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePoints(HttpServletRequest request, String rebPointsDomainStr) {
        SupQueryResult<RebPointsUsersReDomain> rebPointsUsersReDomainSupQueryResult;
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList;
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsReDomain rebPointsDomain = (RebPointsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsReDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        rebPointsDomain.setDataState(0);
        rebPointsDomain.setMemberName(this.getUserSession(request).getUserRelname());
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.updatePoints(rebPointsDomain);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", rebPointsDomain.getTenantCode());
        map.put("pointsCode", rebPointsDomain.getPointsCode());
        SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(map);
        if (rebPointsGoodsReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsGoodsReDomainSupQueryResult.getList())) {
            for (Object rebPointsGoodsReDomain : rebPointsGoodsReDomainSupQueryResult.getList()) {
                this.rebPointsGoodsService.deletePointsGoods(((RebPointsGoodsDomain)rebPointsGoodsReDomain).getPointsGoodsId());
            }
        }
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList())) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(rebPointsDomain.getPointsCode());
                rebPointsGoodsDomain.setTenantCode(rebPointsDomain.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        if ((rebPointsUsersReDomainSupQueryResult = this.rebPointsUsersService.queryPointsUsersPage(map)) != null && CollectionUtils.isNotEmpty((Collection)rebPointsUsersReDomainSupQueryResult.getList())) {
            for (RebPointsUsersReDomain rebPointsUsersReDomain : rebPointsUsersReDomainSupQueryResult.getList()) {
                this.rebPointsUsersService.deleteRebPointsUsers(rebPointsUsersReDomain.getPointsUserId());
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deletePoints.json"}, name="\u5220\u9664\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean deletePoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deletePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryPointsPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("channelCode");
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsState.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState, null);
        if (htmlJsonReBean.isSuccess()) {
            this.rebPointsService.queryPointsCache();
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updatePointsUstart.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsUstart(String pointsId, Integer pointsUstart, Integer oldPointsUstart) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsUstart", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.updatePointsUstartState(Integer.valueOf(pointsId), pointsUstart, oldPointsUstart, null);
    }

    @RequestMapping(value={"queryPointsPageStr.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPageStr(HttpServletRequest request, String channelCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelCode", channelCode);
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsStr.json"}, name="\u66f4\u65b0\u8fd4\u5229\u89c4\u5219  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePointsStr(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        RebPointsReDomain getById = this.rebPointsService.getPoints(rebPointsDomain.getPointsId());
        getById.setPointsRatio(rebPointsDomain.getPointsRatio());
        getById.setTenantCode(this.getTenantCode(request));
        getById.setPointsGoodsScope(rebPointsDomain.getPointsGoodsScope());
        this.rebPointsGoodsService.deletePointsGoodsByPointsCode(this.getTenantCode(request), getById.getPointsCode());
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setPointsCode(getById.getPointsCode());
                rebPointsGoodsDomain.setTenantCode(getById.getTenantCode());
            }
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        return this.rebPointsService.updatePoints(getById);
    }

    @RequestMapping(value={"queryPointsRulePage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u8bbe\u7f6e\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<RebPointsRuleReDomain> queryPointsRulePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsRulePage(param);
    }

    @RequestMapping(value={"updatePointsRule.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsRule(HttpServletRequest request, String rebPointsRuleDomainStr) {
        if (StringUtils.isBlank((String)rebPointsRuleDomainStr)) {
            this.logger.error(CODE + ".updatePointsRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsRuleDomain rebPointsRuleDomain = (RebPointsRuleDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsRuleDomainStr, RebPointsRuleDomain.class);
        rebPointsRuleDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePointsRule(rebPointsRuleDomain);
    }

    @RequestMapping(value={"queryPointsConfPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u8bbe\u7f6e\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<RebPointsConfReDomain> queryPointsConfPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsConfPage(param);
    }

    @RequestMapping(value={"updatePointsConf.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsConf(HttpServletRequest request, String rebPointsConfDomainStr) {
        if (StringUtils.isBlank((String)rebPointsConfDomainStr)) {
            this.logger.error(CODE + ".updatePointsRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsConfDomain rebPointsConfDomain = (RebPointsConfDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsConfDomainStr, RebPointsConfDomain.class);
        rebPointsConfDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePointsConf(rebPointsConfDomain);
    }

    @RequestMapping(value={"updatePointsConfSkuList.json"}, name="\u4fee\u6539\u8fd4\u5229\u5546\u54c1\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsConfSkuList(HttpServletRequest request, String rebPointsGoodsDomains) {
        if (StringUtils.isBlank((String)rebPointsGoodsDomains)) {
            this.logger.error(CODE + ".updatePointsConfSkuList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rebPointsGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(rebPointsGoodsDomains, RebPointsGoodsDomain.class);
        if (CollectionUtils.isNotEmpty((Collection)rebPointsGoodsDomainList)) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
                rebPointsGoodsDomain.setTenantCode(this.getTenantCode(request));
            }
            this.rebPointsGoodsService.deletePointsGoodsByPointsCode(this.getTenantCode(request), ((RebPointsGoodsDomain)rebPointsGoodsDomainList.get(0)).getPointsCode());
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updatePointsConfState.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsConfState(HttpServletRequest request, Integer pointsConfId, Integer dataState) {
        return this.rebPointsService.updatePointsConfState(pointsConfId, dataState, null, new HashMap<String, Object>());
    }
}

