/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wh;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsGoodsRelDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuDomain;
import cn.com.qj.bff.domain.sc.ScShopdeReDomain;
import cn.com.qj.bff.domain.wh.WhStoreSkusafeDomain;
import cn.com.qj.bff.domain.wh.WhStoreSkusafeReDomain;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.sc.ScShopdeService;
import cn.com.qj.bff.service.wh.WhStoreSkusafeService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/whStoreSkusafe"}, name="\u5b89\u5168\u5e93\u5b58SKU")
public class WhStoreSkusafeCon
extends SpringmvcController {
    private static String CODE = "wh.whStoreSkusafe.con";
    @Autowired
    private WhStoreSkusafeService whStoreSkusafeServiceRepository;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private ScShopdeService scShopdeService;
    public static final String CACHE_KEY_SAFESKU = "wh_store_skusafe";

    @Override
    protected String getContext() {
        return "whStoreSkusafe";
    }

    @RequestMapping(value={"saveWhStoreSkusafe.json"}, name="\u589e\u52a0\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean saveWhStoreSkusafe(HttpServletRequest request, WhStoreSkusafeDomain whStoreSkusafeDomain) {
        if (null == whStoreSkusafeDomain) {
            this.logger.error(CODE + ".saveWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreSkusafeServiceRepository.savestoreSkusafe(whStoreSkusafeDomain);
    }

    @RequestMapping(value={"getWhStoreSkusafe.json"}, name="\u83b7\u53d6\u5b89\u5168\u5e93\u5b58SKU\u4fe1\u606f")
    @ResponseBody
    public WhStoreSkusafeReDomain getWhStoreSkusafe(Integer storeSkusafeId) {
        if (StringUtils.isBlank((Integer)storeSkusafeId)) {
            this.logger.error(CODE + ".getWhStoreSkusafe", (Object)"param is null");
            return null;
        }
        return this.whStoreSkusafeServiceRepository.getstoreSkusafe(storeSkusafeId);
    }

    @RequestMapping(value={"updateWhStoreSkusafe.json"}, name="\u66f4\u65b0\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean updateWhStoreSkusafe(HttpServletRequest request, WhStoreSkusafeDomain whStoreSkusafeDomain) {
        if (null == whStoreSkusafeDomain) {
            this.logger.error(CODE + ".updateWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreSkusafeServiceRepository.updatestoreSkusafe(whStoreSkusafeDomain);
    }

    @RequestMapping(value={"deleteWhStoreSkusafe.json"}, name="\u5220\u9664\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean deleteWhStoreSkusafe(Integer storeSkusafeId) {
        if (StringUtils.isBlank((Integer)storeSkusafeId)) {
            this.logger.error(CODE + ".deleteWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreSkusafeServiceRepository.deletestoreSkusafe(storeSkusafeId);
    }

    @RequestMapping(value={"queryWhStoreSkusafePage.json"}, name="\u67e5\u8be2\u5b89\u5168\u5e93\u5b58SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkusafeReDomain> queryWhStoreSkusafePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreSkusafeServiceRepository.querystoreSkusafePage(param);
    }

    @RequestMapping(value={"updateWhStoreSkusafeState.json"}, name="\u66f4\u65b0\u5b89\u5168\u5e93\u5b58SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWhStoreSkusafeState(String storeSkusafeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)storeSkusafeId)) {
            this.logger.error(CODE + ".updateWhStoreSkusafeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreSkusafeServiceRepository.updatestoreSkusafeState(Integer.valueOf(storeSkusafeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"exportInSkuSafe.json"}, name="\u5bfc\u5165\u5b89\u5168\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean exportInSkuSafe(HttpServletRequest request, String storeSkusafe) {
        if (StringUtils.isBlank((String)storeSkusafe)) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession-null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(storeSkusafe, WhStoreSkusafeDomain.class);
        this.logger.error(CODE + ".exportInSkuSafe", (Object)("list-------" + list.size()));
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<WhStoreSkusafeReDomain> queryResult = null;
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<WhStoreSkusafeDomain> errorLsit = new ArrayList<WhStoreSkusafeDomain>();
        HashMap<String, Object> queryGoodsMap = new HashMap<String, Object>();
        for (WhStoreSkusafeDomain whStoreSkusafeDomain : list) {
            if (StringUtils.isBlank((String)whStoreSkusafeDomain.getGoodsCode()) || EmptyUtil.isEmpty((Object)whStoreSkusafeDomain.getGoodsNum())) continue;
            String goodsCode = whStoreSkusafeDomain.getGoodsCode();
            queryGoodsMap = new HashMap();
            queryGoodsMap.put("tenantCode", this.getTenantCode(request));
            queryGoodsMap.put("goodsNo", goodsCode);
            queryGoodsMap.put("goodsClass", "plat");
            SupQueryResult<RsResourceGoodsReDomain> goodsReDomainSupQueryResult = this.rsResourceGoodsService.queryResourceGoodsPage(queryGoodsMap);
            if (EmptyUtil.isEmpty(goodsReDomainSupQueryResult) || ListUtil.isEmpty((Collection)goodsReDomainSupQueryResult.getList())) {
                this.logger.error(CODE + ".exportInSkuSafe-goodsReDomainSupQueryResult", (Object)queryGoodsMap.toString());
                errorLsit.add(whStoreSkusafeDomain);
                continue;
            }
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.fetchResGoods(String.valueOf(((RsResourceGoodsReDomain)goodsReDomainSupQueryResult.getList().get(0)).getGoodsId()));
            rsResourceGoodsReDomain.setGoodsSenum(whStoreSkusafeDomain.getGoodsNum());
            htmlJsonReBean = this.updateResGooMain(request, this.getTenantCode(request), JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain), null);
            if (!htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + ".exportInSkuSafe-goodsReDomainSupQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
                errorLsit.add(whStoreSkusafeDomain);
                continue;
            }
            whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
            queryMap.put("goodsCode", goodsCode);
            queryResult = this.whStoreSkusafeServiceRepository.querystoreSkusafePage(queryMap);
            if (!EmptyUtil.isEmpty(queryResult) && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                WhStoreSkusafeReDomain skusafeReDomain = (WhStoreSkusafeReDomain)queryResult.getList().get(0);
                whStoreSkusafeDomain.setStoreSkusafeId(skusafeReDomain.getStoreSkusafeId());
                whStoreSkusafeDomain.setStoreSkusafeCode(skusafeReDomain.getStoreSkusafeCode());
                htmlJsonReBean = this.whStoreSkusafeServiceRepository.updatestoreSkusafe(whStoreSkusafeDomain);
            } else {
                htmlJsonReBean = this.whStoreSkusafeServiceRepository.savestoreSkusafe(whStoreSkusafeDomain);
            }
            if (htmlJsonReBean.isSuccess()) continue;
            errorLsit.add(whStoreSkusafeDomain);
        }
        if (ListUtil.isNotEmpty(errorLsit)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, JsonUtil.buildNormalBinder().toJson(errorLsit));
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsReDomain fetchResGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResGoodsFromGysEdit", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoods(Integer.valueOf(goodsId));
        if (null != rsResourceGoodsReDomain) {
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
                ArrayList<RsGoodsRelDomain> relDomainList = new ArrayList<RsGoodsRelDomain>();
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    map.put("goodsCode", rsGoodsRelDomain.getGoodsRelGcode());
                    RsResourceGoodsReDomain relGoods = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                    rsGoodsRelDomain.setRsResourceGoods(relGoods);
                    relDomainList.add(rsGoodsRelDomain);
                }
                rsResourceGoodsReDomain.setRsGoodsRelDomainList(relDomainList);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                rsResourceGoodsReDomain.getRsSkuDomainList().forEach(x -> {
                    if (null == x.getRsGoodsRelDomainList()) {
                        x.setRsGoodsRelDomainList(rsResourceGoodsReDomain.getRsGoodsRelDomainList());
                    }
                });
            }
        }
        return rsResourceGoodsReDomain;
    }

    private HtmlJsonReBean updateResGooMain(HttpServletRequest request, String tenantCode, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        if (null == rsResourceGoodsDomain || ListUtil.isEmpty(rsResourceGoodsDomain.getRsSkuDomainList())) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"rsResourceGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
            rsSkuDomain.setGoodsSupplynum(rsSkuDomain.getGoodsNum());
            rsSkuDomain.setGoodsSupplyweight(rsSkuDomain.getGoodsWeight());
        }
        if ((null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) && StringUtils.isBlank((String)rsResourceGoodsDomain.getFileFlg())) {
            this.logger.error(CODE + ".updateResourceGoods.fileList", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsDomain.getRsGoodsFileDomainList()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".updateResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        return this.rsResourceGoodsService.sendUpdateResourceGoods(rsResourceGoodsDomain);
    }

    private String getShopdeName(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult<ScShopdeReDomain> qlist = this.scShopdeService.queryShopdePage(map);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return userSession.getMerberCompname();
        }
        return ((ScShopdeReDomain)qlist.getRows().get(0)).getShopdeName();
    }
}

