/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.reb.RebUpointsDomain;
import cn.com.qj.bff.domain.reb.RebUpointsListReDomain;
import cn.com.qj.bff.domain.reb.RebUpointsReDomain;
import cn.com.qj.bff.service.reb.RebUpointsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/upoints"}, name="\u7528\u6237\u8fd4\u5229")
public class RebUpointsCon
extends SpringmvcController {
    private static String CODE = "reb.upoints.con";
    @Autowired
    private RebUpointsService rebUpointsService;

    @Override
    protected String getContext() {
        return "upoints";
    }

    @RequestMapping(value={"saveUpoints.json"}, name="\u589e\u52a0\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean saveUpoints(HttpServletRequest request, String rebUpointsDomainStr) {
        if (StringUtils.isBlank((String)rebUpointsDomainStr)) {
            this.logger.error(CODE + ".saveUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebUpointsDomainStr, RebUpointsDomain.class);
        rebUpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebUpointsService.saveUpoints(rebUpointsDomain);
    }

    @RequestMapping(value={"getUpoints.json"}, name="\u83b7\u53d6\u7528\u6237\u8fd4\u5229\u4fe1\u606f")
    @ResponseBody
    public RebUpointsReDomain getUpoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".getUpoints", (Object)"param is null");
            return null;
        }
        return this.rebUpointsService.getUpoints(upointsId);
    }

    @RequestMapping(value={"updateUpoints.json"}, name="\u66f4\u65b0\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean updateUpoints(HttpServletRequest request, String rebUpointsDomainStr) {
        if (StringUtils.isBlank((String)rebUpointsDomainStr)) {
            this.logger.error(CODE + ".updateUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebUpointsDomainStr, RebUpointsDomain.class);
        rebUpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebUpointsService.updateUpoints(rebUpointsDomain);
    }

    @RequestMapping(value={"deleteUpoints.json"}, name="\u5220\u9664\u7528\u6237\u8fd4\u5229")
    @ResponseBody
    public HtmlJsonReBean deleteUpoints(Integer upointsId) {
        if (StringUtils.isBlank((Integer)upointsId)) {
            this.logger.error(CODE + ".deleteUpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebUpointsService.deleteUpoints(upointsId);
    }

    @RequestMapping(value={"queryUpointsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsReDomain> queryUpointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsService.queryUpointsPage(param);
    }

    @RequestMapping(value={"updateUpointsState.json"}, name="\u66f4\u65b0\u7528\u6237\u8fd4\u5229\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpointsState(String upointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)upointsId)) {
            this.logger.error(CODE + ".updateUpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebUpointsService.updateUpointsState(Integer.valueOf(upointsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryUpointsPageStr.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u4f59\u989d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public RebUpointsReDomain queryUpointsPageStr(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUpointsPageStr", (Object)"userSession is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", userPcode);
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<RebUpointsReDomain> supQueryResult = this.rebUpointsService.queryUpointsPage(param);
        return (RebUpointsReDomain)supQueryResult.getList().get(0);
    }

    @RequestMapping(value={"queryUpointsListPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsListReDomain> queryUpointsListPage(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUpointsListPage", (Object)"userSession is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", userPcode);
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsService.queryUpointsListPage(param);
    }

    @RequestMapping(value={"queryUpointsPageToStr.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsReDomain> queryUpointsPageToStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebUpointsService.queryUpointsPage(param);
    }

    @RequestMapping(value={"queryUpointsListPageToStr.json"}, name="\u67e5\u8be2\u7528\u6237\u8fd4\u5229\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebUpointsListReDomain> queryUpointsListPageToStr(HttpServletRequest request, String memberCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryUpointsListPageToStr", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        param.put("memberCode", memberCode);
        if (null != param) {
            param.put("order", true);
        }
        return this.rebUpointsService.queryUpointsListPage(param);
    }
}

