/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wh;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.wh.WhStoreSkusafeDomain;
import cn.com.qj.bff.domain.wh.WhStoreSkusafeReDomain;
import cn.com.qj.bff.service.wh.WhStoreSkusafeService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/whStoreSkusafe"}, name="\u5b89\u5168\u5e93\u5b58SKU")
public class WhStoreSkusafeCon
extends SpringmvcController {
    private static String CODE = "wh.whStoreSkusafe.con";
    @Autowired
    private WhStoreSkusafeService whStoreSkusafeServiceRepository;
    public static final String CACHE_KEY_SAFESKU = "wh_store_skusafe";

    @Override
    protected String getContext() {
        return "whStoreSkusafe";
    }

    @RequestMapping(value={"saveWhStoreSkusafe.json"}, name="\u589e\u52a0\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean saveWhStoreSkusafe(HttpServletRequest request, WhStoreSkusafeDomain whStoreSkusafeDomain) {
        if (null == whStoreSkusafeDomain) {
            this.logger.error(CODE + ".saveWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreSkusafeServiceRepository.savestoreSkusafe(whStoreSkusafeDomain);
    }

    @RequestMapping(value={"getWhStoreSkusafe.json"}, name="\u83b7\u53d6\u5b89\u5168\u5e93\u5b58SKU\u4fe1\u606f")
    @ResponseBody
    public WhStoreSkusafeReDomain getWhStoreSkusafe(Integer storeSkusafeId) {
        if (StringUtils.isBlank((Integer)storeSkusafeId)) {
            this.logger.error(CODE + ".getWhStoreSkusafe", (Object)"param is null");
            return null;
        }
        return this.whStoreSkusafeServiceRepository.getstoreSkusafe(storeSkusafeId);
    }

    @RequestMapping(value={"updateWhStoreSkusafe.json"}, name="\u66f4\u65b0\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean updateWhStoreSkusafe(HttpServletRequest request, WhStoreSkusafeDomain whStoreSkusafeDomain) {
        if (null == whStoreSkusafeDomain) {
            this.logger.error(CODE + ".updateWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
        return this.whStoreSkusafeServiceRepository.updatestoreSkusafe(whStoreSkusafeDomain);
    }

    @RequestMapping(value={"deleteWhStoreSkusafe.json"}, name="\u5220\u9664\u5b89\u5168\u5e93\u5b58SKU")
    @ResponseBody
    public HtmlJsonReBean deleteWhStoreSkusafe(Integer storeSkusafeId) {
        if (StringUtils.isBlank((Integer)storeSkusafeId)) {
            this.logger.error(CODE + ".deleteWhStoreSkusafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreSkusafeServiceRepository.deletestoreSkusafe(storeSkusafeId);
    }

    @RequestMapping(value={"queryWhStoreSkusafePage.json"}, name="\u67e5\u8be2\u5b89\u5168\u5e93\u5b58SKU\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhStoreSkusafeReDomain> queryWhStoreSkusafePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whStoreSkusafeServiceRepository.querystoreSkusafePage(param);
    }

    @RequestMapping(value={"updateWhStoreSkusafeState.json"}, name="\u66f4\u65b0\u5b89\u5168\u5e93\u5b58SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWhStoreSkusafeState(String storeSkusafeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)storeSkusafeId)) {
            this.logger.error(CODE + ".updateWhStoreSkusafeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whStoreSkusafeServiceRepository.updatestoreSkusafeState(Integer.valueOf(storeSkusafeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"exportInSkuSafe.json"}, name="\u5bfc\u5165\u5b89\u5168\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean exportInSkuSafe(HttpServletRequest request, String storeSkusafe) {
        if (StringUtils.isBlank((String)storeSkusafe)) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession-null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(storeSkusafe, WhStoreSkusafeDomain.class);
        this.logger.error(CODE + ".exportInSkuSafe", (Object)("list-------" + list.size()));
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".exportInSkuSafe", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<WhStoreSkusafeReDomain> queryResult = null;
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<WhStoreSkusafeDomain> errorLsit = new ArrayList<WhStoreSkusafeDomain>();
        for (WhStoreSkusafeDomain whStoreSkusafeDomain : list) {
            if (StringUtils.isBlank((String)whStoreSkusafeDomain.getGoodsCode()) || EmptyUtil.isEmpty((Object)whStoreSkusafeDomain.getGoodsNum())) continue;
            whStoreSkusafeDomain.setTenantCode(this.getTenantCode(request));
            queryMap.put("goodsCode", whStoreSkusafeDomain.getGoodsCode());
            queryResult = this.whStoreSkusafeServiceRepository.querystoreSkusafePage(queryMap);
            if (!EmptyUtil.isEmpty(queryResult) && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                WhStoreSkusafeReDomain skusafeReDomain = (WhStoreSkusafeReDomain)queryResult.getList().get(0);
                whStoreSkusafeDomain.setStoreSkusafeId(skusafeReDomain.getStoreSkusafeId());
                whStoreSkusafeDomain.setStoreSkusafeCode(skusafeReDomain.getStoreSkusafeCode());
                htmlJsonReBean = this.whStoreSkusafeServiceRepository.updatestoreSkusafe(whStoreSkusafeDomain);
            } else {
                htmlJsonReBean = this.whStoreSkusafeServiceRepository.savestoreSkusafe(whStoreSkusafeDomain);
            }
            if (htmlJsonReBean.isSuccess()) continue;
            errorLsit.add(whStoreSkusafeDomain);
        }
        if (ListUtil.isNotEmpty(errorLsit)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, JsonUtil.buildNormalBinder().toJson(errorLsit));
        }
        return htmlJsonReBean;
    }
}

