/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcRefgoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefgoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.service.oc.OcRefgoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/ocRefgoods"}, name="\u9000\u8d27\u6d3b\u52a8\u5546\u54c1")
public class RefgoodsCon
extends SpringmvcController {
    private static String CODE = "oc.ocRefgoods.con";
    @Autowired
    private OcRefgoodsService ocRefgoodsService;
    @Autowired
    protected RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "ocRefgoods";
    }

    @RequestMapping(value={"saveOcRefgoods.json"}, name="\u589e\u52a0\u9000\u8d27\u6d3b\u52a8\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveOcRefgoods(HttpServletRequest request, String ocRefgoodsDomainStr) {
        if (null == ocRefgoodsDomainStr) {
            this.logger.error(CODE + ".saveOcRefgoods", (Object)"ocRefgoodsDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocRefgoodsDomainStr null");
        }
        List ocRefgoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(ocRefgoodsDomainStr, OcRefgoodsDomain.class);
        if (ListUtil.isEmpty((Collection)ocRefgoodsDomainList)) {
            this.logger.error(CODE + ".saveOcRefgoods", (Object)"ocRefgoodsDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocRefgoodsDomainList null");
        }
        UserSession userSession = this.getUserSession(request);
        ocRefgoodsDomainList.stream().forEach(refGoods -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuBarcode", refGoods.getSkuBarcode());
            map.put("skuNo", refGoods.getSkuNo());
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<RsSkuReDomain> skuPage = this.rsSkuService.querySkuPage(map);
            if (skuPage != null && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)skuPage.getList().get(0);
                refGoods.setSkuName(rsSkuReDomain.getSkuName());
                refGoods.setGoodsName(rsSkuReDomain.getGoodsName());
            }
            refGoods.setTenantCode(this.getTenantCode(request));
            refGoods.setMemberCode(userSession.getUserPcode());
            refGoods.setMemberName(userSession.getUserName());
        });
        return this.ocRefgoodsService.saveRefgoodsBatch(ocRefgoodsDomainList);
    }

    @RequestMapping(value={"getOcRefgoods.json"}, name="\u83b7\u53d6\u9000\u8d27\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public OcRefgoodsReDomain getOcRefgoods(Integer refgoodsId) {
        if (StringUtils.isBlank((Integer)refgoodsId)) {
            this.logger.error(CODE + ".getOcRefgoods", (Object)"param is null");
            return null;
        }
        return this.ocRefgoodsService.getRefgoods(refgoodsId);
    }

    @RequestMapping(value={"updateOcRefgoods.json"}, name="\u66f4\u65b0\u9000\u8d27\u6d3b\u52a8\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateOcRefgoods(HttpServletRequest request, String ocRefgoodsDomainStr) {
        if (null == ocRefgoodsDomainStr) {
            this.logger.error(CODE + ".saveOcRefgoods", (Object)"ocRefgoodsDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocRefgoodsDomainStr null");
        }
        OcRefgoodsDomain ocRefgoodsDomain = (OcRefgoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(ocRefgoodsDomainStr, OcRefgoodsDomain.class);
        if (ocRefgoodsDomain == null) {
            this.logger.error(CODE + ".saveOcRefgoods", (Object)"ocRefgoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ocRefgoodsDomain null");
        }
        ocRefgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefgoodsService.updateRefgoods(ocRefgoodsDomain);
    }

    @RequestMapping(value={"deleteOcRefgoods.json"}, name="\u5220\u9664\u9000\u8d27\u6d3b\u52a8\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteOcRefgoods(Integer refgoodsId) {
        if (StringUtils.isBlank((Integer)refgoodsId)) {
            this.logger.error(CODE + ".deleteOcRefgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefgoodsService.deleteRefgoods(refgoodsId);
    }

    @RequestMapping(value={"queryOcRefgoodsPage.json"}, name="\u67e5\u8be2\u9000\u8d27\u6d3b\u52a8\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefgoodsReDomain> queryOcRefgoodsPage(HttpServletRequest request) {
        SupQueryResult<OcRefgoodsReDomain> refgoodsPage;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((refgoodsPage = this.ocRefgoodsService.queryRefgoodsPage(param)) != null && ListUtil.isNotEmpty((Collection)refgoodsPage.getList())) {
            refgoodsPage.getList().stream().forEach(refgoods -> {
                Map<String, Object> map = this.getQueryMapParam("skuNo,tenantCode", refgoods.getSkuNo(), refgoods.getTenantCode());
                SupQueryResult<RsSkuReDomain> skuPage = this.rsSkuService.querySkuPage(map);
                if (skuPage != null && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    refgoods.setSkuReDomainList(skuPage.getList());
                }
            });
        }
        return refgoodsPage;
    }

    @RequestMapping(value={"updateOcRefgoodsState.json"}, name="\u66f4\u65b0\u9000\u8d27\u6d3b\u52a8\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcRefgoodsState(String refgoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refgoodsId)) {
            this.logger.error(CODE + ".updateOcRefgoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefgoodsService.updateRefgoodsState(Integer.valueOf(refgoodsId), dataState, oldDataState, null);
    }
}

