/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wh;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreGoodsDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreReDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreSkuDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreSkuReDomain;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.wh.WhOpstoreService;
import cn.com.qj.bff.service.wh.WhWarehouseService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class WhOpstoreComCon
extends SpringmvnNewController {
    private static final String CODE = "wh.opstore.con";
    @Autowired
    private WhOpstoreService whOpstoreService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private WhWarehouseService whWarehouseService;

    @Override
    protected String getContext() {
        return "opstore";
    }

    public String make(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            return "error";
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return "error";
        }
        if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            HashMap<String, WhOpstoreGoodsDomain> goodsmap = new HashMap<String, WhOpstoreGoodsDomain>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", whOpstoreDomain.getTenantCode());
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)goodsmap.get(whOpstoreSkuDomain.getGoodsCode());
                if (null == whOpstoreGoodsDomain) {
                    map.put("goodsCode", whOpstoreSkuDomain.getGoodsCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                    if (null == rsResourceGoodsReDomain) {
                        return "error:" + ((Object)map).toString();
                    }
                    whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)rsResourceGoodsReDomain);
                    }
                    catch (Exception e) {
                        return "error1:" + ((Object)map).toString();
                    }
                    goodsmap.put(whOpstoreSkuDomain.getGoodsCode(), whOpstoreGoodsDomain);
                }
                if (null == (whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                    whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
                    whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
                }
                whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
            }
            if (MapUtil.isEmpty(goodsmap)) {
                return "error3";
            }
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            for (String goodsCode : goodsmap.keySet()) {
                whOpstoreGoodsDomainList.add((WhOpstoreGoodsDomain)goodsmap.get(goodsCode));
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal weight = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal mainnum = BigDecimal.ZERO;
        BigDecimal mainweight = BigDecimal.ZERO;
        BigDecimal mainamt = BigDecimal.ZERO;
        for (WhOpstoreGoodsDomain whOpstoreGoodsReDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            num = BigDecimal.ZERO;
            weight = BigDecimal.ZERO;
            amt = BigDecimal.ZERO;
            for (WhOpstoreSkuDomain whOpstoreSkuReDomain : whOpstoreGoodsReDomain.getWhOpstoreSkuDomainList()) {
                if (null == whOpstoreSkuReDomain.getGoodsNum()) {
                    whOpstoreSkuReDomain.setGoodsNum(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getGoodsWeight()) {
                    whOpstoreSkuReDomain.setGoodsWeight(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getPricesetNprice()) {
                    whOpstoreSkuReDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                num = num.add(whOpstoreSkuReDomain.getGoodsNum());
                weight = weight.add(whOpstoreSkuReDomain.getGoodsWeight());
                amt = amt.add(whOpstoreSkuReDomain.getPricesetNprice().multiply(whOpstoreSkuReDomain.getGoodsNum()));
                if (!StringUtils.isNotBlank((String)whOpstoreDomain.getStoreGoodsType())) continue;
                whOpstoreSkuReDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            }
            whOpstoreGoodsReDomain.setGoodsNum(num);
            whOpstoreGoodsReDomain.setGoodsWeight(weight);
            mainnum = mainnum.add(num);
            mainweight = mainweight.add(weight);
            mainamt = mainamt.add(amt);
        }
        whOpstoreDomain.setGoodsNum(mainnum);
        whOpstoreDomain.setGoodsWeight(mainweight);
        whOpstoreDomain.setGoodsAmt(mainamt);
        return null;
    }

    protected HtmlJsonReBean saveOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.opstore.con.saveOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession");
        }
        whOpstoreDomain.setMemberCode(userSession.getUserPcode());
        whOpstoreDomain.setMemberName(userSession.getMerberCompname());
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        String msg = this.make(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
        }
        this.logger.error("wh.opstore.con.saveOpstore", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return this.whOpstoreService.saveOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean saveOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error("wh.opstore.con.saveOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        return this.saveOpstoreMain(request, whOpstoreDomain);
    }

    protected HtmlJsonReBean updateOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error("wh.opstore.con.updateOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreService.updateOpstore(whOpstoreDomain);
    }

    protected WhOpstoreReDomain getOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error("wh.opstore.con.getOpstoreMain", (Object)"param is null");
            return null;
        }
        return this.whOpstoreService.getOpstore(opstoreId);
    }

    protected HtmlJsonReBean updateOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.opstore.con.updateOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreService.updateOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean deleteOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error("wh.opstore.con.deleteOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreService.deleteOpstore(opstoreId);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageCom(HttpServletRequest request, String storeGoodsBtype) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)((String)param.get("storeGoodsBtype")))) {
                storeGoodsBtype = param.get("storeGoodsBtype").toString();
            }
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreService.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageMain(HttpServletRequest request, String storeGoodsBtype) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreService.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreSkuReDomain> queryOpstoreSkuPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whOpstoreService.queryOpstoreSkuPage(param);
    }

    protected HtmlJsonReBean updateOpstoreStateMain(String opstoreId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opstoreId)) {
            this.logger.error("wh.opstore.con.updateOpstoreStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreService.updateOpstoreState(Integer.valueOf(opstoreId), dataState, oldDataState, null);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePagesCom(HttpServletRequest request, String storeGoodsBtype) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whOpstoreService.queryOpstorePages(param);
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block6: {
            List whOpstoreSkuReDomainList;
            block7: {
                block5: {
                    SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                    if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                        this.logger.error("wh.opstore.con.makeExcelData.supQueryResult", (Object)(" is null" + json));
                        return null;
                    }
                    whOpstoreSkuReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhOpstoreSkuReDomain.class);
                    if (ListUtil.isEmpty((Collection)whOpstoreSkuReDomainList)) {
                        this.logger.error("wh.opstore.con.makeExcelData.whStoreSkuReDomainList", (Object)(" is null" + json));
                        return null;
                    }
                    mapList = new ArrayList<Map<String, Object>>();
                    if (!"StockRecordExport".equals(excelTemplate)) break block5;
                    for (WhOpstoreSkuReDomain wh : whOpstoreSkuReDomainList) {
                        Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)wh), String.class, Object.class);
                        Map<String, Object> stringObjectMap = this.coverOpWhSkuState(objectToMap);
                        mapList.add(stringObjectMap);
                    }
                    break block6;
                }
                if (!"TurnoverWarshouseExport".equals(excelTemplate)) break block7;
                for (WhOpstoreSkuReDomain wh : whOpstoreSkuReDomainList) {
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)wh), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOpWhSkuState(objectToMap);
                    mapList.add(stringObjectMap);
                }
                break block6;
            }
            if (!"OccupyStockExport".equals(excelTemplate)) break block6;
            for (WhOpstoreSkuReDomain wh : whOpstoreSkuReDomainList) {
                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)wh), String.class, Object.class);
                Map<String, Object> stringObjectMap = this.coverOccupyStock(objectToMap, wh);
                mapList.add(stringObjectMap);
            }
        }
        return mapList;
    }

    private Map<String, Object> coverOpWhSkuState(Map<String, Object> map) {
        String storeGoodsBtype = null == map.get("storeGoodsBtype") ? "8888" : String.valueOf(map.get("storeGoodsBtype").toString());
        String opstoreDir = null == map.get("opstoreDir") ? "0" : String.valueOf(map.get("opstoreDir").toString());
        switch (storeGoodsBtype) {
            case "R11": {
                map.put("storeGoodsBtype", "\u91c7\u8d2d\u5165\u5e93");
                break;
            }
            case "W11": {
                map.put("storeGoodsBtype", "\u6279\u53d1\u9000\u8d27");
                break;
            }
            case "D11": {
                map.put("storeGoodsBtype", "\u8f6c\u4ed3\u5165\u5e93");
                break;
            }
            case "Y11": {
                map.put("storeGoodsBtype", "\u62a5\u6ea2\u5165\u5e93");
                break;
            }
            case "D54": {
                map.put("storeGoodsBtype", "\u8f6c\u4ed3 \u9501\u5b9a");
                break;
            }
            case "T54": {
                map.put("storeGoodsBtype", "\u62a5\u635f \u9501\u5b9a");
                break;
            }
            case "M54": {
                map.put("storeGoodsBtype", "\u5176\u4ed6\u573a\u666f\u9501\u5b9a\u5e93\u5b58");
                break;
            }
            case "D55": {
                map.put("storeGoodsBtype", "\u8f6c\u4ed3\u51fa\u5e93");
                break;
            }
            case "R55": {
                map.put("storeGoodsBtype", "\u62a5\u635f\u51fa\u5e93");
                break;
            }
            case "M55": {
                map.put("storeGoodsBtype", "\u5176\u4ed6\u51fa\u5e93\u7c7b\u578b");
                break;
            }
            case "X3": {
                map.put("storeGoodsBtype", "\u8ba2\u5355\u9501\u5b9a");
                break;
            }
            case "R3": {
                map.put("storeGoodsBtype", "\u53d6\u6d88\u9501\u5b9a");
                break;
            }
            case "X2": {
                map.put("storeGoodsBtype", "\u9000\u5355");
                break;
            }
            case "X1": {
                map.put("storeGoodsBtype", "\u8ba2\u5355\u51fa\u5e93");
                break;
            }
            case "T11": {
                map.put("storeGoodsBtype", "\u5ba1\u96f6\u5165\u5e93");
            }
        }
        switch (storeGoodsBtype) {
            case "0": {
                map.put("opstoreDir", "\u51fa\u5e93");
                break;
            }
            case "1": {
                map.put("opstoreDir", "\u5165\u5e93");
            }
        }
        return map;
    }

    private Map<String, Object> coverOccupyStock(Map<String, Object> map, WhOpstoreSkuReDomain wh) {
        if (EmptyUtil.isEmpty((Object)wh) || EmptyUtil.isEmpty((Object)wh.getDataState())) {
            return null;
        }
        Integer dataState = wh.getDataState();
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u521d\u59cb\u5316");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
            }
        }
        return map;
    }
}

