/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.um.UmQualityDomain;
import cn.com.qj.bff.domain.um.UmQualityReDomain;
import cn.com.qj.bff.service.um.UmQualityService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/quality"}, name="\u8d44\u8d28\u7ba1\u7406")
public class QualityCon
extends SpringmvcController {
    private static String CODE = "um.quality.con";
    @Autowired
    private UmQualityService umQualityService;

    @Override
    protected String getContext() {
        return "quality";
    }

    @RequestMapping(value={"saveQuality.json"}, name="\u589e\u52a0\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveQuality(HttpServletRequest request, UmQualityDomain umQualityDomain) {
        if (null == umQualityDomain) {
            this.logger.error(CODE + ".saveQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umQualityDomain.setTenantCode(this.getTenantCode(request));
        return this.umQualityService.saveQuality(umQualityDomain);
    }

    @RequestMapping(value={"getQuality.json"}, name="\u83b7\u53d6\u8d44\u8d28\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public UmQualityReDomain getQuality(Integer qualityId) {
        if (StringUtils.isBlank((Integer)qualityId)) {
            this.logger.error(CODE + ".getQuality", (Object)"param is null");
            return null;
        }
        return this.umQualityService.getQuality(qualityId);
    }

    @RequestMapping(value={"updateQuality.json"}, name="\u66f4\u65b0\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateQuality(HttpServletRequest request, UmQualityDomain umQualityDomain) {
        if (null == umQualityDomain) {
            this.logger.error(CODE + ".updateQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umQualityDomain.setTenantCode(this.getTenantCode(request));
        return this.umQualityService.updateQuality(umQualityDomain);
    }

    @RequestMapping(value={"deleteQuality.json"}, name="\u5220\u9664\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteQuality(Integer qualityId) {
        if (StringUtils.isBlank((Integer)qualityId)) {
            this.logger.error(CODE + ".deleteQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umQualityService.deleteQuality(qualityId);
    }

    @RequestMapping(value={"queryQualityPage.json"}, name="\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityPage(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"updateQualityState.json"}, name="\u66f4\u65b0\u8d44\u8d28\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateQualityState(String qualityId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)qualityId)) {
            this.logger.error(CODE + ".updateQualityState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umQualityService.updateQualityState(Integer.valueOf(qualityId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryQualityByRights.json"}, name="\u7528\u6237\u6743\u76ca\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByRights(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"queryQualityByRightsForPlat.json"}, name="\u7528\u6237\u6743\u76ca\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByRightsForPlat(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"queryQualityByUserInfo.json"}, name="\u7528\u6237\u8d44\u8d28\u5217\u8868\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByUserInfo(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    private SupQueryResult<UmQualityReDomain> queryQualityByCommon(HttpServletRequest request) {
        SupQueryResult<UmQualityReDomain> qualityList = new SupQueryResult<UmQualityReDomain>();
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (qualityList = this.umQualityService.queryQualityPage(param)) || qualityList.getList().size() <= 0) {
            param.remove("tenantCode");
            param.put("tenantCode", "00000000");
            qualityList = this.umQualityService.queryQualityPage(param);
        }
        return qualityList;
    }
}

