/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.co;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.co.CoCorderDomain;
import cn.com.qj.bff.domain.co.CoCorderGoodsDomain;
import cn.com.qj.bff.domain.co.CoCorderReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.co.CoCorderService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/co/corder"}, name="\u5408\u540c\u8ba2\u5355")
public class CorderCon
extends SpringmvcController {
    private static String CODE = "co.corder.con";
    @Autowired
    private CoCorderService coCorderService;
    @Autowired
    private UserService userService;

    @Override
    protected String getContext() {
        return "corder";
    }

    @RequestMapping(value={"saveCorder.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.saveCorder(coCorderDomain);
    }

    @RequestMapping(value={"getCorder.json"}, name="\u83b7\u53d6\u5408\u540c\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public CoCorderReDomain getCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".getCorder", (Object)"param is null");
            return null;
        }
        return this.coCorderService.getCorder(corderId);
    }

    @RequestMapping(value={"updateCorder.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".updateCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.updateCorder(coCorderDomain);
    }

    @RequestMapping(value={"deleteCorder.json"}, name="\u5220\u9664\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".deleteCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.deleteCorder(corderId);
    }

    @RequestMapping(value={"queryCorderPage.json"}, name="\u67e5\u8be2\u5408\u540c\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CoCorderReDomain> queryCorderPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.coCorderService.queryCorderPage(param);
    }

    @RequestMapping(value={"updateCorderState.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCorderState(String corderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)corderId)) {
            this.logger.error(CODE + ".updateCorderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.updateCorderState(Integer.valueOf(corderId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"downLoadFile.json"}, name="\u4e0b\u8f7d\u6587\u4ef6")
    @ResponseBody
    public ResponseEntity<byte[]> downLoadFile(String fileName) {
        if (null == fileName) {
            this.logger.error(CODE + ".fileName", (Object)"param is null");
            return null;
        }
        return this.coCorderService.downLoadFile(fileName);
    }

    @RequestMapping(value={"exportCoCorder.json"}, name="\u5bfc\u5165\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean exportCoCorder(HttpServletRequest request, String coCorderDomainList) throws Exception {
        if (StringUtils.isBlank((String)coCorderDomainList)) {
            this.logger.error(CODE + ".saveCorder", (Object)"coCorderDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "coCorderDomainList-null");
        }
        final String tenantCode = this.getTenantCode(request);
        List list = JsonUtil.buildNormalBinder().getJsonToList(coCorderDomainList, CoCorderDomain.class);
        this.logger.error(CODE + ".exportCoCorder", (Object)("list-------" + list.size()));
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".exportCoCorder", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<CoCorderDomain> errorList = new ArrayList<CoCorderDomain>();
        HashMap<String, ArrayList<CoCorderDomain>> coCorderDomainHashMap = new HashMap<String, ArrayList<CoCorderDomain>>();
        HashMap<String, Object> queryUserPage = new HashMap<String, Object>();
        for (CoCorderDomain coCorderDomain : list) {
            String msg = this.checkCoCorderDomain(coCorderDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                coCorderDomain.setContractRemark(msg);
                errorList.add(coCorderDomain);
                continue;
            }
            coCorderDomain.setTenantCode(tenantCode);
            CoCorderGoodsDomain coCorderGoodsDomain = coCorderDomain.getCoCorderGoodsDomain();
            coCorderGoodsDomain.setContractBillcode(coCorderDomain.getContractBillcode());
            coCorderGoodsDomain.setContractGoodsCode(coCorderDomain.getContractBillcode());
            coCorderGoodsDomain.setGoodsCamount(coCorderGoodsDomain.getGoodsNum());
            queryUserPage.put("tenantCode", tenantCode);
            queryUserPage.put("userinfoOcode", coCorderDomain.getCustrelCode());
            queryUserPage.put("departName", coCorderDomain.getDepartShortname());
            queryUserPage.put("userinfoChannelname", coCorderDomain.getChannelName());
            SupQueryResult<UmUserinfoReDomainBean> queryUserinfoPage = this.userService.queryUserinfoPage(queryUserPage);
            if (EmptyUtil.isEmpty(queryUserinfoPage) || ListUtil.isEmpty((Collection)queryUserinfoPage.getList())) {
                coCorderDomain.setContractRemark("\u7528\u6237\u4e0d\u5b58\u5728");
                errorList.add(coCorderDomain);
                continue;
            }
            UmUserinfoReDomainBean userinfoReDomainBean = (UmUserinfoReDomainBean)queryUserinfoPage.getList().get(0);
            coCorderDomain.setMemberBcode(userinfoReDomainBean.getUserinfoCode());
            coCorderGoodsDomain.setMemberBcode(userinfoReDomainBean.getUserinfoCode());
            coCorderGoodsDomain.setTenantCode(tenantCode);
            ArrayList<CoCorderDomain> coCorderDomains = (ArrayList<CoCorderDomain>)coCorderDomainHashMap.get(coCorderDomain.getContractBillcode());
            if (ListUtil.isNotEmpty((Collection)coCorderDomains)) {
                coCorderDomains.add(coCorderDomain);
                continue;
            }
            coCorderDomains = new ArrayList<CoCorderDomain>();
            coCorderDomains.add(coCorderDomain);
            coCorderDomainHashMap.put(coCorderDomain.getContractBillcode(), coCorderDomains);
        }
        if (MapUtil.isEmpty(coCorderDomainHashMap)) {
            return new HtmlJsonReBean(errorList);
        }
        ArrayList<CoCorderDomain> saveList = new ArrayList<CoCorderDomain>();
        for (String s : coCorderDomainHashMap.keySet()) {
            final List coCorderDomains = (List)coCorderDomainHashMap.get(s);
            ArrayList<CoCorderGoodsDomain> CoCorderGoodsList = new ArrayList<CoCorderGoodsDomain>();
            for (int i = 0; i < coCorderDomains.size(); ++i) {
                CoCorderDomain coCorderDomain = (CoCorderDomain)coCorderDomains.get(i);
                CoCorderGoodsDomain coCorderGoodsDomain = coCorderDomain.getCoCorderGoodsDomain();
                CoCorderGoodsDomain newCoCorderGoodsDomain = new CoCorderGoodsDomain();
                coCorderGoodsDomain.setTenantCode(this.getTenantCode(request));
                BeanUtils.copyAllPropertysNotNull((Object)newCoCorderGoodsDomain, (Object)coCorderGoodsDomain);
                CoCorderGoodsList.add(newCoCorderGoodsDomain);
                if (i + 1 != coCorderDomains.size()) continue;
                coCorderDomain.setCoCorderGoodsDomainList(CoCorderGoodsList);
                saveList.add(coCorderDomain);
            }
            SupQueryResult<CoCorderReDomain> queryResult = this.coCorderService.queryCoCorderOrGoodsPage((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("contractBillcode", ((CoCorderDomain)coCorderDomains.get(0)).getContractBillcode());
                    this.put("tenantCode", tenantCode);
                }
            });
            if (EmptyUtil.isEmpty(queryResult) || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
            for (CoCorderReDomain coCorderReDomain : queryResult.getList()) {
                this.coCorderService.deleteCorder(coCorderReDomain.getCorderId());
            }
        }
        this.coCorderService.saveCorderBatch(saveList);
        return new HtmlJsonReBean(errorList);
    }

    private String checkCoCorderDomain(CoCorderDomain coCorderDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)coCorderDomain.getContractBillcode())) {
            msg = msg + "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getDepartShortname())) {
            msg = msg + "\u7ec4\u7ec7\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getChannelName())) {
            msg = msg + "\u6e20\u9053\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getMemberBname())) {
            msg = msg + "\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getCustrelCode())) {
            msg = msg + "\u5ba2\u6237\u4ee3\u7801\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain()) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getCoCorderGoodsDomain().getGoodsNo())) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u7f16\u53f7\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getCoCorderGoodsDomain().getGoodsRemark())) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getGoodsNum() || coCorderDomain.getCoCorderGoodsDomain().getGoodsNum().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a,";
        }
        if (StringUtils.isBlank((String)coCorderDomain.getCoCorderGoodsDomain().getPartsnameNumunit())) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getPricesetNprice() || coCorderDomain.getCoCorderGoodsDomain().getPricesetNprice().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u57fa\u51c6\u4ef7\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getContractGoodsPrice() || coCorderDomain.getCoCorderGoodsDomain().getContractGoodsPrice().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u7ed3\u7b97\u5355\u4ef7\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getGoodsAhnum() || coCorderDomain.getCoCorderGoodsDomain().getGoodsAhnum().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u4ea4\u6613\u5355\u4ef7\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getContractGoodsMoney() || coCorderDomain.getCoCorderGoodsDomain().getContractGoodsMoney().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u7ed3\u7b97\u91d1\u989d\u4e3a\u7a7a,";
        }
        if (null == coCorderDomain.getCoCorderGoodsDomain().getGoodsAhweight() || coCorderDomain.getCoCorderGoodsDomain().getGoodsAhweight().compareTo(BigDecimal.ZERO) == 0) {
            msg = msg + "\u8ba2\u5355\u5546\u54c1\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a,";
        }
        return msg;
    }

    @RequestMapping(value={"queryCoCorderOrGoodsPage.json"}, name="\u67e5\u8be2\u5408\u540c\u8ba2\u5355\u5217\u8868\u542b\u5546\u54c1\u4e00\u5bf9\u4e00")
    @ResponseBody
    public SupQueryResult<CoCorderReDomain> queryCoCorderOrGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.coCorderService.queryCoCorderOrGoodsPage(param);
    }
}

