/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.controller.order.AnnoCreator;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcel<T> {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static final String CODE = "com.common.ReadExcel.";
    private String errorMsg;
    private Class<T> clazz;

    public ReadExcel() {
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Type[] args;
            Type t = clazz.getGenericSuperclass();
            if (!(t instanceof ParameterizedType) || !((args = ((ParameterizedType)t).getActualTypeArguments())[0] instanceof Class)) continue;
            this.clazz = (Class)args[0];
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<T>> readNew(MultipartFile file) {
        Map<String, List<T>> map = null;
        InputStream is = null;
        try {
            is = file.getInputStream();
            String fileName = file.getOriginalFilename();
            HSSFWorkbook workbook = null;
            if (ReadExcel.isExcel2003(fileName)) {
                workbook = new HSSFWorkbook(is);
            } else if (ReadExcel.isExcel2007(fileName)) {
                workbook = new XSSFWorkbook(is);
            } else {
                Map<String, List<T>> map2 = null;
                return map2;
            }
            map = this.readExcel((Workbook)workbook);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    is = null;
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<T>> read(String filePath) {
        Map<String, List<T>> map = null;
        InputStream is = null;
        try {
            if (!this.validateExcel(filePath)) {
                System.out.println(this.errorMsg);
                Map<String, List<T>> map2 = null;
                return map2;
            }
            boolean isExcel2003 = true;
            if (ReadExcel.isExcel2007(filePath)) {
                isExcel2003 = false;
            }
            File file = new File(filePath);
            is = new FileInputStream(file);
            Object workbook = null;
            workbook = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            map = this.readExcel((Workbook)workbook);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    is = null;
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    private Map<String, List<T>> readExcel(Workbook workbook) {
        Map<String, List<T>> map = Collections.synchronizedMap(new HashMap());
        ArrayList<T> list = null;
        int numberOfSheets = workbook.getNumberOfSheets();
        for (int sheetNum = 0; sheetNum < numberOfSheets; ++sheetNum) {
            list = new ArrayList<T>();
            Map<String, String> creatorMap = AnnoCreator.annoCreator(this.clazz);
            Sheet sheet = workbook.getSheetAt(sheetNum);
            int totalRows = sheet.getPhysicalNumberOfRows();
            int totalCells = 0;
            if (totalRows >= 1 && sheet.getRow(0) != null) {
                totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
            }
            ArrayList<String> li = new ArrayList<String>();
            for (int r = 0; r < totalRows; ++r) {
                T t = null;
                try {
                    t = this.clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                Row row = sheet.getRow(r);
                if (row == null) continue;
                for (int c = 0; c < totalCells; ++c) {
                    Cell cell = row.getCell(c);
                    String cellValue = "";
                    if (null != cell) {
                        switch (cell.getCellType()) {
                            case 0: {
                                DecimalFormat df = new DecimalFormat("0.00");
                                cellValue = df.format(cell.getNumericCellValue());
                                break;
                            }
                            case 1: {
                                cellValue = cell.getStringCellValue();
                                break;
                            }
                            case 4: {
                                cellValue = cell.getBooleanCellValue() + "";
                                break;
                            }
                            case 2: {
                                cellValue = cell.getCellFormula() + "";
                                break;
                            }
                            case 3: {
                                cellValue = "";
                                break;
                            }
                            case 5: {
                                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                                break;
                            }
                            default: {
                                cellValue = "\u672a\u77e5\u7c7b\u578b";
                            }
                        }
                    }
                    if (r == 0) {
                        li.add(cellValue);
                        continue;
                    }
                    this.fill(creatorMap, (String)li.get(c), cellValue, t);
                }
                if (r == 0) continue;
                list.add(t);
            }
            map.put(sheet.getSheetName(), list);
        }
        return map;
    }

    private static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    private static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    private boolean validateExcel(String filePath) {
        if (filePath == null || !ReadExcel.isExcel2003(filePath) && !ReadExcel.isExcel2007(filePath)) {
            this.logger.error("com.common.ReadExcel.validateExcel", (Object)"\u6587\u4ef6\u540d\u4e0d\u662fExcel\u683c\u5f0f");
            return false;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            this.logger.error("com.common.ReadExcel.validateExcel", (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            return false;
        }
        return true;
    }

    private void fill(Map<String, String> map, String str, String obj, T t) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                if (!str.equals(entry.getValue())) continue;
                Field f = this.clazz.getDeclaredField(entry.getKey().trim());
                f.setAccessible(true);
                Class<?> type = f.getType();
                String simpleName = type.getSimpleName();
                if ("BigDecimal".equals(simpleName)) {
                    f.set(t, new BigDecimal(obj));
                } else {
                    f.set(t, obj);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

