/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.dd.DdFalgSettingDomain;
import cn.com.qj.bff.domain.dd.DdFalgSettingReDomain;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.oc.ExcelExportTemplate;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractPmGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcRefundBean;
import cn.com.qj.bff.domain.oc.OcRefundDomain;
import cn.com.qj.bff.domain.oc.OcRefundFileDomain;
import cn.com.qj.bff.domain.oc.OcRefundGoodsBean;
import cn.com.qj.bff.domain.oc.OcRefundGoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefundJdBean;
import cn.com.qj.bff.domain.oc.OcRefundPmGoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.domain.oc.OcRefundSettlDomain;
import cn.com.qj.bff.domain.oc.RefundGoods;
import cn.com.qj.bff.domain.oc.RefundType;
import cn.com.qj.bff.domain.oc.RsSkuReDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponsend;
import cn.com.qj.bff.domain.sg.SgSendgoodsDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsGoodsDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsGoodsReDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsReDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsSettlDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.upm.UpmUpointsClearReDomain;
import cn.com.qj.bff.service.dd.DdFalgSettingService;
import cn.com.qj.bff.service.fm.FileService;
import cn.com.qj.bff.service.oc.OcContractPmGoodsService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRefundEngineService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.service.oc.OcShoppingService;
import cn.com.qj.bff.service.pm.PmUserCouponService;
import cn.com.qj.bff.service.pm.PmUserUsecouponService;
import cn.com.qj.bff.service.sg.SgSendgoodsService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.upm.UpmUpointsClearService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/oc/refund"}, name="\u9000\u6b3e\u670d\u52a1")
public class RefundCon
extends SpringmvnNewController {
    private static final String CODE = "oc.refund.con";
    @Autowired
    private OcRefundService ocRefundService;
    @Autowired
    private DdFalgSettingService ddFalgSettingService;
    @Autowired
    private FileService fileService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private PmUserUsecouponService pmUserUsecouponService;
    @Autowired
    private PmUserCouponService pmUserCouponService;
    @Autowired
    private SgSendgoodsService sgSendgoodsService;
    @Autowired
    private OcContractPmGoodsService ocContractPmGoodsService;
    @Autowired
    private OcShoppingService ocShoppingService;
    @Autowired
    private UpmUpointsClearService upmUpointsClearService;
    @Autowired
    private UserService UserService;
    @Autowired
    private OcRefundEngineService ocRefundEngineService;

    @Override
    protected String getContext() {
        return "refund";
    }

    @RequestMapping(value={"saveRefundForPlat.json"}, name="\u5e73\u53f0\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefundForPlat(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.PLAT.getCode());
    }

    @RequestMapping(value={"saveRefundForMem.json"}, name="\u5546\u5bb6\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefundForBus(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.MEM.getCode());
    }

    public boolean makeReGoodsNum(OcRefundBean ocRefundBean) {
        List<OcRefundGoodsBean> ocRefundGoodsBeanList = ocRefundBean.getOcRefundGoodsBeanList();
        if (ListUtil.isEmpty(ocRefundGoodsBeanList)) {
            this.logger.error("oc.refund.con.makeReGoodsNum.ocRefundGoodsBeanList.null");
            return true;
        }
        for (OcRefundGoodsBean ocRefundGoodsBean : ocRefundGoodsBeanList) {
            if (ocRefundGoodsBean.getRefundGoodsNum().compareTo(new BigDecimal(0)) != 0) continue;
            this.logger.error("oc.refund.conmakeReGoodsNum.num.0", (Object)ocRefundBean.getContractBillcode());
            return true;
        }
        return false;
    }

    private HtmlJsonReBean saveRefund(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error("oc.refund.con.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (this.makeReGoodsNum(ocRefundBean)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u7533\u8bf7\uff0c\u65e0\u9700\u91cd\u590d\u7533\u8bf7");
        }
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refund.con.saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error("oc.refund.con.saveRefund.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        if (ocRefundBean.getRefundMoney().compareTo(ocContractReDomain.getDataBmoney().setScale(2, 4)) == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        if (ocRefundBean.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (RefundType.USER.getCode().equals(refundUsertype) && !ocContractReDomain.getMemberBcode().equals(this.getUserSession(request).getUserPcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fe1\u606f\u5f02\u5e38");
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefund.ex", e.getMessage());
        }
        if ("2020091500000001".equals(ocContractReDomain.getTenantCode()) && 2 != ocContractReDomain.getDataState()) {
            ocRefundDomain.setRefundType("B02");
        }
        return this.ocRefundService.saveRefund(ocRefundDomain);
    }

    @RequestMapping(value={"saveRefund.json"}, name="\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefund(HttpServletRequest request, String params) {
        return this.saveRefund(request, params, RefundType.USER.getCode());
    }

    @RequestMapping(value={"jDsaveRefund.json"}, name="\u4eac\u4e1c\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean jDsaveRefund(HttpServletRequest request, String params) {
        if (null == params) {
            this.logger.error("oc.refund.con.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> paramStr = this.assemMapBuyParam(request);
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(paramStr);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            this.logger.error("oc.refund.con.jDsaveRefund", (Object)"ocContractReDomainSupQueryResult is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundJdBean ocRefundBean = (OcRefundJdBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundJdBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refund.con.saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocRefundBean);
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefund.ex", e.getMessage());
        }
        this.sendReFundOrderBigData(ocRefundDomain);
        return this.ocRefundService.saveRefund(ocRefundDomain);
    }

    @RequestMapping(value={"jDgetRefundByCode.json"}, name="\u6839\u636eCODE\u83b7\u53d6jD\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain jDgetRefundByCode(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error("oc.refund.con.getRefundByCode.refundCode", (Object)"param is null");
            return null;
        }
        Map<String, Object> paramStr = this.assemMapBuyParam(request);
        SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundReDomainPage(paramStr);
        if (ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.error("oc.refund.con.jDgetRefundByCode", (Object)"ocRefundReDomainSupQueryResult is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundService.getRefundByCode(map);
    }

    @RequestMapping(value={"queryjDRefundPage.json"}, name="\u67e5\u8be2jD\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryjDRefundPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractType", "16");
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryjDBooksRefundPage.json"}, name="\u67e5\u8be2jD\u56fe\u4e66\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryjDBooksRefundPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("contractType", "17");
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractDomain ocContractDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error("oc.refund.con.makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, List<OcContractPmGoodsReDomain>> contractGoodsPmMap = null;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("contractBillcode", ocContractDomain.getContractBillcode());
        SupQueryResult<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainSupQueryResult = this.ocContractPmGoodsService.queryContractPmGoodsPage(map);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsReDomainSupQueryResult.getList())) {
            contractGoodsPmMap = this.contractPmGoodsMap(ocContractPmGoodsReDomainSupQueryResult.getList());
        }
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList;
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != ocContractGoods.getSkuNo() && !refundGoodsList.getSkuNo().equals(ocContractGoods.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.ocRefundService.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), ocContractDomain.getMemberCode(), ocContractDomain.getMemberCcode(), ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (refundGoodsList.getGoodsCamount().compareTo(ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum())) > 0) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            if (null != refundGoodsList.getGoodsCamount() && !RefundCon.isIntegerValue(refundGoodsList.getGoodsCamount())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 0).setScale(2, 4);
            if (MapUtil.isNotEmpty(contractGoodsPmMap) && ListUtil.isNotEmpty(ocContractPmGoodsReDomainList = contractGoodsPmMap.get(refundGoodsList.getContractGoodsCode()))) {
                ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList1 = new ArrayList<OcContractPmGoodsReDomain>();
                for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
                    if (null == ocContractGoods.getContractGoodsRefnum()) {
                        ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    BigDecimal sumStr = refundGoodsDomain.getRefundGoodsNum().add(ocContractGoods.getContractGoodsRefnum());
                    BigDecimal sum = BigDecimal.ZERO;
                    if (sumStr.compareTo(ocContractGoods.getGoodsCamount()) == 0) {
                        BigDecimal sum2;
                        BigDecimal sum1 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(ocContractGoods.getContractGoodsRefnum()).setScale(2, 5);
                        sum = sum2 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().subtract(sum1);
                    } else {
                        sum = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(refundGoodsDomain.getRefundGoodsNum()).setScale(2, 5);
                    }
                    ocContractPmGoodsReDomain.setContractPmgoodsRepmoney(sum);
                    ocContractPmGoodsReDomain.setContractGoodsRefnum(refundGoodsDomain.getRefundGoodsNum());
                    ocContractPmGoodsReDomainList1.add(ocContractPmGoodsReDomain);
                }
                List<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = this.ocRefundPmGoods(ocContractPmGoodsReDomainList1);
                refundGoodsDomain.setOcRefundPmGoodsDomainList(ocRefundPmGoodsDomainList);
            }
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, List<OcContractPmGoodsReDomain>> contractPmGoodsMap(List<OcContractPmGoodsReDomain> goodsPmList) {
        if (ListUtil.isEmpty(goodsPmList)) {
            this.logger.error("oc.refund.con.contractPmGoodsMap", (Object)"param is null");
            return null;
        }
        HashMap<String, List<OcContractPmGoodsReDomain>> map = new HashMap<String, List<OcContractPmGoodsReDomain>>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : goodsPmList) {
            if (!StringUtils.isNotBlank((String)ocContractPmGoodsReDomain.getContractGoodsCode())) continue;
            ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList = (ArrayList<OcContractPmGoodsReDomain>)map.get(ocContractPmGoodsReDomain.getContractGoodsCode());
            if (null == ocContractPmGoodsReDomainList) {
                ocContractPmGoodsReDomainList = new ArrayList<OcContractPmGoodsReDomain>();
                map.put(ocContractPmGoodsReDomain.getContractGoodsCode(), ocContractPmGoodsReDomainList);
            }
            ocContractPmGoodsReDomainList.add(ocContractPmGoodsReDomain);
        }
        return map;
    }

    public List<OcRefundPmGoodsDomain> ocRefundPmGoods(List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList) {
        if (ListUtil.isEmpty(ocContractPmGoodsReDomainList)) {
            this.logger.error("oc.refund.con.ocRefundPmGoods", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
            OcRefundPmGoodsDomain ocRefundPmGoodsDomain = new OcRefundPmGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsDomain, (Object)ocContractPmGoodsReDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            ocRefundPmGoodsDomain.setRefundPmgoodsRepmoney(ocContractPmGoodsReDomain.getContractPmgoodsRepmoney());
            ocRefundPmGoodsDomainList.add(ocRefundPmGoodsDomain);
        }
        return ocRefundPmGoodsDomainList;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("oc.refund.con.contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    public Map<String, SgSendgoodsGoodsDomain> sgsendgoodsGoodsMap(List<SgSendgoodsGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("oc.refund.con.contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, SgSendgoodsGoodsDomain> map = new HashMap<String, SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : goodsList) {
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain);
        }
        return map;
    }

    @RequestMapping(value={"getRefund.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.getRefund", (Object)"param is null");
            return null;
        }
        OcRefundReDomain refund = this.ocRefundService.getRefund(refundId);
        if (null == refund) {
            return null;
        }
        BigDecimal contractRefundNum = BigDecimal.ZERO;
        BigDecimal contractRefundNumMoney = BigDecimal.ZERO;
        BigDecimal contractRefundNum1 = BigDecimal.ZERO;
        BigDecimal contractRefundNumMoney1 = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty(refund.getOcRefundGoodsList())) {
            for (OcRefundGoodsDomain refundGoods : refund.getOcRefundGoodsList()) {
                if (null != refundGoods.getGoodsNum()) {
                    contractRefundNum = contractRefundNum.add(refundGoods.getGoodsNum());
                    contractRefundNumMoney = contractRefundNumMoney.add(refundGoods.getGoodsNum().multiply(refundGoods.getPricesetNprice()));
                }
                if (null == refundGoods.getContractGoodsRefnum1()) continue;
                contractRefundNum1 = contractRefundNum1.add(refundGoods.getContractGoodsRefnum1());
                BigDecimal ocRefundGoodsMoney = refundGoods.getContractGoodsRefnum1().multiply(refundGoods.getPricesetNprice());
                refundGoods.setContractRefundMoney(ocRefundGoodsMoney);
                contractRefundNumMoney1 = contractRefundNumMoney1.add(ocRefundGoodsMoney);
            }
        }
        refund.setContractRefundNum(contractRefundNum);
        refund.setContractRefundNumMoney(contractRefundNumMoney);
        refund.setContractRefundNum1(contractRefundNum1);
        refund.setContractRefundNumMoney1(contractRefundNumMoney1);
        return refund;
    }

    @RequestMapping(value={"getRefundForPlat.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefundForPlat(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.getRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundService.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundByCode.json"}, name="\u6839\u636eCODE\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefundByCode(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error("oc.refund.con.getRefundByCode.refundCode", (Object)"param is null");
            return null;
        }
        Map<String, Object> map = this.getMemberBcodeQueryMapParams(request);
        map.put("refundCode", refundCode);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = this.ocRefundService.getRefundByCode(map);
        if (null == ocRefundReDomain) {
            return null;
        }
        if (!userSession.getUserPcode().equals(ocRefundReDomain.getMemberBcode())) {
            return null;
        }
        return ocRefundReDomain;
    }

    @RequestMapping(value={"updateRefund.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRefund(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.refund.con.updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcRefundReDomain refund = this.ocRefundService.getRefund(ocRefundDomain.getRefundId());
        if (null == refund) {
            this.logger.error("oc.refund.con.updateRefund.refund", (Object)"getRefundId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refund null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", refund.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain contract = this.ocContractService.getContractByCode(map);
        if (null == contract) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (contract.getDataState() == 4) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5ba1\u6838\u5931\u8d25,\u8ba2\u5355\u5df2\u5b8c\u6210");
        }
        ocRefundDomain.setRefundUname(this.getUserSession(request).getUserName());
        Date date = new Date();
        ocRefundDomain.setRefundAudate(date);
        ocRefundDomain.setTenantCode(this.getTenantCode(request));
        this.logger.error("updateRefund.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.ocRefundService.updateRefund(ocRefundDomain);
    }

    @RequestMapping(value={"updateRefundByCode.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1\u5355\u5730\u5740(\u9000\u8d27\u9000\u6b3e)")
    @ResponseBody
    public HtmlJsonReBean updateRefundByCode(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.refund.con.updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcRefundReDomain refund = this.ocRefundService.getRefund(ocRefundDomain.getRefundId());
        if (null == refund) {
            this.logger.error("oc.refund.con.updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refund null");
        }
        OcRefundDomain newOcRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)newOcRefundDomain, (Object)refund);
        }
        catch (Exception exception) {
            // empty catch block
        }
        newOcRefundDomain.setGoodsReceiptMem(ocRefundDomain.getGoodsReceiptMem());
        newOcRefundDomain.setGoodsReceiptArrdess(ocRefundDomain.getGoodsReceiptArrdess());
        newOcRefundDomain.setGoodsReceiptPhone(ocRefundDomain.getGoodsReceiptPhone());
        Date date = new Date();
        newOcRefundDomain.setRefundAudate(date);
        newOcRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundService.updateRefund(newOcRefundDomain);
    }

    @RequestMapping(value={"updateRefundGoodsByCode.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1\u5355\u5730\u5740(C\u7aef\u8c03\u7528\u9000\u8d27\u9000\u6b3e)")
    @ResponseBody
    public HtmlJsonReBean updateRefundGoodsByCode(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.refund.con.updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcRefundReDomain refund = this.ocRefundService.getRefund(ocRefundDomain.getRefundId());
        if (null == refund) {
            this.logger.error("oc.refund.con.updateRefund.refund", (Object)"getRefundId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refund null");
        }
        if (!refund.getMemberBcode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error("oc.refund.con.updateRefund.MemberBcode", (Object)"MemberBcode is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "MemberBcode");
        }
        OcRefundDomain newOcRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)newOcRefundDomain, (Object)refund);
        }
        catch (Exception exception) {
            // empty catch block
        }
        newOcRefundDomain.setPackageName(ocRefundDomain.getPackageName());
        newOcRefundDomain.setPackageBillno(ocRefundDomain.getPackageBillno());
        newOcRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundService.updateRefund(newOcRefundDomain);
    }

    @RequestMapping(value={"deleteRefund.json"}, name="\u5220\u9664\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.deleteRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundService.deleteRefund(refundId);
    }

    @RequestMapping(value={"queryRefundPage.json"}, name="\u5546\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPage(HttpServletRequest request) {
        return this.queryRefund(request);
    }

    @RequestMapping(value={"queryRefundForMem.json"}, name="\u5546\u5bb6\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForMem(HttpServletRequest request) {
        return this.queryRefund(request);
    }

    private SupQueryResult<OcRefundReDomain> queryRefund(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryByMemberCcode.json"}, name="\u4f9b\u5e94\u5546\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryByMemberCcode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        Map<String, Object> param = this.assemMapParam(request);
        param.put("memberCcode", userSession.getUserPcode());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPageBuy.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPageBuy(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPagePlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"updateRefundState.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRefundState(String refundId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundId)) {
            this.logger.error("oc.refund.con.updateRefundState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundService.updateRefundState(Integer.valueOf(refundId), dataState, oldDataState);
    }

    @RequestMapping(value={"uploadRefFile.json"}, name="\u4e0a\u4f20\u9000\u8d27\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadRefFile(MultipartFile file, HttpServletRequest request) {
        if (null == file) {
            this.logger.error("oc.refund.con.uploadRefFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        String tenantCode = this.getTenantCode(request);
        String fileSort = "FILE_02";
        fmFileReDomainBean = this.fileService.saveFile(file, tenantCode, fileSort);
        return fmFileReDomainBean;
    }

    @RequestMapping(value={"arrGoods.json"}, name="\u5230\u8d27")
    @ResponseBody
    public HtmlJsonReBean arrGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.arrGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.arrGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"platformAuditRefund.json"}, name="\u5e73\u53f0\u5ba1\u6838\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean platformAuditRefund(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.platformAuditRefund", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.platformAuditRefund", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"sendGoods.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09")
    @ResponseBody
    public HtmlJsonReBean sendGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        this.logger.info("oc.refund.con.sendGoods.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.sendGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.sendGoods", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> paramStr = new HashMap<String, Object>();
        paramStr.put("tenantCode", this.getTenantCode(request));
        paramStr.put("memberBcode", this.getMerchantCode(request));
        paramStr.put("refundCode", refundCode);
        SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundPage(paramStr);
        if (ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.error("oc.refund.con.sendGoods", (Object)"ocRefundReDomainSupQueryResult is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"supplieraudit.json"}, name="\u4f9b\u5e94\u5546\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean supplieraudit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"platformAuditRefundAndUex.json"}, name="\u5e73\u53f0\u5ba1\u6838\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean platformAuditRefundAndUex(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.platformAuditRefund", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.platformAuditRefund", (Object)"param is null");
            return null;
        }
        String refundUex = (String)map.get("refundUex");
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("refundCode", refundCode);
        queryMap.put("tenantCode", this.getTenantCode(request));
        OcRefundReDomain refundByCode = this.ocRefundService.getRefundByCode(queryMap);
        if (null == refundByCode) {
            this.logger.error("oc.refund.con.platformAuditRefundAndUex.refundByCode", (Object)((Object)queryMap).toString());
            return new HtmlJsonReBean("-1", "\u8a02\u55ae\u4e0d\u5b58\u5728");
        }
        refundByCode.setRefundUex(refundUex);
        this.ocRefundService.updateRefund(refundByCode);
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"supplierauditPass.json"}, name="\u4f9b\u5e94\u5546\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean supplierauditPass(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("oc.refund.con.supplierauditPass", (Object)"map is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        map.put("refundUcode", userSession.getUserCode());
        map.put("refundUname", userSession.getUserName());
        map.put("refundAudate", new Date());
        String tenantCode = userSession.getTenantCode();
        String refundCode = (String)map.get("refundCode");
        this.ocRefundService.updateRefundExamine(map, tenantCode, refundCode);
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"audit.json"}, name="\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean audit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    private HtmlJsonReBean auditPlus(HttpServletRequest request, Map<String, Object> map) {
        this.logger.info("oc.refund.con.auditPlus.into", map);
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.audit", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        this.logger.info("oc.refund.con.auditPlus.into.getRefundByCode", (Object)refundReDomain.getRefundId());
        if (refundReDomain.getDataState() == 0) {
            map.put("dataStatestr", "60");
            return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5ba1\u6838");
    }

    @RequestMapping(value={"res.json"}, name="\u64a4\u9500\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean res(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        UserSession userSession = this.getUserSession(request);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        if (null == refundReDomain) {
            this.logger.error("oc.refund.con.res", (Object)"refundReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        if (!userSession.getUserPcode().equals(refundReDomain.getMemberBcode())) {
            this.logger.error("oc.refund.con.res", (Object)"getMemberBcode is null");
            return null;
        }
        if (refundReDomain.getDataState() == 0) {
            return this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        }
        map.put("refundUcode", userSession.getUserCode());
        map.put("refundUname", userSession.getUserName());
        map.put("refundAudate", new Date());
        this.ocRefundService.updateRefundExamine(map, tenantCode, refundCode);
        this.sendReFundOrderBigData(refundReDomain);
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u72b6\u6001\u5df2\u66f4\u6539\uff0c\u64a4\u9500\u5931\u8d25");
    }

    @RequestMapping(value={"queryRefCause.json"}, name="\u83b7\u53d6\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryRefCause(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> paramStr = new HashMap<String, Object>();
        paramStr.put("flagSettingScope", "refundExAdmin");
        paramStr.put("flagSettingType", "refundExAdmin");
        paramStr.put("tenantCode", tenantCode);
        paramStr.put("goodsClass", "B2B");
        SupQueryResult<DdFalgSettingReDomain> qlist = this.ddFalgSettingService.queryFalgSettingPage(paramStr);
        if (qlist == null || ListUtil.isEmpty((Collection)qlist.getRows())) {
            this.logger.error("oc.refund.con.queryRefCause.qlist.", (Object)("is null" + paramStr));
            return null;
        }
        return qlist.getRows();
    }

    @RequestMapping(value={"queryRefCauseForMini.json"}, name="\u83b7\u53d6\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryRefCauseForMini(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> paramStr = this.assemMapBuyParam(request);
        String flagSettingType = null == paramStr.get("flagSettingType") ? "refundEx" : (String)paramStr.get("flagSettingType");
        paramStr.put("flagSettingScope", "refundExMini");
        paramStr.put("flagSettingType", "refundExMini");
        paramStr.put("memberMcode", this.getUserSession(request).getUserinfoParentCode());
        paramStr.put("tenantCode", tenantCode);
        SupQueryResult<DdFalgSettingReDomain> qlist = this.ddFalgSettingService.queryFalgSettingPage(paramStr);
        if (qlist == null || ListUtil.isEmpty((Collection)qlist.getRows())) {
            this.logger.error("oc.refund.con.queryRefCause.qlist.", (Object)("is null" + paramStr));
            return null;
        }
        return qlist.getRows();
    }

    @RequestMapping(value={"refuseApplication.json"}, name="\u8fd0\u8425\u7aef\u62d2\u7edd\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean refuseApplication(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null != htmlJsonReBean && !htmlJsonReBean.isSuccess()) {
            this.sendReFundOrderBigData(refundReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"refuseGoods.json"}, name="\u8fd0\u8425\u7aef\u62d2\u7edd\u6536\u8d27")
    @ResponseBody
    public HtmlJsonReBean refuseGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null != htmlJsonReBean && !htmlJsonReBean.isSuccess()) {
            this.sendReFundOrderBigData(refundReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveFalgSetting.json"}, name="\u589e\u52a0\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean saveFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error("oc.refund.con.saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingService.saveFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"deleteFalgSetting.json"}, name="\u5220\u9664\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean deleteFalgSetting(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error("oc.refund.con.deleteFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingService.deleteFalgSetting(Integer.valueOf(flagSettingId));
    }

    @RequestMapping(value={"updateFalgSetting.json"}, name="\u4fee\u6539\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean updateFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error("oc.refund.con.saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingService.updateFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"updateRefundExamine.json"}, name="\u4fee\u6539\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean updateRefundExamine(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.refund.con.updateRefundExamine", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundAudate", ocRefundDomain.getRefundAudate());
        map.put("refundUex", ocRefundDomain.getRefundUex());
        map.put("refundUcode", ocRefundDomain.getRefundUcode());
        map.put("refundUname", ocRefundDomain.getRefundUname());
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        String refundCode = ocRefundDomain.getRefundCode();
        return this.ocRefundService.updateRefundExamine(map, tenantCode, refundCode);
    }

    public void sendReFundOrderBigData(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(ocRefundDomain.getTenantCode() + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        String value = "{\"paasLabel\":\"refundOrder\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    @RequestMapping(value={"queryOcRefundPage.json"}, name="\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"supplierOcAudit.json"}, name="\u4f9b\u5e94\u5546\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean supplierOcAudit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"getRefundPlat.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public OcRefundReDomain getRefundPlat(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.getRefundPlat", (Object)"param is null");
            return null;
        }
        return this.ocRefundService.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundByCodeForC.json"}, name="\u6839\u636eCODE\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f-C\u7aef\u9000\u8d27\u7269\u6d41")
    @ResponseBody
    public OcRefundReDomain getRefundByCodeForC(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error("oc.refund.con.getRefundByCodeForC.refundCode", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundService.getRefundByCode(map);
    }

    @RequestMapping(value={"sendGoodsForC.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean sendGoodsForC(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.sendGoodsForC", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.sendGoodsForC", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"queryRefundPlatForBalance.json"}, name="\u5e73\u53f0\u67e5\u770b\u5168\u6e20\u9053\u9000\u6b3e\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcRefundReDomain> queryRefundPlatForBalance(HttpServletRequest request, String memberCcode) {
        SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("contractState", "4");
        param.put("dataState", "4");
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundReDomainPage(param)) || ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.info("oc.refund.con.queryRefundPlatForBalance.ocRefundReDomainSupQueryResult.null", (Object)("param==" + JsonUtil.buildNonDefaultBinder().toJson(param)));
            return null;
        }
        return this.create(ocRefundReDomainSupQueryResult.getList(), erpFlag);
    }

    @RequestMapping(value={"queryRefundUserForBalance.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u9000\u6b3e\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcRefundReDomain> queryRefundUserForBalance(HttpServletRequest request) {
        SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", userSession.getUserPcode());
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("contractState", "4");
        param.put("dataState", "4");
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundReDomainPage(param)) || ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.info("oc.refund.con.queryRefundPlatForBalance.ocRefundReDomainSupQueryResult.null", (Object)("param==" + JsonUtil.buildNonDefaultBinder().toJson(param)));
            return null;
        }
        return this.create(ocRefundReDomainSupQueryResult.getList(), erpFlag);
    }

    private List<OcRefundReDomain> create(List<OcRefundReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcRefundReDomain> relist = new ArrayList<OcRefundReDomain>();
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocRefundReDomain.getRefundCode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocRefundReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocRefundReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocRefundReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocRefundReDomain);
                    continue;
                }
                this.logger.info("oc.refund.con.queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocRefundReDomain);
                continue;
            }
            this.logger.info("oc.refund.con.queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocRefundReDomain);
        }
        return relist;
    }

    private String getListToString(List<OcRefundReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcRefundReDomain ocRefundReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocRefundReDomain.getRefundCode();
        }
        return noStr;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractService.queryOrderErpFlag(nostr);
    }

    @RequestMapping(value={"queryRefundForPlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundForStore.json"}, name="\u95e8\u5e97\u67e5\u8be2\u9000\u6b3e\u5217\u8868-\u5546\u5bb6\u9000\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundForStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", userSession.getUserPcode());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"supplierOcAuditForStore.json"}, name="\u95e8\u5e97\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean supplierOcAuditForStore(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"supplierOcAuditForPlat.json"}, name="\u95e8\u5e97\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean supplierOcAuditForPlat(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"refuseApplicationForPlat.json"}, name="\u5e73\u53f0\u5ba1\u6838\u62d2\u7edd\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean refuseApplicationForPlat(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.refuseAuditPlus(request, map);
    }

    @RequestMapping(value={"refuseApplicationForStore.json"}, name="\u95e8\u5e97\u62d2\u7edd\u552e\u540e\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean refuseApplicationForStore(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.refuseAuditPlus(request, map);
    }

    private HtmlJsonReBean refuseAuditPlus(HttpServletRequest request, Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"refundCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() != 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u4fe1\u606f\u6709\u8bef");
        }
        map.put("dataStatestr", "50");
        HtmlJsonReBean htmlJsonReBean = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getRefundStore.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f\uff08\u95e8\u5e97\uff09")
    @ResponseBody
    public OcRefundReDomain getRefundStore(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.getRefundStore", (Object)"param is null");
            return null;
        }
        return this.ocRefundService.getRefund(refundId);
    }

    @RequestMapping(value={"getOcRefundForRetail.json"}, name="\u83b7\u53d6\u9000\u6b3e\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getOcRefundForRetail(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error("oc.refund.con.getOcRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundService.getRefund(refundId);
    }

    @RequestMapping(value={"queryOcRefundPageForRetail.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868-\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPageForRetail(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String fileName = "\u9000\u5355\u5217\u8868";
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "retailerOut");
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult supQueryResult = this.queryOcRefundPage(request, fileName, param);
        return null == supQueryResult ? new SupQueryResult() : supQueryResult;
    }

    @RequestMapping(value={"supplierOcAuditForRetail.json"}, name="\u95e8\u5e97\u5ba1\u6838\u901a\u8fc7\uff08\u9000\u6b3e\u670d\u52a1\uff09-\u5206\u9500\u5546")
    @ResponseBody
    public HtmlJsonReBean supplierOcAuditForRetail(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.auditPlus(request, map);
    }

    @RequestMapping(value={"sendGoodsForRetail.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09")
    @ResponseBody
    public HtmlJsonReBean sendGoodsForRetail(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.sendGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.sendGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"refuseApplicationForRetail.json"}, name="\u5206\u9500\u5546\u5ba1\u6838\u62d2\u7edd\uff08\u9000\u6b3e\u670d\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean refuseApplicationForRetail(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        return this.refuseAuditPlus(request, map);
    }

    @RequestMapping(value={"resForRetail.json"}, name="\u64a4\u9500\u7533\u8bf7-\u5206\u9500\u5546")
    @ResponseBody
    public HtmlJsonReBean resForRetail(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        UserSession userSession = this.getUserSession(request);
        map.put("refundUcode", userSession.getUserCode());
        map.put("refundUname", userSession.getUserName());
        map.put("refundAudate", new Date());
        this.ocRefundService.updateRefundExamine(map, tenantCode, refundCode);
        if (refundReDomain.getDataState() == 0) {
            this.logger.error("oc.refund.con.resForRetail.getDataState.0");
            return this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        }
        this.sendReFundOrderBigData(refundReDomain);
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u5355\u72b6\u6001\u5df2\u66f4\u6539\uff0c\u64a4\u9500\u5931\u8d25");
    }

    @RequestMapping(value={"arrGoodsForRetails.json"}, name="\u5230\u8d27")
    @ResponseBody
    public HtmlJsonReBean arrGoodsForRetails(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.arrGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.arrGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (null == this.getRefundByCode(request, refundCode)) {
            this.logger.error("oc.refund.con.arrGoods", (Object)"getRefundByCode is null");
            return null;
        }
        return this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"queryOcRefundPageForPlat.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPageForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String fileName = "E\u8d2d\u9000\u5355\u5217\u8868";
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "pgOut");
        }
        return this.queryOcRefundPage(request, fileName, param);
    }

    @RequestMapping(value={"verificationRefund.json"}, name="\u552e\u540e\u7533\u8bf7\u6821\u9a8c\u662f\u5426\u4ee5\u4f7f\u7528\u7684\u5377")
    @ResponseBody
    public HtmlJsonReBean verificationRefund(HttpServletRequest request, String userinfoCode, String contractBillcode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinfoCode isnull");
        }
        Map<String, Object> param = this.assemMapParam(request);
        param.put("usercouponOcode", contractBillcode);
        param.put("discType", 8);
        SupQueryResult<PmUserCouponsend> pmUserCouponsendQueryResult = this.pmUserUsecouponService.queryuserCouponsendPage(param);
        if (ListUtil.isEmpty((Collection)pmUserCouponsendQueryResult.getList())) {
            this.logger.error("oc.refund.con.verificationRefund", (Object)("param" + param.toString()));
            return new HtmlJsonReBean((Object)true);
        }
        PmUserCouponsend pmUserCouponsend = (PmUserCouponsend)pmUserCouponsendQueryResult.getList().get(0);
        String promotionCode = pmUserCouponsend.getUsercouponCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionCode", promotionCode);
        map.put("memberBcode", userinfoCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<PmUserCouponReDomain> pmUserCouponReDomainSupQueryResult = this.pmUserCouponService.queryUserCouponPage(map);
        if (ListUtil.isEmpty((Collection)pmUserCouponReDomainSupQueryResult.getList())) {
            this.logger.error("oc.refund.con.verificationRefund1", (Object)("map" + ((Object)map).toString()));
            return new HtmlJsonReBean((Object)true);
        }
        PmUserCouponReDomain pmUserCouponReDomain = (PmUserCouponReDomain)pmUserCouponReDomainSupQueryResult.getList().get(0);
        Integer dataState = pmUserCouponReDomain.getDataState();
        if (1 == dataState || 3 == dataState) {
            this.logger.error("oc.refund.con.verificationRefund1", (Object)("dataState" + dataState));
            return new HtmlJsonReBean((Object)false);
        }
        return new HtmlJsonReBean((Object)true);
    }

    protected SupQueryResult<OcRefundReDomain> queryOcRefundPage(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if ("retailerOut".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerOutExcelParam());
            } else if ("pgOut".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgOutExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.info("oc.refund.con.queryContractPageComes.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.refund.queryRefundReDomainPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.queryContractPageComes.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    public boolean checkUpmByOpcode(String upointsClearOpcode, String tenantCode, String upointsClearDirection) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("upointsClearOpcode", upointsClearOpcode);
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("upointsClearDirection", upointsClearDirection);
        SupQueryResult<UpmUpointsClearReDomain> supQueryResult = this.upmUpointsClearService.queryUpointsClearPage(queryMap);
        return null != supQueryResult && !ListUtil.isEmpty((Collection)supQueryResult.getList());
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block13: {
            List ocRefundReDomainList;
            block14: {
                block12: {
                    SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                    if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                        this.logger.error("oc.refund.con.makeExcelData.supQueryResult", (Object)(" is null" + json));
                        return null;
                    }
                    ocRefundReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcRefundReDomain.class);
                    if (ListUtil.isEmpty((Collection)ocRefundReDomainList)) {
                        this.logger.error("oc.refund.con.makeExcelData.ocRefundReDomainList", (Object)(" is null" + json));
                        return null;
                    }
                    this.logger.info("oc.refund.con.makeExcelData.ocRefundReDomainList.param", (Object)json);
                    mapList = new ArrayList<Map<String, Object>>();
                    if (!"retailerOut".equals(excelTemplate)) break block12;
                    for (OcRefundReDomain oc : ocRefundReDomainList) {
                        List<OcRefundGoodsDomain> refundGoodsDomainList = oc.getOcRefundGoodsList();
                        boolean flag = false;
                        if (ListUtil.isNotEmpty(refundGoodsDomainList)) {
                            for (OcRefundGoodsDomain ocRefundGoodsDomain : refundGoodsDomainList) {
                                Map<String, Object> objectDetailToMap = this.covertMapWtite(ocRefundGoodsDomain);
                                if (!flag) {
                                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                    Map<String, Object> stringObjectMap = this.coverRetailerOutState(objectToMap);
                                    if ("0".equals(oc.getDataState().toString())) {
                                        stringObjectMap.put("dataState", "\u5f85\u5ba1\u6838");
                                    }
                                    objectDetailToMap.putAll(stringObjectMap);
                                }
                                mapList.add(objectDetailToMap);
                            }
                            continue;
                        }
                        Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                        Map<String, Object> stringObjectMap = this.coverRetailerOutState(objectToMap);
                        mapList.add(stringObjectMap);
                    }
                    break block13;
                }
                if (!"pgOut".equals(excelTemplate)) break block14;
                for (OcRefundReDomain oc : ocRefundReDomainList) {
                    List<OcRefundGoodsDomain> ocRefundGoodsList = oc.getOcRefundGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty(ocRefundGoodsList)) {
                        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocRefundGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                    mapList.add(stringObjectMap);
                }
                break block13;
            }
            if (!"refundOrderExport".equals(excelTemplate)) break block13;
            for (OcRefundReDomain oc : ocRefundReDomainList) {
                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                Map<String, Object> stringObjectMap = this.coverRefundOrderState(objectToMap, oc);
                mapList.add(stringObjectMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMapWtite(OcRefundGoodsDomain ocRefundGoodsDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("goodsNo", ocRefundGoodsDomain.getGoodsNo());
        orderMaps.put("goodsName", ocRefundGoodsDomain.getGoodsName());
        return orderMaps;
    }

    protected Map<String, Object> coverPgOutState(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u5904\u7406");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 0: {
                map.put("dataState", "\u5904\u7406\u4e2d");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverRetailerOutState(Map<String, Object> map) {
        String refundType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 5: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u7533\u8bf7");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u9000\u5355");
                break;
            }
            case 7: {
                map.put("dataState", "\u5f85\u9000\u5355");
                break;
            }
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 4: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 9: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case 6: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u6536\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u64a4\u9500\u7533\u8bf7");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer refundUsertype = null == map.get("refundUsertype") ? 8888 : Integer.valueOf(map.get("refundUsertype").toString());
        switch (refundUsertype) {
            case 0: {
                map.put("refundUsertype", "\u7528\u6237");
                break;
            }
            case 1: {
                map.put("refundUsertype", "\u5e73\u53f0");
                break;
            }
            case 2: {
                map.put("refundUsertype", "\u5546\u5bb6");
                break;
            }
            default: {
                map.put("refundUsertype", "\u672a\u77e5\u72b6\u6001:" + map.get("refundUsertype"));
            }
        }
        switch (refundType = String.valueOf(null == map.get("refundType") ? Integer.valueOf(8888) : map.get("refundType").toString())) {
            case "B01": {
                map.put("refundType", "\u4ec5\u9000\u6b3e");
                break;
            }
            case "B02": {
                map.put("refundType", "\u9000\u8d27\u9000\u6b3e");
                break;
            }
            case "B04": {
                map.put("refundType", "\u4ec5\u9000\u8d27");
                break;
            }
            case "B05": {
                map.put("refundType", "\u9000\u79ef\u5206");
                break;
            }
            default: {
                map.put("refundType", "\u672a\u77e5\u72b6\u6001:" + map.get("refundType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePg(Map<String, Object> map) {
        String refundType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String tdh = "\u9000\u5355\u53f7\uff1a";
        String tdhs = "\u539f\u8ba2\u5355\u53f7\uff1a";
        String dmst = "dms\u9000\u5355\u7f16\u7801\uff1a";
        String dmsd = "dms\u539f\u8ba2\u5355\u53f7\uff1a";
        String contract = tdh + map.get("refundCode") + tdhs + map.get("contractBillcode");
        map.put("contract", contract);
        String billcode = dmst + map.get("refundNcode") + dmsd + map.get("contractNbbillcode");
        map.put("billcode", billcode);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 5: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u7533\u8bf7");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u9000\u6b3e");
                break;
            }
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 4: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case 6: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u6536\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u64a4\u9500\u7533\u8bf7");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer refundUsertype = null == map.get("refundUsertype") ? 8888 : Integer.valueOf(map.get("refundUsertype").toString());
        switch (refundUsertype) {
            case 0: {
                map.put("refundUsertype", "\u7528\u6237");
                break;
            }
            case 1: {
                map.put("refundUsertype", "\u5e73\u53f0");
                break;
            }
            case 2: {
                map.put("refundUsertype", "\u5546\u5bb6");
                break;
            }
            default: {
                map.put("refundUsertype", "\u672a\u77e5\u72b6\u6001:" + map.get("refundUsertype"));
            }
        }
        switch (refundType = String.valueOf(null == map.get("refundType") ? Integer.valueOf(8888) : map.get("refundType").toString())) {
            case "B01": {
                map.put("refundType", "\u4ec5\u9000\u8d27");
                break;
            }
            case "B02": {
                map.put("refundType", "\u9000\u8d27\u9000\u6b3e");
                break;
            }
            default: {
                map.put("refundType", "\u672a\u77e5\u72b6\u6001:" + map.get("refundType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverRefundOrderState(Map<String, Object> map, OcRefundReDomain ocRefund) {
        BigDecimal contractRefundMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        Integer dataState = ocRefund.getDataState();
        if (ListUtil.isNotEmpty(ocRefund.getOcRefundGoodsList())) {
            for (OcRefundGoodsDomain refundGoods : ocRefund.getOcRefundGoodsList()) {
                if (null == refundGoods.getGoodsCamount()) {
                    refundGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == refundGoods.getPricesetNprice()) {
                    refundGoods.setPricesetNprice(BigDecimal.ZERO);
                }
                if (null == refundGoods.getGoodsCamount()) {
                    refundGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == refundGoods.getRefundGoodsNum()) {
                    refundGoods.setRefundGoodsNum(BigDecimal.ZERO);
                }
                contractRefundMoney = refundGoods.getPricesetNprice().multiply(refundGoods.getGoodsCamount());
                refundMoney = refundGoods.getPricesetNprice().multiply(refundGoods.getRefundGoodsNum());
                map.put("contractGoodsSendnum1", refundGoods.getContractGoodsSendnum1());
                map.put("refundGoodsNum1", refundGoods.getRefundGoodsNum1());
                map.put("goodsCamount", refundGoods.getGoodsCamount());
                map.put("contractRefundMoney", contractRefundMoney);
                if (dataState < 1) continue;
                map.put("refundGoodsNum", refundGoods.getRefundGoodsNum());
                map.put("refundMoney1", refundMoney);
            }
        }
        String memberCname = null == map.get("memberCname") ? "" : String.valueOf(map.get("memberCname").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u9000\u8d27");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u9000\u6b3e");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                map.put("dataState", "\u9000\u6b3e\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u62d2\u7edd");
                break;
            }
            default: {
                map.put("dataState", "unknow:" + dataState);
            }
        }
        return map;
    }

    @RequestMapping(value={"queryRefunReport.json"}, name="\u62a5\u8868\u9000\u5355\u5f85\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult queryRefunReport(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        param.put("dataState", 0);
        SupQueryResult<OcRefundReDomain> ocRefundResult = this.ocRefundService.queryRefundReDomainPage(param);
        int num = 0;
        if (null != ocRefundResult || ListUtil.isNotEmpty((Collection)ocRefundResult.getList())) {
            num = ocRefundResult.getList().size();
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setTotal((long)num);
        return supQueryResult;
    }

    @RequestMapping(value={"queryOcRefundPageRule.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868\u6c47\u7387")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPageRule(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundPage(param);
        List ocRefundReDomains = ocRefundReDomainSupQueryResult.getList();
        for (OcRefundReDomain oc : ocRefundReDomains) {
            if (!StringUtils.isNotBlank((String)oc.getPricesetCurrency())) continue;
            BigDecimal bigDecimal = new BigDecimal(oc.getPricesetCurrency());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(oc.getContractMoney()));
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            oc.setRefundMoney(bigDecimal3);
        }
        return ocRefundReDomainSupQueryResult;
    }

    @RequestMapping(value={"sgSendGoodsSaveRefundUser.json"}, name="\u5b50\u8ba2\u5355\u589e\u52a0\u9000\u6b3e\u670d\u52a1-\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean sgSendGoodsSaveRefundUser(HttpServletRequest request, String params) {
        return this.saveRefundSendgoods(request, params, RefundType.USER.getCode());
    }

    @RequestMapping(value={"sgSendGoodsSaveRefund.json"}, name="\u5b50\u8ba2\u5355\u589e\u52a0\u9000\u6b3e\u670d\u52a1-\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean sgSendGoodsSaveRefund(HttpServletRequest request, String params) {
        return this.saveRefundSendgoods(request, params, RefundType.PLAT.getCode());
    }

    private HtmlJsonReBean saveRefundSendgoods(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error("oc.refund.con.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refund.con.saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error("oc.refund.con.saveRefund.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        SgSendgoodsReDomain sgSendgoodsReDomain = this.sgSendgoodsService.getSendgoods(ocRefundBean.getSendgoodsId());
        List sgSendgoodsGoodsList = this.sgSendgoodsService.querySendgoodsGoodsPage(map).getList();
        if (ListUtil.isEmpty((Collection)sgSendgoodsGoodsList)) {
            return null;
        }
        ArrayList<SgSendgoodsGoodsDomain> domainList = new ArrayList<SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsReDomain sg : sgSendgoodsGoodsList) {
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)sg);
                domainList.add(sgSendgoodsGoodsDomain);
                this.logger.error("sgSendgoodsGoodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsGoodsList));
            }
            catch (Exception exception) {}
        }
        sgSendgoodsReDomain.setSgSendgoodsGoodsDomainList(domainList);
        this.logger.info("sgSendgoodsReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
        if (ocRefundBean.getRefundMoney().compareTo(sgSendgoodsReDomain.getDataBmoney().setScale(2, 4)) == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)sgSendgoodsReDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.ocContractDomain.ex", e.getMessage());
        }
        this.logger.info("sgSendgoodsGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(domainList));
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(sgSendgoodsReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsListSendGoods(ocRefundBean.getOcRefundGoodsBeanList(), sgSendgoodsReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            ocRefundDomain.setPackageMode(String.valueOf(sgSendgoodsReDomain.getSendgoodsId()));
            ocRefundDomain.setFchannelCode(ocRefundBean.getFchannelCode());
            ocRefundDomain.setContractNbbillcode(ocRefundBean.getContractNbbillcode());
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefund.ex", e.getMessage());
        }
        return this.ocRefundService.saveSgsendgoodsRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsListSendGoods(List<OcRefundGoodsBean> ocRefundGoodsList, SgSendgoodsDomain sgSendgoodsDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error("oc.refund.con.makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, SgSendgoodsGoodsDomain> contractGoodsMap = this.sgsendgoodsGoodsMap(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList());
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == sgSendgoodsGoodsDomain) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != sgSendgoodsGoodsDomain.getSkuNo() && !refundGoodsList.getSkuNo().equals(sgSendgoodsGoodsDomain.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.ocRefundService.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), sgSendgoodsGoodsDomain.getMemberCode(), sgSendgoodsGoodsDomain.getMemberCcode(), null, sgSendgoodsGoodsDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (refundGoodsList.getGoodsCamount().compareTo(sgSendgoodsGoodsDomain.getGoodsCamount().subtract(sgSendgoodsGoodsDomain.getContractGoodsRefnum())) > 0) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)sgSendgoodsGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
            refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
            refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
            refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum()).setScale(2, 4);
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    @RequestMapping(value={"queryVopRefundAtt.json"}, name="\u67e5\u8be2Vop\u5546\u54c1\u552e\u540e\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean queryVopRefundAtt(HttpServletRequest request, String thirdApplyId, String orderId, String skuIds, String memberCode, String tenantCode) {
        return this.ocRefundService.queryVopRefundAtt(thirdApplyId, orderId, skuIds, memberCode, tenantCode);
    }

    @RequestMapping(value={"queryVopRefundInfo.json"}, name="\u67e5\u8be2Vop\u5546\u54c1\u552e\u540e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean queryVopRefundInfo(HttpServletRequest request, String thirdApplyId, String orderId, String memberCode, String tenantCode) {
        return this.ocRefundService.queryVopRefundInfo(thirdApplyId, orderId, memberCode, tenantCode);
    }

    @RequestMapping(value={"cancelSendgoods.json"}, name="\u9000\u6b3e\u53d6\u6d88\u53d1\u8d27\u5355")
    @ResponseBody
    public HtmlJsonReBean cancelSendgoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error("oc.refund.con.audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.refund.con.res", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundService.getRefundByCode(codeMap);
        if (null == refundReDomain) {
            return new HtmlJsonReBean("error", "param is missing");
        }
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("contractBillcode", refundReDomain.getContractBillcode());
        SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainSupQueryResult = this.sgSendgoodsService.querySendgoodsPage(mapStr);
        if (ListUtil.isEmpty((Collection)sgSendgoodsReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean("error", "param is \u53d1\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        String sendgoodsCode = ((SgSendgoodsReDomain)sgSendgoodsReDomainSupQueryResult.getList().get(0)).getSendgoodsCode();
        UserSession userSession = this.getUserSession(request);
        return this.ocRefundService.updateSendgoodsStateByCode(tenantCode, sendgoodsCode, userSession.getUserCode(), null, null);
    }

    @RequestMapping(value={"querySgInfoByRefund.json"}, name="\u9000\u6b3e\u5355\u67e5\u8be2\u53d1\u8d27\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean querySgInfoByRefund(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!param.containsKey("goodsNoStr")) {
            this.logger.error("oc.refund.con.querySgInfoByRefund.goodsNoStr.null", (Object)param.toString());
            return new HtmlJsonReBean("-1", "\u9000\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String goodsNoStr = String.valueOf(param.get("goodsNoStr"));
        param.remove("goodsNoStr");
        Integer dataOpbillstate = 0;
        String sendgoodsCode = null;
        for (String goodsNo : goodsNoStr.split(",")) {
            param.put("skuBarcode", goodsNo);
            SupQueryResult<SgSendgoodsGoodsReDomain> sendgoodsGoodsResult = this.sgSendgoodsService.querySendgoodsGoodsPage(param);
            if (null == sendgoodsGoodsResult || ListUtil.isEmpty((Collection)sendgoodsGoodsResult.getList())) {
                this.logger.error("oc.refund.con.querySgInfoByRefund.sendgoodsGoodsResult.null", (Object)param.toString());
                return new HtmlJsonReBean("-1", "\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728\u6b64\u5546\u54c1");
            }
            String newSendgoodsCode = ((SgSendgoodsGoodsReDomain)sendgoodsGoodsResult.getList().get(0)).getSendgoodsCode();
            if (StringUtils.isEmpty(sendgoodsCode)) {
                sendgoodsCode = newSendgoodsCode;
            }
            if (!StringUtils.isNotBlank((String)sendgoodsCode) || sendgoodsCode.equals(newSendgoodsCode)) continue;
            this.logger.error("oc.refund.con.querySgInfoByRefund.sendgoodsCode", (Object)(newSendgoodsCode + "=======" + sendgoodsCode));
            return new HtmlJsonReBean("-1", "\u8ba2\u5355\u5b58\u5728\u5f02\u5e38");
        }
        SgSendgoodsReDomain sendgoodsByCode = this.sgSendgoodsService.getSendgoodsByCode(this.getTenantCode(request), sendgoodsCode);
        if (null == sendgoodsByCode || sendgoodsByCode.getDataOpnextbillstate() != 4) {
            this.logger.error("oc.refund.con.querySgInfoByRefund.sendgoodsCode", (Object)dataOpbillstate);
            return new HtmlJsonReBean("-1", "\u6b64\u8ba2\u5355\u672a\u5ba1\u6838, \u8bf7\u5728\u5ba1\u6838\u4e4b\u540e\u5728\u53d1\u8d77\u9000\u6b3e");
        }
        return new HtmlJsonReBean((Object)dataOpbillstate);
    }

    @RequestMapping(value={"refundExcel.json"}, name="\u9000\u5355\u5bfc\u51fa")
    @ResponseBody
    public HtmlJsonReBean refundExcel(HttpServletRequest request) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        String fileName = "refundList";
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (EmptyUtil.isEmpty((Object)param.get("excelTemplate"))) {
                param.put("excelTemplate", "retailerOut");
            }
        }
        if (null == (userSession = this.getUserSession(request))) {
            return new HtmlJsonReBean((Object)"\u672a\u767b\u5f55");
        }
        this.exportExcelAsy(param, request, fileName, "oc.refund.queryRefundReDomainPage");
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryOcRefundPageForRetailPlat.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868-\u8fd0\u8425\u7aef")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPageForRetailPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        this.logger.error("oc.refund.con====param=====", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
        String fileName = "\u9000\u5355\u5217\u8868";
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("excelTemplate", "retailerOut");
        }
        SupQueryResult<OcRefundReDomain> queryRefundReDomainPage = this.queryOcRefundPage(request, fileName, param);
        this.logger.error("oc.refund.con====queryOcRefundPageForRetailPlat==1===", (Object)JsonUtil.buildNonDefaultBinder().toJson(queryRefundReDomainPage));
        if (queryRefundReDomainPage != null && ListUtil.isNotEmpty((Collection)queryRefundReDomainPage.getList())) {
            for (OcRefundReDomain refundReDomain : queryRefundReDomainPage.getList()) {
                BigDecimal contractRefundNum = BigDecimal.ZERO;
                BigDecimal contractRefundMoney = BigDecimal.ZERO;
                BigDecimal contractRefundSum = BigDecimal.ZERO;
                BigDecimal contractRefundMoneySum = BigDecimal.ZERO;
                if (!ListUtil.isNotEmpty(refundReDomain.getOcRefundGoodsList())) continue;
                for (OcRefundGoodsDomain refundGoods : refundReDomain.getOcRefundGoodsList()) {
                    if (null == refundGoods.getGoodsCamount()) {
                        refundGoods.setGoodsCamount(BigDecimal.ZERO);
                    }
                    if (null == refundGoods.getPricesetNprice()) {
                        refundGoods.setPricesetNprice(BigDecimal.ZERO);
                    }
                    if (null == refundGoods.getGoodsCamount()) {
                        refundGoods.setGoodsCamount(BigDecimal.ZERO);
                    }
                    if (null == refundGoods.getRefundGoodsNum()) {
                        refundGoods.setRefundGoodsNum(BigDecimal.ZERO);
                    }
                    contractRefundSum = contractRefundSum.add(refundGoods.getGoodsCamount());
                    contractRefundMoneySum = contractRefundMoneySum.add(refundGoods.getGoodsCamount().multiply(refundGoods.getPricesetNprice()));
                    contractRefundNum = contractRefundNum.add(refundGoods.getRefundGoodsNum());
                    contractRefundMoney = contractRefundMoney.add(refundGoods.getRefundGoodsNum().multiply(refundGoods.getPricesetNprice()));
                }
                refundReDomain.setContractRefundMoney(contractRefundMoney);
                refundReDomain.setContractRefundNum(contractRefundNum);
                refundReDomain.setContractRefundNum1(contractRefundSum);
                refundReDomain.setContractRefundMoneySum(contractRefundMoneySum);
                UmUserinfoReDomainBean userinfoByCode = this.UserService.getUserinfoByCode(refundReDomain.getTenantCode(), refundReDomain.getMemberBcode());
                if (userinfoByCode == null) continue;
                refundReDomain.setUserinfoOcode(userinfoByCode.getUserinfoOcode());
                refundReDomain.setUserinfoOtype(String.valueOf(userinfoByCode.getCompanyType()));
                refundReDomain.setAddressCode(userinfoByCode.getUserinfoScope());
            }
        }
        this.logger.error("oc.refund.con====queryOcRefundPageForRetailPlat=====", (Object)JsonUtil.buildNonDefaultBinder().toJson(queryRefundReDomainPage));
        return queryRefundReDomainPage;
    }

    @RequestMapping(value={"updateRefundNew.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRefundNew(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error("oc.refund.con.updateRefundNew", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.error("oc.refund.con====paramStr=====", (Object)paramStr);
        OcRefundReDomain ocRefundDomain = (OcRefundReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, OcRefundReDomain.class);
        this.logger.error("oc.refund.con====updateRefundNew=====", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
        ocRefundDomain.setRefundUname(this.getUserSession(request).getUserName());
        Date date = new Date();
        ocRefundDomain.setRefundAudate(date);
        ocRefundDomain.setTenantCode(this.getTenantCode(request));
        this.logger.error("updateRefund.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        BigDecimal refundMoney = BigDecimal.ZERO;
        BigDecimal goodsNum = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsList())) {
            for (OcRefundGoodsDomain refundGoods : ocRefundDomain.getOcRefundGoodsList()) {
                refundMoney = refundMoney.add(refundGoods.getRefundGoodsNum().multiply(refundGoods.getPricesetNprice()));
                goodsNum = goodsNum.add(refundGoods.getRefundGoodsNum());
                HtmlJsonReBean htmlJsonReBean = this.ocRefundService.updateRefundGoods(refundGoods);
                this.logger.error("=====\u552e\u540e\u5ba1\u6838========", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)htmlJsonReBean));
            }
        }
        ocRefundDomain.setRefundMoney(refundMoney);
        ocRefundDomain.setGoodsNum(goodsNum);
        List<OcRefundDomain> ocRefundReDomainList = this.checkRefundSplitOrder(ocRefundDomain);
        if (ListUtil.isNotEmpty(ocRefundReDomainList)) {
            this.logger.error("=====\u62c6\u5355\u6570\u636e========", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRefundReDomainList));
            try {
                this.ocRefundEngineService.sendBatchSaveRefund(ocRefundReDomainList);
            }
            catch (Exception e) {
                this.logger.error("=====\u62c6\u5355\u903b\u8f91========", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRefundReDomainList), (Throwable)e);
            }
        }
        return this.ocRefundService.updateRefund(ocRefundDomain);
    }

    public List<OcRefundDomain> checkRefundSplitOrder(OcRefundReDomain ocRefundDomain) {
        OcRefundDomain ocRefundReDomain;
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsClothingDomainList = new ArrayList<OcRefundGoodsDomain>();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain refundGoods : ocRefundDomain.getOcRefundGoodsList()) {
            if (null != refundGoods.getGoodsPro() && "10".equals(refundGoods.getGoodsPro())) {
                ocRefundGoodsClothingDomainList.add(refundGoods);
                continue;
            }
            ocRefundGoodsDomainList.add(refundGoods);
        }
        if (ListUtil.isNotEmpty(ocRefundGoodsClothingDomainList)) {
            ocRefundReDomain = this.OcRefundParameter(ocRefundDomain, ocRefundGoodsClothingDomainList);
            ocRefundDomainList.add(ocRefundReDomain);
        }
        if (ListUtil.isNotEmpty(ocRefundGoodsDomainList)) {
            ocRefundReDomain = this.OcRefundParameter(ocRefundDomain, ocRefundGoodsDomainList);
            ocRefundDomainList.add(ocRefundReDomain);
        }
        return ocRefundDomainList;
    }

    public OcRefundDomain OcRefundParameter(OcRefundReDomain ocRefundDomain, List<OcRefundGoodsDomain> ocRefundGoodsDomainList) {
        OcRefundDomain ocRefundDomain1 = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain1, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.OcRefundParameter.ocContractDomain.ex", (Throwable)e);
        }
        ocRefundDomain1.setRefundType("B015");
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            ocRefundGoodsDomain.setRefundCode(null);
            ocRefundGoodsDomain.setRefundGoodsCode(null);
            ocRefundGoodsDomain.setRefundGoodsId(null);
            if (StringUtils.isNotBlank((String)ocRefundGoodsDomain.getGoodsPro()) && "10".equals(ocRefundGoodsDomain.getGoodsPro())) {
                ocRefundDomain1.setRefundCode("1_" + ocRefundDomain.getRefundCode());
                continue;
            }
            ocRefundDomain1.setRefundCode("0_" + ocRefundDomain.getRefundCode());
        }
        ocRefundDomain1.setOcRefundGoodsDomainList(null);
        ocRefundDomain1.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundFileDomainList())) {
            for (OcRefundFileDomain ocRefundFileDomain : ocRefundDomain.getOcRefundFileDomainList()) {
                ocRefundFileDomain.setRefundFileCode(null);
                ocRefundFileDomain.setRefundCode(null);
                ocRefundFileDomain.setRefundFileId(null);
            }
            ocRefundDomain1.setOcRefundFileDomainList(null);
            ocRefundDomain1.setOcRefundFileDomainList(ocRefundDomain.getOcRefundFileDomainList());
        }
        ocRefundDomain1.setRefundId(null);
        ocRefundDomain1.setRefundNcode(ocRefundDomain.getRefundCode());
        return ocRefundDomain1;
    }

    @RequestMapping(value={"refundUpdateRefundGoodsNum.json"}, name="\u9000\u5355\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean refundUpdateRefundGoodsNum(HttpServletRequest request, String refundStr) {
        if (StringUtils.isBlank((String)refundStr)) {
            this.logger.error("oc.refund.con.refundUpdateRefundGoodsNum", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List refundList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(refundStr, RefundGoods.class);
        this.logger.error("oc.refund.con====refundUpdateRefundGoodsNum=====", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundList));
        if (ListUtil.isEmpty((Collection)refundList)) {
            this.logger.error("oc.refund.con.refundUpdateRefundGoodsNum", (Object)"refundList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String errorMsg = "";
        String errorMsgStr = "";
        try {
            for (RefundGoods refundGoods : refundList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("refundCode", refundGoods.getRefundCode());
                map.put("tenantCode", this.getTenantCode(request));
                OcRefundReDomain ocRefundDomain = this.ocRefundService.getRefundByCode(map);
                if (ocRefundDomain == null) {
                    this.logger.error("oc.refund.con.refundUpdateRefundGoodsNum=====" + map, (Object)"refundList is null");
                    errorMsg = errorMsg + refundGoods.getRefundCode() + ",";
                    continue;
                }
                if (0 != ocRefundDomain.getDataState()) {
                    this.logger.error("oc.refund.con.refundUpdateRefundGoodsNum=====" + map, (Object)"refundList is null");
                    errorMsgStr = errorMsgStr + refundGoods.getRefundCode() + ",";
                    continue;
                }
                this.logger.error("oc.refund.con.refundUpdateRefundGoodsNum.ocRefundDomain=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                BigDecimal goodsNum = BigDecimal.ZERO;
                if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsList())) {
                    for (OcRefundGoodsDomain refundGoodsDomain : ocRefundDomain.getOcRefundGoodsList()) {
                        if (refundGoods.getSkuBarcode().equals(refundGoodsDomain.getSkuBarcode())) {
                            refundGoodsDomain.setRefundGoodsNum(refundGoods.getRefundGoodsNum());
                            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
                            goodsMap.put("refundGoodsNum", refundGoods.getRefundGoodsNum());
                            goodsMap.put("refundGoodsId", refundGoodsDomain.getRefundGoodsId());
                            goodsMap.put("tenantCode", refundGoods.getTenantCode());
                            this.ocRefundService.updateRefundGoodsNum(goodsMap);
                        }
                        goodsNum = goodsNum.add(refundGoodsDomain.getRefundGoodsNum());
                    }
                }
                HashMap<String, Object> refundMap = new HashMap<String, Object>();
                refundMap.put("goodsNum", goodsNum);
                refundMap.put("refundCode", ocRefundDomain.getRefundCode());
                refundMap.put("tenantCode", refundGoods.getTenantCode());
                this.ocRefundService.updateRefundNew(refundMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank((String)errorMsg)) {
            return new HtmlJsonReBean("error", "\u9000\u8d27\u5355[" + errorMsg + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isNotBlank((String)errorMsgStr)) {
            return new HtmlJsonReBean("error", "\u9000\u8d27\u5355[" + errorMsgStr + "]\u9000\u6b3e\u72b6\u6001\u4e0d\u5bf9\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"saveRefundBySendGoods.json"}, name="\u6839\u636e\u53d1\u8d27\u5355\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean saveRefundBySendGoods(HttpServletRequest request, String params) {
        return this.saveRefundBySendGoods(request, params, RefundType.MEM.getCode());
    }

    @RequestMapping(value={"saveRefundByContract.json"}, name="\u6839\u636e\u8ba2\u5355\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean saveRefundByContract(HttpServletRequest request, String params) {
        return this.saveRefundByContract(request, params, RefundType.MEM.getCode());
    }

    private HtmlJsonReBean saveRefundBySendGoods(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        SgSendgoodsReDomain sendgoodsByCode = this.sgSendgoodsService.getSendgoodsByCode(this.getTenantCode(request), ocRefundBean.getContractBillcode());
        if (null == sendgoodsByCode) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.sendgoodsByCode", (Object)ocRefundBean.getContractBillcode());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == sendgoodsByCode.getRefundAmoney()) {
            sendgoodsByCode.setRefundAmoney(BigDecimal.ZERO);
        }
        if (ocRefundBean.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (ocRefundBean.getRefundMoney().compareTo(sendgoodsByCode.getDataBmoney().subtract(sendgoodsByCode.getRefundAmoney())) > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        List<SgSendgoodsSettlDomain> sgSendgoodsSettlDomainList = sendgoodsByCode.getSgSendgoodsSettlDomainList();
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        if (ListUtil.isNotEmpty(sgSendgoodsSettlDomainList)) {
            boolean flag = false;
            if (null == sendgoodsByCode.getRefundMoney()) {
                sendgoodsByCode.setRefundMoney(BigDecimal.ZERO);
            }
            if (null == sendgoodsByCode.getDataBmoney()) {
                sendgoodsByCode.setDataBmoney(BigDecimal.ZERO);
            }
            if (null == ocRefundBean.getRefundMoney()) {
                ocRefundBean.setRefundMoney(BigDecimal.ZERO);
            }
            if (sendgoodsByCode.getDataBmoney().subtract(ocRefundBean.getRefundMoney()).compareTo(BigDecimal.ZERO) <= 0) {
                flag = true;
            }
            BigDecimal sunMoney = BigDecimal.ZERO;
            for (SgSendgoodsSettlDomain sgSendgoodsSettlDomain : sgSendgoodsSettlDomainList) {
                if (2 != sgSendgoodsSettlDomain.getDataState()) continue;
                OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundSettlDomain, (Object)sgSendgoodsSettlDomain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == sgSendgoodsSettlDomain.getContractSettlPmoney()) {
                    sgSendgoodsSettlDomain.setContractSettlPmoney(BigDecimal.ZERO);
                }
                if (null == sgSendgoodsSettlDomain.getContractSettlArmoney()) {
                    sgSendgoodsSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                }
                if (flag) {
                    ocRefundSettlDomain.setContractSettlPmoney(sgSendgoodsSettlDomain.getContractSettlPmoney().subtract(sgSendgoodsSettlDomain.getContractSettlArmoney()));
                }
                sunMoney = sunMoney.add(sgSendgoodsSettlDomain.getContractSettlPmoney());
                ocRefundSettlDomain.setContractSettlBillcode(sgSendgoodsSettlDomain.getSendgoodsSettlBillcode());
                ocRefundSettlDomain.setContractBillcode(sgSendgoodsSettlDomain.getSendgoodsBillcode());
                ocRefundSettlDomainList.add(ocRefundSettlDomain);
            }
            if (ListUtil.isNotEmpty(ocRefundSettlDomainList) && !flag) {
                BigDecimal rate = BigDecimal.ZERO;
                BigDecimal allMoney = ocRefundBean.getRefundMoney();
                BigDecimal opMoney = ocRefundBean.getRefundMoney();
                int i = 0;
                int num = ocRefundSettlDomainList.size();
                for (OcRefundSettlDomain ocRefundSettlDomain2 : ocRefundSettlDomainList) {
                    rate = ocRefundSettlDomain2.getContractSettlPmoney().divide(sunMoney);
                    if (++i == num) {
                        ocRefundSettlDomain2.setContractSettlPmoney(opMoney);
                        continue;
                    }
                    ocRefundSettlDomain2.setContractSettlPmoney(allMoney.multiply(rate));
                    opMoney = opMoney.subtract(ocRefundSettlDomain2.getContractSettlPmoney());
                }
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)sendgoodsByCode);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefundBySendGoods.ex", e.getMessage());
        }
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        ocRefundDomain.setContractBillcode(sendgoodsByCode.getSendgoodsCode());
        try {
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPake())) {
                ocRefundDomain.setRefundPake(ocRefundBean.getRefundPake());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundArrdess())) {
                ocRefundDomain.setRefundArrdess(ocRefundBean.getRefundArrdess());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPakedes())) {
                ocRefundDomain.setRefundPakedes(ocRefundBean.getRefundPakedes());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundMem())) {
                ocRefundDomain.setRefundMem(ocRefundBean.getRefundMem());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundTel())) {
                ocRefundDomain.setRefundTel(ocRefundBean.getRefundTel());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPhone())) {
                ocRefundDomain.setRefundPhone(ocRefundBean.getRefundPhone());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundEmail())) {
                ocRefundDomain.setRefundEmail(ocRefundBean.getRefundEmail());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getContractPumode())) {
                ocRefundDomain.setContractPumode(ocRefundBean.getContractPumode());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundArrdesscode())) {
                ocRefundDomain.setRefundArrdesscode(ocRefundBean.getRefundArrdesscode());
            }
            ocRefundDomain.setRefundReceiptArrdess(ocRefundBean.getRefundReceiptArrdess());
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            if (null == ocRefundBean.getRefundType()) {
                ocRefundBean.setRefundType("F" + sendgoodsByCode.getContractType());
            }
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(sendgoodsByCode.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsListBySgSendGoods(ocRefundBean.getOcRefundGoodsBeanList(), sendgoodsByCode));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefundBySendGoods.ex", e.getMessage());
        }
        this.logger.error("oc.refund.con.saveRefundBySendGoods.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.ocRefundService.saveRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsListBySgSendGoods(List<OcRefundGoodsBean> ocRefundGoodsList, SgSendgoodsReDomain sgSendgoodsReDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error("oc.refund.con.makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        BigDecimal sumMoney = BigDecimal.ZERO;
        Object contractGoodsPmMap = null;
        Map<String, SgSendgoodsGoodsDomain> contractGoodsMap = this.sendGoodsMap(sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList());
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == sgSendgoodsGoodsDomain) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != sgSendgoodsGoodsDomain.getSkuNo() && !refundGoodsList.getSkuNo().equals(sgSendgoodsGoodsDomain.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.ocRefundService.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), sgSendgoodsReDomain.getMemberCode(), sgSendgoodsReDomain.getMemberCcode(), sgSendgoodsReDomain.getChannelCode(), sgSendgoodsReDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getRefundGoodsNum()) {
                refundGoodsList.setRefundGoodsNum(BigDecimal.ZERO);
            }
            if (null != refundGoodsList.getRefundGoodsNum() && !RefundCon.isIntegerValue(refundGoodsList.getRefundGoodsNum())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            if (sgSendgoodsGoodsDomain.getGoodsCamount().compareTo(refundGoodsList.getRefundGoodsNum().add(sgSendgoodsGoodsDomain.getContractGoodsRefnum())) < 0) {
                throw new Exception("\u7533\u8bf7\u552e\u540e\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)sgSendgoodsGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setContractGoodsCode(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            sumMoney = sumMoney.add(refundGoodsDomain.getGoodsCamount().multiply(refundGoodsDomain.getPricesetNprice()));
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 4);
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, OcContractGoodsDomain> sendContractMap(List<OcContractGoodsDomain> sgSendgoodsGoodsDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsGoodsDomainList)) {
            this.logger.error("oc.refund.con.contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomainList) {
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain);
        }
        return map;
    }

    private HtmlJsonReBean saveRefundByContract(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error("oc.refund.con.saveRefundByContract.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refund.con.saveRefundByContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error("oc.refund.con.saveRefundByContract.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        OcContractReDomain sendgoodsByCode = this.ocContractService.getContractByCode(this.getQueryMapParam("tenantCode,contractBillcode", this.getTenantCode(request), ocRefundBean.getContractBillcode()));
        if (null == sendgoodsByCode) {
            this.logger.error("oc.refund.con.saveRefundByContract.sendgoodsByCode", (Object)ocRefundBean.getContractBillcode());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == sendgoodsByCode.getRefundMoney()) {
            sendgoodsByCode.setRefundMoney(BigDecimal.ZERO);
        }
        if (ocRefundBean.getRefundMoney().compareTo(sendgoodsByCode.getGoodsMoney().subtract(sendgoodsByCode.getRefundMoney())) == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        if (ocRefundBean.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        List<OcContractSettlDomain> sgSendgoodsSettlDomainList = sendgoodsByCode.getOcContractSettlList();
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        if (ListUtil.isNotEmpty(sgSendgoodsSettlDomainList)) {
            boolean flag = false;
            if (null == sendgoodsByCode.getRefundMoney()) {
                sendgoodsByCode.setRefundMoney(BigDecimal.ZERO);
            }
            if (null == sendgoodsByCode.getDataBmoney()) {
                sendgoodsByCode.setDataBmoney(BigDecimal.ZERO);
            }
            if (null == ocRefundBean.getRefundMoney()) {
                ocRefundBean.setRefundMoney(BigDecimal.ZERO);
            }
            if (sendgoodsByCode.getDataBmoney().subtract(sendgoodsByCode.getRefundMoney()).subtract(ocRefundBean.getRefundMoney()).compareTo(BigDecimal.ZERO) == 0) {
                flag = true;
            }
            BigDecimal sunMoney = BigDecimal.ZERO;
            for (OcContractSettlDomain sgSendgoodsSettlDomain : sgSendgoodsSettlDomainList) {
                if (2 != sgSendgoodsSettlDomain.getDataState() || !"CRP".equals(sgSendgoodsSettlDomain.getContractSettlBlance()) && !"VD".equals(sgSendgoodsSettlDomain.getContractSettlBlance())) continue;
                OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundSettlDomain, (Object)sgSendgoodsSettlDomain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == sgSendgoodsSettlDomain.getContractSettlPmoney()) {
                    sgSendgoodsSettlDomain.setContractSettlPmoney(BigDecimal.ZERO);
                }
                if (null == sgSendgoodsSettlDomain.getContractSettlArmoney()) {
                    sgSendgoodsSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                }
                if (flag) {
                    ocRefundSettlDomain.setContractSettlPmoney(sgSendgoodsSettlDomain.getContractSettlPmoney().subtract(sgSendgoodsSettlDomain.getContractSettlArmoney()));
                }
                sunMoney = sunMoney.add(sgSendgoodsSettlDomain.getContractSettlPmoney());
                ocRefundSettlDomainList.add(ocRefundSettlDomain);
            }
            if (ListUtil.isNotEmpty(ocRefundSettlDomainList) && !flag) {
                BigDecimal rate = BigDecimal.ZERO;
                BigDecimal allMoney = ocRefundBean.getRefundMoney();
                BigDecimal opMoney = ocRefundBean.getRefundMoney();
                int i = 0;
                int num = ocRefundSettlDomainList.size();
                for (OcRefundSettlDomain ocRefundSettlDomain2 : ocRefundSettlDomainList) {
                    rate = ocRefundSettlDomain2.getContractSettlPmoney().divide(sunMoney);
                    if (++i == num) {
                        ocRefundSettlDomain2.setContractSettlPmoney(opMoney);
                        continue;
                    }
                    ocRefundSettlDomain2.setContractSettlPmoney(allMoney.multiply(rate));
                    opMoney = opMoney.subtract(ocRefundSettlDomain2.getContractSettlPmoney());
                }
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)sendgoodsByCode);
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefundBySendGoods.ex", e.getMessage());
        }
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        ocRefundDomain.setContractBillcode(sendgoodsByCode.getContractBillcode());
        try {
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPake())) {
                ocRefundDomain.setRefundPake(ocRefundBean.getRefundPake());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundArrdess())) {
                ocRefundDomain.setRefundArrdess(ocRefundBean.getRefundArrdess());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPakedes())) {
                ocRefundDomain.setRefundPakedes(ocRefundBean.getRefundPakedes());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundMem())) {
                ocRefundDomain.setRefundMem(ocRefundBean.getRefundMem());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundTel())) {
                ocRefundDomain.setRefundTel(ocRefundBean.getRefundTel());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundPhone())) {
                ocRefundDomain.setRefundPhone(ocRefundBean.getRefundPhone());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundEmail())) {
                ocRefundDomain.setRefundEmail(ocRefundBean.getRefundEmail());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getContractPumode())) {
                ocRefundDomain.setContractPumode(ocRefundBean.getContractPumode());
            }
            if (StringUtils.isNotBlank((String)ocRefundBean.getRefundArrdesscode())) {
                ocRefundDomain.setRefundArrdesscode(ocRefundBean.getRefundArrdesscode());
            }
            ocRefundDomain.setRefundReceiptArrdess(ocRefundBean.getRefundReceiptArrdess());
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            if (null == ocRefundBean.getRefundType()) {
                ocRefundBean.setRefundType("FO" + sendgoodsByCode.getContractType());
            }
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(sendgoodsByCode.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsListByContract(ocRefundBean.getOcRefundGoodsBeanList(), sendgoodsByCode));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refund.con.saveRefundBySendGoods.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refund.con.saveRefundBySendGoods.ex", e.getMessage());
        }
        return this.ocRefundService.saveRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsListByContract(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractReDomain sgSendgoodsReDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error("oc.refund.con.makeRefundGoodsListByContract.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        BigDecimal sumMoney = BigDecimal.ZERO;
        Object contractGoodsPmMap = null;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.sendContractMap(sgSendgoodsReDomain.getGoodsList());
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            OcContractGoodsDomain sgSendgoodsGoodsDomain = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == sgSendgoodsGoodsDomain) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != sgSendgoodsGoodsDomain.getSkuNo() && !refundGoodsList.getSkuNo().equals(sgSendgoodsGoodsDomain.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.ocRefundService.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), sgSendgoodsReDomain.getMemberCode(), sgSendgoodsReDomain.getMemberCcode(), sgSendgoodsReDomain.getChannelCode(), sgSendgoodsReDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.refund.con.makeRefundGoodsListBySgSendGoods.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getRefundGoodsNum()) {
                refundGoodsList.setRefundGoodsNum(BigDecimal.ZERO);
            }
            if (null != refundGoodsList.getRefundGoodsNum() && !RefundCon.isIntegerValue(refundGoodsList.getRefundGoodsNum())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            if (sgSendgoodsGoodsDomain.getGoodsCamount().compareTo(refundGoodsList.getRefundGoodsNum().add(sgSendgoodsGoodsDomain.getContractGoodsRefnum())) < 0) {
                this.logger.error("oc.refund.con.makeRefundGoodsListBySgSendGoods.ex", (Object)(sgSendgoodsGoodsDomain.getGoodsCamount() + "-" + refundGoodsList.getRefundGoodsNum() + "-" + sgSendgoodsGoodsDomain.getContractGoodsRefnum()));
                throw new Exception("\u7533\u8bf7\u552e\u540e\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)sgSendgoodsGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.refund.con.makeRefundGoodsListBySgSendGoods.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            sumMoney = sumMoney.add(refundGoodsDomain.getGoodsCamount().multiply(refundGoodsDomain.getPricesetNprice()));
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            if (!EmptyUtil.isEmpty((Object)sgSendgoodsGoodsDomain.getContractGoodsAppraise())) {
                refundGoodsDomain.setGoodsProperty4(sgSendgoodsGoodsDomain.getContractGoodsAppraise().toString());
            }
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 4);
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, SgSendgoodsGoodsDomain> sendGoodsMap(List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsGoodsDomainList)) {
            this.logger.error("oc.refund.con.contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, SgSendgoodsGoodsDomain> map = new HashMap<String, SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomainList) {
            if (null == sgSendgoodsGoodsDomain.getContractGoodsRefnum()) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode(), sgSendgoodsGoodsDomain);
        }
        return map;
    }
}

