/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.erp;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.erp.ErpOrderGoodsDomain;
import cn.com.qj.bff.domain.erp.ErpOrderGoodsReDomain;
import cn.com.qj.bff.service.erp.ErpOrderGoodsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/erp/orderGoods"}, name="erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1")
public class OrderGoodsCon
extends SpringmvcController {
    private static String CODE = "erp.orderGoods.con";
    @Autowired
    private ErpOrderGoodsService erpOrderGoodsService;

    @Override
    protected String getContext() {
        return "orderGoods";
    }

    @RequestMapping(value={"saveOrderGoods.json"}, name="\u589e\u52a0erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveOrderGoods(HttpServletRequest request, ErpOrderGoodsDomain erpOrderGoodsDomain) {
        if (null == erpOrderGoodsDomain) {
            this.logger.error(CODE + ".saveOrderGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        erpOrderGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.erpOrderGoodsService.saveOrderGoods(erpOrderGoodsDomain);
    }

    @RequestMapping(value={"getOrderGoods.json"}, name="\u83b7\u53d6erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public ErpOrderGoodsReDomain getOrderGoods(Integer pOrderGoodsId) {
        if (StringUtils.isBlank((Integer)pOrderGoodsId)) {
            this.logger.error(CODE + ".getOrderGoods", (Object)"param is null");
            return null;
        }
        return this.erpOrderGoodsService.getOrderGoods(pOrderGoodsId);
    }

    @RequestMapping(value={"updateOrderGoods.json"}, name="\u66f4\u65b0erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateOrderGoods(HttpServletRequest request, ErpOrderGoodsDomain erpOrderGoodsDomain) {
        if (null == erpOrderGoodsDomain) {
            this.logger.error(CODE + ".updateOrderGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        erpOrderGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.erpOrderGoodsService.updateOrderGoods(erpOrderGoodsDomain);
    }

    @RequestMapping(value={"deleteOrderGoods.json"}, name="\u5220\u9664erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteOrderGoods(Integer pOrderGoodsId) {
        if (StringUtils.isBlank((Integer)pOrderGoodsId)) {
            this.logger.error(CODE + ".deleteOrderGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.erpOrderGoodsService.deleteOrderGoods(pOrderGoodsId);
    }

    @RequestMapping(value={"queryOrderGoodsPage.json"}, name="\u67e5\u8be2erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ErpOrderGoodsReDomain> queryOrderGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.erpOrderGoodsService.queryOrderGoodsPage(param);
    }

    @RequestMapping(value={"updateOrderGoodsState.json"}, name="\u66f4\u65b0erp\u8ba2\u5355\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOrderGoodsState(String pOrderGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pOrderGoodsId)) {
            this.logger.error(CODE + ".updateOrderGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.erpOrderGoodsService.updateOrderGoodsState(Integer.valueOf(pOrderGoodsId), dataState, oldDataState, null);
    }
}

