/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.ExcelExportTemplate;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractPmGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcRefundBean;
import cn.com.qj.bff.domain.oc.OcRefundDomain;
import cn.com.qj.bff.domain.oc.OcRefundGoodsAuBean;
import cn.com.qj.bff.domain.oc.OcRefundGoodsBean;
import cn.com.qj.bff.domain.oc.OcRefundGoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefundPmGoodsDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.domain.oc.RsSkuReDomain;
import cn.com.qj.bff.service.oc.OcContractPmGoodsService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRefgoodsService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class RefundClsCommon
extends SpringmvnNewController {
    private static final String CODE = "oc.refundclscommon.con";
    @Autowired
    public OcRefundService ocRefundService;
    @Autowired
    public OcContractService ocContractService;
    @Autowired
    public OcContractPmGoodsService ocContractPmGoodsService;
    @Autowired
    private OcRefgoodsService ocRefgoodsService;

    @Override
    protected String getContext() {
        return "refundclscommon";
    }

    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractService.queryContractGoodsPage(param);
    }

    public SupQueryResult<OcRefundReDomain> queryRefund(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    public SupQueryResult<OcRefundReDomain> queryRefundOrGoods(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundReDomainPageByGoods(param);
    }

    public boolean makeReGoodsNum(OcRefundBean ocRefundBean) {
        List<OcRefundGoodsBean> ocRefundGoodsBeanList = ocRefundBean.getOcRefundGoodsBeanList();
        if (ListUtil.isEmpty(ocRefundGoodsBeanList)) {
            this.logger.error("oc.refundclscommon.con.makeReGoodsNum.ocRefundGoodsBeanList.null");
            return true;
        }
        for (OcRefundGoodsBean ocRefundGoodsBean : ocRefundGoodsBeanList) {
            if (ocRefundGoodsBean.getRefundGoodsNum().compareTo(new BigDecimal(0)) != 0) continue;
            this.logger.error("oc.refundclscommon.conmakeReGoodsNum.num.0", (Object)ocRefundBean.getContractBillcode());
            return true;
        }
        return false;
    }

    public HtmlJsonReBean auRefund(HttpServletRequest request, String params, boolean flag) {
        if (null == params) {
            this.logger.error("oc.refundclscommon.con.auRefund.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List ocRefundGoodsAuBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(params, OcRefundGoodsAuBean.class);
        if (ListUtil.isEmpty((Collection)ocRefundGoodsAuBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a1");
        }
        return this.ocRefundService.sendUpdateRefundGoodsStateByCode(ocRefundGoodsAuBeanList);
    }

    public HtmlJsonReBean saveRefund(HttpServletRequest request, String params, String refundUsertype) {
        if (null == params) {
            this.logger.error("oc.refundclscommon.con.params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error("oc.refundclscommon.con.saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error("oc.refundclscommon.con.saveRefund.refundMoney", (Object)"refundMoney is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "refundMoney");
        }
        if (this.makeReGoodsNum(ocRefundBean)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u7533\u8bf7\uff0c\u65e0\u9700\u91cd\u590d\u7533\u8bf7");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocRefundBean);
        }
        catch (Exception e) {
            this.logger.error("oc.refundclscommon.con.ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refundclscommon.con.ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), this.getTenantCode(request)));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.refundclscommon.con.saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean("oc.refundclscommon.con.saveRefund.ex", e.getMessage());
        }
        return this.ocRefundService.saveRefund(ocRefundDomain);
    }

    public OcContractReDomain makeContract(OcRefundGoodsBean ocRefundGoodsBean, String tenantCode) {
        if (null == ocRefundGoodsBean) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundGoodsBean.getContractBillcode());
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractDomain) {
            return null;
        }
        return ocContractDomain;
    }

    public Map<String, List<OcContractPmGoodsReDomain>> makePm(OcRefundGoodsBean ocRefundGoodsBean, String tenantCode) {
        if (null == ocRefundGoodsBean) {
            return null;
        }
        Map<String, List<OcContractPmGoodsReDomain>> contractGoodsPmMap = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", ocRefundGoodsBean.getContractBillcode());
        SupQueryResult<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainSupQueryResult = this.ocContractPmGoodsService.queryContractPmGoodsPage(map);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsReDomainSupQueryResult.getList())) {
            contractGoodsPmMap = this.contractPmGoodsMap(ocContractPmGoodsReDomainSupQueryResult.getList());
        }
        return contractGoodsPmMap;
    }

    public List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, String tenantCode) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error("oc.refundclscommon.con.makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList;
            OcContractReDomain ocContractDomain = this.makeContract(refundGoodsList, tenantCode);
            Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            Map<String, List<OcContractPmGoodsReDomain>> contractGoodsPmMap = this.makePm(refundGoodsList, tenantCode);
            if (null != refundGoodsList.getSkuNo() && null != ocContractGoods.getSkuNo() && !refundGoodsList.getSkuNo().equals(ocContractGoods.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.ocRefundService.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), ocContractDomain.getMemberCode(), ocContractDomain.getMemberCcode(), ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.refundclscommon.con.refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (refundGoodsList.getGoodsCamount().compareTo(ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum())) > 0) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            if (null != refundGoodsList.getGoodsCamount() && !RefundClsCommon.isIntegerValue(refundGoodsList.getGoodsCamount())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error("oc.refundclscommon.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 0).setScale(2, 4);
            if (MapUtil.isNotEmpty(contractGoodsPmMap) && ListUtil.isNotEmpty(ocContractPmGoodsReDomainList = contractGoodsPmMap.get(refundGoodsList.getContractGoodsCode()))) {
                ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList1 = new ArrayList<OcContractPmGoodsReDomain>();
                for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
                    if (null == ocContractGoods.getContractGoodsRefnum()) {
                        ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    BigDecimal sumStr = refundGoodsDomain.getRefundGoodsNum().add(ocContractGoods.getContractGoodsRefnum());
                    BigDecimal sum = BigDecimal.ZERO;
                    if (sumStr.compareTo(ocContractGoods.getGoodsCamount()) == 0) {
                        BigDecimal sum2;
                        BigDecimal sum1 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(ocContractGoods.getContractGoodsRefnum()).setScale(2, 5);
                        sum = sum2 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().subtract(sum1);
                    } else {
                        sum = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(refundGoodsDomain.getRefundGoodsNum()).setScale(2, 5);
                    }
                    ocContractPmGoodsReDomain.setContractPmgoodsRepmoney(sum);
                    ocContractPmGoodsReDomain.setContractGoodsRefnum(refundGoodsDomain.getRefundGoodsNum());
                    ocContractPmGoodsReDomainList1.add(ocContractPmGoodsReDomain);
                }
                List<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = this.ocRefundPmGoods(ocContractPmGoodsReDomainList1);
                refundGoodsDomain.setOcRefundPmGoodsDomainList(ocRefundPmGoodsDomainList);
            }
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, List<OcContractPmGoodsReDomain>> contractPmGoodsMap(List<OcContractPmGoodsReDomain> goodsPmList) {
        if (ListUtil.isEmpty(goodsPmList)) {
            this.logger.error("oc.refundclscommon.con.contractPmGoodsMap", (Object)"param is null");
            return null;
        }
        HashMap<String, List<OcContractPmGoodsReDomain>> map = new HashMap<String, List<OcContractPmGoodsReDomain>>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : goodsPmList) {
            if (!StringUtils.isNotBlank((String)ocContractPmGoodsReDomain.getContractGoodsCode())) continue;
            ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList = (ArrayList<OcContractPmGoodsReDomain>)map.get(ocContractPmGoodsReDomain.getContractGoodsCode());
            if (null == ocContractPmGoodsReDomainList) {
                ocContractPmGoodsReDomainList = new ArrayList<OcContractPmGoodsReDomain>();
                map.put(ocContractPmGoodsReDomain.getContractGoodsCode(), ocContractPmGoodsReDomainList);
            }
            ocContractPmGoodsReDomainList.add(ocContractPmGoodsReDomain);
        }
        return map;
    }

    public List<OcRefundPmGoodsDomain> ocRefundPmGoods(List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList) {
        if (ListUtil.isEmpty(ocContractPmGoodsReDomainList)) {
            this.logger.error("oc.refundclscommon.con.ocRefundPmGoods", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
            OcRefundPmGoodsDomain ocRefundPmGoodsDomain = new OcRefundPmGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsDomain, (Object)ocContractPmGoodsReDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.refundclscommon.con.refundGoodsList.ex", (Throwable)e);
                return null;
            }
            ocRefundPmGoodsDomain.setRefundPmgoodsRepmoney(ocContractPmGoodsReDomain.getContractPmgoodsRepmoney());
            ocRefundPmGoodsDomainList.add(ocRefundPmGoodsDomain);
        }
        return ocRefundPmGoodsDomainList;
    }

    public static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("oc.refundclscommon.con.contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    protected SupQueryResult<OcRefundReDomain> queryOcRefundPage(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if ("retailerOut".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerOutExcelParam());
            } else if ("pgOut".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgOutExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            try {
                this.exportComExcel(request, param, infoMap, "oc.refund.queryRefundReDomainPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error("oc.refundclscommon.con.queryContractPageComes.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocRefundService.queryRefundReDomainPage(param);
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block13: {
            List ocRefundReDomainList;
            block14: {
                block12: {
                    SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                    if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                        this.logger.error("oc.refundclscommon.con.makeExcelData.supQueryResult", (Object)(" is null" + json));
                        return null;
                    }
                    ocRefundReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcRefundReDomain.class);
                    if (ListUtil.isEmpty((Collection)ocRefundReDomainList)) {
                        this.logger.error("oc.refundclscommon.con.makeExcelData.ocRefundReDomainList", (Object)(" is null" + json));
                        return null;
                    }
                    this.logger.info("oc.refundclscommon.con.makeExcelData.ocRefundReDomainList.param", (Object)json);
                    mapList = new ArrayList<Map<String, Object>>();
                    if (!"retailerOut".equals(excelTemplate)) break block12;
                    for (OcRefundReDomain oc : ocRefundReDomainList) {
                        List<OcRefundGoodsDomain> refundGoodsDomainList = oc.getOcRefundGoodsList();
                        boolean flag = false;
                        if (ListUtil.isNotEmpty(refundGoodsDomainList)) {
                            for (OcRefundGoodsDomain ocRefundGoodsDomain : refundGoodsDomainList) {
                                Map<String, Object> objectDetailToMap = this.covertMapWtite(ocRefundGoodsDomain);
                                if (!flag) {
                                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                    Map<String, Object> stringObjectMap = this.coverRetailerOutState(objectToMap);
                                    if ("0".equals(oc.getDataState().toString())) {
                                        stringObjectMap.put("dataState", "\u5f85\u5ba1\u6838");
                                    }
                                    objectDetailToMap.putAll(stringObjectMap);
                                }
                                mapList.add(objectDetailToMap);
                            }
                            continue;
                        }
                        Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                        Map<String, Object> stringObjectMap = this.coverRetailerOutState(objectToMap);
                        mapList.add(stringObjectMap);
                    }
                    break block13;
                }
                if (!"pgOut".equals(excelTemplate)) break block14;
                for (OcRefundReDomain oc : ocRefundReDomainList) {
                    List<OcRefundGoodsDomain> ocRefundGoodsList = oc.getOcRefundGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty(ocRefundGoodsList)) {
                        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocRefundGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                    mapList.add(stringObjectMap);
                }
                break block13;
            }
            if (!"refundOrderExport".equals(excelTemplate)) break block13;
            for (OcRefundReDomain oc : ocRefundReDomainList) {
                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                Map<String, Object> stringObjectMap = this.coverRefundOrderState(objectToMap, oc);
                mapList.add(stringObjectMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMapWtite(OcRefundGoodsDomain ocRefundGoodsDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("goodsNo", ocRefundGoodsDomain.getGoodsNo());
        orderMaps.put("goodsName", ocRefundGoodsDomain.getGoodsName());
        return orderMaps;
    }

    protected Map<String, Object> coverPgOutState(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u5904\u7406");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 0: {
                map.put("dataState", "\u5904\u7406\u4e2d");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverRetailerOutState(Map<String, Object> map) {
        String refundType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 5: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u7533\u8bf7");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u9000\u5355");
                break;
            }
            case 7: {
                map.put("dataState", "\u5f85\u9000\u5355");
                break;
            }
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 4: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 9: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case 6: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u6536\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u64a4\u9500\u7533\u8bf7");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer refundUsertype = null == map.get("refundUsertype") ? 8888 : Integer.valueOf(map.get("refundUsertype").toString());
        switch (refundUsertype) {
            case 0: {
                map.put("refundUsertype", "\u7528\u6237");
                break;
            }
            case 1: {
                map.put("refundUsertype", "\u5e73\u53f0");
                break;
            }
            case 2: {
                map.put("refundUsertype", "\u5546\u5bb6");
                break;
            }
            default: {
                map.put("refundUsertype", "\u672a\u77e5\u72b6\u6001:" + map.get("refundUsertype"));
            }
        }
        switch (refundType = String.valueOf(null == map.get("refundType") ? Integer.valueOf(8888) : map.get("refundType").toString())) {
            case "B01": {
                map.put("refundType", "\u4ec5\u9000\u6b3e");
                break;
            }
            case "B02": {
                map.put("refundType", "\u9000\u8d27\u9000\u6b3e");
                break;
            }
            case "B04": {
                map.put("refundType", "\u4ec5\u9000\u8d27");
                break;
            }
            case "B05": {
                map.put("refundType", "\u9000\u79ef\u5206");
                break;
            }
            default: {
                map.put("refundType", "\u672a\u77e5\u72b6\u6001:" + map.get("refundType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePg(Map<String, Object> map) {
        String refundType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String tdh = "\u9000\u5355\u53f7\uff1a";
        String tdhs = "\u539f\u8ba2\u5355\u53f7\uff1a";
        String dmst = "dms\u9000\u5355\u7f16\u7801\uff1a";
        String dmsd = "dms\u539f\u8ba2\u5355\u53f7\uff1a";
        String contract = tdh + map.get("refundCode") + tdhs + map.get("contractBillcode");
        map.put("contract", contract);
        String billcode = dmst + map.get("refundNcode") + dmsd + map.get("contractNbbillcode");
        map.put("billcode", billcode);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 5: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u7533\u8bf7");
                break;
            }
            case 1: {
                map.put("dataState", "\u5ba1\u6838\u901a\u8fc7");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u9000\u6b3e");
                break;
            }
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 4: {
                map.put("dataState", "\u7cfb\u7edf\u5904\u7406\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case 6: {
                map.put("dataState", "\u5546\u5bb6\u62d2\u7edd\u6536\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u64a4\u9500\u7533\u8bf7");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer refundUsertype = null == map.get("refundUsertype") ? 8888 : Integer.valueOf(map.get("refundUsertype").toString());
        switch (refundUsertype) {
            case 0: {
                map.put("refundUsertype", "\u7528\u6237");
                break;
            }
            case 1: {
                map.put("refundUsertype", "\u5e73\u53f0");
                break;
            }
            case 2: {
                map.put("refundUsertype", "\u5546\u5bb6");
                break;
            }
            default: {
                map.put("refundUsertype", "\u672a\u77e5\u72b6\u6001:" + map.get("refundUsertype"));
            }
        }
        switch (refundType = String.valueOf(null == map.get("refundType") ? Integer.valueOf(8888) : map.get("refundType").toString())) {
            case "B01": {
                map.put("refundType", "\u4ec5\u9000\u8d27");
                break;
            }
            case "B02": {
                map.put("refundType", "\u9000\u8d27\u9000\u6b3e");
                break;
            }
            default: {
                map.put("refundType", "\u672a\u77e5\u72b6\u6001:" + map.get("refundType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverRefundOrderState(Map<String, Object> map, OcRefundReDomain ocRefund) {
        BigDecimal contractRefundMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        Integer dataState = ocRefund.getDataState();
        if (ListUtil.isNotEmpty(ocRefund.getOcRefundGoodsList())) {
            for (OcRefundGoodsDomain refundGoods : ocRefund.getOcRefundGoodsList()) {
                if (null == refundGoods.getGoodsCamount()) {
                    refundGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == refundGoods.getPricesetNprice()) {
                    refundGoods.setPricesetNprice(BigDecimal.ZERO);
                }
                if (null == refundGoods.getGoodsCamount()) {
                    refundGoods.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == refundGoods.getRefundGoodsNum()) {
                    refundGoods.setRefundGoodsNum(BigDecimal.ZERO);
                }
                contractRefundMoney = refundGoods.getPricesetNprice().multiply(refundGoods.getGoodsCamount());
                refundMoney = refundGoods.getPricesetNprice().multiply(refundGoods.getRefundGoodsNum());
                map.put("contractGoodsSendnum1", refundGoods.getContractGoodsSendnum1());
                map.put("refundGoodsNum1", refundGoods.getRefundGoodsNum1());
                map.put("goodsCamount", refundGoods.getGoodsCamount());
                map.put("contractRefundMoney", contractRefundMoney);
                if (dataState < 1) continue;
                map.put("refundGoodsNum", refundGoods.getRefundGoodsNum());
                map.put("refundMoney1", refundMoney);
            }
        }
        String memberCname = null == map.get("memberCname") ? "" : String.valueOf(map.get("memberCname").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u9000\u8d27");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u9000\u6b3e");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                map.put("dataState", "\u9000\u6b3e\u4e2d");
                break;
            }
            case 8: {
                map.put("dataState", "\u5b8c\u6210");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u62d2\u7edd");
                break;
            }
            default: {
                map.put("dataState", "unknow:" + dataState);
            }
        }
        return map;
    }
}

