/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.cms;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cms.CmsNoticeDomain;
import cn.com.qj.bff.domain.cms.CmsNoticeReDomain;
import cn.com.qj.bff.service.cms.CmsNoticeService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/notice"}, name="\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
public class NoticeCon
extends SpringmvcController {
    private static String CODE = "cms.notice.con";
    @Autowired
    private CmsNoticeService cmsNoticeService;
    @Autowired
    private OrgCompanyService orgCompanyService;

    @Override
    protected String getContext() {
        return "notice";
    }

    @RequestMapping(value={"saveNotice.json"}, name="\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        this.logger.info(CODE + ".saveNotice", (Object)("param is " + cmsNoticeDomain.toString()));
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        cmsNoticeDomain.setMemberCode(this.getTeananMemberCode(request));
        cmsNoticeDomain.setMemberName("\u5e73\u53f0");
        cmsNoticeDomain.setUserCode(userSession.getUserCode());
        cmsNoticeDomain.setUserName(userSession.getUserName());
        cmsNoticeDomain.setNoticeType("1");
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.saveNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"getNotice.json"}, name="\u83b7\u53d6\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".getNotice", (Object)"param is null");
            return null;
        }
        return this.cmsNoticeService.getNotice(noticeId);
    }

    @RequestMapping(value={"updateNotice.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".updateNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.updateNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"deleteNotice.json"}, name="\u5220\u9664\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.deleteNotice(noticeId);
    }

    @RequestMapping(value={"queryNoticePage.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("noticeType", "1");
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"updateNoticeState.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateNoticeState(String noticeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)noticeId)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.updateNoticeState(Integer.valueOf(noticeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryNoticePageWAP.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u770b\u516c\u544a\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePageWAP(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", 1);
        UserSession userSession = this.getUserSession(request);
        if ("2".equals(param.get("noticeType"))) {
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            cMap.put("companyCode", userSession.getUserPcode());
            cMap.put("tenantCode", this.getTenantCode(request));
            List orgCompanyReDomainList = this.orgCompanyService.queryCompanyPage(cMap).getList();
            if (null == orgCompanyReDomainList) {
                this.logger.error("queryNoticePageWAP", (Object)"orgCompanyReDomainList is null");
                return null;
            }
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"getNoticeWAP.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u770b\u516c\u544a\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNoticeWAP(HttpServletRequest request, String noticeCode) {
        if (StringUtils.isBlank((String)noticeCode)) {
            this.logger.error(CODE + ".getNoticeWAP", (Object)"noticeCode is null");
            return null;
        }
        return this.cmsNoticeService.getNoticeByCode(this.getTenantCode(request), noticeCode);
    }

    @RequestMapping(value={"queryNoticePagePC.json"}, name="pc\u7aef\u4f01\u4e1a\u67e5\u770b\u516c\u544a\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePagePC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        if ("2".equals(param.get("noticeType"))) {
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"getNoticePC.json"}, name="pc\u7aef\u4f01\u4e1a\u67e5\u770b\u516c\u544a\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNoticePC(HttpServletRequest request, String noticeCode) {
        if (StringUtils.isBlank((String)noticeCode)) {
            this.logger.error(CODE + ".getNoticePC", (Object)"noticeCode is null");
            return null;
        }
        return this.cmsNoticeService.getNoticeByCode(this.getTenantCode(request), noticeCode);
    }

    @RequestMapping(value={"saveNoticePC.json"}, name="PC\u7aef\u4f01\u4e1a\u589e\u52a0\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean saveNoticePC(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNoticePC", (Object)"cmsNoticeDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        cmsNoticeDomain.setMemberCode(userSession.getUserPcode());
        cmsNoticeDomain.setMemberName("\u4f01\u4e1a");
        cmsNoticeDomain.setUserCode(userSession.getUserCode());
        cmsNoticeDomain.setUserName(userSession.getUserName());
        cmsNoticeDomain.setNoticeType("2");
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.saveNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"updateNoticePC.json"}, name="PC\u7aef\u4f01\u4e1a\u7f16\u8f91\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateNoticePC(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".updateNoticePC", (Object)"cmsNoticeDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.updateNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"deleteNoticePC.json"}, name="PC\u7aef\u4f01\u4e1a\u5220\u9664\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean deleteNoticePC(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNoticePC", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.deleteNotice(noticeId);
    }

    @RequestMapping(value={"updateNoticeStatePC.json"}, name="PC\u7aef\u4f01\u4e1a\u53d1\u5e03\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateNoticeStatePC(String noticeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)noticeId)) {
            this.logger.error(CODE + ".updateNoticeStatePC", (Object)"noticeId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.updateNoticeState(Integer.valueOf(noticeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryNoticePageForAt.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePageForAt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("noticeType", "1");
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"getNoticeForAt.json"}, name="\u83b7\u53d6\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNoticeForAt(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".getNotice", (Object)"param is null");
            return null;
        }
        return this.cmsNoticeService.getNotice(noticeId);
    }

    @RequestMapping(value={"saveNoticeBatchForUser.json"}, name="\u7528\u6237\u6279\u91cf\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNoticeBatchForUser(HttpServletRequest request, String cmsNoticeDomainListStr) {
        if (StringUtils.isBlank((String)cmsNoticeDomainListStr)) {
            this.logger.error(CODE + ".saveNoticeBatchForUser", (Object)"cmsNoticeDomainListStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "cmsNoticeDomainListStr is null");
        }
        List cmsNoticeDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(cmsNoticeDomainListStr, CmsNoticeDomain.class);
        if (null == cmsNoticeDomainList || ListUtil.isEmpty((Collection)cmsNoticeDomainList)) {
            this.logger.error(CODE + ".saveNoticeBatchForUser", (Object)"cmsNoticeDomainListStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "cmsNoticeDomainList is null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (CmsNoticeDomain cmsNoticeDomain : cmsNoticeDomainList) {
            htmlJsonReBean = this.saveNoticeForUser(request, cmsNoticeDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveNoticeBatchForPlat.json"}, name="\u5e73\u53f0\u6279\u91cf\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNoticeBatchForPlat(HttpServletRequest request, String cmsNoticeDomainListStr) {
        if (StringUtils.isBlank((String)cmsNoticeDomainListStr)) {
            this.logger.error(CODE + ".saveNoticeBatchForPlat", (Object)"cmsNoticeDomainListStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "cmsNoticeDomainListStr is null");
        }
        List cmsNoticeDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(cmsNoticeDomainListStr, CmsNoticeDomain.class);
        if (null == cmsNoticeDomainList || ListUtil.isEmpty((Collection)cmsNoticeDomainList)) {
            this.logger.error(CODE + ".saveNoticeBatchForPlat", (Object)"cmsNoticeDomainListStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "cmsNoticeDomainList is null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (CmsNoticeDomain cmsNoticeDomain : cmsNoticeDomainList) {
            htmlJsonReBean = this.saveNoticeForPlat(request, cmsNoticeDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveNoticeForUser.json"}, name="\u7528\u6237\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNoticeForUser(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", this.getTeananMemberCode(request));
        param.put("memberCcode", userSession.getUserPcode());
        param.put("channelCode", cmsNoticeDomain.getChannelCode());
        SupQueryResult<CmsNoticeReDomain> cmsNoticeReDomainSupQueryResult = this.cmsNoticeService.queryNoticePage(param);
        if (null != cmsNoticeReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)cmsNoticeReDomainSupQueryResult.getList())) {
            CmsNoticeReDomain cmsNoticeReDomain = (CmsNoticeReDomain)cmsNoticeReDomainSupQueryResult.getList().get(0);
            this.cmsNoticeService.deleteNotice(cmsNoticeReDomain.getNoticeId());
        }
        cmsNoticeDomain.setMemberCode(this.getTeananMemberCode(request));
        cmsNoticeDomain.setMemberName("\u95e8\u5e97");
        cmsNoticeDomain.setUserCode(userSession.getUserCode());
        cmsNoticeDomain.setUserName(userSession.getUserName());
        cmsNoticeDomain.setMemberCcode(userSession.getUserPcode());
        cmsNoticeDomain.setMemberCname(userSession.getUserName());
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        this.cmsNoticeService.saveNotice(cmsNoticeDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeContext", cmsNoticeDomain.getNoticeContext());
        map.put("memberCode", cmsNoticeDomain.getMemberCcode());
        map.put("tenantCode", this.getTenantCode(request));
        map.put("channelCode", cmsNoticeDomain.getChannelCode());
        return this.cmsNoticeService.saveStoreNotice(map, cmsNoticeDomain.getChannelCode(), cmsNoticeDomain.getMemberCcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"saveNoticeForPlat.json"}, name="\u5e73\u53f0\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNoticeForPlat(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberCode", this.getTeananMemberCode(request));
        param.put("memberCcode", cmsNoticeDomain.getMemberCcode());
        param.put("channelCode", cmsNoticeDomain.getChannelCode());
        SupQueryResult<CmsNoticeReDomain> cmsNoticeReDomainSupQueryResult = this.cmsNoticeService.queryNoticePage(param);
        if (null != cmsNoticeReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)cmsNoticeReDomainSupQueryResult.getList())) {
            CmsNoticeReDomain cmsNoticeReDomain = (CmsNoticeReDomain)cmsNoticeReDomainSupQueryResult.getList().get(0);
            this.cmsNoticeService.deleteNotice(cmsNoticeReDomain.getNoticeId());
        }
        UserSession userSession = this.getUserSession(request);
        cmsNoticeDomain.setMemberCode(this.getTeananMemberCode(request));
        cmsNoticeDomain.setMemberName("\u5e73\u53f0");
        cmsNoticeDomain.setUserCode(userSession.getUserCode());
        cmsNoticeDomain.setUserName(userSession.getUserName());
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        this.cmsNoticeService.saveNotice(cmsNoticeDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeContext", cmsNoticeDomain.getNoticeContext());
        map.put("memberCode", cmsNoticeDomain.getMemberCcode());
        map.put("tenantCode", this.getTenantCode(request));
        map.put("channelCode", cmsNoticeDomain.getChannelCode());
        return this.cmsNoticeService.saveStoreNotice(map, cmsNoticeDomain.getChannelCode(), cmsNoticeDomain.getMemberCcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryNoticePageForPlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePageForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCode", this.getTeananMemberCode(request));
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"queryNoticePageForUser.json"}, name="\u7528\u6237\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePageForUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", this.getTeananMemberCode(request));
        param.put("memberCcode", userSession.getUserPcode());
        return this.cmsNoticeService.queryNoticePage(param);
    }
}

