/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wh;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.wh.WhGoodsnoConfDomain;
import cn.com.qj.bff.domain.wh.WhGoodsnoConfReDomain;
import cn.com.qj.bff.domain.wh.WhGoodsnoDomain;
import cn.com.qj.bff.domain.wh.WhGoodsnoReDomain;
import cn.com.qj.bff.domain.wh.WhWarehouseReDomain;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.wh.WhGoodsnoService;
import cn.com.qj.bff.service.wh.WhWarehouseService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wh/goodsno"}, name="\u5546\u54c1\u55b7\u7801")
public class GoodsnoCon
extends SpringmvcController {
    private static String CODE = "wh.goodsno.con";
    @Autowired
    private WhGoodsnoService whGoodsnoService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private WhWarehouseService whWarehouseService;

    @Override
    protected String getContext() {
        return "goodsno";
    }

    @RequestMapping(value={"saveGoodsno.json"}, name="\u589e\u52a0\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean saveGoodsno(HttpServletRequest request, WhGoodsnoDomain WhGoodsnoDomain2) {
        if (null == WhGoodsnoDomain2) {
            this.logger.error(CODE + ".saveGoodsno", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhGoodsnoDomain2.setTenantCode(this.getTenantCode(request));
        return this.whGoodsnoService.saveGoodsno(WhGoodsnoDomain2);
    }

    @RequestMapping(value={"getGoodsno.json"}, name="\u83b7\u53d6\u5546\u54c1\u55b7\u7801\u4fe1\u606f")
    @ResponseBody
    public WhGoodsnoReDomain getGoodsno(Integer goodsnoId) {
        if (StringUtils.isBlank((Integer)goodsnoId)) {
            this.logger.error(CODE + ".getGoodsno", (Object)"param is null");
            return null;
        }
        return this.whGoodsnoService.getGoodsno(goodsnoId);
    }

    @RequestMapping(value={"exportInGoodsno.json"}, name="\u5bfc\u5165\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean exportInGoodsno(HttpServletRequest request, String whGoodsnoStr, String exptype) {
        if (StringUtils.isBlank((String)whGoodsnoStr)) {
            this.logger.error(CODE + ".exportInGoodsno", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".exportInGoodsno", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession-null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(whGoodsnoStr, WhGoodsnoDomain.class);
        this.logger.error(CODE + ".exportInGoodsno", (Object)("list-------" + list.size()));
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".exportInGoodsno", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)exptype)) {
            queryMap.put("goodsnoType", exptype);
        }
        final ArrayList<WhGoodsnoDomain> errorList = new ArrayList<WhGoodsnoDomain>();
        final ArrayList<WhGoodsnoDomain> repeatList = new ArrayList<WhGoodsnoDomain>();
        ArrayList<WhGoodsnoDomain> saveList = new ArrayList<WhGoodsnoDomain>();
        queryMap.put("tenantCode", tenantCode);
        for (WhGoodsnoDomain whGoodsnoDomain : list) {
            if (StringUtils.isBlank((String)whGoodsnoDomain.getGoodsnoNo())) {
                errorList.add(whGoodsnoDomain);
                continue;
            }
            if (StringUtils.isNotBlank((String)exptype) && StringUtils.equals((CharSequence)exptype, (CharSequence)"rewharehouse")) {
                queryMap.put("warehouseCode", whGoodsnoDomain.getGoodsnoName());
                SupQueryResult<WhWarehouseReDomain> result = this.whWarehouseService.queryWarehousePage(queryMap);
                if (EmptyUtil.isEmpty(result) || ListUtil.isEmpty((Collection)result.getList()) || result.getList().size() > 1) {
                    errorList.add(whGoodsnoDomain);
                    continue;
                }
                whGoodsnoDomain.setGoodsnoNorule(((WhWarehouseReDomain)result.getList().get(0)).getWarehouseName());
            }
            queryMap.put("goodsNo", whGoodsnoDomain.getGoodsnoNo());
            SupQueryResult<RsSkuReDomain> skuResult = this.rsSkuService.querySkuPage(queryMap);
            if (EmptyUtil.isEmpty(skuResult) || ListUtil.isEmpty((Collection)skuResult.getList()) || skuResult.getList().size() > 1) {
                errorList.add(whGoodsnoDomain);
                continue;
            }
            whGoodsnoDomain.setGoodsnoRemark(((RsSkuReDomain)skuResult.getList().get(0)).getGoodsName());
            queryMap.put("goodsnoNo", whGoodsnoDomain.getGoodsnoNo());
            SupQueryResult<WhGoodsnoReDomain> queryResult = this.whGoodsnoService.queryGoodsnoPage(queryMap);
            if (!EmptyUtil.isEmpty(queryResult) && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                repeatList.add(whGoodsnoDomain);
                continue;
            }
            whGoodsnoDomain.setTenantCode(tenantCode);
            saveList.add(whGoodsnoDomain);
        }
        HtmlJsonReBean htmlJsonReBean = this.whGoodsnoService.saveGoodsnoBatch(saveList);
        htmlJsonReBean.setDataObj((Object)new HashMap<String, Object>(){
            {
                this.put("errorList", errorList);
                this.put("repeatList", repeatList);
            }
        });
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGoodsno.json"}, name="\u66f4\u65b0\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean updateGoodsno(HttpServletRequest request, WhGoodsnoDomain WhGoodsnoDomain2) {
        if (null == WhGoodsnoDomain2) {
            this.logger.error(CODE + ".updateGoodsno", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhGoodsnoDomain2.setTenantCode(this.getTenantCode(request));
        return this.whGoodsnoService.updateGoodsno(WhGoodsnoDomain2);
    }

    @RequestMapping(value={"deleteGoodsno.json"}, name="\u5220\u9664\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsno(Integer goodsnoId) {
        if (StringUtils.isBlank((Integer)goodsnoId)) {
            this.logger.error(CODE + ".deleteGoodsno", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whGoodsnoService.deleteGoodsno(goodsnoId);
    }

    @RequestMapping(value={"queryGoodsnoPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u55b7\u7801\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhGoodsnoReDomain> queryGoodsnoPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whGoodsnoService.queryGoodsnoPage(param);
    }

    @RequestMapping(value={"updateGoodsnoState.json"}, name="\u66f4\u65b0\u5546\u54c1\u55b7\u7801\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGoodsnoState(String goodsnoId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsnoId)) {
            this.logger.error(CODE + ".updateGoodsnoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whGoodsnoService.updateGoodsnoState(Integer.valueOf(goodsnoId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveGoodsnoConf.json"}, name="\u589e\u52a0\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean saveGoodsnoConf(HttpServletRequest request, WhGoodsnoConfDomain WhGoodsnoConfDomain2) {
        if (null == WhGoodsnoConfDomain2) {
            this.logger.error(CODE + ".saveGoodsnoConf", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhGoodsnoConfDomain2.setTenantCode(this.getTenantCode(request));
        return this.whGoodsnoService.saveGoodsnoConf(WhGoodsnoConfDomain2);
    }

    @RequestMapping(value={"saveGoodsnoConfBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean saveGoodsnoConfBatch(HttpServletRequest request, String whGoodsnoConfDomain) {
        if (StringUtils.isBlank((String)whGoodsnoConfDomain)) {
            this.logger.error(CODE + ".saveGoodsnoConfBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List whGoodsnoConfDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(whGoodsnoConfDomain, WhGoodsnoConfDomain.class);
        if (ListUtil.isEmpty((Collection)whGoodsnoConfDomainList)) {
            this.logger.error(CODE + ".whGoodsnoConfDomainList", (Object)("param is whGoodsnoConfDomain" + whGoodsnoConfDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whGoodsnoService.saveGoodsnoConfBatch(whGoodsnoConfDomainList);
    }

    @RequestMapping(value={"getGoodsnoConf.json"}, name="\u83b7\u53d6\u5546\u54c1\u55b7\u7801\u4fe1\u606f")
    @ResponseBody
    public WhGoodsnoConfReDomain getGoodsnoConf(Integer goodsnoConfId) {
        if (StringUtils.isBlank((Integer)goodsnoConfId)) {
            this.logger.error(CODE + ".getGoodsnoConf", (Object)"param is null");
            return null;
        }
        return this.whGoodsnoService.getGoodsnoConf(goodsnoConfId);
    }

    @RequestMapping(value={"updateGoodsnoConf.json"}, name="\u66f4\u65b0\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean updateGoodsnoConf(HttpServletRequest request, WhGoodsnoConfDomain WhGoodsnoConfDomain2) {
        if (null == WhGoodsnoConfDomain2) {
            this.logger.error(CODE + ".updateGoodsnoConf", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhGoodsnoConfDomain2.setTenantCode(this.getTenantCode(request));
        return this.whGoodsnoService.updateGoodsnoConf(WhGoodsnoConfDomain2);
    }

    @RequestMapping(value={"deleteGoodsnoConf.json"}, name="\u5220\u9664\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsnoConf(Integer goodsnoConfId) {
        if (StringUtils.isBlank((Integer)goodsnoConfId)) {
            this.logger.error(CODE + ".deleteGoodsnoConf", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whGoodsnoService.deleteGoodsnoConf(goodsnoConfId);
    }

    @RequestMapping(value={"queryGoodsnoConfPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u55b7\u7801\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WhGoodsnoConfReDomain> queryGoodsnoConfPage(HttpServletRequest request) {
        SupQueryResult<WhGoodsnoConfReDomain> whGoodsnoConfReDomainSupQueryResult;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isNotEmpty((Collection)(whGoodsnoConfReDomainSupQueryResult = this.whGoodsnoService.queryGoodsnoConfPage(param)).getList())) {
            HashMap<String, Object> paramStr = new HashMap<String, Object>();
            for (WhGoodsnoConfReDomain whGoodsnoConfReDomain : whGoodsnoConfReDomainSupQueryResult.getList()) {
                paramStr.put("tenantCode", whGoodsnoConfReDomain.getTenantCode());
                paramStr.put("goodsNo", whGoodsnoConfReDomain.getGoodsnoConfOp());
                SupQueryResult<RsSkuReDomain> rsSkuReDomainSupQueryResult = this.rsSkuService.querySkuPage(paramStr);
                if (!ListUtil.isNotEmpty((Collection)rsSkuReDomainSupQueryResult.getList())) continue;
                whGoodsnoConfReDomain.setRsSkuReDomainList(rsSkuReDomainSupQueryResult.getList());
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)rsSkuReDomainSupQueryResult.getList().get(0);
                whGoodsnoConfReDomain.setGoodsName(rsSkuReDomain.getGoodsName());
                whGoodsnoConfReDomain.setSkuName(rsSkuReDomain.getSkuName());
                whGoodsnoConfReDomain.setSkuBarcode(rsSkuReDomain.getSkuBarcode());
                whGoodsnoConfReDomain.setGoodsShowno(rsSkuReDomain.getGoodsShowno());
            }
        }
        return whGoodsnoConfReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateGoodsnoConfState.json"}, name="\u66f4\u65b0\u5546\u54c1\u55b7\u7801\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGoodsnoConfState(String goodsnoConfId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsnoConfId)) {
            this.logger.error(CODE + ".updateGoodsnoConfState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whGoodsnoService.updateGoodsnoConfState(Integer.valueOf(goodsnoConfId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"deleteGoodsnoConfBatch.json"}, name="\u6279\u91cf\u5220\u9664\u5546\u54c1\u55b7\u7801")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsnoConfBatch(String goodsnoConfIdStr) {
        String[] idStr;
        if (StringUtils.isBlank((String)goodsnoConfIdStr)) {
            this.logger.error(CODE + ".deleteGoodsnoConfBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String id : idStr = goodsnoConfIdStr.split(",")) {
            this.whGoodsnoService.deleteGoodsnoConf(Integer.parseInt(id));
        }
        return new HtmlJsonReBean();
    }
}

