/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wo;

import cn.com.qj.bff.controller.wo.SpScontractGoods;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.OcContractGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.SkuDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsGoodsReDomain;
import cn.com.qj.bff.domain.sp.SpScontractDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileReDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsReDomain;
import cn.com.qj.bff.domain.sp.SpScontractReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.sg.SgSendgoodsService;
import cn.com.qj.bff.service.sp.SpScontractService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvnNewController {
    private static String CODE = "sp.scontract.con";
    @Autowired
    private SpScontractService spScontractService;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private UserService userService;
    @Autowired
    private SgSendgoodsService sgSendgoodsService;
    private static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MMMM-dd HH:mm", Locale.ENGLISH);

    @Override
    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontract(spScontractDomain);
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult<CtCustrelReDomain> qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.debug(CODE + ".createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.debug(CODE + ".makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, Object> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuService.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, Object>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.setUserMap(request, param);
        String exportFlagStr = param.get("exportFlag") == null ? "false" : (String)param.get("exportFlag");
        Boolean exportFlag = Boolean.valueOf(exportFlagStr);
        if (exportFlag.booleanValue()) {
            param.put("excelTemplate", "spScontractGoodsExport");
            ZonedDateTime zdt = ZonedDateTime.now();
            String timeStr = TIME_FORMATTER.format(zdt);
            String fileName = "SpScontractGoods-" + timeStr;
            this.exportExcelAsy(param, request, fileName, "oc.contractGoods.exportSpContractGoodsWithOcGoods");
            return new QueryResult();
        }
        return this.spScontractService.queryScontractPage(param);
    }

    private void setUserMap(HttpServletRequest request, Map<String, Object> param) {
        UmUserinfoReDomainBean userinfo;
        String tenantCode = this.getTenantCode(request);
        String storeFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-store_check-store_check"));
        Object userinfoCode = param.get("userinfoCode");
        if (StringUtils.isNotBlank((String)storeFlag) && userinfoCode != null && (userinfo = this.userService.getUserInfoByUserinfoCode(String.valueOf(userinfoCode), tenantCode)) != null) {
            param.put("mschannelCode", userinfo.getUserinfoChannelcode());
            param.put("companyCode", userinfo.getDepartCode());
            param.put("employeeCode", userinfo.getUserinfoOcode());
        }
    }

    private String setUserMapStr(HttpServletRequest request, Map<String, Object> param) {
        String tenantCode = this.getTenantCode(request);
        Object userinfoCode = param.get("userinfoCode");
        UmUserinfoReDomainBean userinfo = this.userService.getUserInfoByUserinfoCode(String.valueOf(userinfoCode), tenantCode);
        if (userinfo == null) {
            return "error";
        }
        param.put("mschannelCode", userinfo.getUserinfoChannelcode());
        param.put("employeeCode", userinfo.getUserinfoOcode());
        param.put("memberCcode", userinfo.getDepartCode());
        return null;
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error(CODE + ".updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error(CODE + ".saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error(CODE + ".updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        List spScontractGoodsReDomainList;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage = this.spScontractService.queryScontractGoodsPage(param);
        ArrayList<SpScontractGoodsReDomain> spScontractGoodsReDomains = new ArrayList<SpScontractGoodsReDomain>();
        HashMap<String, String> addProcessContractBillcode = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty(queryScontractGoodsPage) && CollectionUtils.isNotEmpty((Collection)(spScontractGoodsReDomainList = queryScontractGoodsPage.getList()))) {
            this.calculateNormal(spScontractGoodsReDomainList, spScontractGoodsReDomains, addProcessContractBillcode);
            this.calculateAbnormal(spScontractGoodsReDomainList, spScontractGoodsReDomains, addProcessContractBillcode);
        }
        return queryScontractGoodsPage;
    }

    private void calculateNormal(List<SpScontractGoodsReDomain> spScontractGoodsReDomainList, List<SpScontractGoodsReDomain> spScontractGoodsReDomains, Map<String, String> addProcessContractBillcode) {
        for (SpScontractGoodsReDomain spScontractGoodsReDomain : spScontractGoodsReDomainList) {
            String projectIsCode = spScontractGoodsReDomain.getScontractCode();
            String goodsNo = spScontractGoodsReDomain.getGoodsNo();
            String ginfoCode = spScontractGoodsReDomain.getGinfoCode();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("goodsNo", goodsNo);
            paramMap.put("goodsContract", projectIsCode);
            paramMap.put("ginfoCode", ginfoCode);
            SupQueryResult<OcContractGoodsReDomain> ocContractGoodsReDomainSupQueryResult = this.ocContractService.queryContractGoodsPage(paramMap);
            if (ObjectUtils.isEmpty(ocContractGoodsReDomainSupQueryResult)) continue;
            if (CollectionUtils.isNotEmpty((Collection)ocContractGoodsReDomainSupQueryResult.getList())) {
                List ocContractGoodsReDomainList = ocContractGoodsReDomainSupQueryResult.getList();
                BigDecimal goodsCamount = new BigDecimal(BigInteger.ZERO);
                BigDecimal contractGoodsSendnum = new BigDecimal(BigInteger.ZERO);
                BigDecimal contractGoodsRefnum = new BigDecimal(BigInteger.ZERO);
                for (OcContractGoodsReDomain ocContractGoodsReDomain : ocContractGoodsReDomainList) {
                    if (StringUtils.isBlank((String)ocContractGoodsReDomain.getGoodsSpec1())) continue;
                    if (!"2".equals(ocContractGoodsReDomain.getPricesetCurrency1()) && "3".equals(spScontractGoodsReDomain.getScontractGoodsRemark())) {
                        spScontractGoodsReDomain.setGoodsCamount(null);
                        spScontractGoodsReDomain.setScontractGoodsRefnum(null);
                        continue;
                    }
                    String msg = "ContractBillcode: " + ocContractGoodsReDomain.getContractBillcode() + " ,oc.GoodsNo:  " + ocContractGoodsReDomain.getGoodsNo() + " ,oc.PricesetCurrency1: " + ocContractGoodsReDomain.getPricesetCurrency1() + " ,sp.ScontractGoodsRemark: " + spScontractGoodsReDomain.getScontractGoodsRemark() + " ,oc.getGoodsCamount: " + ocContractGoodsReDomain.getGoodsCamount() + " ,oc.ContractGoodsSendnum\uff1a" + ocContractGoodsReDomain.getContractGoodsSendnum();
                    this.logger.info(CODE + ".spScontractGoodsReDomain.point.msg", (Object)msg);
                    if ("2".equals(ocContractGoodsReDomain.getPricesetCurrency1()) && "3".equals(spScontractGoodsReDomain.getScontractGoodsRemark())) {
                        String ContractBillcodeListStr = addProcessContractBillcode.get(spScontractGoodsReDomain.getGoodsNo() + spScontractGoodsReDomain.getGinfoCode());
                        if (StringUtils.isBlank((String)ContractBillcodeListStr)) {
                            addProcessContractBillcode.put(spScontractGoodsReDomain.getGoodsNo() + spScontractGoodsReDomain.getGinfoCode(), ocContractGoodsReDomain.getContractBillcode());
                        } else if (!ContractBillcodeListStr.contains(ocContractGoodsReDomain.getContractBillcode())) {
                            ContractBillcodeListStr = ContractBillcodeListStr + "," + ocContractGoodsReDomain.getContractBillcode();
                            addProcessContractBillcode.put(spScontractGoodsReDomain.getGoodsNo() + spScontractGoodsReDomain.getGinfoCode(), ContractBillcodeListStr);
                        }
                        spScontractGoodsReDomains.add(spScontractGoodsReDomain);
                        continue;
                    }
                    if (!ObjectUtils.isEmpty((Object)ocContractGoodsReDomain.getGoodsCamount())) {
                        goodsCamount = goodsCamount.add(ocContractGoodsReDomain.getGoodsCamount());
                    }
                    if (!ObjectUtils.isEmpty((Object)ocContractGoodsReDomain.getContractGoodsSendnum())) {
                        contractGoodsSendnum = contractGoodsSendnum.add(ocContractGoodsReDomain.getContractGoodsSendnum());
                    }
                    if (ObjectUtils.isEmpty((Object)ocContractGoodsReDomain.getContractGoodsRefnum())) continue;
                    contractGoodsRefnum = contractGoodsRefnum.add(ocContractGoodsReDomain.getContractGoodsRefnum());
                }
                spScontractGoodsReDomain.setGoodsCamount(goodsCamount);
                spScontractGoodsReDomain.setScontractGoodsRefnum(contractGoodsRefnum);
                if (!StringUtils.isBlank((String)spScontractGoodsReDomain.getScontractGoodsRemark()) && "3".equals(spScontractGoodsReDomain.getScontractGoodsRemark())) continue;
                BigDecimal goodsNum = spScontractGoodsReDomain.getGoodsNum();
                BigDecimal lastNum = goodsNum.subtract(goodsCamount);
                spScontractGoodsReDomain.setContractGoodsSendnum(lastNum);
                continue;
            }
            if ("3".equals(spScontractGoodsReDomain.getScontractGoodsRemark())) continue;
            spScontractGoodsReDomain.setGoodsCamount(new BigDecimal(BigInteger.ZERO));
            spScontractGoodsReDomain.setScontractGoodsRefnum(new BigDecimal(BigInteger.ZERO));
            spScontractGoodsReDomain.setContractGoodsSendnum(spScontractGoodsReDomain.getGoodsNum());
        }
    }

    private void calculateAbnormal(List<SpScontractGoodsReDomain> spScontractGoodsReDomainList, List<SpScontractGoodsReDomain> spScontractGoodsReDomains, Map<String, String> addProcessContractBillcode) {
        if (CollectionUtils.isNotEmpty(spScontractGoodsReDomainList)) {
            for (SpScontractGoodsReDomain spScontractGoodsReDomain : spScontractGoodsReDomainList) {
                for (SpScontractGoodsReDomain scontractGoodsReDomain : spScontractGoodsReDomains) {
                    if (!scontractGoodsReDomain.getGoodsNo().equals(spScontractGoodsReDomain.getGoodsNo()) || "3".equals(spScontractGoodsReDomain.getScontractGoodsRemark())) continue;
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("goodsNo", spScontractGoodsReDomain.getGoodsNo());
                    param.put("ginfoCode", spScontractGoodsReDomain.getGinfoCode());
                    SupQueryResult<SgSendgoodsGoodsReDomain> sgSendgoodsGoodsQueryResult = this.sgSendgoodsService.querySendgoodsGoodsPage(param);
                    if (ObjectUtils.isEmpty(sgSendgoodsGoodsQueryResult) || !CollectionUtils.isNotEmpty((Collection)sgSendgoodsGoodsQueryResult.getList())) continue;
                    BigDecimal totalArefnum = new BigDecimal(BigInteger.ZERO);
                    BigDecimal goodsCamount = new BigDecimal(BigInteger.ZERO);
                    for (SgSendgoodsGoodsReDomain sgSendgoodsGoods : sgSendgoodsGoodsQueryResult.getList()) {
                        String ContractBillcodeListStr;
                        String msg = "ContractBillcode: " + sgSendgoodsGoods.getContractBillcode() + " ,goodsNo: " + sgSendgoodsGoods.getGoodsNo() + " ,sgSendgoodsGoods.getPricesetCurrency1: " + sgSendgoodsGoods.getPricesetCurrency1() + " ,contractGoodsArefnum: " + sgSendgoodsGoods.getContractGoodsArefnum() + " , goodsNum: " + sgSendgoodsGoods.getGoodsNum();
                        this.logger.info(CODE + ".sgSendgoodsGoodsQueryResult.msg", (Object)msg);
                        if (!"2".equals(sgSendgoodsGoods.getPricesetCurrency1()) || StringUtils.isBlank((String)(ContractBillcodeListStr = addProcessContractBillcode.get(spScontractGoodsReDomain.getGoodsNo() + scontractGoodsReDomain.getGinfoCode()))) || !ContractBillcodeListStr.contains(sgSendgoodsGoods.getContractBillcode())) continue;
                        if (!ObjectUtils.isEmpty((Object)sgSendgoodsGoods.getContractGoodsArefnum())) {
                            totalArefnum = totalArefnum.add(sgSendgoodsGoods.getContractGoodsArefnum());
                        }
                        if (ObjectUtils.isEmpty((Object)sgSendgoodsGoods.getGoodsNum())) continue;
                        goodsCamount = goodsCamount.add(sgSendgoodsGoods.getGoodsNum());
                    }
                    BigDecimal goodsCamountNow = spScontractGoodsReDomain.getGoodsCamount();
                    if (!ObjectUtils.isEmpty((Object)goodsCamountNow)) {
                        goodsCamount = goodsCamountNow.add(goodsCamount);
                    }
                    spScontractGoodsReDomain.setGoodsCamount(goodsCamount);
                    BigDecimal scontractGoodsRefnumNow = spScontractGoodsReDomain.getScontractGoodsRefnum();
                    if (!ObjectUtils.isEmpty((Object)scontractGoodsRefnumNow)) {
                        totalArefnum = scontractGoodsRefnumNow.add(totalArefnum);
                    }
                    spScontractGoodsReDomain.setScontractGoodsRefnum(totalArefnum);
                    BigDecimal goodsNum = spScontractGoodsReDomain.getGoodsNum();
                    BigDecimal lastNum = goodsNum.subtract(goodsCamount);
                    spScontractGoodsReDomain.setContractGoodsSendnum(lastNum);
                }
            }
        }
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error(CODE + ".updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractService.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }

    @RequestMapping(value={"queryScontractGoodsPageStr.json"}, name="\u67e5\u8be2\u7279\u4ef7")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageStr(HttpServletRequest request) {
        String resultStr;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (StringUtils.isNotBlank((String)(resultStr = this.setUserMapStr(request, param)))) {
            return new SupQueryResult();
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        this.logger.info(CODE + "makeExcelData.json", (Object)json);
        this.logger.info(CODE + "makeExcelData.excelTemplate", (Object)excelTemplate);
        this.logger.info(CODE + "makeExcelData.apiRouter", (Object)apiRouter);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if ("spScontractGoodsExport".equals(excelTemplate)) {
            List spScontractGoodsList = JsonUtil.buildNormalBinder().getJsonToList(json, SpScontractGoods.class);
            if (ListUtil.isEmpty((Collection)spScontractGoodsList)) {
                this.logger.error(CODE + "makeExcelData.is.null!");
                return null;
            }
            for (SpScontractGoods spScontractGoods : spScontractGoodsList) {
                Map spScontractGoodsMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)spScontractGoods), String.class, Object.class);
                mapList.add(spScontractGoodsMap);
            }
        }
        this.logger.info(CODE + "makeExcelData.apiRouter", mapList);
        return mapList;
    }
}

