/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.core.util;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SupResourceUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(SupResourceUtil.class);
    private static String PATH = "appres.path";
    private static ResourceBundle resourceBundle = null;
    private static ResourceBundle outResourceBundle = null;
    private static Object obj = new Object();

    public static String getOut(String resourceName, String path, String key) {
        ResourceBundle rb = SupResourceUtil.getOutResourceBundle(resourceName, path);
        if (null == rb) {
            logger.error("ResourceUtil.getOut.null", (Object)("resourceName:" + resourceName + ",path:" + path + ",key:" + key));
            return null;
        }
        return SupResourceUtil.getResourceString(rb, key);
    }

    public static String getIn(String resourceName, String key) {
        ResourceBundle rb = SupResourceUtil.getResourceBundle(resourceName);
        if (null == rb) {
            logger.error("ResourceUtil.getIn.null", (Object)("resourceName:" + resourceName + ",key:" + key));
            return null;
        }
        return SupResourceUtil.getResourceString(rb, key);
    }

    private static String getResourceString(ResourceBundle rb, String key) {
        String value = null;
        try {
            value = rb.getString(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static String getAll(String resourceName, String path, String key) {
        String vl = SupResourceUtil.getOut(resourceName, path, key);
        if (null == vl) {
            vl = SupResourceUtil.getIn(resourceName, key);
        }
        return vl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResourceBundle(String resourceName) {
        Object object = obj;
        synchronized (object) {
            if (null == resourceBundle) {
                resourceBundle = ResourceBundle.getBundle(resourceName);
            }
            return resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getOutResourceBundle(String resourceName, String path) {
        if (StringUtils.isBlank((String)path)) {
            path = PATH;
        }
        Object object = obj;
        synchronized (object) {
            if (null == outResourceBundle) {
                ResourceBundle r = ResourceBundle.getBundle(resourceName);
                if (StringUtils.isBlank((String)r.getString(path))) {
                    outResourceBundle = r;
                    return outResourceBundle;
                }
                InputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(r.getString(path)));
                    outResourceBundle = new PropertyResourceBundle(in);
                }
                catch (Exception e) {
                    logger.error("ResourceUtil", (Object)"e", (Throwable)e);
                }
                finally {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.error("ResourceUtil", (Object)"e1", (Throwable)e);
                        }
                    }
                }
                return outResourceBundle;
            }
            return outResourceBundle;
        }
    }
}

