/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class ExportExcelUtlis {
    public static void exportExcel(HSSFSheet sheet, HSSFRow row, String[] headers, List<Object[]> dataset, String pattern, int index) throws IOException {
        HSSFCellStyle numberStyle = sheet.getWorkbook().createCellStyle();
        numberStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"General"));
        numberStyle.setAlignment((short)1);
        HSSFCellStyle integerStyle = sheet.getWorkbook().createCellStyle();
        integerStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0"));
        integerStyle.setAlignment((short)1);
        HSSFCellStyle decimalStyle = sheet.getWorkbook().createCellStyle();
        decimalStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.##############"));
        decimalStyle.setAlignment((short)1);
        Iterator<Object[]> it = dataset.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Object[] obj = it.next();
            for (short i = 0; i < obj.length; i = (short)(i + 1)) {
                HSSFCell cell = row.createCell(i);
                Object value = obj[i];
                String textValue = null;
                if (!"".equals(value) && value != null) {
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                        continue;
                    }
                    if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        cell.setCellValue((double)fValue);
                        continue;
                    }
                    if (value instanceof Double) {
                        double dValue = (Double)value;
                        cell.setCellValue(dValue);
                        continue;
                    }
                    if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                        continue;
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        if (null == pattern || pattern.equals("")) {
                            pattern = "yyyy-MM-dd";
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                        cell.setCellValue(textValue);
                        continue;
                    }
                    String text = value.toString().trim();
                    try {
                        BigDecimal bValue = new BigDecimal(text);
                        BigDecimal cleaned = bValue.stripTrailingZeros();
                        if (cleaned.scale() <= 0) {
                            cell.setCellValue((double)cleaned.longValue());
                            cell.setCellStyle(integerStyle);
                            continue;
                        }
                        cell.setCellValue(cleaned.doubleValue());
                        cell.setCellStyle(decimalStyle);
                    }
                    catch (NumberFormatException e) {
                        textValue = value.toString();
                        cell.setCellValue(textValue);
                    }
                    continue;
                }
                cell.setCellValue("");
            }
        }
        sheet.setDefaultRowHeight((short)512);
        sheet.setDefaultColumnWidth(17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        FileInputStream in = null;
        try {
            byte[] data;
            in = new FileInputStream(filePath);
            byte[] byArray = data = ExportExcelUtlis.toByteArray(in);
            return byArray;
        }
        finally {
            if (null != in) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }
}

