/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.st;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcCflowReDomain;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcPackageDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.org.OrgCompanyReDomain;
import cn.com.qj.bff.domain.st.StSaleminnumDomain;
import cn.com.qj.bff.domain.st.StSaleminnumReDomain;
import cn.com.qj.bff.service.org.OrgCompanyService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StSaleminnumService
extends SupperFacade {
    public static final String stkey = "Saleminnum-ChannelCode-TenantCode";
    public static final String ALL = "all";
    public static final String CODE = "StSaleminnumService";
    public static final String CACHE_KEY_CFLOW = "ocProtCflow";
    @Autowired
    private OrgCompanyService orgCompanyService;

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    public boolean checkSaleminnum(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getSaleminnum()) || "0".equals(typeBean.getSaleminnum());
    }

    public HtmlJsonReBean makeSaleminnum(String json, UserSession userSession) {
        return this.checkSaleminnumTypeBean(json, userSession);
    }

    private HtmlJsonReBean checkSaleminnumTypeBean(String json, UserSession userSession) {
        String memberCode;
        TypeBean typeBean;
        List ocContractDomainList = JsonUtil.buildNormalBinder().getJsonToList(json, OcContractDomain.class);
        if (ListUtil.isEmpty((Collection)ocContractDomainList) || null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d77\u9001\u91cf\u53c2\u6570\u9519\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (ListUtil.isEmpty(((OcContractDomain)ocContractDomainList.get(0)).getPackageList()) || ListUtil.isEmpty(((OcContractDomain)ocContractDomainList.get(0)).getPackageList().get(0).getContractGoodsList())) {
            return htmlJsonReBean;
        }
        String channelCode = ((OcContractDomain)ocContractDomainList.get(0)).getChannelCode();
        String tenantCode = ((OcContractDomain)ocContractDomainList.get(0)).getTenantCode();
        String type = ((OcContractDomain)ocContractDomainList.get(0)).getContractType();
        if (StringUtils.isBlank((String)type)) {
            type = ((OcContractDomain)ocContractDomainList.get(0)).getPackageList().get(0).getContractGoodsList().get(0).getGoodsType();
        }
        if (!this.checkSaleminnum(typeBean = this.getOcSetting(type, tenantCode))) {
            this.logger.error("StSaleminnumService.typeBean.true");
            return htmlJsonReBean;
        }
        String goodsClass = ((OcContractDomain)ocContractDomainList.get(0)).getPackageList().get(0).getContractGoodsList().get(0).getGoodsClass();
        List<StSaleminnumDomain> saleminnumList = this.getSaleminnum(channelCode, goodsClass, tenantCode, memberCode = userSession.getUserinfoParentCode(), userSession);
        if (ListUtil.isEmpty(saleminnumList)) {
            this.logger.error("StSaleminnumServicec", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
            this.logger.error("StSaleminnumService.channelCode :", (Object)channelCode);
            this.logger.error("StSaleminnumService.ocContractDomain", (Object)json);
            return htmlJsonReBean;
        }
        StSaleminnumDomain stSaleminnumDomain = StSaleminnumService.checkSaleminnum(saleminnumList, userSession);
        if (null == stSaleminnumDomain) {
            return htmlJsonReBean;
        }
        htmlJsonReBean.setDataObj((Object)stSaleminnumDomain);
        BigDecimal goodsMoneySum = new BigDecimal(0);
        BigDecimal goodsCweightSum = new BigDecimal(0);
        BigDecimal goodsCamount = new BigDecimal(0);
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            for (OcPackageDomain packageList : ocContractDomain.getPackageList()) {
                for (OcContractGoodsDomain ocContractGoodsDomain : packageList.getContractGoodsList()) {
                    if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsGtype()) && "1".equals(ocContractGoodsDomain.getContractGoodsGtype())) continue;
                    goodsMoneySum = goodsMoneySum.add(ocContractGoodsDomain.getPricesetNprice().multiply(ocContractGoodsDomain.getGoodsCamount()));
                    goodsCweightSum = goodsCweightSum.add(ocContractGoodsDomain.getGoodsCweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
                    goodsCamount = goodsCamount.add(ocContractGoodsDomain.getGoodsCamount());
                }
            }
        }
        return this.htmlJsonReBean(goodsMoneySum, goodsCweightSum, goodsCamount, stSaleminnumDomain, userSession);
    }

    private HtmlJsonReBean htmlJsonReBean(BigDecimal goodsMoneySum, BigDecimal goodsCweightSum, BigDecimal goodsCamount, StSaleminnumDomain stSaleminnumDomain, UserSession userSession) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        htmlJsonReBean.setDataObj((Object)stSaleminnumDomain);
        if ("0".equals(stSaleminnumDomain.getSaleminnumNumtype()) ? goodsCweightSum.compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1 : ("1".equals(stSaleminnumDomain.getSaleminnumNumtype()) ? goodsMoneySum.compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1 : "2".equals(stSaleminnumDomain.getSaleminnumNumtype()) && goodsCamount.compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1)) {
            return htmlJsonReBean;
        }
        if (!"3".equals(stSaleminnumDomain.getSaleminnumType()) && this.checkContractSum(userSession, stSaleminnumDomain)) {
            return htmlJsonReBean;
        }
        htmlJsonReBean.setErrorCode("2");
        return htmlJsonReBean;
    }

    private List<StSaleminnumDomain> getSaleminnum(String channelCode, String goodsClass, String tenantCode, String memberCode, UserSession userSession) {
        String key = null;
        if (StringUtils.isNotBlank((String)memberCode)) {
            key = memberCode;
        }
        if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isBlank((String)key)) {
            key = channelCode;
        }
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)key)) {
            key = goodsClass;
        }
        if (StringUtils.isBlank((String)key)) {
            key = ALL;
        }
        this.logger.error("StSaleminnumService.getSaleminnum.key", (Object)key);
        List saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(key + "-" + tenantCode), StSaleminnumDomain.class);
        if (ListUtil.isEmpty((Collection)saleminnumList)) {
            this.logger.error("StSaleminnumService.getSaleminnum.qualityQtypeCode");
            String qualityQtypeCode = userSession.getQualityQtypeCode();
            if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
                this.logger.error("StSaleminnumService.getSaleminnum.qualityQtypeCode", (Object)qualityQtypeCode);
                saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(qualityQtypeCode + "-" + tenantCode), StSaleminnumDomain.class);
            }
        }
        if (ListUtil.isEmpty((Collection)saleminnumList)) {
            this.logger.error("StSaleminnumService.getSaleminnum.companyShortcode");
            String companyCode = userSession.getCompanyCode();
            if (StringUtils.isNotBlank((String)companyCode)) {
                HashMap<String, Object> companyMap = new HashMap<String, Object>();
                companyMap.put("companyCode", companyCode);
                companyMap.put("tanantCode", userSession.getTenantCode());
                SupQueryResult<OrgCompanyReDomain> supQueryResult = this.orgCompanyService.queryCompanyPage(companyMap);
                if (null != supQueryResult || ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    String companyShortcode = ((OrgCompanyReDomain)supQueryResult.getList().get(0)).getCompanyShortcode();
                    this.logger.error("StSaleminnumService.getSaleminnum.companyShortcode", (Object)companyShortcode);
                    saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(companyShortcode + "-" + tenantCode), StSaleminnumDomain.class);
                }
            }
        }
        if (ListUtil.isEmpty((Collection)saleminnumList) && !ALL.equals(key)) {
            this.logger.error("StSaleminnumService.getSaleminnum.ALL");
            saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)("all-" + tenantCode), StSaleminnumDomain.class);
        }
        return saleminnumList;
    }

    public HtmlJsonReBean makeSaleminnum(String ocContractDomainJson, UserSession userSession, String channelCode, String tenantCode) {
        String memberCode;
        TypeBean typeBean;
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractDomainJson, OcContractDomain.class);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (ListUtil.isEmpty(ocContractDomain.getPackageList()) || ListUtil.isEmpty(ocContractDomain.getPackageList().get(0).getContractGoodsList())) {
            return htmlJsonReBean;
        }
        String type = ocContractDomain.getContractType();
        if (StringUtils.isBlank((String)type)) {
            type = ocContractDomain.getPackageList().get(0).getContractGoodsList().get(0).getGoodsType();
        }
        if (!this.checkSaleminnum(typeBean = this.getOcSetting(type, tenantCode))) {
            return htmlJsonReBean;
        }
        if (null == ocContractDomain || null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d77\u9001\u91cf\u53c2\u6570\u9519\u8bef");
        }
        String goodsClass = ocContractDomain.getPackageList().get(0).getContractGoodsList().get(0).getGoodsClass();
        List<StSaleminnumDomain> saleminnumList = this.getSaleminnum(channelCode, goodsClass, tenantCode, memberCode = userSession.getUserinfoParentCode(), userSession);
        if (ListUtil.isEmpty(saleminnumList)) {
            this.logger.error("StSaleminnumService.userSession", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
            this.logger.error("StSaleminnumService.channelCode :", (Object)channelCode);
            this.logger.error("StSaleminnumService.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return htmlJsonReBean;
        }
        StSaleminnumDomain stSaleminnumDomain = StSaleminnumService.checkSaleminnum(saleminnumList, userSession);
        if (null == stSaleminnumDomain) {
            return htmlJsonReBean;
        }
        BigDecimal goodsMoneySum = new BigDecimal(0);
        BigDecimal goodsCweightSum = new BigDecimal(0);
        BigDecimal goodsCamount = new BigDecimal(0);
        for (OcPackageDomain packageList : ocContractDomain.getPackageList()) {
            for (OcContractGoodsDomain ocContractGoodsDomain : packageList.getContractGoodsList()) {
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsGtype()) && "1".equals(ocContractGoodsDomain.getContractGoodsGtype())) continue;
                goodsMoneySum = goodsMoneySum.add(ocContractGoodsDomain.getPricesetNprice().multiply(ocContractGoodsDomain.getGoodsCamount()));
                goodsCweightSum = goodsCweightSum.add(ocContractGoodsDomain.getGoodsCweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
                goodsCamount = goodsCamount.add(ocContractGoodsDomain.getGoodsCamount());
            }
        }
        return this.htmlJsonReBean(goodsMoneySum, goodsCweightSum, goodsCamount, stSaleminnumDomain, userSession);
    }

    private boolean checkContractSum(UserSession userSession, StSaleminnumDomain stSaleminnumDomain) {
        BigDecimal sumDataBmoney;
        BigDecimal sumDataBweight;
        String startDate = this.getStartDate(stSaleminnumDomain);
        String endDate = DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm");
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("startDate", startDate);
        ocMap.put("endDate", endDate);
        ocMap.put("memberBcode", userSession.getUserPcode());
        ocMap.put("tenantCode", userSession.getTenantCode());
        ocMap.put("dateState", "2,3,4");
        HtmlJsonReBean htmlJsonReBean = this.saveSaleminnum(ocMap);
        if (null == htmlJsonReBean.getDataObj()) {
            return false;
        }
        Map map = JsonUtil.buildNormalBinder().getJsonToMap(htmlJsonReBean.getDataObj().toString(), String.class, Object.class);
        return "0".equals(stSaleminnumDomain.getSaleminnumNumtype()) ? (sumDataBweight = BigDecimal.valueOf((Double)map.get("sumDataBweight"))).compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1 : ("1".equals(stSaleminnumDomain.getSaleminnumNumtype()) ? (sumDataBmoney = BigDecimal.valueOf((Double)map.get("sumDataBmoney"))).compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1 : "2".equals(stSaleminnumDomain.getSaleminnumNumtype()) && (sumDataBmoney = BigDecimal.valueOf((Double)map.get("goodsCamount"))).compareTo(stSaleminnumDomain.getSaleminnumNum()) > -1);
    }

    public String getStartDate(StSaleminnumDomain stSaleminnumDomain) {
        Date date = new Date();
        String startDate = null;
        Date currentHour = DateUtil.dateToDate((Date)new Date(), (String)"HH:mm");
        String endDate1 = DateUtil.getEndDate((Date)new Date(), (int)0, (int)-1, (String)"yyyy-MM-dd");
        if ("0".equals(stSaleminnumDomain.getSaleminnumType())) {
            Date saleminnumHour = DateUtil.getDateToString((String)stSaleminnumDomain.getSaleminnumValue(), (String)"HH:mm");
            startDate = saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + stSaleminnumDomain.getSaleminnumValue() : DateUtil.getEndDate((Date)date, (int)0, (int)-1, (String)"yyyy-MM-dd") + " " + stSaleminnumDomain.getSaleminnumValue();
        } else if ("1".equals(stSaleminnumDomain.getSaleminnumType())) {
            String[] split = stSaleminnumDomain.getSaleminnumValue().split(";");
            int saleminnumWeek = Integer.valueOf(split[0]);
            String hours = split[1];
            Date saleminnumHour = DateUtil.getDateToString((String)split[1], (String)"HH:mm");
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int week_index = cal.get(7) - 1;
            if (week_index < 0) {
                week_index = 0;
            }
            startDate = saleminnumWeek == week_index ? (saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)0, (int)-7, (String)"yyyy-MM-dd") + " " + hours) : (saleminnumWeek > week_index ? DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumWeek - week_index - 7), (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumWeek - week_index), (String)"yyyy-MM-dd") + " " + hours);
        } else if ("2".equals(stSaleminnumDomain.getSaleminnumType())) {
            String[] split = stSaleminnumDomain.getSaleminnumValue().split(";");
            int saleminnumDay = Integer.valueOf(split[0]);
            String hours = split[1];
            Date saleminnumHour = DateUtil.getDateToString((String)split[1], (String)"HH:mm");
            int day = Integer.parseInt(DateUtil.getDateString((Date)date, (String)"dd"));
            if (saleminnumDay == day) {
                startDate = saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)-1, (int)0, (String)"yyyy-MM-dd") + " " + hours;
            } else if (saleminnumDay < day) {
                startDate = DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumDay - day), (String)"yyyy-MM-dd") + " " + hours;
            } else {
                Date upmonth = DateUtil.getDateToString((String)DateUtil.getEndDate((Date)date, (int)-1, (int)0, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (saleminnumDay > 28) {
                    saleminnumDay = StSaleminnumService.getLastday(upmonth, saleminnumDay);
                }
                startDate = DateUtil.getDateString((Date)upmonth, (String)"yyyy-MM") + "-" + saleminnumDay + " " + hours;
            }
        }
        return startDate;
    }

    private static int getLastday(Date date, int saleminnumDay) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        Calendar cale = Calendar.getInstance();
        cale.setTime(date);
        cale.add(2, 1);
        cale.set(5, 0);
        Integer lastday = Integer.valueOf(format.format(cale.getTime()));
        if (lastday > saleminnumDay) {
            lastday = saleminnumDay;
        }
        return lastday;
    }

    private static StSaleminnumDomain checkSaleminnum(List<StSaleminnumDomain> saleminnumList, UserSession userSession) {
        if (ListUtil.isEmpty(saleminnumList) || null == userSession) {
            return null;
        }
        Map<String, Object> objMap = StSaleminnumService.makeObject(userSession);
        for (StSaleminnumDomain stSaleminnumDomain : saleminnumList) {
            if (StringUtils.isBlank((String)stSaleminnumDomain.getSaleminnumUpro()) || ALL.equals(stSaleminnumDomain.getSaleminnumUpro())) {
                return stSaleminnumDomain;
            }
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            ArrayList<String> list = new ArrayList<String>();
            if (StringUtils.isBlank((String)stSaleminnumDomain.getSaleminnumUprovalue())) {
                stSaleminnumDomain.setSaleminnumUprovalue(ALL);
            }
            list.add(stSaleminnumDomain.getSaleminnumUprovalue());
            map.put(stSaleminnumDomain.getSaleminnumUpro(), list);
            if (!StSaleminnumService.checkConf(map, objMap)) continue;
            return stSaleminnumDomain;
        }
        return null;
    }

    private static Map<String, Object> makeObject(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        Map obj = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)userSession), String.class, Object.class);
        return obj;
    }

    private static boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        block0: for (String keys : map.keySet()) {
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)keys);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = false;
                for (String o : otrs) {
                    if (!StSaleminnumService.cond(valueList, o)) continue;
                    flag = true;
                    continue block0;
                }
                continue;
            }
            if (StSaleminnumService.cond(valueList, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private static boolean cond(List<String> valueList, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        boolean flag = true;
        if (null == objValue) {
            objValue = "";
        }
        if (!valueList.contains(objValue.toString())) {
            flag = false;
        }
        return flag;
    }

    public HtmlJsonReBean saveSaleminnum(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("oc.contract.queryContractSum");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.saveSaleminnum");
        pmap.putParamToJson("stSaleminnumDomain", (Object)stSaleminnumDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSaleminnumBatch(List<StSaleminnumDomain> stSaleminnumDomainList) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.saveSaleminnumBatch");
        pmap.putParamToJson("stSaleminnumDomainList", stSaleminnumDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnumState(Integer saleminnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnumState");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnumStateByCode(String tenantCode, String saleminnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnumStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnum");
        pmap.putParamToJson("stSaleminnumDomain", (Object)stSaleminnumDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<StSaleminnumReDomain> querySaleminnumPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.querySaleminnumPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, StSaleminnumReDomain.class);
    }

    public StSaleminnumReDomain getSaleminnumByCode(String tenantCode, String saleminnumCode) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.getSaleminnumByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        return (StSaleminnumReDomain)this.htmlIBaseService.senReObject(pmap, StSaleminnumReDomain.class);
    }

    public HtmlJsonReBean deleteSaleminnum(Integer saleminnumId) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.deleteSaleminnum");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSaleminnumByCode(String tenantCode, String saleminnumCode) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.deleteSaleminnumByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public StSaleminnumReDomain getSaleminnum(Integer saleminnumId) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.getSaleminnum");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        return (StSaleminnumReDomain)this.htmlIBaseService.senReObject(pmap, StSaleminnumReDomain.class);
    }

    public HtmlJsonReBean querySaleminnumLoadCache() {
        PostParamMap pmap = new PostParamMap("st.saleminnum.querySaleminnumLoadCache");
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

