/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.at;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.at.AtAuctionEnrollDomain;
import cn.com.qj.bff.domain.at.AtAuctionEnrollReDomain;
import cn.com.qj.bff.domain.at.AtAuctionEnrollfileDomain;
import cn.com.qj.bff.domain.at.AtAuctionGinfoReDomain;
import cn.com.qj.bff.domain.at.AtAuctionMemReDomain;
import cn.com.qj.bff.domain.at.AtAuctionReDomain;
import cn.com.qj.bff.domain.at.AtAuctionUserginfoReDomain;
import cn.com.qj.bff.domain.at.AtAuctionWinReDomain;
import cn.com.qj.bff.domain.at.AtAuctiondtReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.vd.VdFaccountInfo;
import cn.com.qj.bff.domain.vd.VdFaccountOuterSubsetDomain;
import cn.com.qj.bff.service.at.AtAuctionEnrollService;
import cn.com.qj.bff.service.at.AtAuctionService;
import cn.com.qj.bff.service.at.AtAuctionUserginfoService;
import cn.com.qj.bff.service.at.AtAuctionWinService;
import cn.com.qj.bff.service.at.AtAuctiondtService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.vd.VdFaccountOuterService;
import cn.com.qj.bff.service.vd.VdFaccountService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionEnroll"}, name="\u7ade\u4ef7\u62a5\u540d")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "at.auctionEnroll.con";
    @Autowired
    private AtAuctionEnrollService atAuctionEnrollService;
    @Autowired
    private AtAuctiondtService atAuctiondtService;
    @Autowired
    private AtAuctionService atAuctionService;
    @Autowired
    private AtAuctionUserginfoService atAuctionUserginfoService;
    @Autowired
    private AtAuctionWinService atAuctionWinService;
    @Autowired
    private VdFaccountOuterService vdFaccountOuterService;
    @Autowired
    private VdFaccountService vdFaccountService;
    @Autowired
    private UserService userService;

    @Override
    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getMerberCompname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        if (!this.checkUserinfoTypePermis(userSession, tenantCode, auctionCode, atAuctionReDomain)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        if (!this.permisAuction(memberBcode, auctionCode, tenantCode)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if ("1".equals(atAuctionEnrollDomain.getAuctionEnrollType()) && date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        atAuctionEnrollDomain.setAuctionQutinfo(atAuctionReDomain.getAuctionQutinfo());
        return this.atAuctionEnrollService.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    private boolean checkUserinfoTypePermis(UserSession userSession, String tenantCode, String auctionCode, AtAuctionReDomain atAuctionReDomain) {
        String auctionMemType;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        SupQueryResult<AtAuctionMemReDomain> atAuctionMemResult = this.atAuctionService.queryatAuctionMemPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionMemResult.getList()) && !"0".equals(auctionMemType = ((AtAuctionMemReDomain)atAuctionMemResult.getList().get(0)).getAuctionMemType()) && !auctionMemType.equals(userSession.getUserinfoType())) {
            return false;
        }
        return !userSession.getUserPcode().equals(atAuctionReDomain.getMemberCcode());
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u62a5\u540d\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        return this.atAuctionEnrollService.getatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionEnrollService.updateatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"updateAuctionEnrollToSubmit.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollToSubmit(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateAuctionEnrollToSubmit", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List atAuctionEnrollfileDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionEnrollfileDomain.class);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollfileDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollDomain = this.atAuctionEnrollService.getatAuctionEnrollByCode(this.getTenantCode(request), ((AtAuctionEnrollfileDomain)atAuctionEnrollfileDomainList.get(0)).getAuctionEnrollCode());
        if (null == atAuctionEnrollDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (2 == atAuctionEnrollDomain.getAuctionEnrollDstate()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fdd\u8bc1\u91d1\u5ba1\u6838\u5931\u8d25,\u6682\u65e0\u8d44\u683c\u91cd\u65b0\u63d0\u4ea4");
        }
        atAuctionEnrollDomain.setAtAuctionEnrollfileDomainList(atAuctionEnrollfileDomainList);
        atAuctionEnrollDomain.setAuctionEnrollQstate(0);
        ((AtAuctionEnrollDomain)atAuctionEnrollDomain).setDataState(0);
        return this.atAuctionEnrollService.updateatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollService.deleteatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollfileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollService.updateatAuctionEnrollState(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionEnrollForAt.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryAuctionBiddingEnrollForAt.json"}, name="\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionBiddingEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"saveAuctionEnrollByStr.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnrollByStr(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        AtAuctionEnrollDomain atAuctionEnrollDomain = (AtAuctionEnrollDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionEnrollDomain.class);
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getMerberCompname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        Integer ruleDpType = atAuctionEnrollDomain.getAuctionruleDptype();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        if (!this.checkUserinfoTypePermis(userSession, tenantCode, auctionCode, atAuctionReDomain)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        if (!this.permisAuction(memberBcode, auctionCode, tenantCode)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if ("1".equals(atAuctionEnrollDomain.getAuctionEnrollType()) && date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        if ("01".equals(atAuctionReDomain.getAuctionType()) && 2 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u573a\u6b21\u5df2\u7ed3\u675f\uff01");
        }
        if ("02".equals(atAuctionReDomain.getAuctionType())) {
            HashMap<String, Object> parMap = new HashMap<String, Object>();
            parMap.put("auctionCode", auctionCode);
            parMap.put("tenantCode", tenantCode);
            parMap.put("fuzzy", true);
            List ginfoReDomains = this.atAuctionService.queryatAuctionGinfoPage(parMap).getList();
            if (ListUtil.isEmpty((Collection)ginfoReDomains)) {
                return new HtmlJsonReBean("error", "\u5305\u88f9\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            Integer gInfoDataState = ((AtAuctionGinfoReDomain)ginfoReDomains.get(0)).getDataState();
            if (2 == atAuctionReDomain.getDataState() && 2 == gInfoDataState) {
                return new HtmlJsonReBean("error", "\u7ade\u4ef7\u573a\u6b21\u5df2\u7ed3\u675f\uff01");
            }
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setAuctionQutinfo(atAuctionReDomain.getAuctionQutinfo());
        atAuctionEnrollDomain.setMemberBname(memberBname);
        atAuctionEnrollDomain.setAuctionruleDptype(ruleDpType);
        atAuctionEnrollDomain.setDataState(0);
        return this.atAuctionEnrollService.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"queryAuctionEnrollForPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u5e73\u53f0\u62a5\u540d\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "0");
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditQstate.json"}, name="\u5ba1\u6838\u8d44\u8d28")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditQstate(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionEnrollService.updateAuctionEnrollAuditQstateNew(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateByTrans.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateByTrans(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId, String phone) {
        String tenantCode;
        String userCode;
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState || StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)phone)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        HtmlJsonReBean htmlJsonReBean = this.atAuctionEnrollService.sendUpdateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, auctionAuremark, auctionDtId, phone, userName, userCode = userSession.getUserPcode(), tenantCode = this.getTenantCode(request));
        if (null == htmlJsonReBean.getDataObj()) {
            return new HtmlJsonReBean("error", "\u5ba1\u6838\u5931\u8d25");
        }
        if ("\u8d26\u6237\u5f02\u5e38\u6216\u53ef\u7528\u4f59\u989d\u4e0d\u8db3".equals(htmlJsonReBean.getDataObj())) {
            return new HtmlJsonReBean("error", "\u8d26\u6237\u5f02\u5e38\u6216\u53ef\u7528\u4f59\u989d\u4e0d\u8db3");
        }
        return new HtmlJsonReBean("\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturn.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturn(HttpServletRequest request, String auctionDtId) {
        Map<String, Object> map = this.assemMapParam(request);
        String memo = map.get("memo").toString();
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, null, memo);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturnFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturnFail(HttpServletRequest request, String auctionDtId) {
        Map<String, Object> map = this.assemMapParam(request);
        String memo = map.get("memo").toString();
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, "returnFail", memo);
    }

    private HtmlJsonReBean updateAuctionEnrollAuditByReturCom(HttpServletRequest request, String auctionDtId, String phone, String memo) {
        if (StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)auctionDtId)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        return this.atAuctionEnrollService.updateAuctionEnrollAuditByReturn(auctionDtId, phone, userName, userCode, tenantCode, memo);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateFail(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId) {
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState) {
            return new HtmlJsonReBean("error", "param is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionEnrollAuditDstateFail", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (dataState == 2) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
            paramMap.put("memberBcode", atAuctionEnrollReDomain.getMemberBcode());
            paramMap.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
            List atAuctiondtReDomains = this.atAuctiondtService.queryAuctiondtPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)atAuctiondtReDomains)) {
                this.logger.error(CODE + ".updateAuctionEnrollAuditDstateFail", (Object)"atAuctiondtReDomains is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "atAuctiondtReDomains is null");
            }
            paramMap.remove("auctionCode");
            paramMap.remove("memberBcode");
            paramMap.remove("tenantCode");
            paramMap.put("userCode", userCode);
            paramMap.put("userName", userName);
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomains) {
                if (atAuctiondtReDomain.getDataState() != 0) continue;
                this.atAuctiondtService.updateAuctiondtState(atAuctiondtReDomain.getAuctionDtId(), 2, 0, paramMap);
            }
            atAuctionEnrollReDomain.setAuctionEnrollQstate(2);
            atAuctionEnrollReDomain.setAuctionEnrollDstate(2);
            atAuctionEnrollReDomain.setDataState(2);
            atAuctionEnrollReDomain.setUserCode(userCode);
            atAuctionEnrollReDomain.setUserName(userName);
            return this.atAuctionEnrollService.updateatAuctionEnroll(atAuctionEnrollReDomain);
        }
        return this.atAuctionEnrollService.sendUpdateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, auctionAuremark, auctionDtId, null, userName, userCode, tenantCode);
    }

    @RequestMapping(value={"getAuctionEnrollForPaasAt.json"}, name="\u7ade\u4ef7\u5ba1\u6838\u9875\u9762")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnrollForPaasAt(String auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnroll(Integer.valueOf(auctionEnrollId));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("memberBcode", atAuctionEnrollReDomain.getMemberBcode());
        map.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
        map.put("auctionDtType", "0,1");
        map.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
        atAuctionEnrollReDomain.setAtAuctiondtReDomainList(this.atAuctiondtService.queryAuctiondtPage(map).getList());
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForAtPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAtPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"checkEnrollAndDt.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAndDt(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(map);
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(map);
        boolean checkEnroll = false;
        boolean checkDt = false;
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            checkDt = true;
        }
        return new HtmlJsonReBean("checkEnroll:" + checkEnroll + ",checkDt:" + checkDt);
    }

    @RequestMapping(value={"checkEnrollAtSign.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d(\u5355\u54c1)")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAtSign(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("fuzzy", true);
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(map);
        boolean checkEnroll = false;
        this.logger.info(CODE + ".updateAuctionState.\u68c0\u67e5\u662f\u5426\u62a5\u540d(\u5355\u54c1)atAuctionEnrollResult\uff1a", (Object)(atAuctionEnrollResult.getTotal() + "," + map));
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        return new HtmlJsonReBean("checkEnroll:" + checkEnroll);
    }

    @RequestMapping(value={"getEnrollTypeAndDt.json"}, name="\u83b7\u53d6\u7528\u6237\u62a5\u540dcheck\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain checkEnrollTypeAndDt(HttpServletRequest request, String auctionCode, String auctionEnrollType) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return null;
        }
        String tenantCode = userSession.getTenantCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionEnrollType", auctionEnrollType);
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = new AtAuctionEnrollReDomain();
        atAuctionEnrollReDomain.setCheckDt(false);
        atAuctionEnrollReDomain.setCheckEnroll(false);
        map.put("dataStateNot", "2");
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(map);
        map.remove("dataStateNot");
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnroll(((AtAuctionEnrollReDomain)atAuctionEnrollResult.getList().get(0)).getAuctionEnrollId());
            atAuctionEnrollReDomain.setCheckEnroll(true);
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            atAuctionEnrollReDomain.setCheckDt(true);
        }
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForPaasAt.json"}, name="\u5e73\u53f0\u62a5\u540d\u5ba1\u6838\u5217\u8868\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaasAt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", this.getTenantCode(request));
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryMyAuctionEnroll.json"}, name="\u6211\u7684\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryMyAuctionEnroll(HttpServletRequest request) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("auctionType", "01");
        param.put("memberBcode", userSession.getUserPcode());
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", tenantCode);
        param.put("EnrollQstateNot", 2);
        param.put("EnrollDstateNot", 2);
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, Object> mapp = new HashMap<String, Object>();
            AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(atAuctionEnrollReDomain.getTenantCode(), atAuctionEnrollReDomain.getAuctionCode());
            atAuctionEnrollReDomain.setMemo(atAuctionReDomain.getDataState().toString());
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            mapp.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
            SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(mapp);
            mapp.put("dataState", 1);
            SupQueryResult<AtAuctionUserginfoReDomain> atAuctionUserginfoResult = this.atAuctionUserginfoService.queryatAuctionUserginfoPage(mapp);
            mapp.remove("auctionEnrollCode");
            mapp.remove("dataState");
            atAuctionEnrollReDomain.setWinResult("weizhongbiao");
            if (ListUtil.isNotEmpty((Collection)atAuctionUserginfoResult.getList())) {
                for (AtAuctionUserginfoReDomain atAuctionUserginfo : atAuctionUserginfoResult.getList()) {
                    mapp.put("auctionGinfoCode", atAuctionUserginfo.getAuctionGinfoCode());
                    SupQueryResult<AtAuctionWinReDomain> atAuctionWinResult = this.atAuctionWinService.queryatAuctionWinPage(mapp);
                    if (!ListUtil.isNotEmpty((Collection)atAuctionWinResult.getList())) continue;
                    atAuctionEnrollReDomain.setWinResult("zhongbiao");
                    break;
                }
            }
            if (ListUtil.isEmpty((Collection)atAuctiondtResult.getList())) {
                atAuctionEnrollReDomain.setReadyTopay(0);
                continue;
            }
            if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) {
                atAuctionEnrollReDomain.setReadyTopay(1);
                continue;
            }
            atAuctionEnrollReDomain.setReadyTopay(2);
        }
        return atAuctionEnrollResult;
    }

    @RequestMapping(value={"queryMyAuctionEnrollItems.json"}, name="\u6211\u7684\u5355\u54c1\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryMyAuctionEnrollItems(HttpServletRequest request) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("auctionType", "02");
        param.put("memberBcode", userSession.getUserPcode());
        param.put("auctionEnrollType", "2");
        param.put("tenantCode", tenantCode);
        SupQueryResult<AtAuctionEnrollReDomain> enrollPageResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
        if (enrollPageResult.getTotal() > 0L) {
            HashMap<String, Object> parMap = new HashMap<String, Object>();
            for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : enrollPageResult.getList()) {
                parMap.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
                param.put("tenantCode", tenantCode);
                SupQueryResult<AtAuctionGinfoReDomain> ginfoPageResult = this.atAuctionService.queryatAuctionGinfoPage(parMap);
                if (ginfoPageResult.getTotal() <= 0L) continue;
                AtAuctionGinfoReDomain auctionGinfoReDomain = (AtAuctionGinfoReDomain)ginfoPageResult.getList().get(0);
                atAuctionEnrollReDomain.setAuctionGinfoReDomain(auctionGinfoReDomain);
            }
        }
        return enrollPageResult;
    }

    @RequestMapping(value={"queryMyAuctionEnrollReadToPay.json"}, name="\u67e5\u8be2\u6211\u7684\u7ade\u4ef7\u62a5\u540d\u4ea4\u4fdd\u72b6\u6001")
    @ResponseBody
    public List<AtAuctionEnrollReDomain> queryMyAuctionEnrollReadToPay(HttpServletRequest request, String readyTopay) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", userSession.getUserPcode());
        param.put("tenantCode", tenantCode);
        ArrayList<AtAuctionEnrollReDomain> atAuctionEnrollReDomains = new ArrayList<AtAuctionEnrollReDomain>();
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, Object> mapp = new HashMap<String, Object>();
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(mapp);
            SupQueryResult<AtAuctionUserginfoReDomain> atAuctionUserginfoResult = this.atAuctionUserginfoService.queryatAuctionUserginfoPage(mapp);
            boolean flag = false;
            switch (readyTopay) {
                case "0": {
                    if (!ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) break;
                    flag = true;
                    break;
                }
                case "1": {
                    if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) break;
                    flag = true;
                    break;
                }
                case "2": {
                    if (!ListUtil.isEmpty((Collection)atAuctiondtResult.getList()) && atAuctionUserginfoResult.getList().size() != atAuctiondtResult.getList().size()) break;
                    flag = true;
                }
            }
            if (flag) continue;
            atAuctionEnrollReDomains.add(atAuctionEnrollReDomain);
        }
        return atAuctionEnrollReDomains;
    }

    @RequestMapping(value={"queryAuctionEnrollItemByMem.json"}, name="\u67e5\u8be2\u6211\u7684\u5355\u54c1\u8d2d\u4e70\u62a5\u540d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollItemByMem(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberBcode = userSession.getUserPcode();
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", memberBcode);
        param.put("auctionEnrollType", "2");
        return this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
    }

    private boolean permisAuction(String memberBcode, String auctionCode, String tenantCode) {
        boolean flag = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<AtAuctionMemReDomain> atAuctionMemResult = this.atAuctionService.queryatAuctionMemPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionMemResult.getList())) {
            String memListStr = "";
            for (AtAuctionMemReDomain atAuctionMem : atAuctionMemResult.getList()) {
                String groupCode = atAuctionMem.getAuctionMemOpcode();
                if ("all".equals(groupCode) || !"0".equals(atAuctionMem.getAuctionMemType())) {
                    flag = true;
                    break;
                }
                String listStr = SupDisUtil.getMap((String)"UmGroup-groupCode", (String)("groupList-" + groupCode + "-" + tenantCode));
                if (StringUtils.isNotBlank((String)memListStr)) {
                    memListStr = memListStr + ",";
                }
                if (!StringUtils.isNotBlank((String)listStr)) continue;
                memListStr = memListStr + listStr;
            }
            if (memListStr.contains(memberBcode)) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    @RequestMapping(value={"getauctionNum.json"}, name="\u83b7\u53d6\u5f00\u59cb\u7ade\u4ef7\u7684\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean getauctionNum(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getauctionNum.json", (Object)"userssion is null");
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("memberBcode", memberCode);
        maps.put("tenantCode", tenantCode);
        maps.put("dataState", "3");
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollReDomainSupQueryResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(maps);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean(0);
        }
        return new HtmlJsonReBean(atAuctionEnrollReDomainSupQueryResult.getList().size());
    }

    private SupQueryResult<UmUserinfoReDomainBean> changeUserInfoBasicResultCom(SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult, String ftype) {
        if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            return null;
        }
        String memberCode = null;
        String type = null;
        String basic = null;
        String frozen = null;
        String jifen = null;
        String tenantCode = null;
        Map<String, VdFaccountInfo> vd = null;
        List<VdFaccountOuterSubsetDomain> basics = null;
        List<VdFaccountOuterSubsetDomain> frozens = null;
        List<VdFaccountOuterSubsetDomain> jifens = null;
        for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeanSupQueryResult.getList()) {
            BigDecimal vdSum;
            memberCode = umUserinfoReDomainBean.getUserinfoCode();
            type = memberCode.substring(0, 1);
            basic = "101";
            frozen = "102";
            jifen = "103";
            if ("2".equals(type)) {
                basic = "201";
                frozen = "202";
                jifen = "203";
            }
            if (!MapUtil.isNotEmpty(vd = this.getVd(memberCode, tenantCode = umUserinfoReDomainBean.getTenantCode(), null))) continue;
            if (StringUtils.isBlank((String)ftype)) {
                if (null == vd.get(basic) || null == vd.get(frozen)) continue;
                basics = vd.get(basic).getSubsetList();
                frozens = vd.get(frozen).getSubsetList();
                if (ListUtil.isEmpty(basics) || ListUtil.isEmpty(frozens)) continue;
                vdSum = new BigDecimal(0);
                BigDecimal frozenSum = new BigDecimal(0);
                for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : basics) {
                    if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType()) || null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                    vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                }
                for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : frozens) {
                    if (!"02".equals(vdFaccountOuterSubsetDomain.getFundType())) continue;
                    if (null != vdFaccountOuterSubsetDomain.getFaccountAmount()) {
                        vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                    }
                    if (null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                    frozenSum = frozenSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                }
                umUserinfoReDomainBean.setVdSum(vdSum);
                umUserinfoReDomainBean.setVdFaccountInfoMap(vd);
                umUserinfoReDomainBean.setVdFrozenSum(frozenSum);
                continue;
            }
            if (null == vd.get(jifen) || ListUtil.isEmpty(jifens = vd.get(jifen).getSubsetList())) continue;
            vdSum = new BigDecimal(0);
            for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : jifens) {
                if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType()) || null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
            }
            umUserinfoReDomainBean.setVdjifenSum(vdSum);
            umUserinfoReDomainBean.setVdFaccountInfoMap(vd);
        }
        return umUserinfoReDomainBeanSupQueryResult;
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List<VdFaccountInfo> vdList = this.vdFaccountService.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    @RequestMapping(value={"queryAuctionEnrollInformation.json"}, name="\u7ade\u4ef7\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollInformation(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        SupQueryResult<AtAuctionEnrollReDomain> atAuctionEnrollResult = this.atAuctionEnrollService.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        block0: for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult;
            SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult1;
            HashMap<String, Object> mapp = new HashMap<String, Object>();
            HashMap<String, Object> paramStr = new HashMap<String, Object>();
            AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(atAuctionEnrollReDomain.getTenantCode(), atAuctionEnrollReDomain.getAuctionCode());
            if (null != atAuctionReDomain) {
                atAuctionEnrollReDomain.setMemo(atAuctionReDomain.getDataState().toString());
                atAuctionEnrollReDomain.setAtAuctionReDomain(atAuctionReDomain);
            }
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            mapp.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
            paramStr.put("userinfoCode", memberBcode);
            paramStr.put("tenantCode", tenantCode);
            SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(paramStr);
            if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList()) && ListUtil.isNotEmpty((Collection)(umUserinfoReDomainBeanSupQueryResult1 = this.changeUserInfoBasicResultCom(umUserinfoReDomainBeanSupQueryResult, null)).getList())) {
                atAuctionEnrollReDomain.setUmUserinfoReDomainBean((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult1.getList().get(0));
            }
            if (ListUtil.isNotEmpty((Collection)(atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(mapp)).getList())) {
                atAuctionEnrollReDomain.setAtAuctiondtReDomainList(atAuctiondtResult.getList());
            }
            SupQueryResult<AtAuctionUserginfoReDomain> atAuctionUserginfoResult = this.atAuctionUserginfoService.queryatAuctionUserginfoPage(mapp);
            mapp.remove("auctionEnrollCode");
            atAuctionEnrollReDomain.setWinResult("weizhongbiao");
            if (!ListUtil.isNotEmpty((Collection)atAuctionUserginfoResult.getList())) continue;
            for (AtAuctionUserginfoReDomain atAuctionUserginfo : atAuctionUserginfoResult.getList()) {
                mapp.put("auctionGinfoCode", atAuctionUserginfo.getAuctionGinfoCode());
                SupQueryResult<AtAuctionWinReDomain> atAuctionWinResult = this.atAuctionWinService.queryatAuctionWinPage(mapp);
                if (!ListUtil.isNotEmpty((Collection)atAuctionWinResult.getList())) continue;
                atAuctionEnrollReDomain.setWinResult("zhongbiao");
                continue block0;
            }
        }
        return atAuctionEnrollResult;
    }
}

