/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.dis;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.dis.DisContractDomain;
import cn.com.qj.bff.domain.rs.RsGoodsClassReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.dis.DisDictionaryService;
import cn.com.qj.bff.service.rs.RsGoodsClassService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DisInit
extends SpringmvcController {
    private static String CODE = "dis.init.con";
    @Autowired
    protected DisDictionaryService disDictionaryService;
    @Autowired
    protected RsGoodsClassService rsGoodsClassService;
    @Autowired
    protected RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    protected RsSkuService rsSkuService;
    @Autowired
    protected UserService userService;
    private String cacheDictionarykey = "DisDictionary-channelCode";

    @Override
    protected String getContext() {
        return "init";
    }

    private Map<String, RsSkuReDomain> makeSku(List<RsSkuReDomain> rsSkuReDomainList) {
        if (ListUtil.isEmpty(rsSkuReDomainList)) {
            return null;
        }
        HashMap<String, RsSkuReDomain> map = new HashMap<String, RsSkuReDomain>();
        for (RsSkuReDomain rsSkuReDomain : rsSkuReDomainList) {
            map.put(rsSkuReDomain.getSkuNo(), rsSkuReDomain);
        }
        return map;
    }

    protected HtmlJsonReBean updateGoodsCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".checkGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        SupQueryResult<RsResourceGoodsReDomain> qsku = this.rsResourceGoodsService.queryResourceGoodsPage(map);
        if (null == qsku || ListUtil.isEmpty((Collection)qsku.getList())) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("memberCode", memberCcode);
        parammap.put("tenantCode", tenantCode);
        parammap.put("channelCode", channelCode);
        String msg = "";
        for (RsResourceGoodsReDomain rsResourceGoodsReDomain : qsku.getList()) {
            parammap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            parammap.put("name", StringUtils.isBlank((String)rsResourceGoodsReDomain.getGoodsShowname()) ? rsResourceGoodsReDomain.getGoodsName() : rsResourceGoodsReDomain.getGoodsShowname());
            parammap.put("goodsClass", rsResourceGoodsReDomain.getClasstreeShopname() == null ? rsResourceGoodsReDomain.getClasstreeName() : rsResourceGoodsReDomain.getClasstreeShopname());
            parammap.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
            HtmlJsonReBean htmlJsonReBean = this.updateGoods(parammap, channelCode, memberCcode, tenantCode);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            msg = msg + rsResourceGoodsReDomain.getGoodsShowname() + "[" + htmlJsonReBean.getMsg() + "];";
        }
        if (StringUtils.isBlank((String)msg)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
    }

    protected List<String> checkGoodsCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        List<Map<String, Object>> qrelist;
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".checkGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        ArrayList<String> noList = new ArrayList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (channelCode.equals("jddj")) {
            map.put("memberCode", memberCode);
        } else {
            map.put("memberCcode", memberCcode);
            map.put("channelCode", channelCode);
        }
        map.put("tenantCode", tenantCode);
        SupQueryResult<RsSkuReDomain> qsku = this.rsSkuService.querySkuOnePage(map);
        if (null == qsku || ListUtil.isEmpty((Collection)qsku.getList())) {
            noList.add("\u5e73\u53f0\u95e8\u5e97\u6e20\u9053\u6ca1\u6709\u5546\u54c1\u4fe1\u606f");
            return noList;
        }
        Map<String, RsSkuReDomain> skumap = this.makeSku(qsku.getList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCcode);
        param.put("tenantCode", tenantCode);
        param.put("channelCode", channelCode);
        int no = 0;
        param.put("offset", no);
        param.put("limit", 200);
        param.put("pageNo", no + 1);
        HashMap<String, String> skunoMap = new HashMap<String, String>();
        while (null != (qrelist = this.querySendGoods(param, channelCode, memberCcode, tenantCode)) && !ListUtil.isEmpty(qrelist)) {
            this.checkComSku(skumap, qrelist, noList, skunoMap);
            param.put("pageNo", ++no);
            param.put("offset", no * 200 + 1);
        }
        if (MapUtil.isNotEmpty(skumap)) {
            for (String key : skumap.keySet()) {
                noList.add("\u8d27\u53f7:\u3010" + key + "\u3011\u5728\u4e09\u65b9\u6e20\u9053\u4e0d\u5b58\u5728");
            }
        }
        return noList;
    }

    protected abstract void checkComSku(Map<String, RsSkuReDomain> var1, List<Map<String, Object>> var2, List<String> var3, Map<String, String> var4);

    protected abstract HtmlJsonReBean updateGoods(Map<String, Object> var1, String var2, String var3, String var4);

    protected HtmlJsonReBean saveDictionaryClassCom(HttpServletRequest request, String channelCode, String memberCcode, String memberCode) {
        UmUserinfoReDomainBean userinfoByCode;
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".saveDictionaryClass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)memberCode) && null != (userinfoByCode = this.userService.getUserinfoByCode(memberCcode, tenantCode))) {
            memberCode = userinfoByCode.getUserinfoParentCode();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        SupQueryResult<RsGoodsClassReDomain> qrelist = this.rsGoodsClassService.queryGoodsClassPage(param);
        if (null == qrelist || ListUtil.isEmpty((Collection)qrelist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u6570\u636e:" + ((Object)param).toString());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        String msg = "";
        for (RsGoodsClassReDomain rsGoodsClassReDomain : qrelist.getList()) {
            map.put("rsGoodsClassDomain", rsGoodsClassReDomain);
            HtmlJsonReBean htmlJsonReBean = this.updateSendClassCodeByName(map, channelCode, memberCcode, tenantCode);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            msg = msg + rsGoodsClassReDomain.getGoodsClassName() + "[" + htmlJsonReBean.getMsg() + "];";
        }
        if (StringUtils.isBlank((String)msg)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
    }

    protected String getDictionaryValue(String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        return this.getDictionaryComValue(this.cacheDictionarykey, tenantCode, channelCode, dictionaryType, propertis, value);
    }

    protected String getShoppingId(String tenantCode, String channelCode, String memberCode) {
        String shoppingId = this.getDictionaryValue(tenantCode, channelCode, "UmUserinfo", "userinfoCode", memberCode);
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.debug(CODE + ".getShoppingId.shoppingId", (Object)(channelCode + "-" + memberCode + "-" + tenantCode));
            return null;
        }
        return shoppingId;
    }

    private String getDictionaryComValue(String cachekey, String tenantCode, String channelCode, String dictionaryType, String propertis, String value) {
        if (StringUtils.isBlank((String)cachekey) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)propertis) || StringUtils.isBlank((String)value)) {
            this.logger.debug(CODE + ".getDictionaryComValue.param");
            return null;
        }
        String valueStr = SupDisUtil.getMap((String)cachekey, (String)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
        if (StringUtils.isBlank((String)valueStr)) {
            this.logger.debug(CODE + ".getDictionaryComValue.valueStr", (Object)(channelCode + "-" + dictionaryType + "-" + propertis + "-" + value + "-" + tenantCode));
            return null;
        }
        String[] values = valueStr.split("\\,");
        if (null == values || values.length < 1) {
            return null;
        }
        return values[1];
    }

    public HtmlJsonReBean updateAppFoodCodeByNameAndSpec(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disGoods.updateAppFoodCodeByNameAndSpec");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSendClassCodeByName(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disGoods.updateSendClassCodeByName");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<Map<String, Object>> querySendClass(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disGoods.querySendClass");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        String s = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return (List)JsonUtil.buildNormalBinder().getJsonToList(s, Map.class);
    }

    public List<Map<String, Object>> querySendGoods(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disGoods.querySendGoods");
        pmap.putParamToJson("map", map);
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        String s = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return (List)JsonUtil.buildNormalBinder().getJsonToList(s, Map.class);
    }

    public DisContractDomain getSendOrder(String contractNbillcode, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disOrder.getSendOrder");
        pmap.putParam("contractNbillcode", contractNbillcode);
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        return (DisContractDomain)this.htmlIBaseService.sendMes(pmap, DisContractDomain.class);
    }

    public HtmlJsonReBean saveSendOrderState(Map<String, Object> map, String channelCode, String memberCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("cmc.disOrder.saveSendOrderState");
        pmap.putParamToJson("map", map);
        if (MapUtil.isNotEmpty(map)) {
            for (String key : map.keySet()) {
                pmap.putParam(key, map.get(key));
            }
        }
        pmap.putParam("channelCode", channelCode);
        pmap.putParam("memberCode", memberCode);
        pmap.putParam("tenantCode", tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

