/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.service.rs;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.send.SupperFacade;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsGoodsClassDomain;
import cn.com.qj.bff.domain.rs.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class RsGoodsClassService
extends SupperFacade {
    public HtmlJsonReBean updateGoodsClassState(Integer goodsClassId, Integer dataState, Integer oldDataState) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.updateGoodsClassState");
        pmap.putParam("goodsClassId", goodsClassId);
        pmap.putParam("dataState", dataState);
        pmap.putParam("oldDataState", oldDataState);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.resource.saveGoodsClass");
        pmap.putParamToJson("rsGoodsClassDomain", rsGoodsClassDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.resource.updateGoodsClass");
        pmap.putParamToJson("rsGoodsClassDomain", rsGoodsClassDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteGoodsClass(Integer goodsClassId) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.resource.deleteGoodsClass");
        pmap.putParam("goodsClassId", goodsClassId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsGoodsClassReDomain> queryGoodsClassPage(Map<String, Object> map) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.queryGoodsClassPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsGoodsClassReDomain.class);
    }

    public RsGoodsClassReDomain getGoodsClassByCode(Map<String, Object> map) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.getGoodsClassByCode");
        pmap.putParamToJson("map", map);
        return (RsGoodsClassReDomain)this.htmlIBaseService.senReObject(pmap, RsGoodsClassReDomain.class);
    }

    public HtmlJsonReBean delGoodsClassByCode(Map<String, Object> map) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.resource.delGoodsClassByCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public RsGoodsClassReDomain getGoodsClass(Integer goodsClassId) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.getGoodsClass");
        pmap.putParam("goodsClassId", goodsClassId);
        return (RsGoodsClassReDomain)this.htmlIBaseService.senReObject(pmap, RsGoodsClassReDomain.class);
    }

    public HtmlJsonReBean updateStateList(String tenantCode, Integer dataState, Integer oldDataState, String goodsClassHide) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.updateStateList");
        pmap.putParam("tenantCode", tenantCode);
        pmap.putParam("dataState", dataState);
        pmap.putParam("oldDataState", oldDataState);
        pmap.putParam("goodsClassHide", goodsClassHide);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<RsGoodsClassReDomain> queryGoodsClassByParent(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.goodsClass.queryGoodsClassByParent");
        pmap.putParam("tenantCode", tenantCode);
        pmap.putParam("goodsClassParentcode", goodsClassParentcode);
        pmap.putParam("goodsClassType", goodsClassType);
        pmap.putParam("channelCode", channelCode);
        return this.htmlIBaseService.getForList(pmap, RsGoodsClassReDomain.class);
    }

    public List<String> getGoodsClass(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        List<RsGoodsClassReDomain> goodsList = this.queryGoodsClassByParent(goodsClassParentcode, goodsClassType, channelCode, tenantCode);
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("RsGoodsClassService.getGoodsClass.goodsList", (Object)(goodsClassParentcode + "=:=" + goodsClassType + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        ArrayList<String> classCodeList = new ArrayList<String>();
        this.makeClassCode(goodsList, classCodeList);
        return classCodeList;
    }

    private void makeClassCode(List<RsGoodsClassReDomain> goodsList, List<String> classCodeList) {
        if (ListUtil.isEmpty(goodsList) || null == classCodeList) {
            return;
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : goodsList) {
            if (StringUtils.isNotBlank((String)rsGoodsClassReDomain.getClasstreeCode())) {
                classCodeList.add(rsGoodsClassReDomain.getClasstreeCode());
            }
            if (!ListUtil.isNotEmpty(rsGoodsClassReDomain.getChildList())) continue;
            this.makeClassCode(rsGoodsClassReDomain.getChildList(), classCodeList);
        }
    }

    public List<String> getGoodsClassAllByPcode(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        List<RsGoodsClassReDomain> goodsList = this.queryGoodsClassByParent(goodsClassParentcode, goodsClassType, channelCode, tenantCode);
        this.logger.info("RsGoodsClassService.getGoodsClassAllByPcode.goodsList1", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("RsGoodsClassService.getGoodsClass.goodsList", (Object)(goodsClassParentcode + "=:=" + goodsClassType + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        ArrayList<String> classCodeList = new ArrayList<String>();
        this.makeGoodsClassCode(goodsList, classCodeList);
        this.logger.info("RsGoodsClassService.getGoodsClassAllByPcode.classCodeList", (Object)JsonUtil.buildNormalBinder().toJson(classCodeList));
        return classCodeList;
    }

    private void makeGoodsClassCode(List<RsGoodsClassReDomain> goodsList, List<String> classCodeList) {
        if (ListUtil.isEmpty(goodsList) || null == classCodeList) {
            return;
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : goodsList) {
            this.logger.info("RsGoodsClassService.makeGoodsClassCode", (Object)(rsGoodsClassReDomain.getGoodsClassCode() + "==" + rsGoodsClassReDomain.getGoodsClassLast()));
            if (StringUtils.isNotBlank((String)rsGoodsClassReDomain.getGoodsClassCode()) && "0".equals(rsGoodsClassReDomain.getGoodsClassLast())) {
                classCodeList.add(rsGoodsClassReDomain.getGoodsClassCode());
            }
            if (!ListUtil.isNotEmpty(rsGoodsClassReDomain.getChildList())) continue;
            this.makeGoodsClassCode(rsGoodsClassReDomain.getChildList(), classCodeList);
        }
    }

    public HtmlJsonReBean sendupdateOrder(List<RsGoodsClassDomain> rsGoodsClassDomains) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("rs.resource.sendupdateOrder");
        pmap.putParamToJson("rsGoodsClassDomains", rsGoodsClassDomains);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

