/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderPayDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsGoodsRel;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoods;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrderUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrdersOutQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryResPonse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.OrderService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderServiceImpl
extends DateBaseService
implements OrderService {
    private static final String SYS_CODE = "OrderServiceImpl";

    @Override
    public String saveOrder(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrder is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrder goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrder getUser is null");
            return "error";
        }
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrder shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status(this.getState(ocContractDomain.getDataState()));
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBname());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setReceiver_mobile(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getDataBmoney());
        if (null == ocContractDomain.getGoodsLogmoney()) {
            ocContractDomain.setGoodsLogmoney(BigDecimal.ZERO);
        }
        if (2 == ocContractDomain.getDataState()) {
            OrderPayDomain orderPayDomain = new OrderPayDomain();
            orderPayDomain.setOuter_pay_id("*************");
            orderPayDomain.setPay_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
            orderPayDomain.setAmount(ocContractDomain.getContractMoney());
            orderPayDomain.setBuyer_account(ocContractDomain.getMemberBcode());
            orderPayDomain.setSeller_account(ocContractDomain.getMemberCode());
            orderPayDomain.setPayment("\u7ebf\u4e0a");
            orderUploadRequest.setPay(orderPayDomain);
        }
        orderUploadRequest.setFreight(ocContractDomain.getGoodsLogmoney());
        orderUploadRequest.setShop_modified(OrderServiceImpl.getDataStr(ocContractDomain.getGmtModified()));
        String picUrl = this.getPicPre(ocContractDomain.getTenantCode());
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        HashMap<String, String> remarkmap = new HashMap<String, String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
                List<OrderGoodsDomain> orderGoodsDomains1 = this.makeOrderGoodsDomains(ocContractGoodsDomain, picUrl, remarkmap);
                if (!ListUtil.isNotEmpty(orderGoodsDomains1)) continue;
                orderGoodsDomains.addAll(orderGoodsDomains1);
                continue;
            }
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getGoodsName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(this.makeOcPic(ocContractGoodsDomain, picUrl));
            if ("Presale".equals(ocContractGoodsDomain.getGoodsSpec2())) {
                orderGoodsDomain.setRemark(ocContractGoodsDomain.getGoodsSpec3());
                remarkmap.put("\u5546\u54c1\u7f16\u7801" + ocContractGoodsDomain.getSkuNo(), "\u9884\u552e\u53d1\u8d27" + ocContractGoodsDomain.getGoodsSpec3());
            }
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequest.setRemark(((Object)remarkmap).toString());
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        this.logger.error("OrderServiceImpl.saveOrdernew" + JsonUtil.buildNormalBinder().toJson(params));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrder responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrder orderUploadResponse is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)orderUploadResponse.getMsg());
            throw new RuntimeException("\u8c03\u7528\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrder data is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrder datas is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            return "error";
        }
        for (OrderUploadDatas orderUploadDatas : datas) {
            if (orderUploadDatas.isIssuccess()) {
                this.updateContractContractNbillcode(ocContractDomain.getContractBillcode(), orderUploadDatas.getO_id().toString(), ocContractDomain.getTenantCode());
                continue;
            }
            this.logger.error("OrderServiceImpl.saveOrder orderUploadDatas is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            return "error";
        }
        return "success";
    }

    public List<OrderGoodsDomain> makeOrderGoodsDomains(OcContractGoodsDomain ocContractGoodsDomain, String picUrl, Map<String, String> remarkmap) {
        if (null == ocContractGoodsDomain) {
            this.logger.error("OrderServiceImpl.makeOrderGoodsDomains", (Object)"is null");
            return null;
        }
        HashMap<String, String> rsGoodsRelMap = new HashMap<String, String>();
        HashMap<String, String> rsGoodsRelMapStr = new HashMap<String, String>();
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
            List rsGoodsRelList;
            rsGoodsRelMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            rsGoodsRelMap.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
            rsGoodsRelMap.put("goodsRelType", "3");
            rsGoodsRelMapStr.put("map", JsonUtil.buildNonNullBinder().toJson(rsGoodsRelMap));
            QueryResult queryResutl = this.getQueryResutl("rs.goodsOther.queryGoodsRelPage", rsGoodsRelMapStr, RsGoodsRel.class);
            if (ListUtil.isNotEmpty((Collection)queryResutl.getList()) && ListUtil.isNotEmpty((Collection)(rsGoodsRelList = queryResutl.getList()))) {
                for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
                    OrderGoodsDomain orderGoodsDomain = new OrderGoodsDomain();
                    orderGoodsDomain.setSku_id(rsGoodsRel.getSkuNo());
                    orderGoodsDomain.setShop_sku_id(rsGoodsRel.getSkuCode());
                    orderGoodsDomain.setAmount(ocContractGoodsDomain.getGoodsCamount().multiply(rsGoodsRel.getGoodsRelNprice()));
                    orderGoodsDomain.setBase_price(ocContractGoodsDomain.getGoodsCamount().multiply(rsGoodsRel.getPricesetNprice()));
                    orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
                    orderGoodsDomain.setName(rsGoodsRel.getGoodsName());
                    orderGoodsDomain.setOuter_oi_id(rsGoodsRel.getGoodsRelCode());
                    orderGoodsDomain.setPic(this.makeOcPic(ocContractGoodsDomain, picUrl));
                    if ("Presale".equals(ocContractGoodsDomain.getGoodsSpec2())) {
                        orderGoodsDomain.setRemark(ocContractGoodsDomain.getGoodsSpec3());
                        remarkmap.put("\u5546\u54c1\u7f16\u7801" + rsGoodsRel.getSkuNo(), "\u9884\u552e\u53d1\u8d27" + ocContractGoodsDomain.getGoodsSpec3());
                    }
                    orderGoodsDomains.add(orderGoodsDomain);
                }
            }
        }
        return orderGoodsDomains;
    }

    private String makeOcPic(OcContractGoodsDomain ocContractGoodsDomain, String picUrl) {
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getDataPic())) {
            return "";
        }
        String pic = "";
        boolean isNotPre = false;
        if (StringUtils.isNotBlank((String)picUrl)) {
            String[] split;
            for (String pre : split = picUrl.split(",")) {
                if (!ocContractGoodsDomain.getDataPic().contains(pre)) continue;
                isNotPre = true;
                break;
            }
            pic = split[0];
        }
        if (isNotPre) {
            return ocContractGoodsDomain.getDataPic();
        }
        return pic + ocContractGoodsDomain.getDataPic();
    }

    @Override
    public String saveOrderBatch(List<OcContractReDomain> ocContractDomains) {
        if (ListUtil.isEmpty(ocContractDomains)) {
            this.logger.error("OrderServiceImpl.saveOrderBatch is null");
            return "\u4e0a\u4f20\u5931\u8d25,\u53c2\u6570\u4e3a\u7a7a";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        String picUrl = this.getPicPre(ocContractDomains.get(0).getTenantCode());
        for (OcContractReDomain ocContractDomain : ocContractDomains) {
            String shopId;
            List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
            if (ListUtil.isEmpty(goodsList)) {
                this.logger.error("OrderServiceImpl.saveOrderBatch goodsList is null", (Object)ocContractDomain.getContractBillcode());
                return "\u4e0a\u4f20\u5931\u8d25,\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a";
            }
            UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
            if (null == user) {
                this.logger.error("OrderServiceImpl.saveOrderBatch getUser is null");
                return "\u4e0a\u4f20\u5931\u8d25,\u7528\u6237\u4fe1\u606f\u5f02\u5e38";
            }
            if (null == ocContractDomain.getGmtCreate()) {
                ocContractDomain.setGmtCreate(new Date());
            }
            if (null == ocContractDomain.getGmtModified()) {
                ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
            }
            if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
                this.logger.error("OrderServiceImpl.saveOrderBatch shopId  is null");
                return "\u4e0a\u4f20\u5931\u8d25,\u672a\u7ed1\u5b9a\u5e97\u94fa";
            }
            OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
            orderUploadRequest.setShop_id(Integer.parseInt(shopId));
            orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
            orderUploadRequest.setOrder_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
            orderUploadRequest.setShop_status(this.getState(ocContractDomain.getDataState()));
            orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBname());
            String res = this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
            if (!"success".equals(res)) {
                return "\u4e0a\u4f20\u5931\u8d25," + res;
            }
            orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
            orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
            orderUploadRequest.setReceiver_mobile(ocContractDomain.getGoodsReceiptPhone());
            orderUploadRequest.setPay_amount(ocContractDomain.getDataBmoney());
            if (null == ocContractDomain.getGoodsLogmoney()) {
                ocContractDomain.setGoodsLogmoney(BigDecimal.ZERO);
            }
            if (2 == ocContractDomain.getDataState()) {
                OrderPayDomain orderPayDomain = new OrderPayDomain();
                orderPayDomain.setOuter_pay_id("*************");
                orderPayDomain.setPay_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
                orderPayDomain.setAmount(ocContractDomain.getContractMoney());
                orderPayDomain.setBuyer_account(ocContractDomain.getMemberBcode());
                orderPayDomain.setSeller_account(ocContractDomain.getMemberCode());
                orderPayDomain.setPayment("\u7ebf\u4e0a");
                orderUploadRequest.setPay(orderPayDomain);
            }
            orderUploadRequest.setFreight(ocContractDomain.getGoodsLogmoney());
            orderUploadRequest.setShop_modified(OrderServiceImpl.getDataStr(ocContractDomain.getGmtModified()));
            ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
            OrderGoodsDomain orderGoodsDomain = null;
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                orderGoodsDomain = new OrderGoodsDomain();
                orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
                orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
                orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
                orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
                orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
                orderGoodsDomain.setName(ocContractGoodsDomain.getGoodsName());
                orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
                orderGoodsDomain.setPic(this.makeOcPic(ocContractGoodsDomain, picUrl));
                orderGoodsDomains.add(orderGoodsDomain);
            }
            orderUploadRequest.setItems(orderGoodsDomains);
            orderUploadRequests.add(orderUploadRequest);
        }
        String url = this.getDdFalgSetting(ocContractDomains.get(0).getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomains.get(0).getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomains.get(0).getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomains.get(0).getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrderBatch responseStr is null");
            return "\u4e0a\u4f20\u5931\u8d25,\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrderBatch orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return orderUploadResponse.getMsg();
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrderBatch data is error", (Object)responseStr);
            return "\u4e0a\u4f20\u5931\u8d25,\u8fd4\u56dedata\u4e3a\u7a7a";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrderBatch datas is error", (Object)responseStr);
            return "\u4e0a\u4f20\u5931\u8d25,\u8fd4\u56dedatas\u4e3a\u7a7a";
        }
        for (OrderUploadDatas orderUploadDatas : datas) {
            if (orderUploadDatas.isIssuccess()) {
                this.updateContractContractNbillcode(orderUploadDatas.getSo_id(), orderUploadDatas.getO_id().toString(), ocContractDomains.get(0).getTenantCode());
                continue;
            }
            this.logger.error("OrderServiceImpl.saveOrderBatch orderUploadDatas is error", (Object)responseStr);
            return "\u4e0a\u4f20\u5931\u8d25,\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38";
        }
        return "success";
    }

    @Override
    public String saveOrderCancelAfterPay(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay getUser is null");
            return "error";
        }
        String picUrl = this.getPicPre(ocContractDomain.getTenantCode());
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status("TRADE_CLOSED");
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBname());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setReceiver_mobile(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getContractMoney());
        if (StringUtils.isBlank((String)ocContractDomain.getFreight())) {
            ocContractDomain.setFreight("0");
        }
        orderUploadRequest.setFreight(new BigDecimal(ocContractDomain.getFreight()));
        orderUploadRequest.setShop_modified(OrderServiceImpl.getDataStr(ocContractDomain.getGmtModified()));
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getGoodsName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(this.makeOcPic(ocContractGoodsDomain, picUrl));
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return "error";
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay data is error", (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay datas is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    private String makeAddress(OrderUploadRequest orderUploadRequest, String goodsReceiptArrdess) {
        if (StringUtils.isBlank((String)goodsReceiptArrdess)) {
            this.logger.error("OrderServiceImpl.makeAddress is null", (Object)goodsReceiptArrdess);
            return "\u5730\u5740\u4e3a\u7a7a";
        }
        String[] split = goodsReceiptArrdess.split("\u2014");
        if (split.length < 4) {
            this.logger.error("OrderServiceImpl.makeAddress is error", (Object)goodsReceiptArrdess);
            return "\u5730\u5740\u4fe1\u606f\u9519\u8bef";
        }
        orderUploadRequest.setReceiver_state(split[0]);
        orderUploadRequest.setReceiver_city(split[1]);
        orderUploadRequest.setReceiver_district(split[2]);
        orderUploadRequest.setReceiver_address(split[3]);
        if (split.length > 4) {
            orderUploadRequest.setReceiver_town(split[3]);
            orderUploadRequest.setReceiver_address(split[4]);
        }
        return "success";
    }

    @Override
    public String saveOrderCancelBeforePay(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        String picUrl = this.getPicPre(ocContractDomain.getTenantCode());
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay getUser is null");
            return "error";
        }
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status("TRADE_CLOSED_BY_TAOBAO");
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBname());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setReceiver_mobile(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getContractMoney());
        if (StringUtils.isBlank((String)ocContractDomain.getFreight())) {
            ocContractDomain.setFreight("0");
        }
        orderUploadRequest.setFreight(new BigDecimal(ocContractDomain.getFreight()));
        orderUploadRequest.setShop_modified(OrderServiceImpl.getDataStr(ocContractDomain.getGmtModified()));
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getGoodsName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(this.makeOcPic(ocContractGoodsDomain, picUrl));
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return "error";
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay data is error", (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay datas is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    protected void updateContractContractNbillcode(String contractBillcode, String contractNbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("OrderServiceImplupdateContractContractNbillcode param is null");
            return;
        }
        String apiCode = "oc.contract.updateContractContractNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("tenantCode", tenantCode);
        String s = this.internalInvoke(apiCode, paramMap);
        this.logger.error("OrderServiceImpl.updateContractContractNbillcode." + s, (Object)((Object)paramMap).toString());
    }

    @Override
    public String simpleOrderRe(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("OrderServiceImpl.simpleOrderRe tenantCode is null");
            return "error";
        }
        String url = this.getDdFalgSetting(tenantCode, "orderOutqueryUrl", "orderOutqueryUrl", "");
        String appkey = this.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", tenantCode);
        List<OrdersOutQueryDatas> ordersOutQueryDatas = this.getOrdersOutQueryDatas(appkey, access_token, secret, url);
        if (ListUtil.isEmpty(ordersOutQueryDatas)) {
            this.logger.error("OrderServiceImpl.simpleOrderRe ordersOutQueryDatas is null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("octype", "sendRe");
        for (OrdersOutQueryDatas ordersOutQueryData : ordersOutQueryDatas) {
            if (StringUtils.isBlank((String)ordersOutQueryData.getL_id()) || StringUtils.isBlank((String)ordersOutQueryData.getSo_id())) {
                this.logger.error("OrderServiceImpl.simpleOrderRe ordersOutQueryDatas \u7269\u6d41\u5355\u53f7\u4e3a\u7a7a", (Object)JsonUtil.buildNormalBinder().toJson((Object)ordersOutQueryData));
                continue;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", tenantCode);
            param.put("packageBillno", ordersOutQueryData.getL_id());
            param.put("contractBillcode", ordersOutQueryData.getSo_id());
            List<SgSendgoods> sgSendgoods = this.querySgSendgoodsPage(param);
            if (!ListUtil.isNotEmpty(sgSendgoods)) continue;
            for (SgSendgoods sgSendgood : sgSendgoods) {
                this.sendSendgoodsBack(sgSendgood.getSendgoodsCode(), tenantCode, map);
            }
        }
        return "success";
    }

    @Override
    public String sendSaveMessageSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            this.logger.error("OrderServiceImpl.sendSaveExSendgoods is null");
            return "error";
        }
        if (ListUtil.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            this.logger.error("OrderServiceImpl.sendSaveExSendgoods.list", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            return "error";
        }
        if (null == sgSendgoodsDomain.getContractShow() || 1 != sgSendgoodsDomain.getContractShow()) {
            return "success";
        }
        ArrayList<SgSendgoodsGoodsDomain> list = new ArrayList<SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            list.add(sgSendgoodsGoodsDomain);
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("sg002");
        mnsMnslistDomainBean.setMnslistBusname("\u53d1\u8d27\u901a\u77e5");
        mnsMnslistDomainBean.setMemberCode(sgSendgoodsDomain.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(sgSendgoodsDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(sgSendgoodsDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", sgSendgoodsDomain.getMemberBcode());
        listReceiver.put("name", sgSendgoodsDomain.getMemberBname());
        listReceiver.put("sendGoods", JsonUtil.buildNonEmptyBinder().toJson((Object)sgSendgoodsDomain));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        this.internalInvoke("mns.mns.sendMnslist", invokeMap);
        return "success";
    }

    private List<SgSendgoods> querySgSendgoodsPage(Map<String, Object> map) {
        String apiCode = "sg.sendgoods.querySendgoodsPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)s)) {
            this.logger.error("OrderServiceImpl.querySgSendgoodsPage is null");
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SgSendgoods.class);
        return list;
    }

    private void sendSendgoodsBack(String sendgoodsCode, String tenantCode, HashMap<String, Object> map) {
        String apiCode = "sg.sendgoodsEngine.sendSendgoodsBack";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", sendgoodsCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void simpleOrderReJst(String tenantCode, Map<String, String> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("OrderServiceImplsimpleOrderReJst param is null");
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("OrderServiceImplsimpleOrderReJst tenantCode is null");
            return;
        }
        String apiCode = "sg.sendgoods.simpleOrderReJst";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        paramMap.put("tenantCode", tenantCode);
        String s = this.internalInvoke(apiCode, paramMap);
        this.logger.error("OrderServiceImpl.simpleOrderReJst." + s, (Object)((Object)paramMap).toString());
    }

    private List<OrdersOutQueryDatas> getOrdersOutQueryDatas(String appkey, String access_token, String secret, String url) {
        OrdersOutQueryData data;
        OrdersOutQueryResPonse ordersOutQueryResPonse;
        String responseStr;
        String parmStr;
        String sign;
        HashMap<String, String> params;
        ArrayList<OrdersOutQueryDatas> returnList = new ArrayList<OrdersOutQueryDatas>();
        int page = 1;
        boolean flag = true;
        long time = new Date().getTime();
        long startTime = new Date(time).getTime() - 600000L;
        String startDate = OrderServiceImpl.getDataStr(new Date(startTime));
        String endDate = OrderServiceImpl.getDataStr(new Date(time));
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ordersOutQueryRequest.setModified_begin(startDate);
        ordersOutQueryRequest.setModified_end(endDate);
        while (flag) {
            ordersOutQueryRequest.setStatus("Cancelled");
            ordersOutQueryRequest.setPage_index(page);
            ordersOutQueryRequest.setPage_size(50);
            params = new HashMap<String, String>();
            params.put("app_key", appkey);
            params.put("access_token", access_token);
            params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            params.put("version", "2");
            params.put("charset", "utf-8");
            params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest));
            sign = SignUtil.getSign(secret, params);
            params.put("sign", sign);
            parmStr = this.buildQuery(params);
            responseStr = this.execute(parmStr, url);
            if (StringUtils.isBlank((String)responseStr)) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Cancelled responseStr is null");
                return returnList;
            }
            ordersOutQueryResPonse = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
            if (null == ordersOutQueryResPonse) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonse is null", (Object)responseStr);
                return returnList;
            }
            data = ordersOutQueryResPonse.getData();
            if (null == data) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonsedata is null", (Object)responseStr);
                return returnList;
            }
            if (ListUtil.isEmpty(data.getDatas())) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Cancelled ordersOutQueryResPonsedatas is null", (Object)responseStr);
                return returnList;
            }
            returnList.addAll(data.getDatas());
            if (data.isHas_next()) {
                ++page;
                continue;
            }
            flag = false;
        }
        flag = true;
        while (flag) {
            ordersOutQueryRequest.setStatus("Delete");
            ordersOutQueryRequest.setPage_index(page);
            ordersOutQueryRequest.setPage_size(50);
            params = new HashMap();
            params.put("app_key", appkey);
            params.put("access_token", access_token);
            params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            params.put("version", "2");
            params.put("charset", "utf-8");
            params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest));
            sign = SignUtil.getSign(secret, params);
            params.put("sign", sign);
            parmStr = this.buildQuery(params);
            responseStr = this.execute(parmStr, url);
            if (StringUtils.isBlank((String)responseStr)) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Delete responseStr is null");
                return returnList;
            }
            ordersOutQueryResPonse = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
            if (null == ordersOutQueryResPonse) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Delete ordersOutQueryResPonse is null", (Object)responseStr);
                return returnList;
            }
            data = ordersOutQueryResPonse.getData();
            if (null == data) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Delete ordersOutQueryResPonsedata is null", (Object)responseStr);
                return returnList;
            }
            if (ListUtil.isEmpty(data.getDatas())) {
                this.logger.error("OrderServiceImpl.simpleOrderRe Delete ordersOutQueryResPonsedatas is null", (Object)responseStr);
                return returnList;
            }
            returnList.addAll(data.getDatas());
            if (data.isHas_next()) {
                ++page;
                continue;
            }
            flag = false;
        }
        return returnList;
    }

    private static String getDataStr(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private String getState(Integer dataState) {
        if (1 == dataState) {
            return "WAIT_BUYER_PAY";
        }
        if (2 == dataState) {
            return "WAIT_SELLER_SEND_GOODS";
        }
        if (3 == dataState) {
            return "WAIT_BUYER_CONFIRM_GOODS";
        }
        if (4 == dataState) {
            return "TRADE_FINISHED";
        }
        if (-1 == dataState) {
            return "TRADE_CLOSED";
        }
        return "error";
    }
}

