/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpgoodsMapper;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpgoodsDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpgoodsReDomain;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpgoods;
import com.yqbsoft.laser.service.logistics.service.WlFreightExpgoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlFreightExpgoodsServiceImpl
extends BaseServiceImpl
implements WlFreightExpgoodsService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlFreightExpgoodsServiceImpl";
    private WlFreightExpgoodsMapper wlFreightExpgoodsMapper;

    public void setWlFreightExpgoodsMapper(WlFreightExpgoodsMapper wlFreightExpgoodsMapper) {
        this.wlFreightExpgoodsMapper = wlFreightExpgoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlFreightExpgoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFreightExpgoods(WlFreightExpgoodsDomain wlFreightExpgoodsDomain) {
        if (null == wlFreightExpgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpgoodsDefault(WlFreightExpgoods wlFreightExpgoods) {
        if (null == wlFreightExpgoods) {
            return;
        }
        if (null == wlFreightExpgoods.getDataState()) {
            wlFreightExpgoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == wlFreightExpgoods.getGmtCreate()) {
            wlFreightExpgoods.setGmtCreate(date);
        }
        wlFreightExpgoods.setGmtModified(date);
        if (StringUtils.isBlank((String)wlFreightExpgoods.getFreightExpgoodsCode())) {
            wlFreightExpgoods.setFreightExpgoodsCode(this.getNo(null, "WlFreightExpgoods", "wlFreightExpgoods", wlFreightExpgoods.getTenantCode()));
        }
    }

    private int getFreightExpgoodsMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpgoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.getFreightExpgoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpgoodsUpdataDefault(WlFreightExpgoods wlFreightExpgoods) {
        if (null == wlFreightExpgoods) {
            return;
        }
        wlFreightExpgoods.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpgoodsModel(WlFreightExpgoods wlFreightExpgoods) throws ApiException {
        if (null == wlFreightExpgoods) {
            return;
        }
        try {
            this.wlFreightExpgoodsMapper.insert(wlFreightExpgoods);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.saveFreightExpgoodsModel.ex", (Throwable)e);
        }
    }

    private void saveFreightExpgoodsBatchModel(List<WlFreightExpgoods> wlFreightExpgoodsList) throws ApiException {
        if (null == wlFreightExpgoodsList || wlFreightExpgoodsList.isEmpty()) {
            return;
        }
        try {
            this.wlFreightExpgoodsMapper.insertBatch(wlFreightExpgoodsList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.saveFreightExpgoodsBatchModel.ex", (Throwable)e);
        }
    }

    private WlFreightExpgoods getFreightExpgoodsModelById(Integer freightExpgoodsId) {
        if (null == freightExpgoodsId) {
            return null;
        }
        try {
            return this.wlFreightExpgoodsMapper.selectByPrimaryKey(freightExpgoodsId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.getFreightExpgoodsModelById", (Throwable)e);
            return null;
        }
    }

    private WlFreightExpgoods getFreightExpgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpgoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.getFreightExpgoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFreightExpgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.delFreightExpgoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.delFreightExpgoodsModelByCode.num");
        }
    }

    private void deleteFreightExpgoodsModel(Integer freightExpgoodsId) throws ApiException {
        if (null == freightExpgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.deleteByPrimaryKey(freightExpgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.deleteFreightExpgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.deleteFreightExpgoodsModel.num");
        }
    }

    private void updateFreightExpgoodsModel(WlFreightExpgoods wlFreightExpgoods) throws ApiException {
        if (null == wlFreightExpgoods) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.updateByPrimaryKey(wlFreightExpgoods);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateFreightExpgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateFreightExpgoodsModel.num");
        }
    }

    private void updateStateFreightExpgoodsModel(Integer freightExpgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == freightExpgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpgoodsId", freightExpgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateStateFreightExpgoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateStateFreightExpgoodsModel.null");
        }
    }

    private void updateStateFreightExpgoodsModelByCode(String tenantCode, String freightExpgoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)freightExpgoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpgoodsCode", freightExpgoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateStateFreightExpgoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateStateFreightExpgoodsModelByCode.null");
        }
    }

    private WlFreightExpgoods makeFreightExpgoods(WlFreightExpgoodsDomain wlFreightExpgoodsDomain, WlFreightExpgoods wlFreightExpgoods) {
        if (null == wlFreightExpgoodsDomain) {
            return null;
        }
        if (null == wlFreightExpgoods) {
            wlFreightExpgoods = new WlFreightExpgoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpgoods, (Object)wlFreightExpgoodsDomain);
            return wlFreightExpgoods;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.makeFreightExpgoods", (Throwable)e);
            return null;
        }
    }

    private WlFreightExpgoodsReDomain makeWlFreightExpgoodsReDomain(WlFreightExpgoods wlFreightExpgoods) {
        if (null == wlFreightExpgoods) {
            return null;
        }
        WlFreightExpgoodsReDomain wlFreightExpgoodsReDomain = new WlFreightExpgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpgoodsReDomain, (Object)wlFreightExpgoods);
            return wlFreightExpgoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.makeWlFreightExpgoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpgoods> queryFreightExpgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.queryFreightExpgoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightExpgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpgoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.countFreightExpgoods", (Throwable)e);
        }
        return i;
    }

    private WlFreightExpgoods createWlFreightExpgoods(WlFreightExpgoodsDomain wlFreightExpgoodsDomain) {
        String msg = this.checkFreightExpgoods(wlFreightExpgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.saveFreightExpgoods.checkFreightExpgoods", msg);
        }
        WlFreightExpgoods wlFreightExpgoods = this.makeFreightExpgoods(wlFreightExpgoodsDomain, null);
        this.setFreightExpgoodsDefault(wlFreightExpgoods);
        return wlFreightExpgoods;
    }

    @Override
    public String saveFreightExpgoods(WlFreightExpgoodsDomain wlFreightExpgoodsDomain) throws ApiException {
        WlFreightExpgoods wlFreightExpgoods = this.createWlFreightExpgoods(wlFreightExpgoodsDomain);
        this.saveFreightExpgoodsModel(wlFreightExpgoods);
        return wlFreightExpgoods.getFreightExpgoodsCode();
    }

    @Override
    public String saveFreightExpgoodsBatch(List<WlFreightExpgoodsDomain> wlFreightExpgoodsDomainList) throws ApiException {
        if (null == wlFreightExpgoodsDomainList || wlFreightExpgoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlFreightExpgoods> wlFreightExpgoodsList = new ArrayList<WlFreightExpgoods>();
        String code = "";
        for (WlFreightExpgoodsDomain wlFreightExpgoodsDomain : wlFreightExpgoodsDomainList) {
            WlFreightExpgoods wlFreightExpgoods = this.createWlFreightExpgoods(wlFreightExpgoodsDomain);
            code = wlFreightExpgoods.getFreightExpgoodsCode();
            wlFreightExpgoodsList.add(wlFreightExpgoods);
        }
        this.saveFreightExpgoodsBatchModel(wlFreightExpgoodsList);
        return code;
    }

    @Override
    public void updateFreightExpgoodsState(Integer freightExpgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == freightExpgoodsId) {
            return;
        }
        this.updateStateFreightExpgoodsModel(freightExpgoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExpgoodsStateByCode(String tenantCode, String freightExpgoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)freightExpgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFreightExpgoodsModelByCode(tenantCode, freightExpgoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExpgoods(WlFreightExpgoodsDomain wlFreightExpgoodsDomain) throws ApiException {
        String msg = this.checkFreightExpgoods(wlFreightExpgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateFreightExpgoods.checkFreightExpgoods", msg);
        }
        WlFreightExpgoods oldWlFreightExpgoods = this.getFreightExpgoodsModelById(wlFreightExpgoodsDomain.getFreightExpgoodsId());
        if (null == oldWlFreightExpgoods) {
            throw new ApiException("wl.LOGISTICS.WlFreightExpgoodsServiceImpl.updateFreightExpgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExpgoods wlFreightExpgoods = this.makeFreightExpgoods(wlFreightExpgoodsDomain, oldWlFreightExpgoods);
        this.setFreightExpgoodsUpdataDefault(wlFreightExpgoods);
        this.updateFreightExpgoodsModel(wlFreightExpgoods);
    }

    @Override
    public WlFreightExpgoods getFreightExpgoods(Integer freightExpgoodsId) {
        if (null == freightExpgoodsId) {
            return null;
        }
        return this.getFreightExpgoodsModelById(freightExpgoodsId);
    }

    @Override
    public void deleteFreightExpgoods(Integer freightExpgoodsId) throws ApiException {
        if (null == freightExpgoodsId) {
            return;
        }
        this.deleteFreightExpgoodsModel(freightExpgoodsId);
    }

    @Override
    public QueryResult<WlFreightExpgoods> queryFreightExpgoodsPage(Map<String, Object> map) {
        List<WlFreightExpgoods> wlFreightExpgoodsList = this.queryFreightExpgoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExpgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpgoodsList);
        return queryResult;
    }

    @Override
    public WlFreightExpgoods getFreightExpgoodsByCode(String tenantCode, String freightExpgoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExpgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpgoodsCode", freightExpgoodsCode);
        return this.getFreightExpgoodsModelByCode(map);
    }

    @Override
    public void deleteFreightExpgoodsByCode(String tenantCode, String freightExpgoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExpgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExpgoodsCode", freightExpgoodsCode);
        this.delFreightExpgoodsModelByCode(map);
    }
}

