/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeCflowMapper;
import com.yqbsoft.laser.service.payengine.dao.PeCflowNodeMapper;
import com.yqbsoft.laser.service.payengine.domain.PeCflowDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowNodeDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowNodeReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowReDomain;
import com.yqbsoft.laser.service.payengine.model.PeCflow;
import com.yqbsoft.laser.service.payengine.model.PeCflowNode;
import com.yqbsoft.laser.service.payengine.service.PeCflowService;
import com.yqbsoft.laser.service.payengine.service.impl.CflowPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.CflowService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PeCflowServiceImpl
extends BaseServiceImpl
implements PeCflowService {
    public static final String SYS_CODE = "pe.PeCflowServiceImpl";
    private PeCflowMapper peCflowMapper;
    private PeCflowNodeMapper peCflowNodeMapper;
    public static final String CACHE_KEY_CFLOW = "peProtCflow";
    public static final String CACHE_KEY_CFLOWNODE = "peProtCflowNode";
    public static final String CACHE_KEY_PARENTCFLOWNODE = "peProtCflowNodeByParent";
    private static CflowService cflowService;
    private static Object lock;

    public void setPeCflowMapper(PeCflowMapper peCflowMapper) {
        this.peCflowMapper = peCflowMapper;
    }

    public void setPeCflowNodeMapper(PeCflowNodeMapper peCflowNodeMapper) {
        this.peCflowNodeMapper = peCflowNodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.peCflowMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCflow(PeCflowDomain peCflowDomain) {
        if (null == peCflowDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCflowDefault(PeCflow peCflow) {
        if (null == peCflow) {
            return;
        }
        if (null == peCflow.getDataState()) {
            peCflow.setDataState(0);
        }
        if (null == peCflow.getGmtCreate()) {
            peCflow.setGmtCreate(this.getSysDate());
        }
        peCflow.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.peCflowMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowUpdataDefault(PeCflow peCflow) {
        if (null == peCflow) {
            return;
        }
        peCflow.setGmtModified(this.getSysDate());
    }

    private void saveCflowModel(PeCflow peCflow) throws ApiException {
        if (null == peCflow) {
            return;
        }
        try {
            this.peCflowMapper.insert(peCflow);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.saveCflowModel.ex", (Throwable)e);
        }
    }

    private PeCflow getCflowModelById(Integer cflowId) {
        if (null == cflowId) {
            return null;
        }
        try {
            return this.peCflowMapper.selectByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getCflowModelById", (Throwable)e);
            return null;
        }
    }

    public PeCflow getCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peCflowMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getCflowModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peCflowMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.delCflowModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeCflowServiceImpl.delCflowModelByCode.num");
        }
    }

    private void deleteCflowModel(Integer cflowId) throws ApiException {
        if (null == cflowId) {
            return;
        }
        int i = 0;
        try {
            i = this.peCflowMapper.deleteByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.deleteCflowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeCflowServiceImpl.deleteCflowModel.num");
        }
    }

    private void updateCflowModel(PeCflow peCflow) throws ApiException {
        if (null == peCflow) {
            return;
        }
        try {
            this.peCflowMapper.updateByPrimaryKeySelective(peCflow);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflowModel.ex", (Throwable)e);
        }
    }

    private void updateStateCflowModel(Integer cflowId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cflowId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowId", cflowId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peCflowMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.updateStateCflowModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeCflowServiceImpl.updateStateCflowModel.null");
        }
    }

    private PeCflow makeCflow(PeCflowDomain peCflowDomain, PeCflow peCflow) {
        if (null == peCflowDomain) {
            return null;
        }
        if (null == peCflow) {
            peCflow = new PeCflow();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peCflow, (Object)peCflowDomain);
            return peCflow;
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.makeCflow", (Throwable)e);
            return null;
        }
    }

    private PeCflowReDomain makeReCflow(PeCflow peCflow) {
        if (null == peCflow) {
            return null;
        }
        PeCflowReDomain peCflowReDomain = new PeCflowReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peCflowReDomain, (Object)peCflow);
            return peCflowReDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.makeReCflow", (Throwable)e);
            return null;
        }
    }

    private List<PeCflow> queryCflowModelPage(Map<String, Object> parammap) {
        try {
            return this.peCflowMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.queryCflowModel", (Throwable)e);
            return null;
        }
    }

    private int countCflow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peCflowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.countCflow", (Throwable)e);
        }
        return i;
    }

    private String checkCflowNode(PeCflowNodeDomain peCflowNodeDomain) {
        if (null == peCflowNodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCflowNodeDefault(PeCflowNode peCflowNode) {
        if (null == peCflowNode) {
            return;
        }
        if (null == peCflowNode.getDataState()) {
            peCflowNode.setDataState(0);
        }
        if (null == peCflowNode.getGmtCreate()) {
            peCflowNode.setGmtCreate(this.getSysDate());
        }
        peCflowNode.setGmtModified(this.getSysDate());
    }

    private int getCflowNodeMaxCode() {
        int code = 0;
        try {
            return this.peCflowNodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getCflowNodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowNodeUpdataDefault(PeCflowNode peCflowNode) {
        if (null == peCflowNode) {
            return;
        }
        peCflowNode.setGmtModified(this.getSysDate());
    }

    private void saveCflowNodeModel(PeCflowNode peCflowNode) throws ApiException {
        if (null == peCflowNode) {
            return;
        }
        try {
            this.peCflowNodeMapper.insert(peCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.saveCflowNodeModel.ex", (Throwable)e);
        }
    }

    private PeCflowNode getCflowNodeModelById(Integer cflowNodeId) {
        if (null == cflowNodeId) {
            return null;
        }
        try {
            return this.peCflowNodeMapper.selectByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getCflowNodeModelById", (Throwable)e);
            return null;
        }
    }

    public PeCflowNode getCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peCflowNodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.getCflowNodeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peCflowNodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.delCflowNodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeCflowServiceImpl.delCflowNodeModelByCode.num");
        }
    }

    private void deleteCflowNodeModel(Integer cflowNodeId) throws ApiException {
        if (null == cflowNodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.peCflowNodeMapper.deleteByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.deleteCflowNodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeCflowServiceImpl.deleteCflowNodeModel.num");
        }
    }

    private void updateCflowNodeModel(PeCflowNode peCflowNode) throws ApiException {
        if (null == peCflowNode) {
            return;
        }
        try {
            this.peCflowNodeMapper.updateByPrimaryKeySelective(peCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflowNodeModel.ex", (Throwable)e);
        }
    }

    private void updateStateCflowNodeModel(Integer cflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cflowNodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowNodeId", cflowNodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peCflowNodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeCflowServiceImpl.updateStateCflowNodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeCflowServiceImpl.updateStateCflowNodeModel.null");
        }
    }

    private PeCflowNode makeCflowNode(PeCflowNodeDomain peCflowNodeDomain, PeCflowNode peCflowNode) {
        if (null == peCflowNodeDomain) {
            return null;
        }
        if (null == peCflowNode) {
            peCflowNode = new PeCflowNode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peCflowNode, (Object)peCflowNodeDomain);
            return peCflowNode;
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.makeCflowNode", (Throwable)e);
            return null;
        }
    }

    private PeCflowNodeReDomain makeReCflowNode(PeCflowNode peCflowNode) {
        if (null == peCflowNode) {
            return null;
        }
        PeCflowNodeReDomain peCflowNodeReDomain = new PeCflowNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peCflowNodeReDomain, (Object)peCflowNode);
            return peCflowNodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.makeReCflowNode", (Throwable)e);
            return null;
        }
    }

    private List<PeCflowNodeReDomain> makeReCflowNodeList(List<PeCflowNode> peCflowNodeList) {
        if (null == peCflowNodeList || peCflowNodeList.isEmpty()) {
            return null;
        }
        ArrayList<PeCflowNodeReDomain> nodeReList = new ArrayList<PeCflowNodeReDomain>();
        for (PeCflowNode peCflowNode : peCflowNodeList) {
            nodeReList.add(this.makeReCflowNode(peCflowNode));
        }
        return nodeReList;
    }

    private List<PeCflowNode> queryCflowNodeModelPage(Map<String, Object> parammap) {
        try {
            return this.peCflowNodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.queryCflowNodeModel", (Throwable)e);
            return null;
        }
    }

    private int countCflowNode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peCflowNodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeCflowServiceImpl.countCflowNode", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveCflow(PeCflowDomain peCflowDomain) throws ApiException {
        String msg = this.checkCflow(peCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeCflowServiceImpl.saveCflow.checkCflow", msg);
        }
        PeCflow peCflow = this.makeCflow(peCflowDomain, null);
        this.setCflowDefault(peCflow);
        this.saveCflowModel(peCflow);
    }

    @Override
    public void updateCflowState(Integer cflowId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCflowModel(cflowId, dataState, oldDataState);
    }

    @Override
    public void updateCflow(PeCflowDomain peCflowDomain) throws ApiException {
        String msg = this.checkCflow(peCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflow.checkCflow", msg);
        }
        PeCflow oldPeCflow = this.getCflowModelById(peCflowDomain.getCflowId());
        if (null == oldPeCflow) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflow.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeCflow peCflow = this.makeCflow(peCflowDomain, oldPeCflow);
        this.setCflowUpdataDefault(peCflow);
        this.updateCflowModel(peCflow);
    }

    @Override
    public PeCflow getCflow(Integer cflowId) {
        return this.getCflowModelById(cflowId);
    }

    @Override
    public PeCflowReDomain getCflowByPaypdCode(String dicPaypdCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dicPaypdCode", dicPaypdCode);
        map.put("tenantCode", tenantCode);
        List<PeCflow> peCflowList = this.queryCflowModelPage(map);
        if (null == peCflowList || peCflowList.isEmpty()) {
            return null;
        }
        PeCflow peCflow = peCflowList.get(0);
        PeCflowReDomain peCflowReDomain = this.makeReCflow(peCflow);
        if (null == peCflowReDomain) {
            return null;
        }
        List<PeCflowNodeReDomain> nodeReList = this.queryNodeNext(tenantCode, peCflowReDomain.getCflowCode(), peCflowReDomain.getCflowCode());
        peCflowReDomain.setNodeReList(nodeReList);
        return peCflowReDomain;
    }

    @Override
    public List<PeCflowNodeReDomain> queryCflowNodeNext(String cflowCode, String cflowNodeParentcode, String tenantCode) {
        return this.queryNodeNext(tenantCode, cflowNodeParentcode, cflowCode);
    }

    private List<PeCflowNodeReDomain> queryNodeNext(String tenantCode, String cflowNodeParentcode, String cflowCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        map.put("cflowNodeParentcode", cflowNodeParentcode);
        map.put("orderStr", "CFLOW_NODE_INDEX");
        map.put("order", true);
        List<PeCflowNodeReDomain> nodeReList = this.makeReCflowNodeList(this.queryCflowNodeModelPage(map));
        if (null == nodeReList || nodeReList.isEmpty()) {
            return null;
        }
        return nodeReList;
    }

    public void createNodeChildren(String tenantCode, List<PeCflowNodeReDomain> nodeReList) {
        if (null == nodeReList || nodeReList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        for (PeCflowNodeReDomain peCflowNodeReDomain : nodeReList) {
            map.put("cflowCode", peCflowNodeReDomain.getCflowCode());
            map.put("cflowNodeParentcode", peCflowNodeReDomain.getCflowNodeCode());
            List<PeCflowNodeReDomain> nodeReChildrenList = this.makeReCflowNodeList(this.queryCflowNodeModelPage(map));
            if (null == nodeReChildrenList || nodeReChildrenList.isEmpty()) continue;
            peCflowNodeReDomain.setChildren(nodeReChildrenList);
            this.createNodeChildren(tenantCode, nodeReChildrenList);
        }
    }

    @Override
    public void deleteCflow(Integer cflowId) throws ApiException {
        this.deleteCflowModel(cflowId);
    }

    @Override
    public QueryResult<PeCflow> queryCflowPage(Map<String, Object> map) {
        List<PeCflow> peCflowList = this.queryCflowModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peCflowList);
        return queryResult;
    }

    @Override
    public void saveCflowNode(PeCflowNodeDomain peCflowNodeDomain) throws ApiException {
        String msg = this.checkCflowNode(peCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeCflowServiceImpl.saveCflowNode.checkCflowNode", msg);
        }
        PeCflowNode peCflowNode = this.makeCflowNode(peCflowNodeDomain, null);
        this.setCflowNodeDefault(peCflowNode);
        this.saveCflowNodeModel(peCflowNode);
    }

    @Override
    public void updateCflowNodeState(Integer cflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCflowNodeModel(cflowNodeId, dataState, oldDataState);
    }

    @Override
    public void updateCflowNode(PeCflowNodeDomain peCflowNodeDomain) throws ApiException {
        String msg = this.checkCflowNode(peCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflowNode.checkCflowNode", msg);
        }
        PeCflowNode oldPeCflowNode = this.getCflowNodeModelById(peCflowNodeDomain.getCflowNodeId());
        if (null == oldPeCflowNode) {
            throw new ApiException("pe.PeCflowServiceImpl.updateCflowNode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeCflowNode peCflowNode = this.makeCflowNode(peCflowNodeDomain, oldPeCflowNode);
        this.setCflowNodeUpdataDefault(peCflowNode);
        this.updateCflowNodeModel(peCflowNode);
    }

    @Override
    public PeCflowNode getCflowNode(Integer cflowNodeId) {
        return this.getCflowNodeModelById(cflowNodeId);
    }

    @Override
    public PeCflowNode getCflowNodeByCode(String cflowNodeCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowNodeCode", cflowNodeCode);
        map.put("tenantCode", tenantCode);
        return this.getCflowNodeModelByCode(map);
    }

    @Override
    public void deleteCflowNode(Integer cflowNodeId) throws ApiException {
        this.deleteCflowNodeModel(cflowNodeId);
    }

    @Override
    public QueryResult<PeCflowNode> queryCflowNodePage(Map<String, Object> map) {
        List<PeCflowNode> peCflowNodeList = this.queryCflowNodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflowNode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peCflowNodeList);
        return queryResult;
    }

    @Override
    public void queryCflowCache() {
        this.info("pe.PeCflowServiceImpl.queryCflowCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<PeCflow> cflowList = this.queryCflowModelPage(params);
        if (CollectionUtils.isEmpty(cflowList)) {
            DisUtil.delVer((String)CACHE_KEY_CFLOW);
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            this.info("pe.PeCflowServiceImpl.queryCflowCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> nodemap = new HashMap<String, String>();
        HashMap<String, String> nodeparentmap = new HashMap<String, String>();
        String key = "";
        for (PeCflow peCflow : cflowList) {
            PeCflowReDomain peCflowReDomain = this.makeCache(peCflow);
            key = peCflow.getDicPaypdCode() + "-" + peCflow.getTenantCode();
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)peCflowReDomain));
        }
        params.put("orderStr", "CFLOW_NODE_INDEX");
        params.put("order", true);
        List<PeCflowNode> nodeList = this.queryCflowNodeModelPage(params);
        if (null == nodeList || nodeList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            return;
        }
        String nodekey = "";
        String parkey = "";
        String str = "";
        ArrayList<PeCflowNode> nodeParentList = null;
        for (PeCflowNode peCflowNode : nodeList) {
            nodekey = peCflowNode.getCflowNodeCode() + "-" + peCflowNode.getTenantCode();
            nodemap.put(nodekey, JsonUtil.buildNormalBinder().toJson((Object)peCflowNode));
            parkey = peCflowNode.getCflowCode() + "-" + peCflowNode.getCflowNodeParentcode() + "-" + peCflowNode.getTenantCode();
            str = (String)nodeparentmap.get(parkey);
            nodeParentList = StringUtils.isNotBlank((String)str) ? JSON.parseArray((String)str, PeCflowNode.class) : new ArrayList<PeCflowNode>();
            nodeParentList.add(peCflowNode);
            nodeparentmap.put(parkey, JsonUtil.buildNormalBinder().toJson(nodeParentList));
        }
        DisUtil.setMap((String)CACHE_KEY_CFLOW, mmap);
        DisUtil.setMap((String)CACHE_KEY_CFLOWNODE, nodemap);
        DisUtil.setMap((String)CACHE_KEY_PARENTCFLOWNODE, nodeparentmap);
        this.info("pe.PeCflowServiceImpl.queryCflowCache.end", "=======\u8c03\u5ea6end=======");
    }

    private PeCflowReDomain makeCache(PeCflow peCflow) {
        if (null == peCflow) {
            return null;
        }
        PeCflowReDomain peCflowReDomain = this.makeReCflow(peCflow);
        if (null == peCflowReDomain) {
            return null;
        }
        List<PeCflowNodeReDomain> nodeReList = this.queryNodeNext(peCflow.getTenantCode(), peCflowReDomain.getCflowCode(), peCflowReDomain.getCflowCode());
        peCflowReDomain.setNodeReList(nodeReList);
        return peCflowReDomain;
    }

    @Override
    public void saveCflowInit(String tenantCode) {
        List<PeCflow> cflowList = this.queryCflowModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        List<PeCflowNode> list = this.queryCflowNodeModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        HashMap map = new HashMap();
        for (PeCflowNode node : list) {
            ArrayList<PeCflowNode> nodelist = (ArrayList<PeCflowNode>)map.get(node.getCflowCode());
            if (null == nodelist) {
                nodelist = new ArrayList<PeCflowNode>();
            }
            node.setTenantCode(tenantCode);
            node.setCflowNodeId(null);
            nodelist.add(node);
            map.put(node.getCflowCode(), nodelist);
        }
        for (PeCflow cflow : cflowList) {
            cflow.setTenantCode(tenantCode);
            cflow.setCflowId(null);
            cflow.setPeCflowNode((List)map.get(cflow.getCflowCode()));
        }
        this.getCflowService().putQueue(cflowList);
    }

    @Override
    public void saveCflowByList(List<PeCflow> list) {
        if (null == list || list.size() == 0) {
            return;
        }
        for (PeCflow cflow : list) {
            this.saveCflowModel(cflow);
            for (PeCflowNode node : cflow.getPeCflowNode()) {
                this.saveCflowNodeModel(node);
            }
        }
        this.queryCflowCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CflowService getCflowService() {
        Object object = lock;
        synchronized (object) {
            if (null == cflowService) {
                cflowService = new CflowService((PeCflowService)SpringApplicationContextUtil.getBean((String)"peCflowService"));
                cflowService.addPollPool(new CflowPollThread(cflowService));
            }
            return cflowService;
        }
    }

    static {
        lock = new Object();
    }
}

