/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgCclasstreeMapper;
import com.yqbsoft.laser.service.pg.domain.PgCclassgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgCclasstreeDomain;
import com.yqbsoft.laser.service.pg.domain.PgCclasstreeReDomain;
import com.yqbsoft.laser.service.pg.model.PgCclasstree;
import com.yqbsoft.laser.service.pg.service.PgCclassgoodsService;
import com.yqbsoft.laser.service.pg.service.PgCclasstreeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgCclasstreeServiceImpl
extends BaseServiceImpl
implements PgCclasstreeService {
    private static final String SYS_CODE = "pg.PICK.PgCclasstreeServiceImpl";
    private PgCclasstreeMapper pgCclasstreeMapper;
    private PgCclassgoodsService pgCclassgoodsService;

    public void setPgCclasstreeMapper(PgCclasstreeMapper pgCclasstreeMapper) {
        this.pgCclasstreeMapper = pgCclasstreeMapper;
    }

    public void setPgCclassgoodsService(PgCclassgoodsService pgCclassgoodsService) {
        this.pgCclassgoodsService = pgCclassgoodsService;
    }

    private Date getSysDate() {
        try {
            return this.pgCclasstreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCclasstree(PgCclasstreeDomain pgCclasstreeDomain) {
        if (null == pgCclasstreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgCclasstreeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCclasstreeDefault(PgCclasstree pgCclasstree) {
        if (null == pgCclasstree) {
            return;
        }
        if (null == pgCclasstree.getDataState()) {
            pgCclasstree.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgCclasstree.getGmtCreate()) {
            pgCclasstree.setGmtCreate(date);
        }
        pgCclasstree.setGmtModified(date);
        if (StringUtils.isBlank((String)pgCclasstree.getCclasstreeCode())) {
            pgCclasstree.setCclasstreeCode(this.getNo(null, "PgCclasstree", "pgCclasstree", pgCclasstree.getTenantCode()));
        }
    }

    private int getCclasstreeMaxCode() {
        int code = 0;
        try {
            return this.pgCclasstreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.getCclasstreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCclasstreeUpdataDefault(PgCclasstree pgCclasstree) {
        if (null == pgCclasstree) {
            return;
        }
        pgCclasstree.setGmtModified(this.getSysDate());
    }

    private void saveCclasstreeModel(PgCclasstree pgCclasstree) throws ApiException {
        if (null == pgCclasstree) {
            return;
        }
        try {
            this.pgCclasstreeMapper.insertSelective(pgCclasstree);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.saveCclasstreeModel.ex", (Throwable)e);
        }
    }

    private void saveCclasstreeBatchModel(List<PgCclasstree> pgCclasstreeList) throws ApiException {
        if (null == pgCclasstreeList || pgCclasstreeList.isEmpty()) {
            return;
        }
        try {
            this.pgCclasstreeMapper.insertBatch(pgCclasstreeList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.saveCclasstreeBatchModel.ex", (Throwable)e);
        }
    }

    private PgCclasstree getCclasstreeModelById(Integer cclasstreeId) {
        if (null == cclasstreeId) {
            return null;
        }
        try {
            return this.pgCclasstreeMapper.selectByPrimaryKey(cclasstreeId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.getCclasstreeModelById", (Throwable)e);
            return null;
        }
    }

    private PgCclasstree getCclasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgCclasstreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.getCclasstreeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCclasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.delCclasstreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.delCclasstreeModelByCode.num");
        }
    }

    private void deleteCclasstreeModel(Integer cclasstreeId) throws ApiException {
        if (null == cclasstreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.deleteByPrimaryKey(cclasstreeId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.deleteCclasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.deleteCclasstreeModel.num");
        }
    }

    private void updateCclasstreeModel(PgCclasstree pgCclasstree) throws ApiException {
        if (null == pgCclasstree) {
            return;
        }
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.updateByPrimaryKey(pgCclasstree);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateCclasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateCclasstreeModel.num");
        }
    }

    private void updateStateCclasstreeModel(Integer cclasstreeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cclasstreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cclasstreeId", cclasstreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateStateCclasstreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateStateCclasstreeModel.null");
        }
    }

    private void updateStateCclasstreeModelByCode(String tenantCode, String cclasstreeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cclasstreeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclasstreeCode", cclasstreeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateStateCclasstreeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateStateCclasstreeModelByCode.null");
        }
    }

    private PgCclasstree makeCclasstree(PgCclasstreeDomain pgCclasstreeDomain, PgCclasstree pgCclasstree) {
        if (null == pgCclasstreeDomain) {
            return null;
        }
        if (null == pgCclasstree) {
            pgCclasstree = new PgCclasstree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgCclasstree, (Object)pgCclasstreeDomain);
            return pgCclasstree;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.makeCclasstree", (Throwable)e);
            return null;
        }
    }

    private PgCclasstreeReDomain makePgCclasstreeReDomain(PgCclasstree pgCclasstree) {
        if (null == pgCclasstree) {
            return null;
        }
        PgCclasstreeReDomain pgCclasstreeReDomain = new PgCclasstreeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgCclasstreeReDomain, (Object)pgCclasstree);
            return pgCclasstreeReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.makePgCclasstreeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgCclasstree> queryCclasstreeModelPage(Map<String, Object> parammap) {
        try {
            return this.pgCclasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.queryCclasstreeModel", (Throwable)e);
            return null;
        }
    }

    private int countCclasstree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgCclasstreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgCclasstreeServiceImpl.countCclasstree", (Throwable)e);
        }
        return i;
    }

    private PgCclasstree createPgCclasstree(PgCclasstreeDomain pgCclasstreeDomain) {
        String msg = this.checkCclasstree(pgCclasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.saveCclasstree.checkCclasstree", msg);
        }
        PgCclasstree pgCclasstree = this.makeCclasstree(pgCclasstreeDomain, null);
        this.setCclasstreeDefault(pgCclasstree);
        return pgCclasstree;
    }

    @Override
    public String saveCclasstree(PgCclasstreeDomain pgCclasstreeDomain) throws ApiException {
        PgCclasstree pgCclasstree = this.createPgCclasstree(pgCclasstreeDomain);
        this.saveCclasstreeModel(pgCclasstree);
        String cclasstreeCode = pgCclasstree.getCclasstreeCode();
        String conditionCode = pgCclasstree.getConditionCode();
        String tenantCode = pgCclasstree.getTenantCode();
        String userCode = pgCclasstree.getUserCode();
        if (ListUtil.isNotEmpty(pgCclasstreeDomain.getPgCclassgoodsDomainList())) {
            pgCclasstreeDomain.getPgCclassgoodsDomainList().forEach(item -> {
                item.setClasstreeCode(cclasstreeCode);
                item.setTenantCode(tenantCode);
                item.setUserCode(userCode);
                item.setConditionCode(conditionCode);
                this.pgCclassgoodsService.saveCclassgoods((PgCclassgoodsDomain)item);
            });
        }
        return pgCclasstree.getCclasstreeCode();
    }

    @Override
    public String saveCclasstreeBatch(List<PgCclasstreeDomain> pgCclasstreeDomainList) throws ApiException {
        if (null == pgCclasstreeDomainList || pgCclasstreeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgCclasstree> pgCclasstreeList = new ArrayList<PgCclasstree>();
        ArrayList<PgCclassgoodsDomain> pgCclassgoodsList = new ArrayList<PgCclassgoodsDomain>(20);
        int a = 0;
        for (PgCclasstreeDomain pgCclasstreeDomain : pgCclasstreeDomainList) {
            PgCclasstree pgCclasstree = this.createPgCclasstree(pgCclasstreeDomain);
            String cclasstreeCode = pgCclasstree.getCclasstreeCode();
            String conditionCode = pgCclasstree.getConditionCode();
            String tenantCode = pgCclasstree.getTenantCode();
            String userCode = pgCclasstree.getUserCode();
            if (ListUtil.isNotEmpty(pgCclasstreeDomain.getPgCclassgoodsDomainList())) {
                pgCclasstreeDomain.getPgCclassgoodsDomainList().forEach(item -> {
                    item.setClasstreeCode(cclasstreeCode);
                    item.setTenantCode(tenantCode);
                    item.setUserCode(userCode);
                    item.setConditionCode(conditionCode);
                    pgCclassgoodsList.add((PgCclassgoodsDomain)item);
                });
            }
            pgCclasstreeList.add(pgCclasstree);
        }
        this.saveCclasstreeBatchModel(pgCclasstreeList);
        this.pgCclassgoodsService.saveCclassgoodsBatch(pgCclassgoodsList);
        return String.valueOf(a);
    }

    @Override
    public void updateCclasstreeState(Integer cclasstreeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cclasstreeId) {
            return;
        }
        this.updateStateCclasstreeModel(cclasstreeId, dataState, oldDataState, map);
    }

    @Override
    public void updateCclasstreeStateByCode(String tenantCode, String cclasstreeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cclasstreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCclasstreeModelByCode(tenantCode, cclasstreeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCclasstree(PgCclasstreeDomain pgCclasstreeDomain) throws ApiException {
        String msg = this.checkCclasstree(pgCclasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateCclasstree.checkCclasstree", msg);
        }
        PgCclasstree oldPgCclasstree = this.getCclasstreeModelById(pgCclasstreeDomain.getCclasstreeId());
        if (null == oldPgCclasstree) {
            throw new ApiException("pg.PICK.PgCclasstreeServiceImpl.updateCclasstree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgCclasstree pgCclasstree = this.makeCclasstree(pgCclasstreeDomain, oldPgCclasstree);
        this.setCclasstreeUpdataDefault(pgCclasstree);
        this.updateCclasstreeModel(pgCclasstree);
    }

    @Override
    public PgCclasstree getCclasstree(Integer cclasstreeId) {
        if (null == cclasstreeId) {
            return null;
        }
        return this.getCclasstreeModelById(cclasstreeId);
    }

    @Override
    public void deleteCclasstree(Integer cclasstreeId) throws ApiException {
        if (null == cclasstreeId) {
            return;
        }
        this.deleteCclasstreeModel(cclasstreeId);
    }

    @Override
    public QueryResult<PgCclasstree> queryCclasstreePage(Map<String, Object> map) {
        List<PgCclasstree> pgCclasstreeList = this.queryCclasstreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCclasstree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgCclasstreeList);
        return queryResult;
    }

    @Override
    public PgCclasstree getCclasstreeByCode(String tenantCode, String cclasstreeCode) throws ApiException {
        if (StringUtils.isBlank((String)cclasstreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclasstreeCode", cclasstreeCode);
        return this.getCclasstreeModelByCode(map);
    }

    @Override
    public void deleteCclasstreeByCode(String tenantCode, String cclasstreeCode) throws ApiException {
        if (StringUtils.isBlank((String)cclasstreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cclasstreeCode", cclasstreeCode);
        this.delCclasstreeModelByCode(map);
    }
}

