/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.PgConstants;
import com.yqbsoft.laser.service.pg.dao.PgConditionMapper;
import com.yqbsoft.laser.service.pg.dao.PgGcfmgoodsMapper;
import com.yqbsoft.laser.service.pg.dao.PgGcfmpackimgsMapper;
import com.yqbsoft.laser.service.pg.dao.PgGcfmpacksizeMapper;
import com.yqbsoft.laser.service.pg.dao.PgGconfirmMapper;
import com.yqbsoft.laser.service.pg.dao.PgLabelMapper;
import com.yqbsoft.laser.service.pg.dao.PgProductStockMapper;
import com.yqbsoft.laser.service.pg.domain.PgCclasstreeDomain;
import com.yqbsoft.laser.service.pg.domain.PgConditionDomain;
import com.yqbsoft.laser.service.pg.domain.PgConditionReDomain;
import com.yqbsoft.laser.service.pg.domain.PgGroupDomain;
import com.yqbsoft.laser.service.pg.domain.PgLabelDomain;
import com.yqbsoft.laser.service.pg.domain.PgSettingDomain;
import com.yqbsoft.laser.service.pg.model.DaPickStatistics;
import com.yqbsoft.laser.service.pg.model.PgCondition;
import com.yqbsoft.laser.service.pg.model.PgGcfmgoods;
import com.yqbsoft.laser.service.pg.model.PgGcfmpackimgs;
import com.yqbsoft.laser.service.pg.model.PgGcfmpacksize;
import com.yqbsoft.laser.service.pg.model.PgGconfirm;
import com.yqbsoft.laser.service.pg.model.PgLabel;
import com.yqbsoft.laser.service.pg.model.PgProductStockCdl;
import com.yqbsoft.laser.service.pg.service.PgCclasstreeService;
import com.yqbsoft.laser.service.pg.service.PgConditionService;
import com.yqbsoft.laser.service.pg.service.PgGroupService;
import com.yqbsoft.laser.service.pg.service.PgLabelService;
import com.yqbsoft.laser.service.pg.service.PgSettingService;
import com.yqbsoft.laser.service.pg.tool.PickUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class PgConditionServiceImpl
extends BaseServiceImpl
implements PgConditionService {
    private static final String SYS_CODE = "pg.PICK.PgConditionServiceImpl";
    private PgConditionMapper pgConditionMapper;
    private PgGcfmpackimgsMapper pgGcfmpackimgsMapper;
    private PgGconfirmMapper pgGconfirmMapper;
    private PgGcfmgoodsMapper pgGcfmgoodsMapper;
    private PgGcfmpacksizeMapper pgGcfmpacksizeMapper;
    private PgLabelMapper pgLabelMapper;
    private PgProductStockMapper pgProductStockMapper;
    private PgCclasstreeService pgCclasstreeService;
    private PgLabelService pgLabelService;
    private PgGroupService pgGroupService;
    private PgSettingService pgSettingService;
    private static String[] table = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public void setPgLabelMapper(PgLabelMapper pgLabelMapper) {
        this.pgLabelMapper = pgLabelMapper;
    }

    public void setPgGcfmpacksizeMapper(PgGcfmpacksizeMapper pgGcfmpacksizeMapper) {
        this.pgGcfmpacksizeMapper = pgGcfmpacksizeMapper;
    }

    public void setPgGcfmgoodsMapper(PgGcfmgoodsMapper pgGcfmgoodsMapper) {
        this.pgGcfmgoodsMapper = pgGcfmgoodsMapper;
    }

    public void setPgGconfirmMapper(PgGconfirmMapper pgGconfirmMapper) {
        this.pgGconfirmMapper = pgGconfirmMapper;
    }

    public void setPgGcfmpackimgsMapper(PgGcfmpackimgsMapper pgGcfmpackimgsMapper) {
        this.pgGcfmpackimgsMapper = pgGcfmpackimgsMapper;
    }

    public void setPgConditionMapper(PgConditionMapper pgConditionMapper) {
        this.pgConditionMapper = pgConditionMapper;
    }

    public void setPgCclasstreeService(PgCclasstreeService pgCclasstreeService) {
        this.pgCclasstreeService = pgCclasstreeService;
    }

    public void setPgLabelService(PgLabelService pgLabelService) {
        this.pgLabelService = pgLabelService;
    }

    public void setPgGroupService(PgGroupService pgGroupService) {
        this.pgGroupService = pgGroupService;
    }

    public void setPgSettingService(PgSettingService pgSettingService) {
        this.pgSettingService = pgSettingService;
    }

    private Date getSysDate() {
        try {
            return this.pgConditionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCondition(PgConditionDomain pgConditionDomain) {
        if (null == pgConditionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgConditionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setConditionDefault(PgCondition pgCondition) {
        if (null == pgCondition) {
            return;
        }
        if (null == pgCondition.getDataState()) {
            pgCondition.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgCondition.getGmtCreate()) {
            pgCondition.setGmtCreate(date);
        }
        pgCondition.setGmtModified(date);
        if (StringUtils.isBlank((String)pgCondition.getConditionCode())) {
            pgCondition.setConditionCode(this.getNo(null, "PgCondition", "pgCondition", pgCondition.getTenantCode()));
        }
    }

    private int getConditionMaxCode() {
        int code = 0;
        try {
            return this.pgConditionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.getConditionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConditionUpdataDefault(PgCondition pgCondition) {
        if (null == pgCondition) {
            return;
        }
        pgCondition.setGmtModified(this.getSysDate());
    }

    private void saveConditionModel(PgCondition pgCondition) throws ApiException {
        if (null == pgCondition) {
            return;
        }
        try {
            this.pgConditionMapper.insertSelective(pgCondition);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.saveConditionModel.ex", (Throwable)e);
        }
    }

    private void saveConditionBatchModel(List<PgCondition> pgConditionList) throws ApiException {
        if (null == pgConditionList || pgConditionList.isEmpty()) {
            return;
        }
        try {
            this.pgConditionMapper.insertBatch(pgConditionList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.saveConditionBatchModel.ex", (Throwable)e);
        }
    }

    private PgCondition getConditionModelById(Integer conditionId) {
        if (null == conditionId) {
            return null;
        }
        try {
            return this.pgConditionMapper.selectByPrimaryKey(conditionId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.getConditionModelById", (Throwable)e);
            return null;
        }
    }

    private PgCondition getConditionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgConditionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.getConditionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delConditionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgConditionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.delConditionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.delConditionModelByCode.num");
        }
    }

    private void deleteConditionModel(Integer conditionId) throws ApiException {
        if (null == conditionId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgConditionMapper.deleteByPrimaryKey(conditionId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.deleteConditionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.deleteConditionModel.num");
        }
    }

    private void updateConditionModel(PgCondition pgCondition) throws ApiException {
        if (null == pgCondition) {
            return;
        }
        int i = 0;
        try {
            i = this.pgConditionMapper.updateByPrimaryKey(pgCondition);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateConditionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateConditionModel.num");
        }
    }

    private void updateStateConditionModel(Integer conditionId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == conditionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionId", conditionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgConditionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateStateConditionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateStateConditionModel.null");
        }
    }

    private void updateStateConditionModelByCode(String tenantCode, String conditionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)conditionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conditionCode", conditionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgConditionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateStateConditionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateStateConditionModelByCode.null");
        }
    }

    private PgCondition makeCondition(PgConditionDomain pgConditionDomain, PgCondition pgCondition) {
        if (null == pgConditionDomain) {
            return null;
        }
        if (null == pgCondition) {
            pgCondition = new PgCondition();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgCondition, (Object)pgConditionDomain);
            return pgCondition;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.makeCondition", (Throwable)e);
            return null;
        }
    }

    private PgConditionReDomain makePgConditionReDomain(PgCondition pgCondition) {
        if (null == pgCondition) {
            return null;
        }
        PgConditionReDomain pgConditionReDomain = new PgConditionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgConditionReDomain, (Object)pgCondition);
            return pgConditionReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.makePgConditionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgCondition> queryConditionModelPage(Map<String, Object> parammap) {
        try {
            return this.pgConditionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.queryConditionModel", (Throwable)e);
            return null;
        }
    }

    private int countCondition(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgConditionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.countCondition", (Throwable)e);
        }
        return i;
    }

    private PgCondition createPgCondition(PgConditionDomain pgConditionDomain) {
        String msg = this.checkCondition(pgConditionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.saveCondition.checkCondition", msg);
        }
        PgCondition pgCondition = this.makeCondition(pgConditionDomain, null);
        this.setConditionDefault(pgCondition);
        return pgCondition;
    }

    @Override
    public String saveCondition(PgConditionDomain pgConditionDomain) throws ApiException {
        Long startTime = System.currentTimeMillis();
        PgCondition pgCondition = this.createPgCondition(pgConditionDomain);
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.createPgCondition -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        this.saveConditionModel(pgCondition);
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.saveConditionModel -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        String conditionCode = pgCondition.getConditionCode();
        String tenantCode = pgCondition.getTenantCode();
        String userCode = pgCondition.getUserCode();
        if (ListUtil.isNotEmpty(pgConditionDomain.getPgCclasstreeDomainList())) {
            List<PgCclasstreeDomain> pgCclasstreeDomainList = pgConditionDomain.getPgCclasstreeDomainList();
            pgCclasstreeDomainList.forEach(item -> {
                item.setConditionCode(conditionCode);
                item.setTenantCode(tenantCode);
                item.setUserCode(userCode);
            });
            this.pgCclasstreeService.saveCclasstreeBatch(pgCclasstreeDomainList);
        }
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.saveCclasstree -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        pgConditionDomain.setConditionCode(pgCondition.getConditionCode());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("pg.goods.cache", pgConditionDomain.getCache());
        paramMap.put("dataState", PgConstants.DATA_STATE_2);
        paramMap.put("fuzzy", PgConstants.DATA_FUZZY_1);
        PgSettingDomain pgSettingDomain = this.pgSettingService.getSettingDomainByCode(tenantCode, pgCondition.getSettingCode());
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.getSettingDomainByCode -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        pgConditionDomain.setPgSettingDomain(pgSettingDomain);
        List<PgLabelDomain> pgLabelList = this.pgLabelService.queryLabelList(paramMap);
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.queryLabelList -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        if (pgConditionDomain.getStockFlag() != null && pgConditionDomain.getStockFlag().booleanValue()) {
            HashMap<String, Object> stockParamMap = new HashMap<String, Object>(8);
            stockParamMap.put("fpcCode", pgLabelList.stream().map(p -> p.getSkuCode()).collect(Collectors.joining(",")));
            stockParamMap.put("regionalDistributorNameEn", pgConditionDomain.getUserInfoCode());
            try {
                stockParamMap.put("tenantCode", DateUtils.parseDateToString((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            List<PgProductStockCdl> pgProductStockCdls = this.pgProductStockMapper.query(stockParamMap);
            this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.pgProductStock.query -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
            this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.pgProductStock.query.size\uff1a", (Object)pgProductStockCdls.size());
            this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.pgProductStock.query.param\uff1a", (Object)JsonUtil.buildNormalBinder().toJson(stockParamMap));
            if (ListUtil.isNotEmpty(pgProductStockCdls)) {
                Map<String, Integer> stockMap = pgProductStockCdls.stream().collect(Collectors.toMap(PgProductStockCdl::getFpcCode, PgProductStockCdl::getInventoryFlag, (o, n) -> n));
                pgLabelList.stream().forEach(p -> {
                    if (stockMap.containsKey(p.getSkuCode())) {
                        p.setStockFlag((Integer)stockMap.get(p.getSkuCode()) == 0);
                    }
                });
            }
            this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.pgProductStock -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        }
        List<PgGroupDomain> pgGroupDomains = PickUtils.generatorGroupByCondition(pgLabelList, pgConditionDomain);
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.generatorGroupByCondition -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        if (!CollectionUtils.isEmpty(pgGroupDomains)) {
            for (int i = 0; i < pgGroupDomains.size(); ++i) {
                PgGroupDomain pgGroupDomain = pgGroupDomains.get(i);
                String groupTitle = pgGroupDomain.getGroupTitle();
                if (!StringUtils.isNotBlank((String)groupTitle)) continue;
                groupTitle = groupTitle.replace("M998M", table[i % 26]);
                pgGroupDomain.setGroupTitle(groupTitle);
            }
        }
        this.pgGroupService.saveGroupBatch(pgGroupDomains);
        this.logger.info("pg.PICK.PgConditionServiceImpl.saveCondition.saveGroupBatch -\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a", (Object)(System.currentTimeMillis() - startTime));
        return pgCondition.getConditionCode();
    }

    @Override
    public String saveConditionBatch(List<PgConditionDomain> pgConditionDomainList) throws ApiException {
        if (null == pgConditionDomainList || pgConditionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgCondition> pgConditionList = new ArrayList<PgCondition>();
        String code = "";
        for (PgConditionDomain pgConditionDomain : pgConditionDomainList) {
            PgCondition pgCondition = this.createPgCondition(pgConditionDomain);
            code = pgCondition.getConditionCode();
            pgConditionList.add(pgCondition);
        }
        this.saveConditionBatchModel(pgConditionList);
        return code;
    }

    @Override
    public void updateConditionState(Integer conditionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == conditionId) {
            return;
        }
        this.updateStateConditionModel(conditionId, dataState, oldDataState, map);
    }

    @Override
    public void updateConditionStateByCode(String tenantCode, String conditionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)conditionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateConditionModelByCode(tenantCode, conditionCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCondition(PgConditionDomain pgConditionDomain) throws ApiException {
        String msg = this.checkCondition(pgConditionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateCondition.checkCondition", msg);
        }
        PgCondition oldPgCondition = this.getConditionModelById(pgConditionDomain.getConditionId());
        if (null == oldPgCondition) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.updateCondition.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgCondition pgCondition = this.makeCondition(pgConditionDomain, oldPgCondition);
        this.setConditionUpdataDefault(pgCondition);
        this.updateConditionModel(pgCondition);
    }

    @Override
    public PgCondition getCondition(Integer conditionId) {
        if (null == conditionId) {
            return null;
        }
        return this.getConditionModelById(conditionId);
    }

    @Override
    public void deleteCondition(Integer conditionId) throws ApiException {
        if (null == conditionId) {
            return;
        }
        this.deleteConditionModel(conditionId);
    }

    @Override
    public QueryResult<PgCondition> queryConditionPage(Map<String, Object> map) {
        List<PgCondition> pgConditionList = this.queryConditionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCondition(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgConditionList);
        return queryResult;
    }

    @Override
    public PgCondition getConditionByCode(String tenantCode, String conditionCode) throws ApiException {
        if (StringUtils.isBlank((String)conditionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conditionCode", conditionCode);
        return this.getConditionModelByCode(map);
    }

    @Override
    public void deleteConditionByCode(String tenantCode, String conditionCode) throws ApiException {
        if (StringUtils.isBlank((String)conditionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conditionCode", conditionCode);
        this.delConditionModelByCode(map);
    }

    @Override
    public QueryResult<PgGcfmgoods> exportConditionPage(Map<String, Object> map) {
        if (EmptyUtil.isEmpty((Object)map.get("conditionCode")) || EmptyUtil.isEmpty((Object)map.get("tenantCode"))) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.exportConditionPage", map);
            return null;
        }
        final String conditionCode = (String)map.get("conditionCode");
        final String tenantCode = (String)map.get("tenantCode");
        PgCondition conditionByCode = this.getConditionByCode(tenantCode, conditionCode);
        if (null == conditionByCode) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.exportConditionPage-conditionByCode-null", map);
            return null;
        }
        Boolean conditionComparePrice = conditionByCode.getConditionComparePrice();
        Integer priceTarget = Optional.ofNullable(conditionByCode).map(PgCondition::getConditionComparePriceTarget).orElse(0);
        List<PgGcfmpackimgs> pgGcfmpackimgs = this.queryGcfmpackimgsModelPage(map);
        String packName = "";
        if (ListUtil.isNotEmpty(pgGcfmpackimgs)) {
            packName = pgGcfmpackimgs.get(0).getMemo();
        }
        List<PgGconfirm> pgGconfirms = this.queryGconfirmModelPage(map);
        String spec = "";
        ArrayList<PgGcfmgoods> returnGoods = new ArrayList<PgGcfmgoods>();
        int index = 0;
        for (final PgGconfirm pgGconfirm : pgGconfirms) {
            PgGcfmgoods pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u5957\u7ec4 ( " + ++index + " )");
            returnGoods.add(pgGcfmgoodsDoman);
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName(pgGconfirm.getGconfirmTitle());
            returnGoods.add(pgGcfmgoodsDoman);
            List<PgGcfmgoods> pgGcfmgoods = this.queryGcfmgoodsModelPage((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("gconfirmCode", pgGconfirm.getGconfirmCode());
                    this.put("tenantCode", pgGconfirm.getTenantCode());
                }
            });
            List<PgGcfmpacksize> pgGcfmpacksizes = this.queryGcfmpacksizeModelPage((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("gconfirmCode", pgGconfirm.getGconfirmCode());
                    this.put("tenantCode", pgGconfirm.getTenantCode());
                }
            });
            if (ListUtil.isNotEmpty(pgGcfmpacksizes)) {
                PgGcfmpacksize pgGcfmpacksize = pgGcfmpacksizes.get(0);
                spec = pgGcfmpacksize.getGcfmpacksizeLength().setScale(2, 1) + "cm*" + pgGcfmpacksize.getGcfmpacksizeWide().setScale(2, 1) + "cm*" + pgGcfmpacksize.getGcfmpacksizeHigh().setScale(2, 1) + "cm";
            }
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u7bb1\u89c4\u5efa\u8bae\u5c3a\u5bf8: " + spec);
            returnGoods.add(pgGcfmgoodsDoman);
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u5305\u88c5\u8bbe\u8ba1\u56fe: " + packName);
            returnGoods.add(pgGcfmgoodsDoman);
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u5546\u54c1\u6e05\u5355 (" + pgGcfmgoods.size() + "\u4ef6)");
            returnGoods.add(pgGcfmgoodsDoman);
            BigDecimal nprice = new BigDecimal(0);
            BigDecimal maxprice = new BigDecimal(0);
            BigDecimal jdprice = new BigDecimal(0);
            BigDecimal insideprice = new BigDecimal(0);
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u5546\u54c1\u540d\u79f0");
            pgGcfmgoodsDoman.setLabelCode("\u4ea7\u54c1\u6761\u7801");
            pgGcfmgoodsDoman.setClasstreeName("\u4e24\u767e\u7bb1\u542b\u7a0e\u5382\u4ef7");
            pgGcfmgoodsDoman.setPackageImage("\u5efa\u8bae\u96f6\u552e\u4ef7");
            pgGcfmgoodsDoman.setGroupSpec("\u5efa\u8bae\u6700\u5927\u4fc3\u9500\u4ef7");
            pgGcfmgoodsDoman.setBrandName("\u4e3b\u6d41\u7535\u5546\u4fc3\u9500\u53c2\u8003\u4ef7");
            if (conditionComparePrice.booleanValue()) {
                pgGcfmgoodsDoman.setLabelJdlink("\u4eac\u4e1c\u94fe\u63a5");
            }
            returnGoods.add(pgGcfmgoodsDoman);
            for (final PgGcfmgoods pgGcfmgood : pgGcfmgoods) {
                PgLabel byCode;
                block14: {
                    final String labelCode = pgGcfmgood.getLabelCode();
                    byCode = null;
                    try {
                        byCode = this.pgLabelMapper.getByCode((Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("tenantCode", tenantCode);
                                this.put("labelCode", labelCode);
                            }
                        });
                    }
                    catch (Exception e) {
                        List<PgLabel> query = this.pgLabelMapper.query((Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("tenantCode", tenantCode);
                                this.put("labelCode", labelCode);
                                this.put("skuCode", pgGcfmgood.getSkuCode());
                            }
                        });
                        if (!ListUtil.isNotEmpty(query)) break block14;
                        byCode = query.get(0);
                    }
                }
                BigDecimal pricesetNprice = Optional.ofNullable(pgGcfmgood).map(PgGcfmgoods::getPricesetNprice).orElse(BigDecimal.ZERO);
                BigDecimal labelPrefprice = Optional.ofNullable(pgGcfmgood).map(PgGcfmgoods::getLabelPrefprice).orElse(BigDecimal.ZERO);
                BigDecimal discountPrice = Optional.ofNullable(pgGcfmgood).map(PgGcfmgoods::getDisCountPrice).orElse(Optional.ofNullable(pgGcfmgood).map(PgGcfmgoods::getLabelJdprice).orElse(BigDecimal.ZERO));
                BigDecimal labelJdprice = Optional.ofNullable(pgGcfmgood).map(PgGcfmgoods::getLabelJdprice).orElse(BigDecimal.ZERO);
                BigDecimal labelInsideprice = Optional.ofNullable(byCode).map(PgLabel::getLabelInsideprice).orElse(BigDecimal.ZERO);
                insideprice = insideprice.add(labelInsideprice);
                nprice = nprice.add(pricesetNprice);
                maxprice = maxprice.add(labelPrefprice);
                jdprice = priceTarget > 0 ? jdprice.add(discountPrice) : jdprice.add(labelJdprice);
                pgGcfmgood.setClasstreeName(labelInsideprice.setScale(2, 1) + "");
                pgGcfmgood.setPackageImage(pricesetNprice.setScale(2, 1) + "");
                pgGcfmgood.setGroupSpec(labelPrefprice.setScale(2, 1) + "");
                if (priceTarget > 0) {
                    pgGcfmgood.setBrandName(discountPrice.setScale(2, 1) + "");
                } else {
                    pgGcfmgood.setBrandName(labelJdprice.setScale(2, 1) + "");
                }
                if (!conditionComparePrice.booleanValue()) {
                    pgGcfmgood.setLabelJdlink("");
                }
                returnGoods.add(pgGcfmgood);
            }
            pgGcfmgoodsDoman = new PgGcfmgoods();
            pgGcfmgoodsDoman.setGoodsName("\u603b\u8ba1");
            pgGcfmgoodsDoman.setClasstreeName(insideprice.setScale(2, 1) + "");
            pgGcfmgoodsDoman.setPackageImage(nprice.setScale(2, 1) + "");
            pgGcfmgoodsDoman.setGroupSpec(maxprice.setScale(2, 1) + "");
            pgGcfmgoodsDoman.setBrandName(jdprice.setScale(2, 1) + "");
            returnGoods.add(pgGcfmgoodsDoman);
            pgGcfmgoodsDoman = new PgGcfmgoods();
            returnGoods.add(pgGcfmgoodsDoman);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(returnGoods.size());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(returnGoods);
        int i = this.countPickStatistics((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("pistField1", conditionCode);
                this.put("tenantCode", tenantCode);
                this.put("pistDate", "out");
            }
        });
        if (i > 0) {
            return queryResult;
        }
        if (returnGoods.size() == 0) {
            return queryResult;
        }
        DaPickStatistics daPickStatistics = new DaPickStatistics();
        daPickStatistics.setUserCode(pgGconfirms.get(0).getUserCode());
        daPickStatistics.setUserName(pgGconfirms.get(0).getUserName());
        daPickStatistics.setPistField1(conditionCode);
        daPickStatistics.setOutputList(1);
        daPickStatistics.setPistDate("out");
        daPickStatistics.setAppmanageIcode("retailer");
        daPickStatistics.setTenantCode(tenantCode);
        this.savePickStatisticsModel(daPickStatistics);
        return queryResult;
    }

    private void savePickStatisticsModel(DaPickStatistics daPickStatistics) throws ApiException {
        if (null == daPickStatistics) {
            return;
        }
        try {
            this.setPickStatisticsDefault(daPickStatistics);
            this.pgGcfmpackimgsMapper.savePickStatisticsModel(daPickStatistics);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgConditionServiceImpl.savePickStatisticsModel.ex", (Throwable)e);
        }
    }

    private void setPickStatisticsDefault(DaPickStatistics daPickStatistics) {
        if (null == daPickStatistics) {
            return;
        }
        if (null == daPickStatistics.getDataState()) {
            daPickStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daPickStatistics.getGmtCreate()) {
            daPickStatistics.setGmtCreate(date);
        }
        daPickStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daPickStatistics.getPistCode())) {
            daPickStatistics.setPistCode(this.getNo(null, "DaPickStatistics", "daPickStatistics", daPickStatistics.getTenantCode()));
        }
    }

    private int countPickStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGcfmpackimgsMapper.countcountPickStatistics(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.countPickStatistics", (Throwable)e);
        }
        return i;
    }

    private PgLabel getLabelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgLabelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.getLabelModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<PgGcfmpackimgs> queryGcfmpackimgsModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGcfmpackimgsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.queryGcfmpackimgsModel", (Throwable)e);
            return null;
        }
    }

    private List<PgGconfirm> queryGconfirmModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGconfirmMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.queryGconfirmModel", (Throwable)e);
            return null;
        }
    }

    private List<PgGcfmgoods> queryGcfmgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGcfmgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.queryGcfmgoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<PgGcfmpacksize> queryGcfmpacksizeModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGcfmpacksizeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgConditionServiceImpl.queryGcfmpacksizeModel", (Throwable)e);
            return null;
        }
    }

    public PgProductStockMapper getPgProductStockMapper() {
        return this.pgProductStockMapper;
    }

    public void setPgProductStockMapper(PgProductStockMapper pgProductStockMapper) {
        this.pgProductStockMapper = pgProductStockMapper;
    }
}

