/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgDictMapper;
import com.yqbsoft.laser.service.pg.domain.PgDictDomain;
import com.yqbsoft.laser.service.pg.domain.PgDictReDomain;
import com.yqbsoft.laser.service.pg.model.PgDict;
import com.yqbsoft.laser.service.pg.service.PgDictService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgDictServiceImpl
extends BaseServiceImpl
implements PgDictService {
    private static final String SYS_CODE = "pg.PICK.PgDictServiceImpl";
    private PgDictMapper pgDictMapper;

    public void setPgDictMapper(PgDictMapper pgDictMapper) {
        this.pgDictMapper = pgDictMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgDictMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDict(PgDictDomain pgDictDomain) {
        if (null == pgDictDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgDictDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDictDefault(PgDict pgDict) {
        if (null == pgDict) {
            return;
        }
        if (null == pgDict.getDataState()) {
            pgDict.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgDict.getGmtCreate()) {
            pgDict.setGmtCreate(date);
        }
        pgDict.setGmtModified(date);
        if (StringUtils.isBlank((String)pgDict.getDictCode())) {
            pgDict.setDictCode(this.getNo(null, "PgDict", "pgDict", pgDict.getTenantCode()));
        }
    }

    private int getDictMaxCode() {
        int code = 0;
        try {
            return this.pgDictMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.getDictMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDictUpdataDefault(PgDict pgDict) {
        if (null == pgDict) {
            return;
        }
        pgDict.setGmtModified(this.getSysDate());
    }

    private void saveDictModel(PgDict pgDict) throws ApiException {
        if (null == pgDict) {
            return;
        }
        try {
            this.pgDictMapper.insert(pgDict);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.saveDictModel.ex", (Throwable)e);
        }
    }

    private void saveDictBatchModel(List<PgDict> pgDictList) throws ApiException {
        if (null == pgDictList || pgDictList.isEmpty()) {
            return;
        }
        try {
            this.pgDictMapper.insertBatch(pgDictList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.saveDictBatchModel.ex", (Throwable)e);
        }
    }

    private PgDict getDictModelById(Integer dictId) {
        if (null == dictId) {
            return null;
        }
        try {
            return this.pgDictMapper.selectByPrimaryKey(dictId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.getDictModelById", (Throwable)e);
            return null;
        }
    }

    private PgDict getDictModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgDictMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.getDictModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDictModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgDictMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.delDictModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.delDictModelByCode.num");
        }
    }

    private void deleteDictModel(Integer dictId) throws ApiException {
        if (null == dictId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgDictMapper.deleteByPrimaryKey(dictId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.deleteDictModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.deleteDictModel.num");
        }
    }

    private void updateDictModel(PgDict pgDict) throws ApiException {
        if (null == pgDict) {
            return;
        }
        int i = 0;
        try {
            i = this.pgDictMapper.updateByPrimaryKey(pgDict);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateDictModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateDictModel.num");
        }
    }

    private void updateStateDictModel(Integer dictId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dictId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dictId", dictId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgDictMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateStateDictModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateStateDictModel.null");
        }
    }

    private void updateStateDictModelByCode(String tenantCode, String dictCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dictCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictCode", dictCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgDictMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateStateDictModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateStateDictModelByCode.null");
        }
    }

    private PgDict makeDict(PgDictDomain pgDictDomain, PgDict pgDict) {
        if (null == pgDictDomain) {
            return null;
        }
        if (null == pgDict) {
            pgDict = new PgDict();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgDict, (Object)pgDictDomain);
            return pgDict;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.makeDict", (Throwable)e);
            return null;
        }
    }

    private PgDictReDomain makePgDictReDomain(PgDict pgDict) {
        if (null == pgDict) {
            return null;
        }
        PgDictReDomain pgDictReDomain = new PgDictReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgDictReDomain, (Object)pgDict);
            return pgDictReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.makePgDictReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgDict> queryDictModelPage(Map<String, Object> parammap) {
        try {
            return this.pgDictMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.queryDictModel", (Throwable)e);
            return null;
        }
    }

    private int countDict(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgDictMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgDictServiceImpl.countDict", (Throwable)e);
        }
        return i;
    }

    private PgDict createPgDict(PgDictDomain pgDictDomain) {
        String msg = this.checkDict(pgDictDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.saveDict.checkDict", msg);
        }
        PgDict pgDict = this.makeDict(pgDictDomain, null);
        this.setDictDefault(pgDict);
        return pgDict;
    }

    @Override
    public String saveDict(PgDictDomain pgDictDomain) throws ApiException {
        PgDict pgDict = this.createPgDict(pgDictDomain);
        this.saveDictModel(pgDict);
        return pgDict.getDictCode();
    }

    @Override
    public String saveDictBatch(List<PgDictDomain> pgDictDomainList) throws ApiException {
        if (null == pgDictDomainList || pgDictDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgDict> pgDictList = new ArrayList<PgDict>();
        String code = "";
        for (PgDictDomain pgDictDomain : pgDictDomainList) {
            PgDict pgDict = this.createPgDict(pgDictDomain);
            code = pgDict.getDictCode();
            pgDictList.add(pgDict);
        }
        this.saveDictBatchModel(pgDictList);
        return code;
    }

    @Override
    public void updateDictState(Integer dictId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dictId) {
            return;
        }
        this.updateStateDictModel(dictId, dataState, oldDataState, map);
    }

    @Override
    public void updateDictStateByCode(String tenantCode, String dictCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dictCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDictModelByCode(tenantCode, dictCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDict(PgDictDomain pgDictDomain) throws ApiException {
        String msg = this.checkDict(pgDictDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateDict.checkDict", msg);
        }
        PgDict oldPgDict = this.getDictModelById(pgDictDomain.getDictId());
        if (null == oldPgDict) {
            throw new ApiException("pg.PICK.PgDictServiceImpl.updateDict.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgDict pgDict = this.makeDict(pgDictDomain, oldPgDict);
        this.setDictUpdataDefault(pgDict);
        this.updateDictModel(pgDict);
    }

    @Override
    public PgDict getDict(Integer dictId) {
        if (null == dictId) {
            return null;
        }
        return this.getDictModelById(dictId);
    }

    @Override
    public void deleteDict(Integer dictId) throws ApiException {
        if (null == dictId) {
            return;
        }
        this.deleteDictModel(dictId);
    }

    @Override
    public QueryResult<PgDict> queryDictPage(Map<String, Object> map) {
        List<PgDict> pgDictList = this.queryDictModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDict(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgDictList);
        return queryResult;
    }

    @Override
    public PgDict getDictByCode(String tenantCode, String dictCode) throws ApiException {
        if (StringUtils.isBlank((String)dictCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictCode", dictCode);
        return this.getDictModelByCode(map);
    }

    @Override
    public void deleteDictByCode(String tenantCode, String dictCode) throws ApiException {
        if (StringUtils.isBlank((String)dictCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictCode", dictCode);
        this.delDictModelByCode(map);
    }
}

