/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgProductFileIdMapper;
import com.yqbsoft.laser.service.pg.domain.PgProductFileIdDomain;
import com.yqbsoft.laser.service.pg.domain.PgProductFileIdReDomain;
import com.yqbsoft.laser.service.pg.model.PgProductFileId;
import com.yqbsoft.laser.service.pg.service.PgProductFileIdService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgProductFileIdServiceImpl
extends BaseServiceImpl
implements PgProductFileIdService {
    private static final String SYS_CODE = "pg.PICK.PgProductFileIdServiceImpl";
    private PgProductFileIdMapper pgProductFileIdMapper;

    public void setPgProductFileIdMapper(PgProductFileIdMapper pgProductFileIdMapper) {
        this.pgProductFileIdMapper = pgProductFileIdMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgProductFileIdMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProductFileId(PgProductFileIdDomain pgProductFileIdDomain) {
        if (null == pgProductFileIdDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgProductFileIdDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProductFileIdDefault(PgProductFileId pgProductFileId) {
        if (null == pgProductFileId) {
            return;
        }
        if (null == pgProductFileId.getDataState()) {
            pgProductFileId.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgProductFileId.getGmtCreate()) {
            pgProductFileId.setGmtCreate(date);
        }
        pgProductFileId.setGmtModified(date);
        if (StringUtils.isBlank((String)pgProductFileId.getCode())) {
            pgProductFileId.setCode(this.getNo(null, "PgProductFileId", "pgProductFileId", pgProductFileId.getTenantCode()));
        }
    }

    private int getProductFileIdMaxCode() {
        int code = 0;
        try {
            return this.pgProductFileIdMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.getProductFileIdMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProductFileIdUpdataDefault(PgProductFileId pgProductFileId) {
        if (null == pgProductFileId) {
            return;
        }
        pgProductFileId.setGmtModified(this.getSysDate());
    }

    private void saveProductFileIdModel(PgProductFileId pgProductFileId) throws ApiException {
        if (null == pgProductFileId) {
            return;
        }
        try {
            this.pgProductFileIdMapper.insert(pgProductFileId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.saveProductFileIdModel.ex", (Throwable)e);
        }
    }

    private void saveProductFileIdBatchModel(List<PgProductFileId> pgProductFileIdList) throws ApiException {
        if (null == pgProductFileIdList || pgProductFileIdList.isEmpty()) {
            return;
        }
        try {
            this.pgProductFileIdMapper.insertBatch(pgProductFileIdList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.saveProductFileIdBatchModel.ex", (Throwable)e);
        }
    }

    private PgProductFileId getProductFileIdModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.pgProductFileIdMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.getProductFileIdModelById", (Throwable)e);
            return null;
        }
    }

    private PgProductFileId getProductFileIdModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgProductFileIdMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.getProductFileIdModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProductFileIdModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.delProductFileIdModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.delProductFileIdModelByCode.num");
        }
    }

    private void deleteProductFileIdModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.deleteProductFileIdModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.deleteProductFileIdModel.num");
        }
    }

    private void updateProductFileIdModel(PgProductFileId pgProductFileId) throws ApiException {
        if (null == pgProductFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.updateByPrimaryKey(pgProductFileId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateProductFileIdModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateProductFileIdModel.num");
        }
    }

    private void updateStateProductFileIdModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateStateProductFileIdModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateStateProductFileIdModel.null");
        }
    }

    private void updateStateProductFileIdModelByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)code) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateStateProductFileIdModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateStateProductFileIdModelByCode.null");
        }
    }

    private PgProductFileId makeProductFileId(PgProductFileIdDomain pgProductFileIdDomain, PgProductFileId pgProductFileId) {
        if (null == pgProductFileIdDomain) {
            return null;
        }
        if (null == pgProductFileId) {
            pgProductFileId = new PgProductFileId();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgProductFileId, (Object)pgProductFileIdDomain);
            return pgProductFileId;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.makeProductFileId", (Throwable)e);
            return null;
        }
    }

    private PgProductFileIdReDomain makePgProductFileIdReDomain(PgProductFileId pgProductFileId) {
        if (null == pgProductFileId) {
            return null;
        }
        PgProductFileIdReDomain pgProductFileIdReDomain = new PgProductFileIdReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgProductFileIdReDomain, (Object)pgProductFileId);
            return pgProductFileIdReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.makePgProductFileIdReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgProductFileId> queryProductFileIdModelPage(Map<String, Object> parammap) {
        try {
            return this.pgProductFileIdMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.queryProductFileIdModel", (Throwable)e);
            return null;
        }
    }

    private int countProductFileId(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgProductFileIdMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductFileIdServiceImpl.countProductFileId", (Throwable)e);
        }
        return i;
    }

    private PgProductFileId createPgProductFileId(PgProductFileIdDomain pgProductFileIdDomain) {
        String msg = this.checkProductFileId(pgProductFileIdDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.saveProductFileId.checkProductFileId", msg);
        }
        PgProductFileId pgProductFileId = this.makeProductFileId(pgProductFileIdDomain, null);
        this.setProductFileIdDefault(pgProductFileId);
        return pgProductFileId;
    }

    @Override
    public String saveProductFileId(PgProductFileIdDomain pgProductFileIdDomain) throws ApiException {
        PgProductFileId pgProductFileId = this.createPgProductFileId(pgProductFileIdDomain);
        this.saveProductFileIdModel(pgProductFileId);
        return pgProductFileId.getCode();
    }

    @Override
    public String saveProductFileIdBatch(List<PgProductFileIdDomain> pgProductFileIdDomainList) throws ApiException {
        if (null == pgProductFileIdDomainList || pgProductFileIdDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgProductFileId> pgProductFileIdList = new ArrayList<PgProductFileId>();
        String code = "";
        for (PgProductFileIdDomain pgProductFileIdDomain : pgProductFileIdDomainList) {
            PgProductFileId pgProductFileId = this.createPgProductFileId(pgProductFileIdDomain);
            code = pgProductFileId.getCode();
            pgProductFileIdList.add(pgProductFileId);
        }
        this.saveProductFileIdBatchModel(pgProductFileIdList);
        return code;
    }

    @Override
    public void updateProductFileIdState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateProductFileIdModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateProductFileIdStateByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateProductFileIdModelByCode(tenantCode, code, dataState, oldDataState, map);
    }

    @Override
    public void updateProductFileId(PgProductFileIdDomain pgProductFileIdDomain) throws ApiException {
        String msg = this.checkProductFileId(pgProductFileIdDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateProductFileId.checkProductFileId", msg);
        }
        PgProductFileId oldPgProductFileId = this.getProductFileIdModelById(pgProductFileIdDomain.getId());
        if (null == oldPgProductFileId) {
            throw new ApiException("pg.PICK.PgProductFileIdServiceImpl.updateProductFileId.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgProductFileId pgProductFileId = this.makeProductFileId(pgProductFileIdDomain, oldPgProductFileId);
        this.setProductFileIdUpdataDefault(pgProductFileId);
        this.updateProductFileIdModel(pgProductFileId);
    }

    @Override
    public PgProductFileId getProductFileId(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getProductFileIdModelById(id);
    }

    @Override
    public void deleteProductFileId(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteProductFileIdModel(id);
    }

    @Override
    public QueryResult<PgProductFileId> queryProductFileIdPage(Map<String, Object> map) {
        List<PgProductFileId> pgProductFileIdList = this.queryProductFileIdModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProductFileId(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgProductFileIdList);
        return queryResult;
    }

    @Override
    public PgProductFileId getProductFileIdByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        return this.getProductFileIdModelByCode(map);
    }

    @Override
    public void deleteProductFileIdByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        this.delProductFileIdModelByCode(map);
    }
}

