/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool.ws.model;

import com.yqbsoft.laser.service.pg.tool.ws.entity.Square;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabuMapTree {
    Map<String, TabuMapTree> sonTreeMap = new HashMap<String, TabuMapTree>();
    Square nodeSquare;

    public void add(List<Square> squareList, int index) {
        Square square;
        String id;
        if (index >= squareList.size()) {
            return;
        }
        if (this.nodeSquare == null) {
            this.nodeSquare = squareList.get(index);
            ++index;
        }
        if (this.sonTreeMap.containsKey(id = (square = squareList.get(index)).getId())) {
            this.sonTreeMap.get(id).add(squareList, index + 1);
        } else {
            TabuMapTree tabuMapTree = new TabuMapTree();
            tabuMapTree.setNodeSquare(square);
            this.sonTreeMap.put(id, tabuMapTree);
            this.sonTreeMap.get(id).add(squareList, index + 1);
        }
    }

    public boolean contains(List<Square> squareList, int index) {
        if (index >= squareList.size()) {
            return true;
        }
        Square square = squareList.get(index);
        String id = square.getId();
        if (this.sonTreeMap.containsKey(id)) {
            return this.sonTreeMap.get(id).contains(squareList, index + 1);
        }
        return false;
    }

    public void show() {
        for (String key : this.sonTreeMap.keySet()) {
            String id = this.sonTreeMap.get(key).getNodeSquare().getId();
            this.sonTreeMap.get(key).show();
        }
    }

    public boolean isEq(Square square1, Square square2) {
        return square1.getId().equals(square2.getId());
    }

    public Map<String, TabuMapTree> getSonTreeMap() {
        return this.sonTreeMap;
    }

    public Square getNodeSquare() {
        return this.nodeSquare;
    }

    public void setSonTreeMap(Map<String, TabuMapTree> sonTreeMap) {
        this.sonTreeMap = sonTreeMap;
    }

    public void setNodeSquare(Square nodeSquare) {
        this.nodeSquare = nodeSquare;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabuMapTree)) {
            return false;
        }
        TabuMapTree other = (TabuMapTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, TabuMapTree> this$sonTreeMap = this.getSonTreeMap();
        Map<String, TabuMapTree> other$sonTreeMap = other.getSonTreeMap();
        if (this$sonTreeMap == null ? other$sonTreeMap != null : !((Object)this$sonTreeMap).equals(other$sonTreeMap)) {
            return false;
        }
        Square this$nodeSquare = this.getNodeSquare();
        Square other$nodeSquare = other.getNodeSquare();
        return !(this$nodeSquare == null ? other$nodeSquare != null : !((Object)this$nodeSquare).equals(other$nodeSquare));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabuMapTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, TabuMapTree> $sonTreeMap = this.getSonTreeMap();
        result = result * 59 + ($sonTreeMap == null ? 43 : ((Object)$sonTreeMap).hashCode());
        Square $nodeSquare = this.getNodeSquare();
        result = result * 59 + ($nodeSquare == null ? 43 : ((Object)$nodeSquare).hashCode());
        return result;
    }

    public String toString() {
        return "TabuMapTree(sonTreeMap=" + this.getSonTreeMap() + ", nodeSquare=" + this.getNodeSquare() + ")";
    }
}

